/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_KeyWrapCipher;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnhancedFlatFileDBAccess {
    static final String CERT_DIR = "certs";
    static final String CRL_DIR = "crls";
    static final String PRIV_DIR = "privs";
    static final String PUB_DIR = "pubs";
    static final String CERT_TYPE = "cer";
    static final String CRL_TYPE = "crl";
    static final String PRV_TYPE = "prv";
    static final String PUB_TYPE = "pub";
    private File certDir;
    private File crlDir;
    private File privDir;
    private File pubDir;
    private static final int KEY_LENGTH_BITS = 256;
    private static final String DRBG_ALGORITHM = "CTRDRBG";
    private static final String DRBG_KEY_LENGTH_BITS = "128";
    private static final String PERSONALISATION_STRING = "0";
    private static final String PBKDF_ALGORITHM = "PBKDF2/SHA256/PKCS5V2PBE-1000";
    private static final String KEYWRAP_ALGORITHM = "AESKeyWrapRFC5649";
    private static final int MAX_FILE_PREFIX = 999999;
    File path;
    protected char[] passphrase;
    private final byte[] salt;
    private JSAFE_SecretKey secretKey;
    int references = 0;
    private final ReentrantReadWriteLock certReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock crlReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock keyReadWriteLock = new ReentrantReadWriteLock();

    EnhancedFlatFileDBAccess(File path, char[] passphrase, byte[] salt) throws DatabaseException {
        this.path = path;
        this.passphrase = passphrase;
        this.salt = salt;
        this.setupStores();
    }

    private void setupStores() throws DatabaseException {
        if (!this.path.exists() && !this.path.mkdirs()) {
            throw new DatabaseException("Error: Could not create base directory " + this.path.getPath());
        }
        this.certDir = EnhancedFlatFileDBAccess.setupComponentDirectory(this.path, CERT_DIR);
        this.crlDir = EnhancedFlatFileDBAccess.setupComponentDirectory(this.path, CRL_DIR);
        this.privDir = EnhancedFlatFileDBAccess.setupComponentDirectory(this.path, PRIV_DIR);
        this.pubDir = EnhancedFlatFileDBAccess.setupComponentDirectory(this.path, PUB_DIR);
    }

    private static File setupComponentDirectory(File directory, String subdirectory) throws DatabaseException {
        File file = new File(directory, subdirectory);
        if (file.exists()) {
            if (!file.isDirectory()) {
                if (!file.delete()) {
                    throw new DatabaseException("Error deleting previous file at this location");
                }
                if (!file.mkdir()) {
                    throw new DatabaseException("Error creating " + subdirectory + " directory");
                }
            }
        } else if (!file.mkdir()) {
            throw new DatabaseException("Error creating " + subdirectory + " directory");
        }
        return file;
    }

    protected List<File> collectAllFiles(File directory, String extension) {
        DbFilenameFilter filter = new DbFilenameFilter(extension);
        File[] files = directory.listFiles(filter);
        if (files != null) {
            return Arrays.asList(files);
        }
        return new ArrayList<File>(0);
    }

    private List<File> collectMatchingFiles(File directory, String baseName, String extension) {
        if (baseName == null) {
            return this.collectAllFiles(directory, extension);
        }
        DbFilenameFilter filter = new DbFilenameFilter(baseName, extension);
        File[] files = directory.listFiles(filter);
        if (files != null) {
            return Arrays.asList(files);
        }
        return new ArrayList<File>(0);
    }

    static X509Certificate loadCertFromFile(File input) throws DatabaseException {
        try {
            byte[] certArray = EnhancedFlatFileDBAccess.loadBinaryFromFile(input);
            return new X509Certificate(certArray, 0, 0);
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: unable to instantiate an X509Certificate object.", e);
        }
    }

    static X509CRL loadCRLFromFile(File input) throws DatabaseException {
        try {
            byte[] crlArray = EnhancedFlatFileDBAccess.loadBinaryFromFile(input);
            return new X509CRL(crlArray, 0, 0);
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: unable to instantiate an X509CRL object.", e);
        }
    }

    private static byte[] loadBinaryFromFile(File file) throws DatabaseException {
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(file);
            int length = (int)file.length();
            byte[] ber = new byte[length];
            int bytesRead = ((InputStream)fileIn).read(ber);
            if (bytesRead != length) {
                throw new DatabaseException("Error: contents read from " + file + " are of wrong length.");
            }
            byte[] byArray = ber;
            return byArray;
        }
        catch (IOException e) {
            throw new DatabaseException("Error: IO operation failed.", e);
        }
        finally {
            try {
                if (fileIn != null) {
                    ((InputStream)fileIn).close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertCertificate(X509Certificate cert, CertJ certJ) throws DatabaseException {
        byte[] output;
        String baseName;
        byte[] serialNumber;
        X500Name issuerName;
        try {
            issuerName = cert.getIssuerName();
            serialNumber = cert.getSerialNumber();
            baseName = this.makeFileName(issuerName, serialNumber, certJ);
            output = new byte[cert.getDERLen(0)];
            cert.getDEREncoding(output, 0, 0);
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: X509Certificate operation failed.", e);
        }
        this.certReadWriteLock.writeLock().lock();
        try {
            File file = (File)this.findCert(baseName, issuerName, serialNumber, true);
            if (file != null) {
                return;
            }
            file = this.findNewFileName(this.certDir, baseName, CERT_TYPE);
            this.writeToFile(file, output);
        }
        finally {
            this.certReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int selectCertificate(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList, CertJ certJ) throws DatabaseException {
        Certificate cert;
        this.certReadWriteLock.readLock().lock();
        try {
            cert = (Certificate)this.findCert(this.makeFileName(issuerName, serialNumber, certJ), issuerName, serialNumber, false);
        }
        finally {
            this.certReadWriteLock.readLock().unlock();
        }
        if (cert == null) {
            return 0;
        }
        if (!certList.contains(cert)) {
            certList.addElement(cert);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int selectCertificate(X500Name subjectName, Vector<Certificate> certList) throws DatabaseException {
        int count = 0;
        this.certReadWriteLock.readLock().lock();
        try {
            List<File> filenames = this.collectAllFiles(this.certDir, CERT_TYPE);
            for (int index = 0; index < filenames.size(); ++index) {
                X509Certificate cert = EnhancedFlatFileDBAccess.loadCertFromFile(filenames.get(index));
                X500Name foundName = cert.getSubjectName();
                if (!subjectName.equals(foundName)) continue;
                ++count;
                if (certList.contains(cert)) continue;
                certList.addElement(cert);
            }
        }
        finally {
            this.certReadWriteLock.readLock().unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int selectCertificate(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
        int count = 0;
        this.certReadWriteLock.readLock().lock();
        try {
            List<File> fileList = this.collectAllFiles(this.certDir, CERT_TYPE);
            for (int index = 0; index < fileList.size(); ++index) {
                X509Certificate cert = EnhancedFlatFileDBAccess.loadCertFromFile(fileList.get(index));
                if (cert == null) continue;
                X500Name subjectName = cert.getSubjectName();
                if (baseName != null && !subjectName.contains(baseName) || !CertJUtils.compareExtensions(extensions, cert.getExtensions())) continue;
                if (!certList.contains(cert)) {
                    certList.addElement(cert);
                }
                ++count;
            }
        }
        finally {
            this.certReadWriteLock.readLock().unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCertificate(X500Name issuerName, byte[] serialNumber, CertJ certJ) throws DatabaseException {
        if (issuerName == null || serialNumber == null) {
            throw new DatabaseException("Error: neither issuerName nor serialNumber is null.");
        }
        this.certReadWriteLock.writeLock().lock();
        try {
            File file = (File)this.findCert(this.makeFileName(issuerName, serialNumber, certJ), issuerName, serialNumber, true);
            if (file != null) {
                file.delete();
            }
        }
        finally {
            this.certReadWriteLock.writeLock().unlock();
        }
    }

    private Object findCert(String baseName, X500Name issuerName, byte[] serialNumber, boolean returnFile) throws DatabaseException {
        List<File> files = this.collectMatchingFiles(this.certDir, baseName, CERT_TYPE);
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            X509Certificate cert = EnhancedFlatFileDBAccess.loadCertFromFile(file);
            if (cert == null) continue;
            if (issuerName.equals(cert.getIssuerName()) && CertJUtils.byteArraysEqual(serialNumber, cert.getSerialNumber()) && returnFile) {
                return file;
            }
            return cert;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> allCerts() {
        this.certReadWriteLock.readLock().lock();
        try {
            List<File> list = this.collectAllFiles(this.certDir, CERT_TYPE);
            return list;
        }
        finally {
            this.certReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertCRL(X509CRL crl, CertJ certJ) throws DatabaseException {
        byte[] output;
        String baseName;
        Date thisUpdate;
        X500Name issuerName;
        try {
            issuerName = crl.getIssuerName();
            thisUpdate = crl.getThisUpdate();
            baseName = this.makeFileName(issuerName, certJ);
            output = new byte[crl.getDERLen(0)];
            crl.getDEREncoding(output, 0, 0);
        }
        catch (CertificateException e) {
            throw new DatabaseException("Error: X509CRL operation failed.", e);
        }
        this.crlReadWriteLock.writeLock().lock();
        try {
            File file = this.findCRLFile(baseName, issuerName, thisUpdate);
            if (file != null) {
                return;
            }
            file = this.findNewFileName(this.crlDir, baseName, CRL_TYPE);
            this.writeToFile(file, output);
        }
        finally {
            this.crlReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int selectCRL(X500Name issuerName, Date time, Vector<CRL> crlList, CertJ certJ) throws DatabaseException {
        X509CRL bestCRL = null;
        this.crlReadWriteLock.readLock().lock();
        try {
            List<File> files = this.collectMatchingFiles(this.crlDir, this.makeFileName(issuerName, certJ), CRL_TYPE);
            Date bestTime = new Date(0L);
            for (int i = 0; i < files.size(); ++i) {
                Date thisUpdate;
                X509CRL crl = EnhancedFlatFileDBAccess.loadCRLFromFile(files.get(i));
                if (!issuerName.equals(crl.getIssuerName()) || (thisUpdate = crl.getThisUpdate()).after(time) || !thisUpdate.after(bestTime)) continue;
                bestTime = thisUpdate;
                bestCRL = crl;
            }
        }
        finally {
            this.crlReadWriteLock.readLock().unlock();
        }
        if (bestCRL == null) {
            return 0;
        }
        if (!crlList.contains(bestCRL)) {
            crlList.addElement(bestCRL);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteCRL(X500Name issuerName, Date lastUpdate, CertJ certJ) throws DatabaseException {
        if (issuerName == null || lastUpdate == null) {
            throw new DatabaseException("Error: neither issuerName nor lastUpdate should be null.");
        }
        this.crlReadWriteLock.writeLock().lock();
        try {
            File file = this.findCRLFile(this.makeFileName(issuerName, certJ), issuerName, lastUpdate);
            if (file == null) {
                return;
            }
            file.delete();
        }
        finally {
            this.crlReadWriteLock.writeLock().unlock();
        }
    }

    private File findCRLFile(String baseName, X500Name issuerName, Date thisUpdate) throws DatabaseException {
        List<File> files = this.collectMatchingFiles(this.crlDir, baseName, CRL_TYPE);
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            X509CRL crl = EnhancedFlatFileDBAccess.loadCRLFromFile(files.get(i));
            if (crl == null || !issuerName.equals(crl.getIssuerName()) || !thisUpdate.equals(crl.getThisUpdate())) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> allCRLs() {
        this.crlReadWriteLock.readLock().lock();
        try {
            List<File> list = this.collectAllFiles(this.crlDir, CRL_TYPE);
            return list;
        }
        finally {
            this.crlReadWriteLock.readLock().unlock();
        }
    }

    private void deriveKey(CertJ certJ) throws DatabaseException {
        try {
            JSAFE_SecureRandom random = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"CTRDRBG-128-0", (String)"Java");
            SecureRandom seeder = new SecureRandom();
            random.setSeed(seeder.generateSeed(20));
            JSAFE_SecretKey pbKey = JSAFE_SecretKey.getInstance((String)PBKDF_ALGORITHM, (String)certJ.getDevice());
            pbKey.setPassword(this.passphrase, 0, this.passphrase.length);
            pbKey.setSalt(this.salt, 0, this.salt.length);
            pbKey.generateInit(new int[]{256}, (SecureRandom)random);
            pbKey.generate();
            this.secretKey = JSAFE_SecretKey.getInstance((String)"AES256", (String)certJ.getDevice());
            byte[] keyData = pbKey.getSecretKeyData();
            this.secretKey.setSecretKeyData(keyData, 0, keyData.length);
        }
        catch (Exception e) {
            throw new DatabaseException("Could not derive key encryption key: ", e);
        }
    }

    private static JSAFE_PublicKey loadPublicKeyFromFile(File input, CertJ certJ) throws DatabaseException {
        try {
            byte[] keyArray = EnhancedFlatFileDBAccess.loadBinaryFromFile(input);
            return JSAFEFactory.getPublicKey(keyArray, 0, certJ.getDevice(), certJ);
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: unable to instantiate a public key object.", (Exception)((Object)e));
        }
    }

    JSAFE_PrivateKey loadPrivateKeyFromFile(File input, CertJ certJ) throws DatabaseException {
        return this.decryptPrivateKey(EnhancedFlatFileDBAccess.loadBinaryFromFile(input), certJ);
    }

    protected synchronized byte[] encryptPrivateKey(JSAFE_PrivateKey privateKey, CertJ certJ) throws DatabaseException {
        JSAFE_KeyWrapCipher keyWrapper = null;
        try {
            if (this.secretKey == null) {
                this.deriveKey(certJ);
            }
            keyWrapper = JSAFE_KeyWrapCipher.getInstance((String)KEYWRAP_ALGORITHM, (String)certJ.getDevice());
            keyWrapper.encryptInit(this.secretKey);
            byte[] byArray = keyWrapper.wrapPrivateKey(privateKey);
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: symmetric cipher operation failed.", (Exception)((Object)e));
        }
        finally {
            if (keyWrapper != null) {
                keyWrapper.clearSensitiveData();
            }
        }
    }

    protected JSAFE_PrivateKey decryptPrivateKey(byte[] data, CertJ certJ) throws DatabaseException {
        JSAFE_KeyWrapCipher keyUnwrapper = null;
        try {
            if (this.secretKey == null) {
                this.deriveKey(certJ);
            }
            keyUnwrapper = JSAFE_KeyWrapCipher.getInstance((String)KEYWRAP_ALGORITHM, (String)certJ.getDevice());
            keyUnwrapper.decryptInit(this.secretKey);
            JSAFE_PrivateKey jSAFE_PrivateKey = keyUnwrapper.unwrapPrivateKey(data, 0, data.length);
            return jSAFE_PrivateKey;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: symmetric cipher operation failed.", (Exception)((Object)e));
        }
        finally {
            if (keyUnwrapper != null) {
                keyUnwrapper.clearSensitiveData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey, CertJ certJ) throws DatabaseException {
        byte[][] ber;
        byte[] output;
        String baseName;
        try {
            baseName = this.makeFileName(publicKey);
            output = this.encryptPrivateKey(privateKey, certJ);
            ber = publicKey.getKeyData(publicKey.getAlgorithm() + "PublicKeyBER");
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: publicKey getKeyData failed.", (Exception)((Object)e));
        }
        this.keyReadWriteLock.writeLock().lock();
        try {
            File file = (File)this.findKey(baseName, publicKey, true, certJ);
            if (file != null) {
                return;
            }
            file = this.findNewFileName(this.privDir, baseName, PRV_TYPE);
            this.writeToFile(file, output);
            this.writeToFile(new File(this.pubDir, this.matchingPublicKeyFileName(file.getName())), ber[0]);
        }
        finally {
            this.keyReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSAFE_PrivateKey selectPrivateKey(JSAFE_PublicKey publicKey, CertJ certJ) throws DatabaseException {
        this.keyReadWriteLock.readLock().lock();
        try {
            JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)this.findKey(this.makeFileName(publicKey), publicKey, false, certJ);
            return jSAFE_PrivateKey;
        }
        finally {
            this.keyReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteKey(JSAFE_PublicKey publicKey, CertJ certJ) throws DatabaseException {
        try {
            publicKey.getKeyData(publicKey.getAlgorithm() + "PublicKeyBER");
        }
        catch (JSAFE_UnimplementedException e1) {
            // empty catch block
        }
        this.keyReadWriteLock.writeLock().lock();
        try {
            List<File> files = this.collectMatchingFiles(this.pubDir, this.makeFileName(publicKey), PUB_TYPE);
            for (int i = 0; i < files.size(); ++i) {
                File pubFile = files.get(i);
                JSAFE_PublicKey foundKey = EnhancedFlatFileDBAccess.loadPublicKeyFromFile(pubFile, certJ);
                if (foundKey.getAlgorithm().equals(publicKey.getAlgorithm())) {
                    try {
                        foundKey.getKeyData(foundKey.getAlgorithm() + "PublicKeyBER");
                    }
                    catch (JSAFE_UnimplementedException e) {
                        // empty catch block
                    }
                }
                if (!publicKey.equals((Object)foundKey)) continue;
                File privFile = new File(this.privDir, this.matchingPrivateKeyFileName(pubFile.getName()));
                pubFile.delete();
                privFile.delete();
                return;
            }
        }
        finally {
            this.keyReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> allKeys() {
        this.keyReadWriteLock.readLock().lock();
        try {
            List<File> list = this.collectAllFiles(this.privDir, PRV_TYPE);
            return list;
        }
        finally {
            this.keyReadWriteLock.readLock().unlock();
        }
    }

    private Object findKey(String baseName, JSAFE_PublicKey publicKey, boolean returnFile, CertJ certJ) throws DatabaseException {
        try {
            publicKey.getKeyData(publicKey.getAlgorithm() + "PublicKeyBER");
        }
        catch (JSAFE_UnimplementedException e1) {
            // empty catch block
        }
        List<File> files = this.collectMatchingFiles(this.pubDir, baseName, PUB_TYPE);
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            JSAFE_PublicKey foundKey = EnhancedFlatFileDBAccess.loadPublicKeyFromFile(file, certJ);
            if (foundKey.getAlgorithm().equals(publicKey.getAlgorithm())) {
                try {
                    foundKey.getKeyData(foundKey.getAlgorithm() + "PublicKeyBER");
                }
                catch (JSAFE_UnimplementedException e) {
                    // empty catch block
                }
            }
            if (!publicKey.equals((Object)foundKey)) continue;
            File privFile = new File(this.privDir, this.matchingPrivateKeyFileName(file.getName()));
            if (returnFile) {
                return privFile;
            }
            return this.loadPrivateKeyFromFile(privFile, certJ);
        }
        return null;
    }

    protected File findNewFileName(File directory, String baseName, String extension) throws DatabaseException {
        File file;
        int prefix = 0;
        do {
            if (prefix == 999999) {
                throw new DatabaseException("Database in " + directory.toString() + " is full.");
            }
            file = new File(directory, prefix + "_" + baseName + "." + extension);
            ++prefix;
        } while (file.exists());
        return file;
    }

    private void writeToFile(File file, byte[] data) throws DatabaseException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(data);
            out.flush();
        }
        catch (IOException e) {
            throw new DatabaseException("Error writing to file.");
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {}
        }
    }

    private String matchingPublicKeyFileName(String name) {
        return name.substring(0, name.length() - PRV_TYPE.length()) + PUB_TYPE;
    }

    private String matchingPrivateKeyFileName(String name) {
        return name.substring(0, name.length() - PUB_TYPE.length()) + PRV_TYPE;
    }

    protected String makeFileName(X500Name issuerName, CertJ certJ) throws DatabaseException {
        try {
            int nameLength = issuerName.getDERLen(0);
            byte[] input = new byte[nameLength];
            issuerName.getDEREncoding(input, 0, 0);
            int hash = CertJUtils.bytesToHashCode(input);
            return Integer.toHexString(hash |= Integer.MIN_VALUE);
        }
        catch (NameException e) {
            throw new DatabaseException("Error: X500Name operation failed.", e);
        }
    }

    protected String makeFileName(X500Name issuerName, byte[] serialNumber, CertJ certJ) throws DatabaseException {
        try {
            int nameLength = issuerName.getDERLen(0);
            byte[] input = new byte[nameLength];
            issuerName.getDEREncoding(input, 0, 0);
            int hash = CertJUtils.bytesToHashCode(input);
            hash ^= CertJUtils.bytesToHashCode(serialNumber);
            return Integer.toHexString(hash |= Integer.MIN_VALUE);
        }
        catch (NameException e) {
            throw new DatabaseException("Error: X500Name operation failed.", e);
        }
    }

    protected String makeFileName(JSAFE_PublicKey publicKey) throws DatabaseException {
        int hash = 0;
        if (publicKey.getAlgorithm().equals("EC") && publicKey.getDevice().equals("Native")) {
            try {
                byte[] ber = publicKey.getKeyData("ECPublicKeyBER")[0];
                publicKey = JSAFE_PublicKey.getInstance((byte[])ber, (int)0, (String)"Java");
            }
            catch (JSAFE_UnimplementedException e) {
                throw new DatabaseException((Exception)((Object)e));
            }
            catch (JSAFE_InvalidParameterException e) {
                throw new DatabaseException((Exception)((Object)e));
            }
        }
        byte[][] keyData = publicKey.getKeyData();
        for (int i = 0; i < keyData.length; ++i) {
            if (keyData[i] == null) continue;
            hash ^= CertJUtils.bytesToHashCode(keyData[i]);
        }
        return Integer.toHexString(hash |= Integer.MIN_VALUE);
    }

    private static class DbFilenameFilter
    implements FilenameFilter {
        private final String basefilename;

        public DbFilenameFilter(String basename, String extension) {
            this.basefilename = basename + "." + extension;
        }

        public DbFilenameFilter(String extension) {
            this.basefilename = "." + extension;
        }

        public boolean accept(File directory, String filename) {
            return filename.endsWith(this.basefilename);
        }
    }
}

