/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.db.EnhancedFlatFileDBAccess;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.File;
import java.security.SecureRandom;

public class FlatFileDBAccess
extends EnhancedFlatFileDBAccess {
    private static final String PBE_ALGORITHM = "PBE/SHA1/RC4/PKCS12V1PBE-5-128";
    private static final String DIGEST_TYPE = "MD5";
    private int baseNameLen;
    private int prefixLen;

    FlatFileDBAccess(File path, char[] passphrase, int baseNameLen, int prefixLen) throws DatabaseException {
        super(path, passphrase, null);
        this.baseNameLen = baseNameLen;
        this.prefixLen = prefixLen;
    }

    private static String hexEncode(byte value) {
        int higher;
        char[] hex = new char[2];
        int lower = value & 0xF;
        if (lower < 0) {
            lower += 16;
        }
        if ((higher = value >> 4) < 0) {
            higher += 16;
        }
        hex[1] = lower < 10 ? (char)(48 + lower) : (char)(65 + (lower - 10));
        hex[0] = higher < 10 ? (char)(48 + higher) : (char)(65 + (higher - 10));
        return new String(hex);
    }

    protected byte[] encryptPrivateKey(JSAFE_PrivateKey privateKey, CertJ certJ) throws DatabaseException {
        JSAFE_SymmetricCipher keyWrapper = null;
        try {
            keyWrapper = JSAFEFactory.getSymmetricCipher(PBE_ALGORITHM, certJ.getDevice(), certJ);
            JSAFE_SecureRandom saltRandom = certJ.getRandomObject();
            keyWrapper.generateSalt((SecureRandom)saltRandom);
            JSAFE_SecretKey secretKey = keyWrapper.getBlankKey();
            secretKey.setPassword(this.passphrase, 0, this.passphrase.length);
            keyWrapper.encryptInit(secretKey, (SecureRandom)saltRandom);
            byte[] byArray = keyWrapper.wrapPrivateKey(privateKey, true);
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: symmetric cipher operation failed.", (Exception)((Object)e));
        }
        catch (NoServiceException e) {
            throw new DatabaseException("Error: random provider is not available in certJ.", e);
        }
        catch (RandomException e) {
            throw new DatabaseException("Error: random number generation failed.", e);
        }
        finally {
            if (keyWrapper != null) {
                keyWrapper.clearSensitiveData();
            }
        }
    }

    protected JSAFE_PrivateKey decryptPrivateKey(byte[] data, CertJ certJ) throws DatabaseException {
        JSAFE_SymmetricCipher unwrapper = null;
        try {
            unwrapper = JSAFEFactory.getSymmetricCipher(data, 0, certJ.getDevice(), certJ);
            JSAFE_SecretKey unwrappingKey = unwrapper.getBlankKey();
            unwrappingKey.setPassword(this.passphrase, 0, this.passphrase.length);
            byte[] unwrappedKey = FlatFileDBAccess.unwrapBER(data, 0, unwrapper, unwrappingKey);
            JSAFE_PrivateKey jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((byte[])unwrappedKey, (int)0, (String)certJ.getDevice());
            return jSAFE_PrivateKey;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: symmetric cipher operation failed.", (Exception)((Object)e));
        }
        finally {
            if (unwrapper != null) {
                unwrapper.clearSensitiveData();
            }
        }
    }

    private static byte[] unwrapBER(byte[] wrapped, int wrappedOffset, JSAFE_SymmetricCipher cipher, JSAFE_SecretKey unwrappingKey) throws DatabaseException {
        int[] encKeyInfo = FlatFileDBAccess.getEncryptedKeyInfo(wrapped, wrappedOffset);
        int offset = encKeyInfo[0];
        int keyLen = encKeyInfo[1];
        try {
            cipher.decryptInit(unwrappingKey);
            byte[] plain1 = cipher.decryptUpdate(wrapped, offset, keyLen);
            byte[] plain2 = cipher.decryptFinal();
            byte[] result = new byte[plain1.length + plain2.length];
            System.arraycopy(plain1, 0, result, 0, plain1.length);
            System.arraycopy(plain2, 0, result, plain1.length, plain2.length);
            return result;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException((Exception)((Object)e));
        }
    }

    private static int[] getEncryptedKeyInfo(byte[] pkcs8Key, int offset) throws DatabaseException {
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer encAlgID = new EncodedContainer(12288);
        OctetStringContainer encData = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, encAlgID, encData, anEnd};
        try {
            ASN1.berDecode((byte[])pkcs8Key, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnExc) {
            throw new DatabaseException("Cannot build the PKCS #8 encrypted key. (" + asnExc.getMessage() + ")");
        }
        return new int[]{encData.dataOffset, encData.dataLen};
    }

    protected File findNewFileName(File directory, String baseName, String extension) throws DatabaseException {
        File file;
        int filePointer = 0;
        int max = 10 * (this.prefixLen + 1);
        char[] prefix = new char[this.prefixLen];
        do {
            int i;
            if (filePointer == max) {
                throw new DatabaseException("Error: Database in " + directory.toString() + " is full.");
            }
            String numString = "" + filePointer;
            for (i = 0; i < this.prefixLen - numString.length(); ++i) {
                prefix[i] = 48;
            }
            for (i = 0; i < numString.length(); ++i) {
                prefix[this.prefixLen - numString.length() + i] = numString.charAt(i);
            }
            file = new File(directory, new String(prefix) + baseName + "." + extension);
            ++filePointer;
        } while (file.exists());
        return file;
    }

    protected String makeFileName(X500Name issuerName, byte[] serialNumber, CertJ certJ) throws DatabaseException {
        try {
            byte[][] input = new byte[2][];
            int nameLength = issuerName.getDERLen(0);
            input[0] = serialNumber;
            input[1] = new byte[nameLength];
            issuerName.getDEREncoding(input[1], 0, 0);
            JSAFE_MessageDigest digester = JSAFEFactory.getDigest(DIGEST_TYPE, certJ.getDevice(), certJ);
            digester.digestInit();
            for (int i = 0; i < input.length; ++i) {
                digester.digestUpdate(input[i], 0, input[i].length);
            }
            byte[] digestedData = digester.digestFinal();
            return this.truncateByteArray(digestedData);
        }
        catch (NameException e) {
            throw new DatabaseException("Error: X500Name operation failed.", e);
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: digest operation failed.", (Exception)((Object)e));
        }
    }

    protected String makeFileName(X500Name issuerName, CertJ certJ) throws DatabaseException {
        try {
            int nameLength = issuerName.getDERLen(0);
            byte[] input = new byte[nameLength];
            issuerName.getDEREncoding(input, 0, 0);
            JSAFE_MessageDigest digester = JSAFEFactory.getDigest(DIGEST_TYPE, certJ.getDevice(), certJ);
            digester.digestInit();
            digester.digestUpdate(input, 0, input.length);
            byte[] digestedData = digester.digestFinal();
            return this.truncateByteArray(digestedData);
        }
        catch (NameException e) {
            throw new DatabaseException("Error: X500Name operation failed.", e);
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("Error: digest operation failed.", (Exception)((Object)e));
        }
    }

    protected String makeFileName(JSAFE_PublicKey publicKey) {
        int dataLen = this.baseNameLen / 2;
        byte[][] keyData = publicKey.getKeyData();
        byte[] input = keyData[0];
        if (input.length < dataLen) {
            byte[] data = input;
            input = new byte[dataLen];
            System.arraycopy(data, 0, input, 0, data.length);
            for (int i = data.length; i < dataLen; ++i) {
                input[i] = 0;
            }
        }
        String baseName = "";
        int offset = input.length - dataLen;
        for (int i = 0; i < dataLen; ++i) {
            baseName = baseName + FlatFileDBAccess.hexEncode(input[offset + i]);
        }
        return baseName;
    }

    private synchronized String truncateByteArray(byte[] dataToTruncate) {
        int length = this.baseNameLen / 2;
        int dataLen = dataToTruncate.length;
        int offset = dataLen - length;
        byte[] truncatedBytes = new byte[length];
        System.arraycopy(dataToTruncate, offset, truncatedBytes, 0, length);
        StringBuffer string = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            string.append(FlatFileDBAccess.hexEncode(truncatedBytes[i]));
        }
        return string.toString();
    }
}

