/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class LDAPConfiguration {
    public static final int LDAP_AUTH_NONE = 0;
    public static final int LDAP_AUTH_SIMPLE = 1;
    public static final int LDAP_DEFAULT_AUTH_TYPE = 0;
    public static final int LDAP_DEFAULT_PORT_NUMBER = 389;
    public static final int LDAP_DEFAULT_SIZE_LIMIT = 200;
    public static final int LDAP_DEFAULT_TIME_LIMIT = 0;
    public static final String LDAP_DEFAULT_BASE_DN_ATTRS = "o,ou";
    public static final String LDAP_DEFAULT_SEARCH_FILTER_ATTRS = "cn";
    public static final String LDAP_DEFAULT_CERTIFICATE_ATTRS = "usercertificate;binary,caCertificate;binary";
    public static final String LDAP_DEFAULT_CERTIFICATE_REVOCATION_ATTRS = "authorityRevocationList;binary,certificateRevocationList;binary";
    public static final int LDAP_SEARCH_SCOPE_EXACT = 1;
    public static final int LDAP_SEARCH_SCOPE_FILTER = 2;
    public static final int LDAP_SEARCH_SCOPE_BASEDN = 3;
    public static final int LDAP_SEARCH_SCOPE_ALL = 4;
    public static final int LDAP_DEFAULT_SEARCH_SCOPE = 4;
    public static final boolean LDAP_DEFAULT_DISCONNECT_BEFORE_CONNECT = true;
    private String descriptiveName;
    private InetAddress networkAddress;
    private int portNumber = 389;
    private int authType = 0;
    private int sizeLimit = 200;
    private int timeLimit = 0;
    private String baseDNAttrs = "o,ou";
    private String searchRoot;
    private String searchFilterAttrs = "cn";
    private String certificateAttrs = "usercertificate;binary,caCertificate;binary";
    private String certificateRevocationAttrs = "authorityRevocationList;binary,certificateRevocationList;binary";
    private int searchScope = 4;
    private boolean disconnectBeforeConnect = true;

    public LDAPConfiguration(String descriptiveName, InetAddress networkAddress, int portNumber) {
        this.descriptiveName = descriptiveName;
        this.networkAddress = networkAddress;
        this.portNumber = portNumber;
    }

    public LDAPConfiguration(String hostname) throws UnknownHostException {
        this(hostname, InetAddress.getByName(hostname), 389);
    }

    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public String getBaseDNAttrs() {
        return this.baseDNAttrs;
    }

    public void setBaseDNAttrs(String baseDNAttrs) {
        this.baseDNAttrs = baseDNAttrs;
    }

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public void setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(int searchScope) {
        this.searchScope = searchScope;
    }

    public String getSearchFilterAttrs() {
        return this.searchFilterAttrs;
    }

    public void setSearchFilterAttrs(String searchFilterAttrs) {
        this.searchFilterAttrs = searchFilterAttrs;
    }

    public String getCertificateAttrs() {
        return this.certificateAttrs;
    }

    public void setCertificateAttrs(String certificateAttrs) {
        this.certificateAttrs = certificateAttrs;
    }

    public String getCertificateRevocationAttrs() {
        return this.certificateRevocationAttrs;
    }

    public void setCertificateRevocationAttrs(String certificateRevocationAttrs) {
        this.certificateRevocationAttrs = certificateRevocationAttrs;
    }

    public boolean getDisconnectBeforeConnect() {
        return this.disconnectBeforeConnect;
    }

    public void setDisconnectBeforeConnect(boolean disconnectBeforeConnect) {
        this.disconnectBeforeConnect = disconnectBeforeConnect;
    }
}

