/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4relateMatch;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4byteArray;
import codebase.Field4deleteFlag;
import codebase.Field4info;
import codebase.Field4stringBuffer;
import codebase.Tag4info;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.db.CRLFields;
import com.rsa.certj.provider.db.CertFields;
import com.rsa.certj.provider.db.KeyFields;
import com.rsa.certj.provider.db.SearchResult;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class NativeDB
extends Provider {
    private static final String CDX_FILE_TYPE = ".cdx";
    private static final String DBF_FILE_TYPE = ".dbf";
    private static final String FPT_FILE_TYPE = ".fpt";
    private static final char CERT_FILE_PREFIX = 'c';
    private static final char CRL_FILE_PREFIX = 'r';
    private static final char KEY_FILE_PREFIX = 'p';
    static final String SUBJECT_FIELD_NAME = "SUBJECT";
    static final String ISSUER_FIELD_NAME = "ISSUER";
    static final String SERIAL_FIELD_NAME = "SERIAL";
    static final String CERT_FIELD_NAME = "CERT";
    static final String CRL_ISSUER_FIELD_NAME = "ISSUER";
    static final String THIS_UPDATE_FIELD_NAME = "LAST";
    static final String CRL_FIELD_NAME = "CRL";
    static final String SPKI_FIELD_NAME = "SPKI";
    static final String KEY_FIELD_NAME = "KEY";
    static final String SALT_FIELD_NAME = "SALT";
    static final String IV_FIELD_NAME = "IV";
    private static final String SUBJECT_TAG_NAME = "SUBJECT";
    private static final String ISN_TAG_NAME = "ISN";
    private static final String ILU_TAG_NAME = "ILU";
    private static final String SPKI_TAG_NAME = "SPKI";
    private static final String NOT_DELETED_FILTER = ".NOT.DELETED()";
    private static final int NAME_LEN = 128;
    private static final int SUBJECT_LEN = 128;
    private static final int ISSUER_LEN = 128;
    private static final int SERIAL_LEN = 32;
    private static final int THIS_UPDATE_LEN = 4;
    private static final int SPKI_LEN = 20;
    private static final int SALT_LEN = 8;
    private static final int IV_LEN = 8;
    private static final byte KEY_TYPE_RSA = 0;
    private static final byte KEY_TYPE_DSA = 1;
    private static final String MASTER_TABLE_NAME = "rsadb";
    private static final String DATABASE_NAME_FIELD_NAME = "NAME";
    private static final String DATABASE_ID_FIELD_NAME = "ID";
    private static final String DATABASE_NAME_TAG_NAME = "NAME";
    private static final int DATABASE_ID_LEN = 7;
    private static final int DATABASE_NAME_LEN = 32;
    private static final String PBE_CIPHER = "PBE/SHA1/3DES_EDE/CBC/PKCS5V2PBE-1000-3";
    private static final long SCHEMA_VERSION = 3L;
    private static Hashtable<File, Object> masterTableLockHash = new Hashtable();
    private static Hashtable<File, Access> accessHash = new Hashtable();
    private static Code4jni code4;
    private static final Object CODE_4_LOCK;
    File path;
    String databaseName;
    char[] password;
    boolean newDatabase;

    public static boolean create(String pathString, String databaseName) throws InvalidParameterException, DatabaseException {
        if (pathString == null) {
            throw new InvalidParameterException("PathString should not be null.");
        }
        return NativeDB.create(new File(pathString), databaseName);
    }

    public static boolean create(File path, String databaseName) throws InvalidParameterException, DatabaseException {
        if (path == null) {
            throw new InvalidParameterException("Path should not be null.");
        }
        if (databaseName == null) {
            throw new InvalidParameterException("DatabaseName should not be null.");
        }
        return NativeDB.createDatabase(path, databaseName);
    }

    public static boolean delete(String pathString, String databaseName) throws InvalidParameterException, DatabaseException {
        if (pathString == null) {
            throw new InvalidParameterException("PathString should not be null.");
        }
        return NativeDB.delete(new File(pathString), databaseName);
    }

    public static boolean delete(File path, String databaseName) throws InvalidParameterException, DatabaseException {
        if (path == null) {
            throw new InvalidParameterException("Path should not be null.");
        }
        if (databaseName == null) {
            throw new InvalidParameterException("DatabaseName should not be null.");
        }
        return NativeDB.removeDatabase(path, databaseName);
    }

    public static String[] listAllDatabaseNames(String pathString) throws InvalidParameterException, DatabaseException {
        if (pathString == null) {
            throw new InvalidParameterException("PathString should not be null.");
        }
        return NativeDB.listAllDatabaseNames(new File(pathString));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] listAllDatabaseNames(File path) throws InvalidParameterException, DatabaseException {
        if (path == null) {
            throw new InvalidParameterException("Path should not be null.");
        }
        if (!path.exists()) {
            throw new DatabaseException("Path " + path.toString() + " does not exist.");
        }
        Code4jni code = NativeDB.getCode4();
        Object object = NativeDB.getMasterTableLock(path);
        synchronized (object) {
            Data4jni master = NativeDB.openMasterTable(code, path);
            try {
                NativeDB.lock(master);
                int count = master.recCount();
                ArrayList<String> list = new ArrayList<String>();
                Field4stringBuffer nameField = new Field4stringBuffer((Data4)master, "NAME");
                new Field4stringBuffer((Data4)master, DATABASE_ID_FIELD_NAME);
                Field4deleteFlag deletedField = new Field4deleteFlag((Data4)master);
                for (int i = 1; i <= count; ++i) {
                    master.go(i);
                    if (deletedField.deleted) continue;
                    list.add(NativeDB.decodeDatabaseName(nameField.contents));
                }
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
            catch (Error4 e) {
                throw new DatabaseException(NativeDB.error4Message(e));
            }
            finally {
                NativeDB.close(master);
            }
        }
    }

    public NativeDB(String name, String pathString, String databaseName, char[] password, boolean newDatabase) throws InvalidParameterException {
        super(1, name);
        if (pathString == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: pathString should not be null.");
        }
        if (databaseName == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: databaseName should not be null.");
        }
        this.path = new File(pathString);
        this.databaseName = databaseName;
        this.password = password;
        this.newDatabase = newDatabase;
    }

    public NativeDB(String name, File path, String databaseName, char[] password, boolean newDatabase) throws InvalidParameterException {
        super(1, name);
        if (path == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: path should not be null.");
        }
        if (databaseName == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: databaseName should not be null.");
        }
        this.path = path;
        this.databaseName = databaseName;
        this.password = password;
        this.newDatabase = newDatabase;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            boolean success;
            if (this.newDatabase && !(success = NativeDB.createDatabase(this.path, this.databaseName))) {
                throw new ProviderManagementException("Creation of database failed. Check if the database already exists. If so, delete the database first if you want to create a new database with the same name, or create NativeDB with newDatabase being false if you want to use the existing database.");
            }
            return new Implementation(certJ, this.getName());
        }
        catch (CertJException e) {
            throw new ProviderManagementException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Code4jni getCode4() throws DatabaseException {
        Object object = CODE_4_LOCK;
        synchronized (object) {
            if (code4 != null) {
                return code4;
            }
            try {
                code4 = new Code4jni();
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB.getCode4: Java Native Interface access failed.", e);
            }
            catch (UnsatisfiedLinkError e) {
                throw new DatabaseException("NativeDB.getCode4: Java Native Interface access failed. You need to install NativeDB library for your platform." + e.getMessage() + ").");
            }
            code4.safety(false);
            try {
                code4.accessMode((byte)1);
            }
            catch (Error4usage e) {
                throw new DatabaseException("NativeDB.getCode4: unable to get exclusive lock on database" + NativeDB.error4Message((Error4)((Object)e)));
            }
            return code4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findExistingId(Code4jni code, File path, String databaseName) throws DatabaseException {
        Object object = NativeDB.getMasterTableLock(path);
        synchronized (object) {
            Data4jni master = NativeDB.openMasterTable(code, path);
            try {
                NativeDB.lock(master);
                Field4stringBuffer idField = new Field4stringBuffer((Data4)master, DATABASE_ID_FIELD_NAME);
                int recNo = NativeDB.getMasterRecord(master, databaseName);
                if (recNo == 0) {
                    String string = null;
                    return string;
                }
                master.go(recNo);
                String string = idField.contents.toString();
                return string;
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB.findExistingId.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB.findExistingId: " + NativeDB.error4Message(e));
            }
            finally {
                NativeDB.close(master);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String addDatabase(Code4jni code, File path, String databaseName) throws DatabaseException {
        String[] dbNames;
        if (NativeDB.findExistingId(code, path, databaseName) != null) {
            return null;
        }
        try {
            dbNames = NativeDB.listAllDatabaseNames(path);
        }
        catch (InvalidParameterException e) {
            throw new DatabaseException(e);
        }
        if (dbNames.length > 0) {
            throw new DatabaseException("Another database already exists with different name, delete old one first before creating a new one in " + path.getAbsolutePath());
        }
        Object object = NativeDB.getMasterTableLock(path);
        synchronized (object) {
            Data4jni master = NativeDB.openMasterTable(code, path);
            try {
                NativeDB.lock(master);
                Field4byteArray nameField = new Field4byteArray((Data4)master, "NAME");
                Field4stringBuffer idField = new Field4stringBuffer((Data4)master, DATABASE_ID_FIELD_NAME);
                Field4deleteFlag deletedField = new Field4deleteFlag((Data4)master);
                int recNo = NativeDB.getMasterRecord(master, databaseName);
                if (recNo != 0) {
                    String string = null;
                    return string;
                }
                master.go(1);
                StringBuffer nextId = idField.contents;
                recNo = NativeDB.findAvailableMasterRecord(master);
                master.go(recNo);
                StringBuffer encodedString = NativeDB.encodeDatabaseName(databaseName);
                byte[] encodedBytes = encodedString.toString().getBytes();
                nameField.contents = new byte[33];
                System.arraycopy(encodedBytes, 0, nameField.contents, 0, 32);
                nameField.contents[32] = 0;
                idField.contents = nextId;
                deletedField.deleted = false;
                master.update();
                String string = nextId.toString();
                return string;
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB.addDatabase.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB.addDatabase: " + NativeDB.error4Message(e));
            }
            finally {
                NativeDB.close(master);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String deleteDatabase(Code4jni code, File path, String databaseName) throws DatabaseException {
        Object object = NativeDB.getMasterTableLock(path);
        synchronized (object) {
            Data4jni master = NativeDB.openMasterTable(code, path);
            try {
                NativeDB.lock(master);
                Field4byteArray nameByteField = new Field4byteArray((Data4)master, "NAME");
                Field4stringBuffer idField = new Field4stringBuffer((Data4)master, DATABASE_ID_FIELD_NAME);
                Field4deleteFlag deletedField = new Field4deleteFlag((Data4)master);
                int recNo = NativeDB.getMasterRecord(master, databaseName);
                if (recNo == 0) {
                    String string = null;
                    return string;
                }
                master.go(recNo);
                String id = idField.contents.toString();
                master.go(1);
                byte[] nextDeletedRec = nameByteField.contents;
                nameByteField.contents = NativeDB.encodeRecNoAndVersion(recNo);
                master.update();
                master.go(recNo);
                nameByteField.contents = nextDeletedRec;
                deletedField.deleted = true;
                master.update();
                String string = id;
                return string;
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB.deleteDatabase.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB.deleteDatabase: " + NativeDB.error4Message(e));
            }
            finally {
                NativeDB.close(master);
            }
        }
    }

    private static Data4jni openMasterTable(Code4jni code, File path) throws DatabaseException {
        try {
            String masterFile = new File(path, MASTER_TABLE_NAME).toString();
            Data4jni master = new Data4jni(code);
            try {
                master.open(masterFile);
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB.openMasterTable.", e);
            }
            catch (Error4 e) {
                NativeDB.createMasterTable(master, masterFile);
                master.open(masterFile);
            }
            NativeDB.checkSchemaVersion(master);
            NativeDB.close(master);
            master.open(masterFile);
            return master;
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.openMasterTable.", e);
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.openMasterTable: " + NativeDB.error4Message(e));
        }
    }

    private static void checkSchemaVersion(Data4jni master) throws DatabaseException {
        try {
            Field4byteArray nameByteField = new Field4byteArray((Data4)master, "NAME");
            master.go(1);
            byte[] schemaBytes = new byte[4];
            System.arraycopy(nameByteField.contents, 4, schemaBytes, 0, 4);
            int schemaVersion = NativeDB.decodeInt(schemaBytes);
            if ((long)schemaVersion != 3L) {
                throw new DatabaseException("NativeDB.checkSchemaVersion: schema version(" + schemaVersion + ") is wrong(" + 3L + " is expected).");
            }
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.checkSchemaVersion.", e);
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.checkSchemaVersion: " + NativeDB.error4Message(e));
        }
    }

    private static void createMasterTable(Data4jni master, String masterFile) throws DatabaseException {
        try {
            Field4info fieldInfo = new Field4info();
            Tag4info tagInfo = new Tag4info();
            fieldInfo.add("NAME", 'C', 33, 0, false);
            fieldInfo.add(DATABASE_ID_FIELD_NAME, 'C', 7, 0, false);
            tagInfo.add("NAME", "NAME", NOT_DELETED_FILTER, (byte)20, false);
            master.create(masterFile, fieldInfo, tagInfo);
            master.blank();
            master.append();
            Field4byteArray nameByteField = new Field4byteArray((Data4)master, "NAME");
            Field4stringBuffer idField = new Field4stringBuffer((Data4)master, DATABASE_ID_FIELD_NAME);
            Field4deleteFlag deletedField = new Field4deleteFlag((Data4)master);
            nameByteField.contents = NativeDB.encodeRecNoAndVersion(0);
            idField.contents = new StringBuffer("aaaaaaa");
            deletedField.deleted = true;
            master.update();
            NativeDB.close(master);
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.createMasterFile.", e);
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.createMasterFile: " + NativeDB.error4Message(e));
        }
    }

    private static byte[] encodeRecNoAndVersion(int recNo) {
        byte[] result = new byte[33];
        byte[] encodedLong = NativeDB.encodeLong(recNo);
        System.arraycopy(encodedLong, 0, result, 0, 4);
        encodedLong = NativeDB.encodeLong(3L);
        System.arraycopy(encodedLong, 0, result, 4, 4);
        for (int i = 8; i < 33; ++i) {
            result[i] = 32;
        }
        return result;
    }

    private static int getMasterRecord(Data4jni master, String databaseName) throws DatabaseException {
        try {
            master.select("NAME");
            int status = master.seek(NativeDB.encodeDatabaseName(databaseName).toString());
            if (status == 0) {
                return master.recNo();
            }
            return 0;
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.getMasterRecord: " + NativeDB.error4Message(e));
        }
    }

    private static StringBuffer encodeDatabaseName(String databaseName) {
        if (databaseName.length() > 32) {
            return new StringBuffer(databaseName.substring(0, 32));
        }
        StringBuffer buffer = new StringBuffer(databaseName);
        for (int i = 0; i < 32 - databaseName.length(); ++i) {
            buffer.append(' ');
        }
        return buffer;
    }

    private static String decodeDatabaseName(StringBuffer databaseName) {
        int size = 0;
        for (int i = databaseName.length() - 1; i >= 0; --i) {
            if (databaseName.charAt(i) == ' ') continue;
            size = i + 1;
            break;
        }
        char[] chars = new char[size];
        databaseName.getChars(0, size, chars, 0);
        return new String(chars);
    }

    private static int findAvailableMasterRecord(Data4jni master) throws DatabaseException {
        try {
            Field4byteArray nameByteField = new Field4byteArray((Data4)master, "NAME");
            master.go(1);
            byte[] nameContents = nameByteField.contents;
            byte[] recNoBytes = new byte[4];
            System.arraycopy(nameContents, 0, recNoBytes, 0, 4);
            int secondRec = NativeDB.decodeInt(recNoBytes);
            if (secondRec == 0) {
                int status = master.bottom();
                if (status != 0 && status != 3) {
                    throw new DatabaseException("NativeDB.findAvailableMasterRecord: error in going to the bottom.");
                }
                master.blank();
                master.append();
                return master.recNo();
            }
            master.go(secondRec);
            byte[] thirdRec = nameByteField.contents;
            master.go(1);
            nameByteField.contents = thirdRec;
            master.update();
            return secondRec;
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.findAvailableMasterRecord.", e);
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.findAvailableMasterRecord: " + NativeDB.error4Message(e));
        }
    }

    private static String databaseName(File path, String id, char type) {
        StringBuffer filename = new StringBuffer();
        filename.append(type);
        filename.append(id);
        return new File(path, filename.toString()).toString();
    }

    private static void deleteDatabaseFiles(String filename) {
        File file = new File(filename + CDX_FILE_TYPE);
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(filename + DBF_FILE_TYPE)).exists()) {
            file.delete();
        }
        if ((file = new File(filename + FPT_FILE_TYPE)).exists()) {
            file.delete();
        }
    }

    private static byte[] encodeLong(long longVal) {
        byte[] encoded = new byte[4];
        long tmp = longVal;
        for (int i = encoded.length - 1; i >= 0; --i) {
            encoded[i] = (byte)(tmp & 0xFFL);
            tmp >>= 8;
        }
        return encoded;
    }

    private static int decodeInt(byte[] encoding) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int thisValue = encoding[i];
            if (thisValue < 0) {
                thisValue += 256;
            }
            value <<= 8;
            value |= thisValue;
        }
        return value;
    }

    private static boolean createDatabase(File path, String databaseName) throws DatabaseException {
        Data4jni data4;
        if (!path.exists() && !path.mkdirs()) {
            throw new DatabaseException("Unable to create directory " + path.toString() + ".");
        }
        Code4jni code = NativeDB.getCode4();
        String id = NativeDB.addDatabase(code, path, databaseName);
        if (id == null) {
            return false;
        }
        try {
            data4 = new Data4jni(code);
        }
        catch (Error4 e) {
            throw new DatabaseException("Creating each database with one deleted record failed." + NativeDB.error4Message(e));
        }
        NativeDB.createCertDatabase(data4, NativeDB.databaseName(path, id, 'c'));
        NativeDB.createCRLDatabase(data4, NativeDB.databaseName(path, id, 'r'));
        NativeDB.createKeyDatabase(data4, NativeDB.databaseName(path, id, 'p'));
        return true;
    }

    private static void createCertDatabase(Data4jni data4, String file) throws DatabaseException {
        try {
            Field4info fieldInfo = new Field4info();
            Tag4info tagInfo = new Tag4info();
            fieldInfo.add("SUBJECT", 'C', 128, 0, false);
            fieldInfo.add("ISSUER", 'C', 128, 0, false);
            fieldInfo.add(SERIAL_FIELD_NAME, 'C', 32, 0, false);
            fieldInfo.add(CERT_FIELD_NAME, 'M', 1, 0, false);
            tagInfo.add("SUBJECT", "SUBJECT", NOT_DELETED_FILTER, (byte)0, false);
            tagInfo.add(ISN_TAG_NAME, "ISSUER+SERIAL", NOT_DELETED_FILTER, (byte)0, false);
            data4.create(file, fieldInfo, tagInfo);
            data4.blank();
            data4.append();
            CertFields certFields = new CertFields(data4);
            certFields.subject.contents = NativeDB.encodeLong(0L);
            certFields.issuer.contents = new byte[0];
            certFields.serial.contents = new byte[0];
            certFields.cert.contents = new byte[0];
            certFields.deleted.deleted = true;
            data4.update();
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.createCertDatabase.", e);
        }
        catch (Error4 e) {
            NativeDB.deleteDatabaseFiles(file);
            throw new DatabaseException("NativeDB.createCertDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(e));
        }
        finally {
            NativeDB.close(data4);
        }
    }

    private static void createCRLDatabase(Data4jni data4, String file) throws DatabaseException {
        try {
            Field4info fieldInfo = new Field4info();
            Tag4info tagInfo = new Tag4info();
            fieldInfo.add("ISSUER", 'C', 128, 0, false);
            fieldInfo.add(THIS_UPDATE_FIELD_NAME, 'C', 4, 0, false);
            fieldInfo.add(CRL_FIELD_NAME, 'M', 1, 0, false);
            tagInfo.add(ILU_TAG_NAME, "ISSUER+LAST", NOT_DELETED_FILTER, (byte)0, true);
            data4.create(file, fieldInfo, tagInfo);
            data4.blank();
            data4.append();
            CRLFields crlFields = new CRLFields(data4);
            crlFields.issuer.contents = NativeDB.encodeLong(0L);
            crlFields.thisUpdate.contents = new byte[0];
            crlFields.crl.contents = new byte[0];
            crlFields.deleted.deleted = true;
            data4.update();
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.createCRLDatabase.", e);
        }
        catch (Error4 e) {
            NativeDB.deleteDatabaseFiles(file);
            throw new DatabaseException("NativeDB.createCRLDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(e));
        }
        finally {
            NativeDB.close(data4);
        }
    }

    private static void createKeyDatabase(Data4jni data4, String file) throws DatabaseException {
        try {
            Field4info fieldInfo = new Field4info();
            Tag4info tagInfo = new Tag4info();
            fieldInfo.add("SPKI", 'C', 20, 0, false);
            fieldInfo.add(SALT_FIELD_NAME, 'C', 8, 0, false);
            fieldInfo.add(IV_FIELD_NAME, 'C', 8, 0, false);
            fieldInfo.add(KEY_FIELD_NAME, 'M', 1, 0, false);
            tagInfo.add("SPKI", "SPKI", NOT_DELETED_FILTER, (byte)20, true);
            data4.create(file, fieldInfo, tagInfo);
            data4.blank();
            data4.append();
            KeyFields keyFields = new KeyFields(data4);
            keyFields.spki.contents = NativeDB.encodeLong(0L);
            keyFields.salt.contents = new byte[0];
            keyFields.iv.contents = new byte[0];
            keyFields.key.contents = new byte[0];
            keyFields.deleted.deleted = true;
            data4.update();
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.createKeyDatabase.", e);
        }
        catch (Error4 e) {
            NativeDB.deleteDatabaseFiles(file);
            throw new DatabaseException("NativeDB.createKeyDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(e));
        }
        finally {
            NativeDB.close(data4);
        }
    }

    private static boolean removeDatabase(File path, String databaseName) throws DatabaseException {
        Data4jni data4Key;
        Data4jni data4CRL;
        Data4jni data4Cert;
        if (!path.exists()) {
            return false;
        }
        Code4jni code = NativeDB.getCode4();
        try {
            data4Cert = new Data4jni(code);
            data4CRL = new Data4jni(code);
            data4Key = new Data4jni(code);
        }
        catch (Error4usage e) {
            throw new DatabaseException("NativeDB.removeDatabase: unable to create Data4jni(" + NativeDB.error4Message((Error4)((Object)e)) + ").");
        }
        String id = NativeDB.deleteDatabase(code, path, databaseName);
        if (id == null) {
            return false;
        }
        try {
            String certFile = NativeDB.databaseName(path, id, 'c');
            String crlFile = NativeDB.databaseName(path, id, 'r');
            String keyFile = NativeDB.databaseName(path, id, 'p');
            data4Cert.open(certFile);
            NativeDB.lock(data4Cert);
            data4CRL.open(crlFile);
            NativeDB.lock(data4CRL);
            data4Key.open(keyFile);
            NativeDB.lock(data4Key);
            NativeDB.deleteDatabaseFiles(certFile);
            NativeDB.deleteDatabaseFiles(crlFile);
            NativeDB.deleteDatabaseFiles(keyFile);
            accessHash.remove(new File(path, id));
            NativeDB.close(data4Cert);
            NativeDB.close(data4CRL);
            NativeDB.close(data4Key);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new DatabaseException("NativeDB.removeDatabase.", e);
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.removeDatabase: unable to delete database files" + NativeDB.error4Message(e));
        }
        finally {
            NativeDB.closeQuietly(data4Cert);
            NativeDB.closeQuietly(data4CRL);
            NativeDB.closeQuietly(data4Key);
        }
    }

    private static String getError4DescriptionEntry() {
        return "unable to position to a record entry";
    }

    private static String getError4DescriptionField() {
        return "unable to associate Field4 object with a database field";
    }

    private static String getError4DescriptionFile() {
        return "unable to create or open file";
    }

    private static String getError4DescriptionLocked() {
        return "unable to lock an item that has been already locked";
    }

    private static String getError4DescriptionMessage() {
        return "unable to understand a server message";
    }

    private static String getError4DescriptionRelatedmatch() {
        return "unable to locate a slave record";
    }

    private static String getError4DescriptionTagName() {
        return "specified tag name is not open";
    }

    private static String getError4Description(Error4unexpected e) {
        String errorMessage = e.getMessage();
        String codeString = errorMessage.substring(16, errorMessage.length());
        int errorCode = Integer.parseInt(codeString, 10);
        if (errorCode <= -400 && errorCode >= -600) {
            return "expression evaluation error";
        }
        if (errorCode <= -1300 && errorCode >= -1400) {
            return "communication error";
        }
        if (errorCode <= -2100 && errorCode >= -2110) {
            return "server error";
        }
        switch (errorCode) {
            case -10: {
                return "An error occurred while attempting to close a file.";
            }
            case -30: {
                return "An error occurred while attempting to determine the length of a file. This error occurs when CodeBase runs out of valid file handles. If you receive this error, reduce the number of files opened by your application at any given time.";
            }
            case -40: {
                return "An error occurred while setting the length of a file. This error occurs when an application does not have write access to the file or is out of disk space.";
            }
            case -70: {
                return "An error occurred while reading a file.";
            }
            case -80: {
                return "An error occurred while attempting to remove a file. This error will occur when the file  is opened by another user or the current process, and an attempt is made to remove that file.";
            }
            case -90: {
                return "An error occurred while renaming a file. This error can be caused when the file name already exists.";
            }
            case -110: {
                return "An error occurred while unlocking part of a file.";
            }
            case -120: {
                return "An error occurred while writing to a file. This error can occur when the disk is full.";
            }
            case -200: {
                return "Database corruption detected. This error occurs when attempting to open a database that is not actually a true data file. If the file is a data file, its header and possibly its data is corrupt.";
            }
            case -220: {
                return "A data field had an unrecognized field type.";
            }
            case -230: {
                return "The total record length is too large. The maximum is 65534 bytes.";
            }
            case -250: {
                return "This error can occur if Data4.seek(double) tries to do a seek on a non-numeric tag.";
            }
            case -300: {
                return "A tag entry is missing. This error occurs when a key, corresponding to a database record, should be in a tag but is not.";
            }
            case -310: {
                return "An index corruption was detected.";
            }
            case -350: {
                return "An attempt to create an index failed because the Tag4info class contained invalid information.";
            }
            case -710: {
                return "A general CodeBase relation error was discovered.";
            }
            case -720: {
                return "CodeBase could not locate the master record's corresponding slave record.";
            }
            case -910: {
                return "CodeBase discovered an unexpected value in one of its internal variables.";
            }
            case -920: {
                return "CodeBase tried to allocate some memory from the heap but no memory was available.";
            }
            case -930: {
                return "A CodeBase method was passed an unexpected value.";
            }
            case -935: {
                return "A CodeBase method was passed a null value.";
            }
            case -940: {
                return "Exceeded maximum support due to demo version of CodeBase.";
            }
            case -950: {
                return "A CodeBase function returned an unexpected result to another CodeBase function.";
            }
            case -960: {
                return "Unexpected result while attempting to verify the integrity of a structure.";
            }
            case -970: {
                return "CodeBase internal structures have been detected as invalid.";
            }
            case -1090: {
                return "Operation generally not supported in this configuration.";
            }
            case -1095: {
                return "Version mismatch (e.g. client version mismatches server version).";
            }
            case -1110: {
                return "A memo file or entry is corrupt.";
            }
            case -1120: {
                return "Could not create memo file.";
            }
            case -1400: {
                return "The capabilities of CodeBase or the server have been maxed out. For example, the maximum allowable connections may have been exceeded by the server.";
            }
            case -1420: {
                return "The specified name was invalid or not found.";
            }
            case -1430: {
                return "The requested operation could not be performed because the requester has insufficient authority to perform the operation. For example, a user without creation privileges has made a call to Data4.create(java.lang.String, codebase.Field4info, codebase.Tag4info).";
            }
        }
        return "Unknown error code";
    }

    private static String getError4DescriptionUnique() {
        return "unable to add a duplicate key to a unique tag";
    }

    private static String getError4DescriptionUsage() {
        return "a CodeBase method is called in an incorrect manner";
    }

    static String error4Message(Error4 error) {
        try {
            throw error;
        }
        catch (Error4usage e) {
            return NativeDB.getError4DescriptionUsage();
        }
        catch (Error4unexpected e) {
            return NativeDB.getError4Description(e);
        }
        catch (Error4unique e) {
            return NativeDB.getError4DescriptionUnique();
        }
        catch (Error4locked e) {
            return NativeDB.getError4DescriptionLocked();
        }
        catch (Error4field e) {
            return NativeDB.getError4DescriptionField();
        }
        catch (Error4message e) {
            return NativeDB.getError4DescriptionMessage();
        }
        catch (Error4entry e) {
            return NativeDB.getError4DescriptionEntry();
        }
        catch (Error4file e) {
            return NativeDB.getError4DescriptionFile();
        }
        catch (Error4tagName e) {
            return NativeDB.getError4DescriptionTagName();
        }
        catch (Error4relateMatch e) {
            return NativeDB.getError4DescriptionRelatedmatch();
        }
        catch (Error4 e) {
            return "unknown CodeBase error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getMasterTableLock(File file) {
        Hashtable<File, Object> hashtable = masterTableLockHash;
        synchronized (hashtable) {
            Object lock = masterTableLockHash.get(file);
            if (lock == null) {
                lock = new Object();
                masterTableLockHash.put(file, lock);
            }
            return lock;
        }
    }

    private static void lock(Data4jni data4) throws DatabaseException {
        try {
            data4.lockAddAll();
            code4.lock();
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.lock: " + NativeDB.error4Message(e));
        }
    }

    private static void close(Data4jni data4) throws DatabaseException {
        try {
            data4.close();
            code4.unlock();
        }
        catch (Error4 e) {
            throw new DatabaseException("NativeDB.close: unable to close data4(" + NativeDB.error4Message(e) + ").");
        }
    }

    private static void closeQuietly(Data4jni data4) {
        if (data4 == null) {
            return;
        }
        try {
            NativeDB.close(data4);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    private static JSAFE_SymmetricCipher preparePBECipher(byte[] salt, byte[] iv, char[] password, boolean encryption, CertJ certJ) throws DatabaseException {
        try {
            JSAFE_SymmetricCipher des3PBE = JSAFEFactory.getSymmetricCipher(PBE_CIPHER, certJ.getDevice(), certJ);
            des3PBE.setIV(iv, 0, 8);
            des3PBE.setSalt(salt, 0, 8);
            JSAFE_SecretKey des3PBEKey = des3PBE.getBlankKey();
            des3PBEKey.setPassword(password, 0, password.length);
            if (encryption) {
                des3PBE.encryptInit(des3PBEKey, null);
            } else {
                des3PBE.decryptInit(des3PBEKey, null);
            }
            return des3PBE;
        }
        catch (JSAFE_Exception e) {
            throw new DatabaseException("NativeDB.preparePBECipher.", (Exception)((Object)e));
        }
    }

    static {
        CODE_4_LOCK = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Access {
        private String certFile;
        private String crlFile;
        private String keyFile;
        private Data4jni data4Cert;
        private Data4jni data4CRL;
        private Data4jni data4Key;

        private Access(File path, String id) throws DatabaseException {
            Code4jni code = NativeDB.getCode4();
            try {
                this.data4Cert = new Data4jni(code);
                this.data4CRL = new Data4jni(code);
                this.data4Key = new Data4jni(code);
            }
            catch (Error4usage e) {
                throw new DatabaseException("NativeDB$Access.Access: unable to create Data4jni(" + NativeDB.getError4DescriptionUsage() + ").");
            }
            this.certFile = NativeDB.databaseName(path, id, 'c');
            this.crlFile = NativeDB.databaseName(path, id, 'r');
            this.keyFile = NativeDB.databaseName(path, id, 'p');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertCertificate(X509Certificate cert, byte[] issuerSerial, byte[] subject, byte[] issuer, byte[] serial, byte[] der) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    SearchResult result = this.findCert(issuerSerial, cert.getIssuerName(), cert.getSerialNumber(), certFields);
                    if (result != null && result.recNo > 0) {
                        return;
                    }
                    this.data4Cert.go(this.findAvailableRecord(this.data4Cert, certFields.subject));
                    certFields.subject.contents = subject;
                    certFields.issuer.contents = issuer;
                    certFields.serial.contents = serial;
                    certFields.cert.contents = der;
                    certFields.deleted.deleted = false;
                    this.data4Cert.update();
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Acccess.insertCertificate: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Acccess.insertCertificate: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertCRL(X509CRL crl, byte[] issuerTime, byte[] issuer, byte[] thisUpdate, byte[] der) throws DatabaseException {
            Data4jni data4jni = this.data4CRL;
            synchronized (data4jni) {
                try {
                    this.data4CRL.open(this.crlFile);
                    NativeDB.lock(this.data4CRL);
                    CRLFields crlFields = new CRLFields(this.data4CRL);
                    if (this.findCRL(issuerTime, crl.getIssuerName(), crl.getThisUpdate(), crlFields) > 0) {
                        return;
                    }
                    this.data4CRL.go(this.findAvailableRecord(this.data4CRL, crlFields.issuer));
                    crlFields.issuer.contents = issuer;
                    crlFields.thisUpdate.contents = thisUpdate;
                    crlFields.crl.contents = der;
                    crlFields.deleted.deleted = false;
                    this.data4CRL.update();
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.insertCRL: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.insertCRL: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4CRL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insertKey(byte[] spki, byte[] salt, byte[] iv, byte[] der, char[] password, CertJ certJ) throws DatabaseException {
            Data4jni data4jni = this.data4Key;
            synchronized (data4jni) {
                try {
                    this.data4Key.open(this.keyFile);
                    NativeDB.lock(this.data4Key);
                    KeyFields keyFields = new KeyFields(this.data4Key);
                    SearchResult result = this.findKey(spki, keyFields, certJ, password);
                    if (result != null && result.recNo > 0) {
                        return;
                    }
                    this.data4Key.go(this.findAvailableRecord(this.data4Key, keyFields.spki));
                    keyFields.spki.contents = spki;
                    keyFields.salt.contents = salt;
                    keyFields.iv.contents = iv;
                    keyFields.key.contents = der;
                    keyFields.deleted.deleted = false;
                    this.data4Key.update();
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.insertPrivateKey: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.insertPrivateKey: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Key);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, byte[] issuerSerial, Vector<Certificate> certList) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    SearchResult result = this.findCert(issuerSerial, issuerName, serialNumber, certFields);
                    if (result == null) {
                        int n = 0;
                        return n;
                    }
                    X509Certificate cert = (X509Certificate)result.object;
                    if (!certList.contains(cert)) {
                        certList.addElement(cert);
                    }
                    int n = 1;
                    return n;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateByIssuerAndSerialNumber: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateByIssuerAndSerialNumber: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int selectCertificateBySubject(X500Name subjectName, byte[] subject, Vector<Certificate> certList) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    this.data4Cert.select("SUBJECT");
                    int status = this.data4Cert.seek(subject);
                    int count = 0;
                    while (status == 0) {
                        X509Certificate cert;
                        if (certFields.cert.contents.length > 0 && subjectName.equals((cert = new X509Certificate(certFields.cert.contents, 0, 0)).getSubjectName()) && !certFields.deleted.deleted) {
                            if (!certList.contains(cert)) {
                                certList.addElement(cert);
                            }
                            ++count;
                        }
                        status = this.data4Cert.skip(1);
                    }
                    int n = count;
                    return n;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateBySubject: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateBySubject: " + NativeDB.error4Message(e));
                }
                catch (CertificateException e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateBySubject.", e);
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    int count = 0;
                    int total = this.data4Cert.recCount();
                    if (total <= 0) {
                        int n = 0;
                        return n;
                    }
                    for (int i = 1; i <= total; ++i) {
                        this.data4Cert.go(i);
                        if (certFields.deleted.deleted) continue;
                        X509Certificate cert = new X509Certificate(certFields.cert.contents, 0, 0);
                        X500Name subjectName = cert.getSubjectName();
                        if (baseName != null && !subjectName.contains(baseName) || !CertJUtils.compareExtensions(extensions, cert.getExtensions())) continue;
                        if (!certList.contains(cert)) {
                            certList.addElement(cert);
                        }
                        ++count;
                    }
                    int n = count;
                    return n;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateByExtensions: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateByExtensions: " + NativeDB.error4Message(e));
                }
                catch (CertificateException e) {
                    throw new DatabaseException("NativeDB$Access.selectCertificateByExtensions", e);
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int selectCRL(X500Name issuerName, Date time, byte[] issuer, Vector<CRL> crlList) throws DatabaseException {
            Data4jni data4jni = this.data4CRL;
            synchronized (data4jni) {
                try {
                    this.data4CRL.open(this.crlFile);
                    NativeDB.lock(this.data4CRL);
                    CRLFields crlFields = new CRLFields(this.data4CRL);
                    this.data4CRL.select(NativeDB.ILU_TAG_NAME);
                    int status = this.data4CRL.seek(issuer);
                    Date bestTime = new Date(0L);
                    X509CRL bestCRL = null;
                    while (status == 0) {
                        Date lastUpdate;
                        X509CRL crl;
                        if (crlFields.crl.contents.length > 0 && issuerName.equals((crl = new X509CRL(crlFields.crl.contents, 0, 0)).getIssuerName()) && !(lastUpdate = crl.getThisUpdate()).after(time) && lastUpdate.after(bestTime) && !crlFields.deleted.deleted) {
                            bestTime = lastUpdate;
                            bestCRL = crl;
                        }
                        status = this.data4CRL.skip(1);
                    }
                    if (bestCRL == null) {
                        int crl = 0;
                        return crl;
                    }
                    if (!crlList.contains(bestCRL)) {
                        try {
                            crlList.addElement((CRL)bestCRL.clone());
                        }
                        catch (CloneNotSupportedException e) {
                            throw new DatabaseException("NativeDBProvider.selectCRL: Unable to clone a CRL.", e);
                        }
                    }
                    int n = 1;
                    return n;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.selectCRL: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.selectCRL: " + NativeDB.error4Message(e));
                }
                catch (CertificateException e) {
                    throw new DatabaseException("NativeDB$Access.selectCRL.", e);
                }
                finally {
                    NativeDB.close(this.data4CRL);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private JSAFE_PrivateKey selectKey(byte[] spki, char[] password, CertJ certJ) throws DatabaseException {
            Data4jni data4jni = this.data4Key;
            synchronized (data4jni) {
                try {
                    this.data4Key.open(this.keyFile);
                    NativeDB.lock(this.data4Key);
                    KeyFields keyFields = new KeyFields(this.data4Key);
                    SearchResult result = this.findKey(spki, keyFields, certJ, password);
                    if (result == null) {
                        JSAFE_PrivateKey jSAFE_PrivateKey = null;
                        return jSAFE_PrivateKey;
                    }
                    JSAFE_PrivateKey jSAFE_PrivateKey = (JSAFE_PrivateKey)result.object;
                    return jSAFE_PrivateKey;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.selectKey: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.selectKey: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Key);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteCertificate(X500Name issuerName, byte[] serialNumber, byte[] issuerSerial) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    SearchResult result = this.findCert(issuerSerial, issuerName, serialNumber, certFields);
                    if (result == null) {
                        return;
                    }
                    this.deleteRecord(this.data4Cert, result.recNo, certFields.subject, certFields.deleted);
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.deleteCertificate: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.deleteCertificate: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteCRL(X500Name issuerName, Date lastUpdate, byte[] issuerTime) throws DatabaseException {
            Data4jni data4jni = this.data4CRL;
            synchronized (data4jni) {
                try {
                    this.data4CRL.open(this.crlFile);
                    NativeDB.lock(this.data4CRL);
                    CRLFields crlFields = new CRLFields(this.data4CRL);
                    int recNo = this.findCRL(issuerTime, issuerName, lastUpdate, crlFields);
                    if (recNo <= 0) {
                        return;
                    }
                    this.deleteRecord(this.data4CRL, recNo, crlFields.issuer, crlFields.deleted);
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.deleteCRL: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.deleteCRL: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4CRL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteKey(byte[] spki, char[] password, CertJ certJ) throws DatabaseException {
            Data4jni data4jni = this.data4Key;
            synchronized (data4jni) {
                try {
                    this.data4Key.open(this.keyFile);
                    NativeDB.lock(this.data4Key);
                    KeyFields keyFields = new KeyFields(this.data4Key);
                    SearchResult result = this.findKey(spki, keyFields, certJ, password);
                    if (result == null) {
                        return;
                    }
                    this.deleteRecord(this.data4Key, result.recNo, keyFields.spki, keyFields.deleted);
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.deleteKey: unable to open database file.", e);
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.deleteKey: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Key);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Certificate findNextCert(Implementation implementation) throws DatabaseException {
            Data4jni data4jni = this.data4Cert;
            synchronized (data4jni) {
                try {
                    this.data4Cert.open(this.certFile);
                    NativeDB.lock(this.data4Cert);
                    CertFields certFields = new CertFields(this.data4Cert);
                    int count = this.data4Cert.recCount();
                    if (implementation.certIterator > count) {
                        Certificate certificate = null;
                        return certificate;
                    }
                    while (implementation.certIterator <= count) {
                        this.data4Cert.go(implementation.certIterator);
                        if (!certFields.deleted.deleted) {
                            X509Certificate x509Certificate = new X509Certificate(certFields.cert.contents, 0, 0);
                            return x509Certificate;
                        }
                        implementation.certIterator++;
                    }
                    implementation.certIterator--;
                    Certificate certificate = null;
                    return certificate;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.findNextCert: unable to open database file.", e);
                }
                catch (CertificateException e) {
                    throw new DatabaseException("NativeDB$Access.findNextCert: unable to create a certificate object.", e);
                }
                catch (Error4entry e) {
                    Certificate certificate = null;
                    return certificate;
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.findNextCert: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Cert);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CRL findNextCRL(Implementation implementation) throws DatabaseException {
            Data4jni data4jni = this.data4CRL;
            synchronized (data4jni) {
                try {
                    this.data4CRL.open(this.crlFile);
                    NativeDB.lock(this.data4CRL);
                    CRLFields crlFields = new CRLFields(this.data4CRL);
                    int count = this.data4CRL.recCount();
                    if (implementation.crlIterator > count) {
                        CRL cRL = null;
                        return cRL;
                    }
                    while (implementation.crlIterator <= count) {
                        this.data4CRL.go(implementation.crlIterator);
                        if (!crlFields.deleted.deleted) {
                            X509CRL x509CRL = new X509CRL(crlFields.crl.contents, 0, 0);
                            return x509CRL;
                        }
                        implementation.crlIterator++;
                    }
                    implementation.crlIterator--;
                    CRL cRL = null;
                    return cRL;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.findNextCRL: unable to open database file.", e);
                }
                catch (CertificateException e) {
                    throw new DatabaseException("NativeDB$Access.findNextCRL: unable to create a CRL object.", e);
                }
                catch (Error4entry e) {
                    CRL cRL = null;
                    return cRL;
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.findNextCRL: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4CRL);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private JSAFE_PrivateKey findNextKey(Implementation implementation, CertJ certJ, char[] password) throws DatabaseException {
            Data4jni data4jni = this.data4Key;
            synchronized (data4jni) {
                try {
                    this.data4Key.open(this.keyFile);
                    NativeDB.lock(this.data4Key);
                    KeyFields keyFields = new KeyFields(this.data4Key);
                    int count = this.data4Key.recCount();
                    if (implementation.keyIterator > count) {
                        JSAFE_PrivateKey jSAFE_PrivateKey = null;
                        return jSAFE_PrivateKey;
                    }
                    while (implementation.keyIterator <= count) {
                        this.data4Key.go(implementation.keyIterator);
                        if (!keyFields.deleted.deleted) {
                            JSAFE_PrivateKey jSAFE_PrivateKey = this.decryptPrivateKey(keyFields.key.contents, keyFields.salt.contents, keyFields.iv.contents, password, certJ);
                            return jSAFE_PrivateKey;
                        }
                        implementation.keyIterator++;
                    }
                    implementation.keyIterator--;
                    JSAFE_PrivateKey jSAFE_PrivateKey = null;
                    return jSAFE_PrivateKey;
                }
                catch (IOException e) {
                    throw new DatabaseException("NativeDB$Access.findNextKey: unable to open database file.", e);
                }
                catch (Error4entry e) {
                    JSAFE_PrivateKey jSAFE_PrivateKey = null;
                    return jSAFE_PrivateKey;
                }
                catch (Error4 e) {
                    throw new DatabaseException("NativeDB$Access.findNextKey: " + NativeDB.error4Message(e));
                }
                finally {
                    NativeDB.close(this.data4Key);
                }
            }
        }

        private void deleteRecord(Data4jni data4, int recNo, Field4byteArray recField, Field4deleteFlag deleteField) throws DatabaseException {
            try {
                data4.go(1);
                byte[] nextDeletedRec = recField.contents;
                recField.contents = NativeDB.encodeLong(recNo);
                data4.update();
                data4.go(recNo);
                recField.contents = nextDeletedRec;
                deleteField.deleted = true;
                data4.update();
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB$Access.deleteRecord: " + NativeDB.error4Message(e));
            }
        }

        private int findAvailableRecord(Data4jni data4, Field4byteArray field) throws DatabaseException {
            try {
                data4.go(1);
                if (NativeDB.decodeInt(field.contents) == 0) {
                    int status = data4.bottom();
                    if (status != 0 && status != 3) {
                        throw new DatabaseException("NativeDB$Access.findAvailableRecord: error in going to the bottom.");
                    }
                    data4.blank();
                    data4.append();
                    return data4.recNo();
                }
                int secondRec = NativeDB.decodeInt(field.contents);
                data4.go(secondRec);
                byte[] thirdRec = field.contents;
                data4.go(1);
                field.contents = thirdRec;
                data4.update();
                return secondRec;
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB$Access.findAvailableRecord.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB$Access.findAvailableRecord: " + NativeDB.error4Message(e));
            }
        }

        private SearchResult findCert(byte[] issuerSerial, X500Name issuerName, byte[] serialNumber, CertFields certFields) throws DatabaseException {
            try {
                this.data4Cert.select(NativeDB.ISN_TAG_NAME);
                int status = this.data4Cert.seek(issuerSerial);
                while (status == 0) {
                    X509Certificate cert;
                    if (certFields.cert.contents.length > 0 && (cert = new X509Certificate(certFields.cert.contents, 0, 0)).getIssuerName().equals(issuerName) && CertJUtils.byteArraysEqual(cert.getSerialNumber(), serialNumber) && !certFields.deleted.deleted) {
                        return new SearchResult(this.data4Cert.recNo(), cert);
                    }
                    status = this.data4Cert.skip(1);
                }
                return null;
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Access.findCert: unable to create an X509Certificate object.", e);
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB$Access.findCert.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB$Access.findCert: " + NativeDB.error4Message(e));
            }
        }

        private int findCRL(byte[] issuerTime, X500Name issuerName, Date lastUpdate, CRLFields crlFields) throws DatabaseException {
            try {
                this.data4CRL.select(NativeDB.ILU_TAG_NAME);
                int status = this.data4CRL.seek(issuerTime);
                while (status == 0) {
                    X509CRL crl;
                    if (crlFields.crl.contents.length > 0 && issuerName.equals((crl = new X509CRL(crlFields.crl.contents, 0, 0)).getIssuerName()) && lastUpdate.equals(crl.getThisUpdate()) && !crlFields.deleted.deleted) {
                        return this.data4CRL.recNo();
                    }
                    status = this.data4CRL.skip(1);
                }
                return 0;
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Access.findCRL: unable to create an X509CRL object.", e);
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB$Access.findCRL.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB$Access.findCRL: " + NativeDB.error4Message(e));
            }
        }

        private SearchResult findKey(byte[] spki, KeyFields keyFields, CertJ certJ, char[] password) throws DatabaseException {
            try {
                this.data4Key.select("SPKI");
                int status = this.data4Key.seek(spki);
                while (status == 0) {
                    if (keyFields.key.contents.length > 0) {
                        JSAFE_PrivateKey key = this.decryptPrivateKey(keyFields.key.contents, keyFields.salt.contents, keyFields.iv.contents, password, certJ);
                        return new SearchResult(this.data4Key.recNo(), key);
                    }
                    status = this.data4Key.skip(1);
                }
                return null;
            }
            catch (IOException e) {
                throw new DatabaseException("NativeDB$Access.findKey.", e);
            }
            catch (Error4 e) {
                throw new DatabaseException("NativeDB$Access.findKey: " + NativeDB.error4Message(e));
            }
        }

        private JSAFE_PrivateKey decryptPrivateKey(byte[] data, byte[] salt, byte[] iv, char[] password, CertJ certJ) throws DatabaseException {
            JSAFE_PrivateKey privateKey;
            byte[] encryptedKey = new byte[data.length - 1];
            System.arraycopy(data, 1, encryptedKey, 0, data.length - 1);
            byte[] ber = this.pbeDecrypt(encryptedKey, salt, iv, password, certJ);
            String device = certJ.getDevice();
            byte[][] privData = new byte[][]{ber};
            try {
                switch (data[0]) {
                    case 0: {
                        privateKey = JSAFEFactory.getPrivateKey("RSA", device, certJ);
                        privateKey.setKeyData("RSAPrivateKeyBER", (byte[][])privData);
                        break;
                    }
                    case 1: {
                        privateKey = JSAFEFactory.getPrivateKey("DSA", device, certJ);
                        privateKey.setKeyData("DSAPrivateKeyBER", (byte[][])privData);
                        break;
                    }
                    default: {
                        throw new DatabaseException("NativeDB$Access.decryptPrivateKey: unknown key type " + data[0]);
                    }
                }
            }
            catch (JSAFE_Exception e) {
                throw new DatabaseException("NativeDB$Access.decryptPrivateKey.", (Exception)((Object)e));
            }
            return privateKey;
        }

        private byte[] pbeDecrypt(byte[] data, byte[] salt, byte[] iv, char[] password, CertJ certJ) throws DatabaseException {
            byte[] decryptedData = new byte[data.length];
            JSAFE_SymmetricCipher des3PBE = null;
            try {
                des3PBE = NativeDB.preparePBECipher(salt, iv, password, false, certJ);
                int outputLen = des3PBE.decryptUpdate(data, 0, data.length, decryptedData, 0);
                outputLen += des3PBE.decryptFinal(decryptedData, outputLen);
                byte[] returnArray = new byte[outputLen];
                System.arraycopy(decryptedData, 0, returnArray, 0, outputLen);
                byte[] byArray = returnArray;
                return byArray;
            }
            catch (JSAFE_Exception e) {
                throw new DatabaseException("NativeDB$Access.pbeDecrypt: PBE decryption failed.", (Exception)((Object)e));
            }
            finally {
                if (des3PBE != null) {
                    des3PBE.clearSensitiveData();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private int certIterator;
        private int crlIterator;
        private int keyIterator;
        private final Object certIteratorLock;
        private final Object crlIteratorLock;
        private final Object keyIteratorLock;
        private Access access;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Implementation(CertJ certJ, String name) throws InvalidParameterException, DatabaseException {
            super(certJ, name);
            this.certIteratorLock = new Object();
            this.crlIteratorLock = new Object();
            this.keyIteratorLock = new Object();
            String id = NativeDB.findExistingId(NativeDB.getCode4(), NativeDB.this.path, NativeDB.this.databaseName);
            if (id == null) {
                throw new DatabaseException("NativeDB$Implementation.Implementation: database named " + NativeDB.this.databaseName + " does not exist in " + NativeDB.this.path.toString() + ".");
            }
            Hashtable hashtable = accessHash;
            synchronized (hashtable) {
                File hashKey = new File(NativeDB.this.path, id);
                this.access = (Access)accessHash.get(hashKey);
                if (this.access == null) {
                    this.access = new Access(NativeDB.this.path, id);
                    accessHash.put(hashKey, this.access);
                }
            }
        }

        @Override
        public void insertCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("NativeDB$Implementation.insertCertificate: certificate should not be null.");
            }
            if (!(certificate instanceof X509Certificate)) {
                throw new DatabaseException("NativeDB$Implementation.insertCertificate: certificate should be an instance of X509Certificate.");
            }
            X509Certificate cert = (X509Certificate)certificate;
            byte[] subject = this.encodeName(cert.getSubjectName(), 128);
            byte[] issuer = this.encodeName(cert.getIssuerName(), 128);
            byte[] serial = this.encodeSerial(cert.getSerialNumber());
            byte[] issuerSerial = this.encodeIssuerSerial(cert.getIssuerName(), cert.getSerialNumber());
            byte[] der = new byte[cert.getDERLen(0)];
            try {
                cert.getDEREncoding(der, 0, 0);
            }
            catch (CertificateException e) {
                throw new NotSupportedException("NativeDB$Implementation.insertCertificate: unable to encode the given certificate.", e);
            }
            this.access.insertCertificate(cert, issuerSerial, subject, issuer, serial, der);
        }

        @Override
        public void insertCRL(CRL genericCRL) throws DatabaseException {
            if (genericCRL == null) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL: genericCRL should not be null.");
            }
            if (!(genericCRL instanceof X509CRL)) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL: genericCRL should be an instance of X509CRL.");
            }
            X509CRL crl = (X509CRL)genericCRL;
            byte[] issuer = this.encodeName(crl.getIssuerName(), 128);
            byte[] thisUpdate = this.encodeDate(crl.getThisUpdate(), 4);
            byte[] der = new byte[crl.getDERLen(0)];
            try {
                crl.getDEREncoding(der, 0, 0);
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL.", e);
            }
            byte[] issuerTime = this.encodeIssuerTime(crl.getIssuerName(), crl.getThisUpdate());
            this.access.insertCRL(crl, issuerTime, issuer, thisUpdate, der);
        }

        @Override
        public void insertPrivateKeyByCertificate(Certificate cert, JSAFE_PrivateKey privateKey) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.insertPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()), privateKey);
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByCertificate.", e);
            }
        }

        @Override
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey key) throws DatabaseException {
            JSAFE_SecureRandom random;
            if (publicKey == null || key == null) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByPublicKey: neither publicKey nor key should be null.");
            }
            byte[] spki = this.encodeSpki(publicKey, this.certJ);
            byte[] salt = new byte[8];
            byte[] iv = new byte[8];
            try {
                random = this.certJ.getRandomObject();
            }
            catch (CertJException e) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKey: random provider is not available in certJ.", e);
            }
            random.nextBytes(salt);
            random.nextBytes(iv);
            byte[] der = this.encryptPrivateKey(key, salt, iv, NativeDB.this.password, this.certJ);
            this.access.insertKey(spki, salt, iv, der, NativeDB.this.password, this.certJ);
        }

        @Override
        public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList) throws DatabaseException {
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCertificateByIssuerAndSerialNumber: neither issuerName nor serialNumber should be null.");
            }
            byte[] issuerSerial = this.encodeIssuerSerial(issuerName, serialNumber);
            return this.access.selectCertificateByIssuerAndSerialNumber(issuerName, serialNumber, issuerSerial, certList);
        }

        @Override
        public int selectCertificateBySubject(X500Name subjectName, Vector<Certificate> certList) throws DatabaseException {
            if (subjectName == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCertificateBySubject: subjectName should not be null.");
            }
            byte[] subject = this.encodeName(subjectName, 128);
            return this.access.selectCertificateBySubject(subjectName, subject, certList);
        }

        @Override
        public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws DatabaseException {
            if (baseName == null && extensions == null) {
                throw new DatabaseException("NativeDB.selectCertificateByExtensions: either baseName or extensions should have a non-null value.");
            }
            return this.access.selectCertificateByExtensions(baseName, extensions, certList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCertificateIteratorSetup() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                return this.certIterator != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCertificateIterator() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                this.certIterator = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate firstCertificate() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                this.setupCertificateIterator();
                try {
                    return this.nextCertificate();
                }
                catch (DatabaseException e) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                Certificate cert;
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                this.certIterator = (cert = this.access.findNextCert(this)) == null ? 0 : ++this.certIterator;
                return cert;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                Certificate cert;
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                boolean bl = (cert = this.access.findNextCert(this)) != null;
                return bl;
            }
        }

        @Override
        public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector<CRL> crlList) throws DatabaseException {
            if (issuerName == null || time == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCRLByIssuerAndTime: neither issuerName nor time should be null.");
            }
            byte[] issuer = this.encodeName(issuerName, 128);
            return this.access.selectCRL(issuerName, time, issuer, crlList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCRLIteratorSetup() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                return this.crlIterator != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupCRLIterator() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.crlIterator = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CRL firstCRL() {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                this.setupCRLIterator();
                try {
                    return this.nextCRL();
                }
                catch (DatabaseException e) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CRL nextCRL() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                CRL crl;
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                this.crlIterator = (crl = this.access.findNextCRL(this)) == null ? 0 : ++this.crlIterator;
                return crl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.crlIteratorLock;
            synchronized (object) {
                CRL crl;
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                boolean bl = (crl = this.access.findNextCRL(this)) != null;
                return bl;
            }
        }

        @Override
        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                return this.selectPrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByCertificate.", e);
            }
        }

        @Override
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            if (publicKey == null) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            byte[] spki = this.encodeSpki(publicKey, this.certJ);
            return this.access.selectKey(spki, NativeDB.this.password, this.certJ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                return this.keyIterator != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setupPrivateKeyIterator() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                this.keyIterator = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSAFE_PrivateKey firstPrivateKey() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                this.setupPrivateKeyIterator();
                try {
                    return this.nextPrivateKey();
                }
                catch (DatabaseException e) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                JSAFE_PrivateKey key;
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                this.keyIterator = (key = this.access.findNextKey(this, this.certJ, NativeDB.this.password)) == null ? 0 : ++this.keyIterator;
                return key;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMorePrivateKeys() throws DatabaseException {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                JSAFE_PrivateKey key;
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                boolean bl = (key = this.access.findNextKey(this, this.certJ, NativeDB.this.password)) != null;
                return bl;
            }
        }

        @Override
        public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws DatabaseException {
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("NativeDB$Implementation.deleteCertificate: neither issuerName nor serialNumber is null.");
            }
            byte[] issuerSerial = this.encodeIssuerSerial(issuerName, serialNumber);
            this.access.deleteCertificate(issuerName, serialNumber, issuerSerial);
        }

        @Override
        public void deleteCRL(X500Name issuerName, Date lastUpdate) throws DatabaseException {
            if (issuerName == null || lastUpdate == null) {
                throw new DatabaseException("NativeDB$Implementation.deleteCRL: neither issuerName nor lastUpdate should be null.");
            }
            byte[] issuerTime = this.encodeIssuerTime(issuerName, lastUpdate);
            this.access.deleteCRL(issuerName, lastUpdate, issuerTime);
        }

        @Override
        public void deletePrivateKeyByCertificate(Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.deletePrivateKeyByPublicKey(cert.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException e) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate.", e);
            }
        }

        @Override
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            if (publicKey == null) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate: publicKey should not be null.");
            }
            byte[] spki = this.encodeSpki(publicKey, this.certJ);
            this.access.deleteKey(spki, NativeDB.this.password, this.certJ);
        }

        @Override
        public String toString() {
            return "NativeDB database provider named: " + super.getName();
        }

        private byte[] encodeName(X500Name name, int length) {
            int len = length;
            if (length == 0) {
                len = 128;
            }
            String backwardString = name.toString(false);
            backwardString = backwardString.toUpperCase();
            byte[] data = new byte[len];
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0;
            }
            byte[] backwardBytes = backwardString.getBytes();
            if (backwardString.length() < len) {
                System.arraycopy(backwardBytes, 0, data, 0, backwardBytes.length);
            } else {
                System.arraycopy(backwardBytes, 0, data, 0, len);
            }
            return data;
        }

        private byte[] encodeSerial(byte[] serial) {
            byte[] chars = new byte[32];
            for (int i = 0; i < 32; ++i) {
                chars[i] = 0;
            }
            if (serial.length < 32) {
                System.arraycopy(serial, 0, chars, 0, serial.length);
            } else {
                System.arraycopy(serial, 0, chars, 0, 32);
            }
            return chars;
        }

        private byte[] encodeIssuerSerial(X500Name issuer, byte[] serial) {
            byte[] isn = new byte[160];
            for (int i = 0; i < isn.length; ++i) {
                isn[i] = 0;
            }
            byte[] nameBytes = this.encodeName(issuer, 0);
            if (nameBytes.length < 128) {
                System.arraycopy(nameBytes, 0, isn, 0, nameBytes.length);
            } else {
                System.arraycopy(nameBytes, 0, isn, 0, 128);
            }
            if (serial.length < 32) {
                System.arraycopy(serial, 0, isn, 128, serial.length);
            } else {
                System.arraycopy(serial, 0, isn, 128, 32);
            }
            return isn;
        }

        private byte[] encodeIssuerTime(X500Name issuer, Date time) {
            byte[] ilu = new byte[132];
            for (int i = 0; i < ilu.length; ++i) {
                ilu[i] = 0;
            }
            byte[] nameBytes = this.encodeName(issuer, 128);
            if (nameBytes.length < 128) {
                System.arraycopy(nameBytes, 0, ilu, 0, nameBytes.length);
            } else {
                System.arraycopy(nameBytes, 0, ilu, 0, 128);
            }
            byte[] timeBytes = this.encodeDate(time, 4);
            System.arraycopy(timeBytes, 0, ilu, 128, 4);
            return ilu;
        }

        private byte[] encodeDate(Date date, int len) {
            long uint4 = date.getTime() / 1000L;
            byte[] value = new byte[len];
            for (int i = len - 1; i >= 0; --i) {
                value[i] = (byte)uint4;
                uint4 >>= 8;
            }
            return value;
        }

        private byte[] encodeSpki(JSAFE_PublicKey publicKey, CertJ certJ) throws DatabaseException {
            JSAFE_MessageDigest sha1 = null;
            try {
                byte[][] ber = publicKey.getKeyData(publicKey.getAlgorithm() + "PublicKeyBER");
                byte[] spki = ber[0];
                int count = spki.length;
                sha1 = JSAFEFactory.getDigest("SHA1", certJ.getDevice(), this.context.jsafe);
                byte[] digestedData = new byte[sha1.getDigestSize()];
                sha1.digestInit();
                int batch = 64;
                for (int start = 0; start < count; start += batch) {
                    sha1.digestUpdate(spki, start, count - start > batch ? batch : count - start);
                }
                sha1.digestFinal(digestedData, 0);
                byte[] byArray = digestedData;
                return byArray;
            }
            catch (JSAFE_Exception e) {
                throw new DatabaseException("NativeDB$Implementation.encodeSpki.", (Exception)((Object)e));
            }
            finally {
                if (sha1 != null) {
                    sha1.clearSensitiveData();
                }
            }
        }

        private byte[] encryptPrivateKey(JSAFE_PrivateKey privateKey, byte[] salt, byte[] iv, char[] password, CertJ certJ) throws DatabaseException {
            byte[][] keyData;
            byte keyType;
            try {
                String alg = privateKey.getAlgorithm();
                if (alg.equals("RSA")) {
                    keyType = 0;
                } else if (alg.equals("DSA")) {
                    keyType = 1;
                } else {
                    throw new DatabaseException("NativeDB$Implementation.encryptPrivateKey: unknown private key type(" + alg + ").");
                }
                keyData = privateKey.getKeyData(alg + "PrivateKeyBER");
            }
            catch (JSAFE_Exception e) {
                throw new DatabaseException("NativeDB$Implementation.encryptPrivateKey: private key operation failed.", (Exception)((Object)e));
            }
            byte[] encryptedKey = this.pbeEncrypt(keyData[0], salt, iv, password, certJ);
            byte[] result = new byte[encryptedKey.length + 1];
            System.arraycopy(encryptedKey, 0, result, 1, encryptedKey.length);
            result[0] = keyType;
            return result;
        }

        private byte[] pbeEncrypt(byte[] data, byte[] salt, byte[] iv, char[] password, CertJ certJ) throws DatabaseException {
            byte[] encryptedData = new byte[data.length + 8];
            JSAFE_SymmetricCipher des3PBE = null;
            try {
                des3PBE = NativeDB.preparePBECipher(salt, iv, password, true, certJ);
                int outputLen = des3PBE.encryptUpdate(data, 0, data.length, encryptedData, 0);
                outputLen += des3PBE.encryptFinal(encryptedData, outputLen);
                byte[] returnArray = new byte[outputLen];
                System.arraycopy(encryptedData, 0, returnArray, 0, outputLen);
                byte[] byArray = returnArray;
                return byArray;
            }
            catch (JSAFE_Exception e) {
                throw new DatabaseException("NativeDB$Implementation.pbeEncrypt: PBE encryption failed.", (Exception)((Object)e));
            }
            finally {
                if (des3PBE != null) {
                    des3PBE.clearSensitiveData();
                }
            }
        }
    }
}

