/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db.pkcs11;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PKCS11SessionSpec;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_SessionSpec;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.provider.HardwareIterator;
import com.rsa.jsafe.provider.HardwareStore;
import com.rsa.jsafe.provider.HardwareStoreException;
import com.rsa.jsafe.provider.JsafeJCE;
import com.rsa.jsafe.provider.JsafeJCEPKCS11;
import com.rsa.jsafe.provider.PKCS11CertIteratorParameters;
import com.rsa.jsafe.provider.PKCS11Key;
import com.rsa.jsafe.provider.PKCS11KeyIteratorParameters;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PKCS11DB
extends Provider {
    JsafeJCEPKCS11 p11Provider;
    HardwareStore store;
    private final java.security.Provider jsafeJCE = new JsafeJCE();
    private HardwareIterator<Certificate> certIterator;
    private HardwareIterator<Key> keyIterator;
    private JSAFE_Session session;
    private boolean sessionFlag;
    private static final String PASSED_IN_SESSION_IS_NULL = "Passed in session is null.";
    private static final String CANNOT_CREATE_PKCS_11_SESSION = "Cannot create PKCS#11 session.";
    private static final String CANNOT_CREATE_PROVIDER = "Cannot create provider.";

    public PKCS11DB(String name, JSAFE_Session session) throws InvalidParameterException {
        super(1, name);
        if (session == null) {
            throw new InvalidParameterException(PASSED_IN_SESSION_IS_NULL);
        }
        this.session = session;
        this.createProvider(name, session);
    }

    public PKCS11DB(String name, JSAFE_PKCS11SessionSpec spec) throws InvalidParameterException {
        super(1, name);
        if (spec == null) {
            throw new InvalidParameterException("Spec is null.");
        }
        try {
            this.session = JSAFE_Session.getInstance((JSAFE_SessionSpec)spec);
            this.sessionFlag = true;
            this.createProvider(name, this.session);
        }
        catch (JSAFE_InvalidParameterException jsafeException) {
            throw new InvalidParameterException(CANNOT_CREATE_PKCS_11_SESSION, (Exception)((Object)jsafeException));
        }
    }

    public PKCS11DB(String name, String libraryName, String tokenLabel, char[] passPhrase, int offset, int len) throws InvalidParameterException {
        super(1, name);
        try {
            JSAFE_PKCS11SessionSpec p11Spec = new JSAFE_PKCS11SessionSpec(libraryName, tokenLabel, passPhrase, offset, len);
            this.session = JSAFE_Session.getInstance((JSAFE_SessionSpec)p11Spec);
            this.sessionFlag = true;
            this.createProvider(name, this.session);
        }
        catch (JSAFE_InvalidParameterException jsafeException) {
            throw new InvalidParameterException(CANNOT_CREATE_PKCS_11_SESSION, (Exception)((Object)jsafeException));
        }
    }

    private void createProvider(String name, JSAFE_Session session) throws InvalidParameterException {
        if (session == null) {
            throw new InvalidParameterException(PASSED_IN_SESSION_IS_NULL);
        }
        JSAFE_SessionSpec spec = session.getSessionSpec();
        if (spec == null || !(spec instanceof JSAFE_PKCS11SessionSpec)) {
            throw new InvalidParameterException("Passed in session does not contain PKCS11 spec.");
        }
        JSAFE_PKCS11SessionSpec p11Spec = (JSAFE_PKCS11SessionSpec)spec;
        try {
            this.p11Provider = this.createP11Provider(name, p11Spec);
        }
        catch (Exception e) {
            this.p11Provider = null;
        }
        if (this.p11Provider == null) {
            throw new InvalidParameterException(CANNOT_CREATE_PROVIDER);
        }
        try {
            this.store = HardwareStore.getInstance((String)"PKCS11", (JsafeJCEPKCS11)this.p11Provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterException(CANNOT_CREATE_PROVIDER);
        }
    }

    private JsafeJCEPKCS11 createP11Provider(String name, JSAFE_PKCS11SessionSpec spec) throws Exception {
        Properties props = new Properties();
        props.setProperty("library", spec.getLibraryName());
        props.setProperty("name", name);
        props.setProperty("tokenLabel", spec.getTokenLabel());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        JsafeJCEPKCS11 jsafeJcePkcs11 = new JsafeJCEPKCS11((InputStream)bais);
        jsafeJcePkcs11.login(CertJUtils.byteArrayToCharArray(spec.getPassPhrase()));
        bais.close();
        baos.close();
        return jsafeJcePkcs11;
    }

    @Override
    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new PKCS11DBImplementation(certJ, this.getName());
        }
        catch (InvalidParameterException invalidException) {
            throw new ProviderManagementException("PKCS11DB.instantiate.", invalidException);
        }
    }

    public String toString() {
        return "PKCS11 database provider named: " + super.getName();
    }

    private int nativeInsertCertificate(byte[] certBER, byte[] ckaId) {
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X509", this.jsafeJCE);
            ByteArrayInputStream bis = new ByteArrayInputStream(certBER);
            Certificate certificate = certFact.generateCertificate(bis);
            bis.close();
            this.store.setCertificate(ckaId, null, certificate);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private int nativeInsertPrivateKey(String alg, byte[] ckaId, byte[] priKeyData) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(alg, this.jsafeJCE);
            PrivateKey key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(priKeyData));
            this.store.setKey(ckaId, null, (Key)key);
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private byte[][] nativeSelectCertByIssuerSerial(byte[] nameBER, byte[] serialNumber, java.security.Provider provider) {
        try {
            ArrayList<java.security.cert.X509Certificate> foundCerts = new ArrayList<java.security.cert.X509Certificate>();
            HardwareStore ps = HardwareStore.getInstance((String)"PKCS11", (JsafeJCEPKCS11)((JsafeJCEPKCS11)provider));
            PKCS11CertIteratorParameters params = new PKCS11CertIteratorParameters(null, null);
            HardwareIterator iterator = ps.certificateIterator((HardwareStore.CertIteratorParameters)params);
            while (iterator.hasNext()) {
                byte[] iteratorSerial;
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)iterator.next();
                byte[] iteratorIssuerName = cert.getIssuerX500Principal().getEncoded();
                if (!CertJUtils.byteArraysEqual(nameBER, iteratorIssuerName) || !CertJUtils.byteArraysEqual(serialNumber, iteratorSerial = cert.getSerialNumber().toByteArray())) continue;
                foundCerts.add(cert);
            }
            int numFound = foundCerts.size();
            byte[][] returnList = new byte[numFound][];
            for (int i = 0; i < numFound; ++i) {
                returnList[i] = ((java.security.cert.X509Certificate)foundCerts.get(i)).getEncoded();
            }
            return returnList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[][] nativeSelectCertBySubject(byte[] nameBER, java.security.Provider provider) {
        try {
            ArrayList<java.security.cert.X509Certificate> foundCerts = new ArrayList<java.security.cert.X509Certificate>();
            HardwareStore ps = HardwareStore.getInstance((String)"PKCS11", (JsafeJCEPKCS11)((JsafeJCEPKCS11)provider));
            PKCS11CertIteratorParameters params = new PKCS11CertIteratorParameters(null, null);
            HardwareIterator iterator = ps.certificateIterator((HardwareStore.CertIteratorParameters)params);
            while (iterator.hasNext()) {
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)iterator.next();
                byte[] iteratorSubjectName = cert.getSubjectX500Principal().getEncoded();
                if (!CertJUtils.byteArraysEqual(nameBER, iteratorSubjectName)) continue;
                foundCerts.add(cert);
            }
            int numFound = foundCerts.size();
            byte[][] returnList = new byte[numFound][];
            for (int i = 0; i < numFound; ++i) {
                returnList[i] = ((java.security.cert.X509Certificate)foundCerts.get(i)).getEncoded();
            }
            return returnList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[][] nativeSelectCertByExtensions(byte[] nameBER, byte[] extBER, java.security.Provider provider) {
        try {
            ArrayList<java.security.cert.X509Certificate> foundCerts = new ArrayList<java.security.cert.X509Certificate>();
            HardwareStore ps = HardwareStore.getInstance((String)"PKCS11", (JsafeJCEPKCS11)((JsafeJCEPKCS11)provider));
            PKCS11CertIteratorParameters params = new PKCS11CertIteratorParameters(null, null);
            HardwareIterator iterator = ps.certificateIterator((HardwareStore.CertIteratorParameters)params);
            while (iterator.hasNext()) {
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)iterator.next();
                byte[] iteratorSubjectName = cert.getSubjectX500Principal().getEncoded();
                if (!CertJUtils.byteArraysEqual(nameBER, iteratorSubjectName)) continue;
                X509Certificate certjCert = new X509Certificate(cert.getEncoded(), 0, 0);
                byte[] foundBER = new byte[certjCert.getExtensions().getDERLen(0)];
                certjCert.getExtensions().getDEREncoding(foundBER, 0, 0);
                if (!CertJUtils.byteArraysEqual(extBER, foundBER)) continue;
                foundCerts.add(cert);
            }
            int numFound = foundCerts.size();
            byte[][] returnList = new byte[numFound][];
            for (int i = 0; i < numFound; ++i) {
                returnList[i] = ((java.security.cert.X509Certificate)foundCerts.get(i)).getEncoded();
            }
            return returnList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[][] nativeSelectPrivateKey(String alg, byte[] ckaId, java.security.Provider provider) {
        try {
            HardwareIterator iterator = this.store.keyIterator((HardwareStore.KeyIteratorParameters)new PKCS11KeyIteratorParameters(ckaId, null, alg));
            if (iterator.hasNext()) {
                PKCS11Key key = (PKCS11Key)iterator.next();
                byte[][] result = new byte[][]{key.getManufacturerId(), key.getKeyId()};
                return result;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private byte[] nativeNextCertificate() {
        try {
            return ((Certificate)this.certIterator.next()).getEncoded();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int nativeDeleteCert(byte[] nameBER, byte[] serialNumber, java.security.Provider provider) {
        try {
            HardwareStore ps = HardwareStore.getInstance((String)"PKCS11", (JsafeJCEPKCS11)((JsafeJCEPKCS11)provider));
            HardwareIterator iterator = ps.certificateIterator((HardwareStore.CertIteratorParameters)new PKCS11CertIteratorParameters(null, null));
            while (iterator.hasNext()) {
                byte[] iteratorSerial;
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)iterator.next();
                byte[] iteratorIssuerName = cert.getIssuerX500Principal().getEncoded();
                if (!CertJUtils.byteArraysEqual(nameBER, iteratorIssuerName) || !CertJUtils.byteArraysEqual(serialNumber, iteratorSerial = cert.getSerialNumber().toByteArray())) continue;
                iterator.remove();
                return 0;
            }
        }
        catch (Exception e) {
            return 1;
        }
        return 1;
    }

    private byte[][] nativeNextPrivateKey(HardwareIterator<Key> keyIterator) {
        PKCS11Key key = (PKCS11Key)keyIterator.next();
        byte[][] result = new byte[][]{key.getManufacturerId(), key.getKeyId()};
        return result;
    }

    private int nativeDeletePrivateKey(String alg, byte[] ckaId) {
        try {
            HardwareIterator iterator = this.store.keyIterator((HardwareStore.KeyIteratorParameters)new PKCS11KeyIteratorParameters(ckaId, null, alg));
            boolean foundKey = false;
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
                foundKey = true;
            }
            if (foundKey) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static String byteArrayToHexString(byte[] buffer) {
        StringBuffer theLine = new StringBuffer();
        int len = buffer.length;
        int offset = 0;
        while (len > 0) {
            int temp = buffer[offset] & 0xFF;
            String hexVal = Integer.toHexString(temp);
            if (hexVal.length() == 1) {
                theLine = theLine.append("0");
            }
            theLine = theLine.append(hexVal);
            --len;
            ++offset;
        }
        return theLine.toString();
    }

    private void nativeFinalizeSession() {
        this.p11Provider.logout();
    }

    static {
        System.loadLibrary("ncm");
    }

    private final class PKCS11DBImplementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private final Object certLock;
        private final Object keyLock;
        private final Object certIteratorLock;
        private final Object keyIteratorLock;
        private static final String PROVIDER_INSERT_CERTIFICATE = "PKCS11DBProvider.insertCertificate: ";
        private static final String INSERT_PRIVATE_KEY_BY_CERTIFICATE = "PKCS11DBProvider.insertPrivateKeyByCertificate: ";
        private static final String INSERT_PRIVATE_KEY_BY_PUBLIC_KEY = "PKCS11DBProvider.insertPrivateKeyByPublicKey: ";
        private static final String SELECT_CERTIFICATE_SESSION_IS_NOT_OPEN = "PKCS11DBProvider.selectCertificate: Session is not open.";
        private static final String PKCS11_DB_PROVIDER_DOES_NOT_SUPPORT = "PKCS11 DB provider does not support ";
        private static final String PKCS11 = "PKCS11";
        private static final int KEY_TYPE_OFFSET = 7;
        private static final int RSA_KEY_TYPE = 0;
        private static final int DSA_KEY_TYPE = 1;
        private static final int DH_KEY_TYPE = 2;
        private final byte[] toSign;

        private PKCS11DBImplementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
            this.certLock = new Object();
            this.keyLock = new Object();
            this.certIteratorLock = new Object();
            this.keyIteratorLock = new Object();
            this.toSign = "Message to sign".getBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertCertificate(com.rsa.certj.cert.Certificate cert) throws DatabaseException {
            if (cert == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: Session is not open. MES DB Provider is not initialized.");
            }
            X500Name issuerName = ((X509Certificate)cert).getIssuerName();
            byte[] serialNumber = ((X509Certificate)cert).getSerialNumber();
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate. IssuerName or SerialNumber is null.");
            }
            try {
                int certLen = ((X509Certificate)cert).getDERLen(0);
                if (certLen == 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate. Cannot DER-encode certificate.");
                }
                byte[] certEncoding = new byte[certLen];
                if ((certLen = ((X509Certificate)cert).getDEREncoding(certEncoding, 0, 0)) == 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate. Cannot DER-encode certificate.");
                }
                byte[] ckaId = this.getCkaId(cert);
                Object object = this.certLock;
                synchronized (object) {
                    if (PKCS11DB.this.nativeInsertCertificate(certEncoding, ckaId) != 0) {
                        throw new DatabaseException("PKCS11DBProvider.insertCertificate: unable to insert certificate");
                    }
                }
            }
            catch (Exception certException) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate.", certException);
            }
        }

        private byte[] getCkaId(JSAFE_PublicKey key) {
            try {
                byte[] ckaId = null;
                if (key.getAlgorithm().equalsIgnoreCase("RSA")) {
                    ckaId = this.digest(key.getKeyData("RSAPublicKey")[0]);
                } else if (key.getAlgorithm().equalsIgnoreCase("DSA")) {
                    byte[][] keyData = key.getKeyData("DSAPublicKey");
                    ckaId = this.digest(keyData[keyData.length - 1]);
                } else if (key.getAlgorithm().equalsIgnoreCase("EC")) {
                    ckaId = null;
                }
                return ckaId;
            }
            catch (Exception e) {
                return null;
            }
        }

        private byte[] getCkaId(com.rsa.certj.cert.Certificate cert) {
            try {
                JSAFE_PublicKey key = cert.getSubjectPublicKey("Java");
                return this.getCkaId(key);
            }
            catch (Exception e) {
                return null;
            }
        }

        private byte[] digest(byte[] message) {
            try {
                JSAFE_MessageDigest digest = JSAFE_MessageDigest.getInstance((String)"SHA1", (String)"Java");
                digest.digestInit();
                digest.digestUpdate(message, 0, message.length);
                return digest.digestFinal();
            }
            catch (Exception e) {
                return null;
            }
        }

        public void insertCRL(CRL crl) throws NotSupportedException {
            throw new NotSupportedException("insertCRL method is not supported by PKCS11DB provider.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertPrivateKeyByCertificate(com.rsa.certj.cert.Certificate cert, JSAFE_PrivateKey privateKey) throws DatabaseException {
            if (cert == null || privateKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.insertPrivateKeyByCertificate: cert and private key should not be null");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: Session is not open.");
            }
            try {
                JSAFE_PublicKey pub = cert.getSubjectPublicKey("Java");
                if (!this.pairwiseCheck(pub.getAlgorithm(), privateKey, pub, this.certJ.getRandomObject())) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: pairwise check failure.");
                }
            }
            catch (Exception e) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: pairwise check failure.");
            }
            Object e = this.keyLock;
            synchronized (e) {
                if (this.selectPrivateKeyByCertificate(cert) != null) {
                    return;
                }
            }
            byte[] priKeyData = this.getPrivateKeyData(privateKey);
            byte[] ckaId = this.getCkaId(cert);
            if (ckaId == null) {
                throw new DatabaseException("PKCS11DBImplementation.insertPrivateKeyByCertificate: Public key in certificate is null.");
            }
            Object object = this.keyLock;
            synchronized (object) {
                if (PKCS11DB.this.nativeInsertPrivateKey(privateKey.getAlgorithm(), ckaId, priKeyData) != 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: unable to insert private key");
                }
                if (this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
            }
        }

        private byte[] getPrivateKeyData(JSAFE_PrivateKey privateKey) throws DatabaseException {
            byte[][] priKeyData = null;
            try {
                int index;
                String[] priFormat = privateKey.getSupportedGetFormats();
                for (index = 0; index < priFormat.length; ++index) {
                    if (!priFormat[index].equals("RSAPrivateKeyBER") && !priFormat[index].equals("DSAPrivateKeyBER") && !priFormat[index].equals("DSAPrivateKeyX957BER")) continue;
                    priKeyData = privateKey.getKeyData(priFormat[index]);
                    break;
                }
                if (index == priFormat.length) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: cannot get private key BER data.");
                }
                if (priKeyData == null || priKeyData.length == 0 || priKeyData[0] == null) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: cannot get private key data");
                }
            }
            catch (JSAFE_UnimplementedException jsafeException) {
                throw new DatabaseException(INSERT_PRIVATE_KEY_BY_CERTIFICATE, (Exception)((Object)jsafeException));
            }
            return priKeyData[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) throws DatabaseException {
            if (publicKey == null || privateKey == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: Neither publicKey nor privateKey should be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: Session is not open.");
            }
            try {
                if (!this.pairwiseCheck(publicKey.getAlgorithm(), privateKey, publicKey, this.certJ.getRandomObject())) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: pairwise check failure.");
                }
            }
            catch (Exception e) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: pairwise check failure.");
            }
            Object e = this.keyLock;
            synchronized (e) {
                if (this.selectPrivateKeyByPublicKey(publicKey) != null) {
                    return;
                }
            }
            byte[] priKeyData = this.getPrivateKeyData(privateKey);
            byte[] ckaId = this.getCkaId(publicKey);
            Object object = this.keyLock;
            synchronized (object) {
                if (PKCS11DB.this.nativeInsertPrivateKey(privateKey.getAlgorithm(), ckaId, priKeyData) != 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: unable to insert private key");
                }
                if (this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector certList) throws DatabaseException {
            byte[][] result;
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("PKCS11DBProvider.Neither issuerName nor serialNumber should be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException(SELECT_CERTIFICATE_SESSION_IS_NOT_OPEN);
            }
            byte[] nameBER = new byte[issuerName.getDERLen(0)];
            try {
                if (issuerName.getDEREncoding(nameBER, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName. Cannot DER-encode IssuerName.");
                }
            }
            catch (NameException nameExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName.", nameExc);
            }
            Object object = this.certLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeSelectCertByIssuerSerial(nameBER, serialNumber, (java.security.Provider)PKCS11DB.this.p11Provider);
            }
            if (result == null) {
                return 0;
            }
            int count = 0;
            try {
                for (int i = 0; i < result.length; ++i) {
                    X509Certificate cert = new X509Certificate(result[i], 0, 0);
                    if (certList.contains(cert)) continue;
                    certList.addElement(cert);
                    ++count;
                }
            }
            catch (CertificateException certExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate.", certExc);
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateBySubject(X500Name subjectName, Vector certList) throws DatabaseException {
            byte[][] result;
            if (subjectName == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificateBySubject: subjectName should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException(SELECT_CERTIFICATE_SESSION_IS_NOT_OPEN);
            }
            byte[] nameBER = new byte[subjectName.getDERLen(0)];
            try {
                if (subjectName.getDEREncoding(nameBER, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid SubjectName. Cannot DER-encode SubjectName.");
                }
            }
            catch (NameException nameExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid SubjectName.", nameExc);
            }
            Object object = this.certLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeSelectCertBySubject(nameBER, (java.security.Provider)PKCS11DB.this.p11Provider);
            }
            if (result == null) {
                return 0;
            }
            int count = 0;
            try {
                for (int i = 0; i < result.length; ++i) {
                    X509Certificate cert = new X509Certificate(result[i], 0, 0);
                    if (certList.contains(cert)) continue;
                    certList.addElement(cert);
                    ++count;
                }
            }
            catch (CertificateException certExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate.", certExc);
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector certList) throws DatabaseException {
            byte[][] result;
            if (baseName == null || extensions == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificateByExtensions: Either baseName or extensions should have a non-null value.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException(SELECT_CERTIFICATE_SESSION_IS_NOT_OPEN);
            }
            byte[] nameBER = new byte[baseName.getDERLen(0)];
            try {
                if (baseName.getDEREncoding(nameBER, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid BaseName. Cannot DER-encode BaseName.");
                }
            }
            catch (NameException nameExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid BaseName.", nameExc);
            }
            byte[] extBER = new byte[extensions.getDERLen(0)];
            if (extensions.getDEREncoding(extBER, 0, 0) == 0) {
                throw new DatabaseException("PKCS11DBProvider: Invalid extensions. Cannot DER-encode extensions.");
            }
            Object object = this.certLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeSelectCertByExtensions(nameBER, extBER, (java.security.Provider)PKCS11DB.this.p11Provider);
            }
            if (result == null) {
                return 0;
            }
            int count = 0;
            try {
                for (int i = 0; i < result.length; ++i) {
                    X509Certificate cert = new X509Certificate(result[i], 0, 0);
                    if (certList.contains(cert)) continue;
                    certList.addElement(cert);
                    ++count;
                }
            }
            catch (CertificateException certExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate.", certExc);
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                return PKCS11DB.this.certIterator != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() {
            Object object = this.certIteratorLock;
            synchronized (object) {
                try {
                    PKCS11DB.this.certIterator = PKCS11DB.this.store.certificateIterator((HardwareStore.CertIteratorParameters)new PKCS11CertIteratorParameters(null, null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.rsa.certj.cert.Certificate firstCertificate() throws DatabaseException {
            byte[] result;
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.firstCertificate: Session is not open.");
            }
            this.setupCertificateIterator();
            Object object = this.certIteratorLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeNextCertificate();
                if (result == null) {
                    PKCS11DB.this.certIterator = null;
                    return null;
                }
            }
            try {
                return new X509Certificate(result, 0, 0);
            }
            catch (CertificateException certException) {
                throw new DatabaseException("PKCS11DBProvider.", certException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public com.rsa.certj.cert.Certificate nextCertificate() throws DatabaseException {
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.nextCertificate: Session is not open.");
            }
            if (!this.isCertificateIteratorSetup()) {
                throw new DatabaseException("PKCS11DBProvider.nextCertificate: iterator is not set up.");
            }
            byte[] result = null;
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (PKCS11DB.this.certIterator.hasNext()) {
                    result = PKCS11DB.this.nativeNextCertificate();
                }
                if (result == null) {
                    PKCS11DB.this.certIterator = null;
                    return null;
                }
            }
            try {
                return new X509Certificate(result, 0, 0);
            }
            catch (CertificateException certException) {
                throw new DatabaseException("PKCS11DBProvider.", certException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.certIteratorLock;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    throw new DatabaseException("Iterator is not set up.");
                }
                return PKCS11DB.this.certIterator.hasNext();
            }
        }

        public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector crlList) throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support selectCRLByIssuerAndTime method.");
        }

        public boolean isCRLIteratorSetup() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support isCRLIteratorSetup() method");
        }

        public void setupCRLIterator() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support setupCRLIterator() method");
        }

        public CRL firstCRL() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support firstCRL() method");
        }

        public CRL nextCRL() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support nextCRL() method");
        }

        public boolean hasMoreCRLs() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not support hasMoreCRLs() method");
        }

        private JSAFE_PrivateKey setPrivateKeyData(byte[][] keyData) throws DatabaseException {
            JSAFE_PrivateKey key = null;
            try {
                if (keyData.length == 1) {
                    key = JSAFEFactory.getPrivateKey(keyData[0], 0, "Java", this.context.jsafe);
                } else if (keyData[0] != null && keyData[1] != null && keyData[1].length >= 8) {
                    if (keyData[1][7] == 0) {
                        key = JSAFEFactory.getPrivateKey("RSA", PKCS11, this.context.jsafe);
                    } else if (keyData[1][7] == 1) {
                        key = JSAFEFactory.getPrivateKey("DSA", PKCS11, this.context.jsafe);
                    } else if (keyData[1][7] == 2) {
                        key = JSAFEFactory.getPrivateKey("DH", PKCS11, this.context.jsafe);
                    } else {
                        throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByCertificate: Invalid Private key - unknown algorithm: " + keyData[1][7]);
                    }
                    byte[][] data = new byte[2][];
                    data[0] = keyData[0];
                    byte[] uniqueKeyData = new byte[keyData[1].length - 7 - 1];
                    System.arraycopy(keyData[1], 8, uniqueKeyData, 0, uniqueKeyData.length);
                    data[1] = uniqueKeyData;
                    key.setKeyData("KeyToken", (byte[][])data);
                }
            }
            catch (JSAFE_Exception jsafeException) {
                throw new DatabaseException("Cannot set the private key data.", (Exception)((Object)jsafeException));
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey selectPrivateKeyByCertificate(com.rsa.certj.cert.Certificate cert) throws DatabaseException {
            byte[][] result;
            if (cert == null) {
                throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.selectPrivateKey: Session is not open.");
            }
            byte[] ckaId = this.getCkaId(cert);
            if (ckaId == null) {
                throw new DatabaseException("Cert does not contain public key info.");
            }
            Object object = this.keyLock;
            synchronized (object) {
                try {
                    result = PKCS11DB.this.nativeSelectPrivateKey(cert.getSubjectPublicKey("Java").getAlgorithm(), ckaId, (java.security.Provider)PKCS11DB.this.p11Provider);
                }
                catch (Exception e) {
                    result = null;
                }
            }
            if (result == null) {
                return null;
            }
            return this.setPrivateKeyData(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            byte[][] result;
            if (publicKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.selectPrivateKey: Session is not open.");
            }
            byte[] ckaId = this.getCkaId(publicKey);
            Object object = this.keyLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeSelectPrivateKey(publicKey.getAlgorithm(), ckaId, (java.security.Provider)PKCS11DB.this.p11Provider);
            }
            if (result == null) {
                return null;
            }
            return this.setPrivateKeyData(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                return PKCS11DB.this.keyIterator != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupPrivateKeyIterator() {
            Object object = this.keyIteratorLock;
            synchronized (object) {
                try {
                    PKCS11DB.this.keyIterator = PKCS11DB.this.store.keyIterator((HardwareStore.KeyIteratorParameters)new PKCS11KeyIteratorParameters(null, null, "RSA"));
                }
                catch (HardwareStoreException hardwareStoreException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.firstPrivateKey: Session is not open.");
            }
            byte[][] result = null;
            this.setupPrivateKeyIterator();
            Object object = this.keyIteratorLock;
            synchronized (object) {
                try {
                    result = PKCS11DB.this.nativeNextPrivateKey((HardwareIterator<Key>)PKCS11DB.this.keyIterator);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (result == null) {
                    PKCS11DB.this.keyIterator = null;
                    return null;
                }
            }
            return this.setPrivateKeyData(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.nextPrivateKey: Session is not open.");
            }
            if (!this.isPrivateKeyIteratorSetup()) {
                throw new DatabaseException("PKCS11DBProvider.nextPrivateKey: iterator is not set up.");
            }
            byte[][] result = null;
            Object object = this.keyIteratorLock;
            synchronized (object) {
                if (result == null) {
                    PKCS11DB.this.keyIterator = null;
                    return null;
                }
            }
            return this.setPrivateKeyData(result);
        }

        public boolean hasMorePrivateKeys() throws NotSupportedException {
            if (!this.isPrivateKeyIteratorSetup()) {
                this.setupPrivateKeyIterator();
            }
            return PKCS11DB.this.keyIterator.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws DatabaseException {
            int result;
            if (issuerName == null || serialNumber == null) {
                throw new DatabaseException("PKCS11DBImplementation.deleteCertificate: Neither issuerName nor serialNumber should be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.deleteCertificate: Session is not open. MES DB provider is not initialized.");
            }
            byte[] nameBER = new byte[issuerName.getDERLen(0)];
            try {
                if (issuerName.getDEREncoding(nameBER, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName. Cannot DER-encode Issuer Name.");
                }
            }
            catch (NameException nameExc) {
                throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName.", nameExc);
            }
            Object object = this.certLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeDeleteCert(nameBER, serialNumber, (java.security.Provider)PKCS11DB.this.p11Provider);
            }
            if (result != 0) {
                throw new DatabaseException("PKCS11DBProvider: Unable to delete certificate.");
            }
        }

        public void deleteCRL(X500Name issuerName, Date lastUpdate) throws NotSupportedException {
            throw new NotSupportedException("deleteCRL method is not supported by PKCS11DB provider.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePrivateKeyByCertificate(com.rsa.certj.cert.Certificate cert) throws DatabaseException {
            int result;
            if (cert == null) {
                throw new DatabaseException("PKCS11DBImplementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.deletePrivateKey: Session is not open.");
            }
            try {
                byte[] ckaId = this.getCkaId(cert);
                if (ckaId == null) {
                    throw new DatabaseException("PKCS11DBProvider: cert is missing public Key.");
                }
                Object object = this.keyLock;
                synchronized (object) {
                    result = PKCS11DB.this.nativeDeletePrivateKey(cert.getSubjectPublicKey("Java").getAlgorithm(), ckaId);
                }
            }
            catch (CertificateException certExc) {
                throw new DatabaseException("PKCS11DBProvider: invalid cert.", certExc);
            }
            if (result != 0) {
                throw new DatabaseException("PKCS11DBProvider: Unable to delete private key.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws DatabaseException {
            int result;
            if (publicKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.deletePrivateKeyByPublicKey: publicKey should not be null.");
            }
            if (PKCS11DB.this.p11Provider == null) {
                throw new DatabaseException("PKCS11DBProvider.deletePrivateKey: Session is not open.");
            }
            byte[] ckaId = this.getCkaId(publicKey);
            Object object = this.keyLock;
            synchronized (object) {
                result = PKCS11DB.this.nativeDeletePrivateKey(publicKey.getAlgorithm(), ckaId);
            }
            if (result != 0) {
                throw new DatabaseException("PKCS11DB: Unable to delete private key.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean pairwiseCheck(String alg, JSAFE_PrivateKey priv, JSAFE_PublicKey pub, JSAFE_SecureRandom random) {
            JSAFE_Signature signer = null;
            JSAFE_Signature verifier = null;
            String sigAlg = "SHA1/" + alg + "/PKCS1Block01Pad";
            try {
                signer = JSAFE_Signature.getInstance((String)sigAlg, (String)"Java");
                signer.signInit(priv, (SecureRandom)random);
                signer.signUpdate(this.toSign, 0, this.toSign.length);
                byte[] signature = signer.signFinal();
                verifier = JSAFE_Signature.getInstance((String)sigAlg, (String)"Java");
                verifier.verifyInit(pub, (SecureRandom)random);
                verifier.verifyUpdate(this.toSign, 0, this.toSign.length);
                boolean bl = verifier.verifyFinal(signature, 0, signature.length);
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (signer != null) {
                    signer.clearSensitiveData();
                }
                if (verifier != null) {
                    verifier.clearSensitiveData();
                }
            }
        }

        public void unregister() {
            if (PKCS11DB.this.p11Provider != null) {
                PKCS11DB.this.nativeFinalizeSession();
            }
            if (PKCS11DB.this.sessionFlag) {
                PKCS11DB.this.session.clearSensitiveData();
                PKCS11DB.this.session.closeSession();
            }
            PKCS11DB.this.store = null;
            PKCS11DB.this.p11Provider = null;
        }

        protected void finalize() {
            this.unregister();
        }
    }
}

