/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.path.PolicyInformation;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CertPathCommonImplementation
extends ProviderImplementation
implements CertPathInterface {
    private CertPathCtx pathCtx;
    private int pathOptions;
    protected Vector<Certificate> trustedCerts;
    private Vector<byte[]> policies;
    private Date validationTime;
    private DatabaseService database;

    public CertPathCommonImplementation(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList) throws NotSupportedException, CertPathException {
        this.savePathCtx(pathCtx);
        if (crlList == null && crlCerts != null) {
            crlCerts = null;
        }
        Vector<Certificate> pathFound = new Vector<Certificate>();
        if (startObject instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)startObject;
            if (!this.verifyCertValidityPeriod(cert)) {
                if (!this.trustedCerts.contains(cert)) return false;
                if (certPath == null) return true;
                if (!certPath.contains(cert)) {
                    certPath.addElement(cert);
                    return true;
                }
            }
            if (!this.certBuildPath(cert, pathFound, crlList, crlCerts, policyInfoList)) {
                return false;
            }
        } else {
            if (!(startObject instanceof X509CRL)) throw new NotSupportedException("CertPathCommonImplementation.buildCertPath: does not support startObjects other than X509Certificate or X509CRL.");
            if (!this.crlBuildPath((X509CRL)startObject, pathFound, crlList, crlCerts, policyInfoList)) {
                return false;
            }
        }
        CertJUtils.mergeLists(certPath, pathFound);
        CertJUtils.subtractLists(crlCerts, certPath);
        return true;
    }

    @Override
    public void getNextCertInPath(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> certList) throws NotSupportedException, CertPathException {
        if (!(baseObject instanceof X509Certificate) && !(baseObject instanceof X509CRL)) {
            throw new NotSupportedException("CertPathCommonImplementation.getNextCertInPath: does not support startObjects other than X509Certificate or X509CRL.");
        }
        this.savePathCtx(pathCtx);
        this.getNextCertInPathInternal(baseObject, certList);
    }

    private void getNextCertInPathInternal(Object baseObject, Vector<Certificate> certList) throws CertPathException {
        Vector<Certificate> candidates = new Vector<Certificate>();
        this.getNextCertCandidates(baseObject, candidates);
        this.removeInvalidNextCerts(baseObject, candidates);
        CertJUtils.mergeLists(certList, candidates);
    }

    @Override
    public boolean validateCertificate(CertPathCtx pathCtx, Certificate cert, JSAFE_PublicKey validationKey) throws NotSupportedException, CertPathException {
        this.savePathCtx(pathCtx);
        if (!(cert instanceof X509Certificate)) {
            throw new NotSupportedException("CertPathCommonImplementation.validateCertificate: does not support certificate types other than X509Certificate.");
        }
        if (!this.verifyCertValidityPeriod((X509Certificate)cert)) {
            return false;
        }
        if ((this.pathOptions & 1) != 0) {
            return true;
        }
        try {
            return cert.verifyCertificateSignature(this.certJ.getDevice(), validationKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException("CertPathCommonImplementation.validateCertificate: (no random service is registered)", e);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getPathOptions() {
        return this.pathOptions;
    }

    public Vector<byte[]> getPolicies() {
        return this.policies;
    }

    public DatabaseService getDatabase() {
        return this.database;
    }

    private boolean certBuildPath(X509Certificate cert, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList) throws CertPathException {
        if (certPath.contains(cert)) {
            return false;
        }
        certPath.addElement(cert);
        if (this.trustedCerts.contains(cert)) {
            if (this.verifyPath(certPath, crlList, crlCerts, policyInfoList)) {
                return true;
            }
            certPath.removeElement(cert);
            return false;
        }
        Vector<Certificate> nextCerts = new Vector<Certificate>();
        this.getNextCertInPathInternal(cert, nextCerts);
        for (Certificate nextCert : nextCerts) {
            if (!this.certBuildPath((X509Certificate)nextCert, certPath, crlList, crlCerts, policyInfoList)) continue;
            return true;
        }
        certPath.removeElement(cert);
        return false;
    }

    private boolean crlBuildPath(X509CRL crl, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList) throws CertPathException {
        Vector<Certificate> crlIssuers = new Vector<Certificate>();
        this.getNextCertInPathInternal(crl, crlIssuers);
        for (Certificate crlIssuer : crlIssuers) {
            if (!this.certBuildPath((X509Certificate)crlIssuer, certPath, crlList, crlCerts, policyInfoList)) continue;
            return true;
        }
        return false;
    }

    public void getNextCertCandidates(Object baseObject, Vector<Certificate> candidates) throws CertPathException {
        throw new CertPathException("CertPathCommonImplementatin.getNextCertCandidates: subclass should override this method.");
    }

    public boolean verifyPath(Vector<Certificate> path, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList) throws CertPathException {
        throw new CertPathException("CertPathCommonImplementation.verifyPath: subclass should overrides this method.");
    }

    public boolean verifyRevocation(X509Certificate cert, Vector<CRL> crlList, Vector<Certificate> crlCerts) throws CertPathException {
        CRL crl;
        CertRevocationInfo revocation;
        if ((this.pathOptions & 4) != 0) {
            return true;
        }
        try {
            revocation = this.certJ.checkCertRevocation(this.pathCtx, cert);
        }
        catch (NoServiceException e) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: (no Certificate Status Service is registered)", e);
        }
        catch (InvalidParameterException e) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: (checkCertRevocation parameters)", e);
        }
        catch (CertStatusException e) {
            throw new CertPathException("CertPathCommonImplementation.verifyRevocation: ", e);
        }
        if (revocation.getStatus() != 0) {
            return false;
        }
        if (revocation.getType() != 1) {
            return true;
        }
        CRLEvidence evidence = (CRLEvidence)revocation.getEvidence();
        if (crlList != null && !crlList.contains(crl = evidence.getCRL())) {
            crlList.addElement(crl);
        }
        CertJUtils.mergeLists(crlList, evidence.getCRLList());
        CertJUtils.mergeLists(crlCerts, evidence.getCertList());
        return true;
    }

    private void removeInvalidNextCerts(Object startObject, Vector<Certificate> nextCerts) throws CertPathException {
        int count = nextCerts.size();
        while (count > 0) {
            X509Certificate nextCert = (X509Certificate)nextCerts.elementAt(--count);
            if (startObject instanceof X509Certificate) {
                if (!this.verifyCertSignature((X509Certificate)startObject, nextCert)) {
                    nextCerts.removeElementAt(count);
                }
            } else if (!this.verifyCrlSignature((X509CRL)startObject, nextCert)) {
                nextCerts.removeElementAt(count);
            }
            if (this.verifyCertValidityPeriod(nextCert)) continue;
            nextCerts.removeElementAt(count);
        }
    }

    private boolean verifyCertSignature(X509Certificate cert, X509Certificate issuer) throws CertPathException {
        if ((this.pathOptions & 1) != 0) {
            return true;
        }
        try {
            JSAFE_PublicKey publicKey = issuer.getSubjectPublicKey(this.certJ.getDevice());
            return cert.verifyCertificateSignature(this.certJ.getDevice(), publicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException("CertPathCommonImplementation.verifyCertSignature:", e);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyCrlSignature(X509CRL crl, X509Certificate issuer) throws CertPathException {
        if ((this.pathOptions & 1) != 0) {
            return true;
        }
        String device = this.certJ.getDevice();
        try {
            JSAFE_PublicKey publicKey = issuer.getSubjectPublicKey(device);
            return crl.verifyCRLSignature(device, publicKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            throw new CertPathException("CertPathCommonImplementation.verifyCrlSignature:", e);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean verifyCertValidityPeriod(X509Certificate cert) {
        if ((this.pathOptions & 2) != 0) {
            return true;
        }
        return !this.validationTime.before(cert.getStartDate()) && !this.validationTime.after(cert.getEndDate());
    }

    private void savePathCtx(CertPathCtx pathCtx) {
        byte[][] ids;
        this.pathCtx = pathCtx;
        this.pathOptions = pathCtx.getPathOptions();
        this.trustedCerts = new Vector();
        Certificate[] certs = pathCtx.getTrustedCerts();
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                this.trustedCerts.addElement(certs[i]);
            }
        }
        if ((ids = pathCtx.getPolicies()) == null) {
            this.policies = null;
        } else {
            this.policies = new Vector();
            for (int i = 0; i < ids.length; ++i) {
                this.policies.addElement(ids[i]);
            }
        }
        this.validationTime = pathCtx.getValidationTime();
        if (this.validationTime == null) {
            this.validationTime = new Date();
        }
        this.database = pathCtx.getDatabase();
    }
}

