/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.path.PKIXCertPathCommon;
import com.rsa.jsafe.JSAFE_PublicKey;

public final class PKIXCertPath
extends Provider {
    public PKIXCertPath(String name) throws InvalidParameterException {
        super(3, name);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException(e);
        }
    }

    private final class Implementation
    extends PKIXCertPathCommon {
        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
        }

        public String toString() {
            return "PKIX Certification Path provider named: " + super.getName();
        }

        protected boolean checkCompliance(X509Certificate certInPath, JSAFE_PublicKey issuerPubKey) {
            return true;
        }

        protected String getCRLComplianceFailedMessage() {
            return ".";
        }
    }
}

