/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.InhibitAnyPolicy;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyMappings;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.internal.Debug;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.path.CertPathCommon;
import com.rsa.certj.provider.path.PKIXCertPathResult;
import com.rsa.certj.provider.path.ValidPolicyTree;
import com.rsa.certj.provider.path.ValidPolicyTreeNode;
import com.rsa.certj.provider.path.X509CertificateValidator;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.path.PolicyInformation;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PKIXCertPathCommon
extends CertPathCommon {
    protected static final String SUITEB_COMPLIANCE_FAILED = "SuiteB compliance checks failed for Certificate with subject: ";
    private final X509CertificateValidator certValidator;

    protected PKIXCertPathCommon(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
        this.certValidator = new X509CertificateValidator(certJ);
    }

    @Override
    protected void getNextCertCandidates(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> candidates) throws CertPathException {
        X509V3Extensions extensions;
        X500Name issuerName;
        if (baseObject instanceof X509Certificate) {
            X509Certificate cert = (X509Certificate)baseObject;
            issuerName = cert.getIssuerName();
            extensions = cert.getExtensions();
        } else if (baseObject instanceof X509CRL) {
            X509CRL crl = (X509CRL)baseObject;
            issuerName = crl.getIssuerName();
            extensions = crl.getExtensions();
        } else {
            throw new CertPathException("PKIXCertPath does not support startObjects other than X509Certificate or X509CRL.");
        }
        this.getNextCertUsingIssuerAndAuthKeyId(pathCtx, issuerName, extensions, candidates);
    }

    @Override
    protected boolean verifyPath(CertPathCtx pathCtx, Vector<Certificate> path, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees, CertPathResult pathResult) throws CertPathException {
        Vector crlListLocal = crlList == null ? null : new Vector();
        Vector crlCertsLocal = crlCerts == null ? null : new Vector();
        int pathLen = path.size();
        int index = pathLen - 1;
        int certIndex = 0;
        X509Certificate certInPath = null;
        X509Certificate issuer = (X509Certificate)path.elementAt(index);
        Debug.println(DEBUG_ON, "Start PKIX verifying path, using trusted root first.");
        if (issuer == null) {
            throw new CertPathException("The certificate path was built incorrectly: A null certificate was found.");
        }
        CertPathState pathState = this.createCertPathState(pathCtx, issuer, pathLen, initialPermittedSubtrees, initialExcludedSubtrees);
        PKIXCertPathResult result = pathResult != null && pathResult instanceof PKIXCertPathResult ? (PKIXCertPathResult)pathResult : new PKIXCertPathResult(this.context);
        while (index > 0) {
            JSAFE_PublicKey issuerPubKey;
            ++certIndex;
            if ((certInPath = (X509Certificate)path.elementAt(--index)) == null) {
                throw new CertPathException("The certificate path was built incorrectly: A null certificate was found.");
            }
            if (DEBUG_ON) {
                Debug.println("Verifying path with certificate " + certInPath.getSubjectName().toString());
            }
            try {
                issuerPubKey = this.getWorkingPublicKey(pathState, issuer);
            }
            catch (CertificateException e) {
                throw new CertPathException(e);
            }
            if (!this.checkCompliance(certInPath, issuerPubKey)) {
                Debug.println(DEBUG_ON, "Compliance check failed.");
                result.setValidationResult(false);
                result.setMessage(SUITEB_COMPLIANCE_FAILED + certInPath.getSubjectName().toString());
                return false;
            }
            Debug.println(DEBUG_ON, "Compliance check passed.");
            try {
                this.certValidator.validateBasics(certInPath, pathCtx, issuerPubKey);
            }
            catch (CertificateException e) {
                Debug.println(DEBUG_ON, "Certificate verification failed.");
                result.setValidationResult(false);
                result.setMessage("Certificate with subject " + certInPath.getSubjectName() + " failed basic certificate checks: " + e.getMessage());
                return false;
            }
            Debug.println(DEBUG_ON, "Basic certificate verification passed.");
            if (!this.verifyRevocation(pathCtx, certInPath, crlListLocal, crlCertsLocal)) {
                Debug.println(DEBUG_ON, "Certificate revocation check failed.");
                result.setValidationResult(false);
                result.setMessage("Certificate with subject " + certInPath.getSubjectName() + " is either revoked or the revocation could not be determined" + this.getCRLComplianceFailedMessage());
                return false;
            }
            if (index == 0 || !this.isSelfIssued(certInPath)) {
                if (!this.verifySubjectAndAltNames(pathState, certInPath)) {
                    result.setValidationResult(false);
                    result.setMessage("Subject/issuer name chain error!");
                    return false;
                }
                Debug.println(DEBUG_ON, "Certificate subject name verification passed.");
            }
            if (!this.verifyPolicyInfo(pathState, certInPath, certIndex, pathLen - 1)) {
                Debug.println(DEBUG_ON, "Certificate policy info verification failed.");
                result.setValidationResult(false);
                result.setMessage("Policy info check error!");
                return false;
            }
            Debug.println(DEBUG_ON, "Certificate policy info verification passed.");
            if (index != 0 && !this.prepareForNextCertificate(pathCtx, pathState, certInPath, certIndex, result)) {
                return false;
            }
            issuer = certInPath;
        }
        CertJUtils.mergeLists(crlList, crlListLocal);
        CertJUtils.mergeLists(crlCerts, crlCertsLocal);
        if (certInPath == null) {
            Debug.println(DEBUG_ON, "Only one certificate in cert path and it is trusted, so validation passed.");
            result.setValidationResult(true);
            result.setMessage("Validation completed successfully.");
            return true;
        }
        return this.wrapUpVerifyPath(pathCtx, pathState, certInPath, pathLen, policyInfoList, result);
    }

    protected abstract String getCRLComplianceFailedMessage();

    protected abstract boolean checkCompliance(X509Certificate var1, JSAFE_PublicKey var2) throws CertPathException;

    private boolean prepareForNextCertificate(CertPathCtx pathCtx, CertPathState pathState, X509Certificate cert, int certIndex, PKIXCertPathResult result) throws CertPathException {
        if (!this.verifyPolicyMappings(pathState, cert, certIndex)) {
            result.setValidationResult(false);
            result.setMessage("Policy mapping check error!");
            return false;
        }
        this.updateWorkingKey(pathState, cert);
        this.updateNameConstraints(pathCtx, pathState, cert);
        if (!this.isSelfIssued(cert)) {
            this.updateStateVariables(pathState);
        }
        this.updatePolicyConstraints(pathState, cert);
        this.updateInhibitAnyPolicy(pathState, cert);
        if (!this.verifyBasicConstraints(pathCtx, cert)) {
            result.setValidationResult(false);
            result.setMessage("Basic constraints error!");
            return false;
        }
        if (!this.verifyMaxPathLen(pathCtx, pathState, cert)) {
            result.setValidationResult(false);
            result.setMessage("Max path length error!");
            return false;
        }
        if (!this.verifyKeyUsage(pathCtx, cert)) {
            result.setValidationResult(false);
            result.setMessage("Key usage error!");
            return false;
        }
        if (!this.verifyOtherCriticalExtensions(pathCtx, cert)) {
            result.setValidationResult(false);
            result.setMessage("Other critical extensions error!");
            return false;
        }
        return true;
    }

    private boolean verifyMaxPathLen(CertPathCtx pathCtx, CertPathState pathState, X509Certificate cert) {
        int pathLen;
        BasicConstraints basicConstraints;
        if (pathCtx.isFlagRaised(32)) {
            return true;
        }
        if (!this.isSelfIssued(cert)) {
            if (pathState.maxPathLen <= 0) {
                return false;
            }
            --pathState.maxPathLen;
        }
        if ((basicConstraints = (BasicConstraints)this.getExtension(cert, 19)) != null && (pathLen = basicConstraints.getPathLen()) != -1 && pathLen < pathState.maxPathLen) {
            pathState.maxPathLen = pathLen;
        }
        return true;
    }

    private boolean wrapUpVerifyPath(CertPathCtx pathCtx, CertPathState pathState, X509Certificate lastCertificate, int pathLen, Vector<PolicyInformation> policyInfoList, PKIXCertPathResult result) throws CertPathException {
        if (pathState.explicitPolicy > 0) {
            --pathState.explicitPolicy;
        }
        this.updatePolicyConstraints(pathState, lastCertificate);
        this.updateWorkingKey(pathState, lastCertificate);
        if (!this.verifyOtherCriticalExtensions(pathCtx, lastCertificate)) {
            result.setValidationResult(false);
            result.setMessage("Other critical extensions error!");
            return false;
        }
        Debug.println(DEBUG_ON, "Verification of other critical extensions passed.");
        this.finalizeValidPolicyTree(pathState.validPolicyTree, pathCtx, pathLen - 1);
        if (pathState.validPolicyTree != null && !pathState.validPolicyTree.getRoot().hasChildren()) {
            pathState.validPolicyTree = null;
        }
        Vector<PolicyInformation> policyInfos = new Vector<PolicyInformation>();
        this.fillInPolicyInfos(pathState.validPolicyTree, policyInfos);
        if (policyInfoList != null) {
            policyInfoList.addAll(policyInfos);
        }
        if (pathState.explicitPolicy == 0 && pathState.validPolicyTree == null) {
            Debug.println(DEBUG_ON, "Policy info check failed, no policy tree found.");
            result.setValidationResult(false);
            result.setMessage("Policy info check error!");
            return false;
        }
        result.setValidationResult(true);
        result.setMessage("Validation completed successfully!");
        result.setValidPolicies(policyInfos);
        result.setWorkingPubKey(pathState.workingPubKey);
        result.setWorkingPubKeyAlg(pathState.workingPubKeyAlg);
        result.setWorkingPubKeyParams(pathState.workingPubKeyParams);
        return true;
    }

    private void updateStateVariables(CertPathState pathState) {
        if (pathState.inhibitAnyPolicy > 0) {
            --pathState.inhibitAnyPolicy;
        }
        if (pathState.explicitPolicy > 0) {
            --pathState.explicitPolicy;
        }
        if (pathState.policyMapping > 0) {
            --pathState.policyMapping;
        }
    }

    private boolean verifyPolicyMappings(CertPathState pathState, X509Certificate cert, int certIndex) throws CertPathException {
        PolicyMappings policyMappings = (PolicyMappings)this.getExtension(cert, 33);
        if (policyMappings == null) {
            return true;
        }
        if (!this.verifyPolicyMappingEntries(policyMappings)) {
            return false;
        }
        this.updatePolicyMappings(pathState, policyMappings, certIndex);
        return true;
    }

    private boolean verifyPolicyMappingEntries(PolicyMappings policyMappings) throws CertPathException {
        int policyCount = policyMappings.getPolicyCount();
        try {
            for (int i = 0; i < policyCount; ++i) {
                if (!CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, policyMappings.getIssuerDomainPolicy(i)) && !CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, policyMappings.getSubjectDomainPolicy(i))) continue;
                return false;
            }
        }
        catch (CertificateException e) {
            throw new CertPathException(e);
        }
        return true;
    }

    private void updatePolicyMappings(CertPathState pathState, PolicyMappings policyMappings, int certIndex) throws CertPathException {
        int policyCount = policyMappings.getPolicyCount();
        try {
            if (pathState.policyMapping > 0) {
                for (int i = 0; i < policyCount; ++i) {
                    byte[] issuerDomainPolicy = policyMappings.getIssuerDomainPolicy(i);
                    this.updateValidPolicyTree(issuerDomainPolicy, policyMappings, pathState, certIndex);
                }
            } else {
                for (int i = 0; i < policyCount; ++i) {
                    byte[] issuerDomainPolicy = policyMappings.getIssuerDomainPolicy(i);
                    this.pruneValidPolicyTree(issuerDomainPolicy, pathState, certIndex);
                }
            }
        }
        catch (CertificateException e) {
            throw new CertPathException(e);
        }
    }

    private void updateValidPolicyTree(byte[] issuerDomainPolicy, PolicyMappings policyMappings, CertPathState pathState, int certIndex) throws CertPathException {
        Vector<byte[]> subjectDomainPolicies = policyMappings.getSubjectDomainPolicies(issuerDomainPolicy);
        Vector<ValidPolicyTreeNode> validPolicyTreeNodes = new Vector<ValidPolicyTreeNode>(pathState.validPolicyTree.getNodesAtDepth(certIndex));
        boolean flagIssuerDomainPolicy = false;
        for (ValidPolicyTreeNode node : validPolicyTreeNodes) {
            if (!node.hasPolicyOID(issuerDomainPolicy)) continue;
            Vector<byte[]> expectedPolicies = node.getExpectedPolicyOIDs();
            expectedPolicies.clear();
            expectedPolicies.addAll(subjectDomainPolicies);
            flagIssuerDomainPolicy = true;
        }
        if (flagIssuerDomainPolicy) {
            return;
        }
        ValidPolicyTreeNode anyPolicyNode = PKIXCertPathCommon.findNodeByOID(X509V3Extension.ANY_POLICY_OID, validPolicyTreeNodes);
        if (anyPolicyNode != null) {
            ValidPolicyTreeNode parent = anyPolicyNode.getParent();
            ValidPolicyTreeNode newChild = ValidPolicyTreeNode.createNode(issuerDomainPolicy, anyPolicyNode.getPolicyQualifiers(), subjectDomainPolicies);
            parent.addChild(newChild);
        }
    }

    private void pruneValidPolicyTree(byte[] issuerDomainPolicy, CertPathState pathState, int certIndex) {
        Vector<ValidPolicyTreeNode> validPolicyTreeNodes = new Vector<ValidPolicyTreeNode>(pathState.validPolicyTree.getNodesAtDepth(certIndex));
        for (ValidPolicyTreeNode node : validPolicyTreeNodes) {
            if (!node.hasPolicyOID(issuerDomainPolicy)) continue;
            node.getParent().removeChild(node);
        }
        pathState.validPolicyTree.removeNodesWithoutChildren(certIndex - 1);
    }

    private boolean isSelfIssued(X509Certificate cert) {
        return cert.getIssuerName().equals(cert.getSubjectName());
    }

    private void updateInhibitAnyPolicy(CertPathState pathState, X509Certificate cert) {
        InhibitAnyPolicy inhibitAnyPolicy = (InhibitAnyPolicy)this.getExtension(cert, 54);
        if (inhibitAnyPolicy == null) {
            return;
        }
        if (inhibitAnyPolicy.getSkipCerts() < pathState.inhibitAnyPolicy) {
            pathState.inhibitAnyPolicy = inhibitAnyPolicy.getSkipCerts();
        }
    }

    private void finalizeValidPolicyTree(ValidPolicyTree validPolicyTree, CertPathCtx pathCtx, int pathLen) throws CertPathException {
        if (validPolicyTree == null) {
            return;
        }
        Debug.println(DEBUG_ON, "Finalizing valid policy tree.");
        Vector<byte[]> userInitialPolicySet = new Vector<byte[]>(Arrays.asList(pathCtx.getPolicies()));
        if (CertJUtils.containsByteArray(userInitialPolicySet, X509V3Extension.ANY_POLICY_OID)) {
            return;
        }
        Vector<ValidPolicyTreeNode> validPolicyNodeSet = this.detrmineValidPolicyNodeSet(validPolicyTree);
        for (ValidPolicyTreeNode validNode : validPolicyNodeSet) {
            ValidPolicyTreeNode parent;
            if (validNode.hasAnyPolicyOID() || CertJUtils.containsByteArray(userInitialPolicySet, validNode.getPolicyOID()) || (parent = validNode.getParent()) == null) continue;
            parent.removeChild(validNode);
        }
        Vector<ValidPolicyTreeNode> deepNodes = validPolicyTree.getNodesAtDepth(pathLen);
        ValidPolicyTreeNode anyPolicyNode = PKIXCertPathCommon.findNodeByOID(X509V3Extension.ANY_POLICY_OID, deepNodes);
        if (anyPolicyNode == null) {
            validPolicyTree.removeNodesWithoutChildren(pathLen - 1);
            return;
        }
        ValidPolicyTreeNode parent = anyPolicyNode.getParent();
        PolicyQualifiers qualifiers = anyPolicyNode.getPolicyQualifiers();
        for (byte[] initalPolicyOID : userInitialPolicySet) {
            if (PKIXCertPathCommon.findNodeByOID(initalPolicyOID, validPolicyNodeSet) != null) continue;
            Vector<byte[]> expectedPolicyOIDs = new Vector<byte[]>();
            expectedPolicyOIDs.add(initalPolicyOID);
            ValidPolicyTreeNode newNode = ValidPolicyTreeNode.createNode(initalPolicyOID, qualifiers, expectedPolicyOIDs);
            parent.addChild(newNode);
        }
        parent.removeChild(anyPolicyNode);
        validPolicyTree.removeNodesWithoutChildren(pathLen - 1);
    }

    private Vector<ValidPolicyTreeNode> detrmineValidPolicyNodeSet(ValidPolicyTree validPolicyTree) {
        Vector<ValidPolicyTreeNode> result = new Vector<ValidPolicyTreeNode>();
        this.determineValidPolicyNodeSetHelper(validPolicyTree.getRoot(), result);
        return result;
    }

    private void determineValidPolicyNodeSetHelper(ValidPolicyTreeNode node, Vector<ValidPolicyTreeNode> result) {
        ValidPolicyTreeNode parent = node.getParent();
        if (parent != null && parent.hasAnyPolicyOID()) {
            result.add(node);
        }
        if (!node.hasChildren()) {
            return;
        }
        for (ValidPolicyTreeNode child : node.getChildren()) {
            this.determineValidPolicyNodeSetHelper(child, result);
        }
    }

    private void fillInPolicyInfos(ValidPolicyTree validPolicyTree, Vector<PolicyInformation> policyInfoList) throws CertPathException {
        if (validPolicyTree == null) {
            return;
        }
        if (policyInfoList == null) {
            return;
        }
        Debug.println(DEBUG_ON, "Creating new valid policy info list.");
        ValidPolicyTreeNode root = validPolicyTree.getRoot();
        this.fillInPolicyInfoListHelper(root, policyInfoList, new boolean[]{false});
    }

    private void fillInPolicyInfoListHelper(ValidPolicyTreeNode node, Vector<PolicyInformation> policyInfoList, boolean[] interruptFlag) throws CertPathException {
        if (node.hasAnyPolicyOID()) {
            if (!node.hasChildren()) {
                policyInfoList.clear();
                policyInfoList.add(node.asPolicyInfo());
                interruptFlag[0] = true;
                return;
            }
        } else if (node.getParent().hasAnyPolicyOID()) {
            policyInfoList.add(node.asPolicyInfo());
        }
        if (!node.hasChildren()) {
            return;
        }
        Vector<ValidPolicyTreeNode> children = node.getChildren();
        Iterator<ValidPolicyTreeNode> childrenIter = children.iterator();
        while (childrenIter.hasNext() && !interruptFlag[0]) {
            this.fillInPolicyInfoListHelper(childrenIter.next(), policyInfoList, interruptFlag);
        }
    }

    private boolean verifySubjectAndAltNames(CertPathState pathState, X509Certificate cert) {
        X500Name subjectName = cert.getSubjectName();
        SubjectAltName subjectAltName = (SubjectAltName)this.getExtension(cert, 17);
        if (subjectName != null && subjectName.getRDNCount() > 0) {
            GeneralName generalName = new GeneralName();
            try {
                generalName.setGeneralName(subjectName, 5);
            }
            catch (NameException e) {
                return false;
            }
            if (!this.verifyNameSubtrees(pathState, generalName)) {
                return false;
            }
            if (!this.verifyEmailAddressConstraints(pathState, subjectName)) {
                return false;
            }
        } else if (subjectAltName == null) {
            Debug.println(DEBUG_ON, "Certificate subject name verification failed (no name found).");
            return false;
        }
        return subjectAltName == null || this.verifyGeneralNames(pathState, subjectAltName.getGeneralNames());
    }

    private boolean verifyPolicyInfo(CertPathState pathState, X509Certificate cert, int certIndex, int pathLen) throws CertPathException {
        if (pathState.validPolicyTree == null) {
            return true;
        }
        CertPolicies certPolicies = (CertPolicies)this.getExtension(cert, 32);
        if (certPolicies == null) {
            pathState.validPolicyTree = null;
            return pathState.explicitPolicy > 0;
        }
        Vector<ValidPolicyTreeNode> policyTreeNodes = pathState.validPolicyTree.getNodesAtDepth(certIndex - 1);
        for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
            boolean processed;
            byte[] policyOID;
            try {
                policyOID = certPolicies.getCertPolicyId(i);
            }
            catch (CertificateException e) {
                throw new CertPathException(e);
            }
            if (CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, policyOID) || (processed = this.processPolicyInExpectedSet(policyOID, certPolicies, i, policyTreeNodes))) continue;
            this.processPolicyNotInExpectedSet(policyOID, certPolicies, i, policyTreeNodes);
        }
        this.processAnyPolicy(pathState, certPolicies, policyTreeNodes, certIndex, pathLen, this.isSelfIssued(cert));
        Vector<ValidPolicyTreeNode> deepNodes = pathState.validPolicyTree.getNodesAtDepth(certIndex);
        if (deepNodes.isEmpty()) {
            pathState.validPolicyTree = null;
        } else {
            pathState.validPolicyTree.removeNodesWithoutChildren(certIndex - 1);
        }
        return pathState.validPolicyTree != null || pathState.explicitPolicy != 0;
    }

    private boolean processPolicyInExpectedSet(byte[] policyID, CertPolicies certPolicies, int policyIndex, Vector<ValidPolicyTreeNode> policyTreeNodes) throws CertPathException {
        for (ValidPolicyTreeNode node : policyTreeNodes) {
            if (!CertJUtils.containsByteArray(node.getExpectedPolicyOIDs(), policyID)) continue;
            Vector<byte[]> expectedPoliciesOID = new Vector<byte[]>();
            expectedPoliciesOID.add(policyID);
            try {
                ValidPolicyTreeNode child = ValidPolicyTreeNode.createNode(policyID, certPolicies.getPolicyQualifiers(policyIndex), expectedPoliciesOID);
                node.addChild(child);
            }
            catch (CertificateException e) {
                throw new CertPathException(e);
            }
            return true;
        }
        return false;
    }

    private void processPolicyNotInExpectedSet(byte[] policyID, CertPolicies certPolicies, int policyIndex, Vector<ValidPolicyTreeNode> policyTreeNodes) throws CertPathException {
        for (ValidPolicyTreeNode node : policyTreeNodes) {
            if (!node.hasAnyPolicyOID()) continue;
            Vector<byte[]> expectedPoliciesOID = new Vector<byte[]>();
            expectedPoliciesOID.add(policyID);
            try {
                ValidPolicyTreeNode child = ValidPolicyTreeNode.createNode(policyID, certPolicies.getPolicyQualifiers(policyIndex), expectedPoliciesOID);
                node.addChild(child);
                break;
            }
            catch (CertificateException e) {
                throw new CertPathException(e);
            }
        }
    }

    private void processAnyPolicy(CertPathState pathState, CertPolicies certPolicies, Vector<ValidPolicyTreeNode> policyTreeNodes, int certIndex, int pathLen, boolean selfIssued) throws CertPathException {
        int anyPolicyIndex = -1;
        try {
            for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
                byte[] policyOID = certPolicies.getCertPolicyId(i);
                if (!CertJUtils.byteArraysEqual(policyOID, X509V3Extension.ANY_POLICY_OID)) continue;
                anyPolicyIndex = i;
                break;
            }
        }
        catch (CertificateException e) {
            throw new CertPathException(e);
        }
        if (anyPolicyIndex >= 0 && (pathState.inhibitAnyPolicy > 0 || selfIssued && certIndex < pathLen)) {
            PolicyQualifiers anyPolicyQualifiers;
            try {
                anyPolicyQualifiers = certPolicies.getPolicyQualifiers(anyPolicyIndex);
            }
            catch (CertificateException e) {
                throw new CertPathException(e);
            }
            for (ValidPolicyTreeNode node : policyTreeNodes) {
                for (byte[] expectedOID : node.getExpectedPolicyOIDs()) {
                    if (node.getChildByOID(expectedOID) != null) continue;
                    Vector<byte[]> childExpectedOIDs = new Vector<byte[]>();
                    childExpectedOIDs.add(expectedOID);
                    ValidPolicyTreeNode child = ValidPolicyTreeNode.createNode(expectedOID, anyPolicyQualifiers, childExpectedOIDs);
                    node.addChild(child);
                }
            }
        }
    }

    private X509V3Extension getExtension(X509Certificate cert, int type) {
        X509V3Extension result = null;
        X509V3Extensions extensions = cert.getExtensions();
        if (extensions != null) {
            try {
                result = extensions.getExtensionByType(type);
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean verifyOtherCriticalExtensions(CertPathCtx pathCtx, X509Certificate cert) {
        X509V3Extensions extensions = cert.getExtensions();
        if (extensions == null) {
            return true;
        }
        if (pathCtx.isFlagRaised(128)) {
            return true;
        }
        block5: for (int i = 0; i < extensions.getExtensionCount(); ++i) {
            X509V3Extension extension;
            try {
                extension = extensions.getExtensionByIndex(i);
            }
            catch (CertificateException e) {
                return false;
            }
            if (!extension.getCriticality()) break;
            switch (extension.getExtensionType()) {
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: 
                case 36: 
                case 37: {
                    continue block5;
                }
                default: {
                    if (DEBUG_ON) {
                        byte[] oid = extension.getOID();
                        Debug.println("An unknown critical extension with OID " + OIDList.getTrans((byte[])oid, (int)0, (int)oid.length, (int)-1) + " has been found in certificate " + cert.getSubjectName().toString());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean verifyBasicConstraints(CertPathCtx pathCtx, X509Certificate cert) {
        if (pathCtx.isFlagRaised(32)) {
            return true;
        }
        BasicConstraints basicConstraints = (BasicConstraints)this.getExtension(cert, 19);
        return basicConstraints != null && basicConstraints.getCA();
    }

    private void updateNameConstraints(CertPathCtx pathCtx, CertPathState pathState, X509Certificate cert) {
        if (pathCtx.isFlagRaised(16)) {
            return;
        }
        NameConstraints nameConstraints = (NameConstraints)this.getExtension(cert, 30);
        if (nameConstraints == null) {
            return;
        }
        GeneralSubtrees permittedSubtrees = nameConstraints.getPermittedSubtrees();
        this.intersectNameSubtrees(pathState.constrainedSubtrees, permittedSubtrees);
        this.uniteNameSubtrees(pathState.excludedSubtrees, nameConstraints.getExcludedSubtrees());
    }

    private void updatePolicyConstraints(CertPathState pathState, X509Certificate cert) {
        PolicyConstraints policyConstraints = (PolicyConstraints)this.getExtension(cert, 36);
        if (policyConstraints == null) {
            return;
        }
        int requireExplicitPolicy = policyConstraints.getExplicitPolicy();
        int inhibitPolicyMapping = policyConstraints.getPolicyMapping();
        if (requireExplicitPolicy != -1 && requireExplicitPolicy < pathState.explicitPolicy) {
            pathState.explicitPolicy = requireExplicitPolicy;
        }
        if (inhibitPolicyMapping != -1 && inhibitPolicyMapping < pathState.policyMapping) {
            pathState.policyMapping = inhibitPolicyMapping;
        }
    }

    private boolean verifyKeyUsage(CertPathCtx pathCtx, X509Certificate cert) {
        if (pathCtx.isFlagRaised(64)) {
            return true;
        }
        KeyUsage keyUsage = (KeyUsage)this.getExtension(cert, 15);
        return keyUsage == null || (keyUsage.getKeyUsage() & 0x4000000) != 0;
    }

    private boolean verifyGeneralNames(CertPathState pathState, GeneralNames generalNames) {
        try {
            for (int i = 0; i < generalNames.getNameCount(); ++i) {
                if (this.verifyNameSubtrees(pathState, generalNames.getGeneralName(i))) continue;
                return false;
            }
            return true;
        }
        catch (NameException e) {
            return false;
        }
    }

    private boolean verifyNameSubtrees(CertPathState pathState, GeneralName altName) {
        try {
            if (altName.getDERLen(0) == 0) {
                return true;
            }
        }
        catch (NameException e) {
            throw new IllegalStateException("Internal errror!");
        }
        int type = altName.getGeneralNameType();
        try {
            GeneralNames names = pathState.constrainedSubtrees.get(new Integer(type));
            if (names != null) {
                boolean matched = false;
                for (int i = 0; i < names.getNameCount(); ++i) {
                    GeneralName subtreeName = names.getGeneralName(i);
                    if (!NameMatcher.matchGeneralNames(altName, subtreeName, type)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    Debug.println(DEBUG_ON, "Certificate subject name verification failed ", " because of unmatched constraint names", names.toString());
                    return false;
                }
            }
            for (int i = 0; i < pathState.excludedSubtrees.getNameCount(); ++i) {
                GeneralName subtreeName = pathState.excludedSubtrees.getGeneralName(i);
                if (type != subtreeName.getGeneralNameType() || !NameMatcher.matchGeneralNames(altName, subtreeName, type)) continue;
                Debug.println(DEBUG_ON, "Certificate subject name verification failed ", " because of matched excluded name", subtreeName.toString());
                return false;
            }
            return true;
        }
        catch (NameException e) {
            return false;
        }
    }

    private boolean verifyEmailAddressConstraints(CertPathState pathState, X500Name name) {
        for (int i = 0; i < name.getRDNCount(); ++i) {
            try {
                RDN rdn = name.getRDN(i);
                AttributeValueAssertion ava = rdn.getAttribute(7);
                if (ava == null) continue;
                String email = ava.getStringAttribute();
                GeneralNames subtreeNames = pathState.constrainedSubtrees.get(new Integer(2));
                if (subtreeNames != null) {
                    boolean found = false;
                    for (int j = 0; j < subtreeNames.getNameCount(); ++j) {
                        GeneralName subtreeName = subtreeNames.getGeneralName(j);
                        if (!NameMatcher.matchRfc822Names(email, (String)subtreeName.getGeneralName())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return false;
                    }
                }
                for (int j = 0; j < pathState.excludedSubtrees.getNameCount(); ++j) {
                    GeneralName subtreeName = pathState.excludedSubtrees.getGeneralName(j);
                    if (subtreeName.getGeneralNameType() != 2 || !NameMatcher.matchRfc822Names(email, (String)subtreeName.getGeneralName())) continue;
                    return false;
                }
                continue;
            }
            catch (NameException e) {
                // empty catch block
            }
        }
        return true;
    }

    private void intersectNameSubtrees(Map<Integer, GeneralNames> nameMap, GeneralSubtrees subtrees) {
        HashMap<Integer, GeneralNames> oldMap = new HashMap<Integer, GeneralNames>(nameMap);
        Iterator keysIter = oldMap.keySet().iterator();
        while (keysIter.hasNext()) {
            nameMap.put((Integer)keysIter.next(), new GeneralNames());
        }
        HashSet<Integer> foundTypes = new HashSet<Integer>();
        try {
            for (int j = 0; j < subtrees.getSubtreeCount(); ++j) {
                GeneralName subtreeName = subtrees.getBase(j);
                Integer subtreeType = new Integer(subtreeName.getGeneralNameType());
                GeneralNames oldNameList = (GeneralNames)oldMap.get(subtreeType);
                GeneralNames newNameList = nameMap.get(subtreeType);
                if (oldNameList == null) {
                    if (newNameList == null) {
                        newNameList = new GeneralNames();
                        nameMap.put(subtreeType, newNameList);
                    }
                    newNameList.addGeneralName(subtreeName);
                    continue;
                }
                foundTypes.add(subtreeType);
                block9: for (int i = oldNameList.getNameCount() - 1; i >= 0; --i) {
                    GeneralName name = oldNameList.getGeneralName(i);
                    switch (NameMatcher.compareAltNames(name, subtreeName)) {
                        case 1: 
                        case 2: {
                            newNameList.addGeneralName(name);
                            continue block9;
                        }
                        case 3: {
                            newNameList.addGeneralName(subtreeName);
                            continue block9;
                        }
                        case 0: {
                            continue block9;
                        }
                    }
                }
            }
            Iterator foundTypesIter = foundTypes.iterator();
            while (foundTypesIter.hasNext()) {
                oldMap.remove(foundTypesIter.next());
            }
            nameMap.putAll(oldMap);
        }
        catch (NameException e) {
            throw new IllegalStateException("Internal error!");
        }
    }

    private void uniteNameSubtrees(GeneralNames nameList, GeneralSubtrees subtrees) {
        try {
            for (int i = 0; i < subtrees.getSubtreeCount(); ++i) {
                GeneralName subtreeName;
                try {
                    subtreeName = subtrees.getBase(i);
                }
                catch (NameException e) {
                    return;
                }
                boolean found = false;
                block10: for (int j = nameList.getNameCount() - 1; j >= 0; --j) {
                    GeneralName name = nameList.getGeneralName(j);
                    if (subtreeName.getGeneralNameType() != name.getGeneralNameType()) continue;
                    switch (NameMatcher.compareAltNames(name, subtreeName)) {
                        case 1: 
                        case 3: {
                            found = true;
                            continue block10;
                        }
                        case 2: {
                            found = true;
                            Vector<GeneralName> names = nameList.getGeneralNames();
                            names.setElementAt(subtreeName, j);
                            continue block10;
                        }
                        case 0: {
                            continue block10;
                        }
                    }
                }
                if (found) continue;
                nameList.addGeneralName(subtreeName);
            }
        }
        catch (NameException nameException) {
            // empty catch block
        }
    }

    private void getNextCertUsingIssuerAndAuthKeyId(CertPathCtx pathCtx, X500Name issuerName, X509V3Extensions extensions, Vector<Certificate> candidates) throws CertPathException {
        if ((pathCtx.getPathOptions() & 0x200) != 0) {
            this.findCertBySubject(pathCtx, issuerName, candidates);
            return;
        }
        AuthorityKeyID authKeyId = null;
        try {
            if (extensions != null) {
                authKeyId = (AuthorityKeyID)extensions.getExtensionByType(35);
            }
        }
        catch (CertificateException e) {
            // empty catch block
        }
        if (authKeyId != null) {
            this.getIssuersWithAuthKeyId(pathCtx, issuerName, authKeyId, candidates);
        } else {
            this.findCertBySubject(pathCtx, issuerName, candidates);
        }
    }

    private void getIssuersWithAuthKeyId(CertPathCtx pathCtx, X500Name issuerName, AuthorityKeyID authKeyId, Vector<Certificate> certList) throws CertPathException {
        byte[] keyId = authKeyId.getKeyID();
        if (keyId != null) {
            this.getIssuersWithKeyId(pathCtx, issuerName, keyId, certList);
        } else {
            this.getIssuersWithoutKeyId(pathCtx, authKeyId, certList);
        }
    }

    private void getIssuersWithKeyId(CertPathCtx pathCtx, X500Name issuerName, byte[] keyId, Vector<Certificate> certList) throws CertPathException {
        Vector<Certificate> candidates = new Vector<Certificate>();
        this.findCertBySubject(pathCtx, issuerName, candidates);
        int certCount = candidates.size();
        while (certCount > 0) {
            X509Certificate candidate;
            X509V3Extensions extensions;
            if ((extensions = (candidate = (X509Certificate)candidates.elementAt(--certCount)).getExtensions()) == null) {
                candidates.removeElementAt(certCount);
                continue;
            }
            SubjectKeyID subjectKeyId = null;
            try {
                subjectKeyId = (SubjectKeyID)extensions.getExtensionByType(14);
            }
            catch (CertificateException e) {
                // empty catch block
            }
            if (subjectKeyId == null) {
                candidates.removeElementAt(certCount);
                continue;
            }
            if (Arrays.equals(keyId, subjectKeyId.getKeyID())) continue;
            candidates.removeElementAt(certCount);
        }
        CertJUtils.mergeLists(certList, candidates);
    }

    private void getIssuersWithoutKeyId(CertPathCtx pathCtx, AuthorityKeyID authKeyId, Vector<Certificate> certList) throws CertPathException {
        byte[] serialNumber = authKeyId.getSerialNumber();
        if (serialNumber.length == 0) {
            return;
        }
        GeneralNames issuerNames = authKeyId.getAuthorityCertIssuer();
        if (issuerNames == null) {
            return;
        }
        try {
            for (int i = 0; i < issuerNames.getNameCount(); ++i) {
                GeneralName name = issuerNames.getGeneralName(i);
                if (name.getGeneralNameType() == 5) {
                    this.findCertByIssuerSerial(pathCtx, (X500Name)name.getGeneralName(), serialNumber, certList);
                    continue;
                }
                this.getIssuersWithIssuerAltNameExtension(pathCtx, name, serialNumber, certList);
            }
        }
        catch (NameException e) {
            // empty catch block
        }
    }

    private void getIssuersWithIssuerAltNameExtension(CertPathCtx pathCtx, GeneralName issuerName, byte[] serialNumber, Vector<Certificate> certList) throws CertPathException {
        X509V3Extensions extensions;
        GeneralNames generalNames = new GeneralNames();
        generalNames.addGeneralName(issuerName);
        try {
            IssuerAltName issuerAltName = new IssuerAltName(generalNames, false);
            extensions = new X509V3Extensions(1);
            extensions.addV3Extension(issuerAltName);
        }
        catch (CertificateException e) {
            return;
        }
        Vector<Certificate> candidates = new Vector<Certificate>();
        this.findCertByExtensions(pathCtx, null, extensions, candidates);
        int certCount = candidates.size();
        while (certCount > 0) {
            X509Certificate cert;
            if (Arrays.equals(serialNumber, (cert = (X509Certificate)candidates.elementAt(--certCount)).getSerialNumber())) continue;
            candidates.removeElementAt(certCount);
        }
        CertJUtils.mergeLists(certList, candidates);
    }

    private void findCertByIssuerSerial(CertPathCtx pathCtx, X500Name issuerName, byte[] serialNumber, Vector<Certificate> result) throws CertPathException {
        Certificate[] trustedCerts = pathCtx.getTrustedCerts();
        if (trustedCerts != null) {
            for (int i = 0; i < trustedCerts.length; ++i) {
                X509Certificate x509Cert;
                Certificate cert = trustedCerts[i];
                if (!(cert instanceof X509Certificate) || !issuerName.equals((x509Cert = (X509Certificate)cert).getIssuerName()) || !Arrays.equals(serialNumber, x509Cert.getSerialNumber())) continue;
                if (!result.contains(x509Cert)) {
                    result.addElement(x509Cert);
                }
                return;
            }
        }
        try {
            pathCtx.getDatabase().selectCertificateByIssuerAndSerialNumber(issuerName, serialNumber, result);
        }
        catch (NoServiceException e) {
            throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: ", e);
        }
        catch (DatabaseException e) {
            throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: ", e);
        }
    }

    private void findCertByExtensions(CertPathCtx pathCtx, X500Name baseName, X509V3Extensions extensions, Vector<Certificate> result) throws CertPathException {
        Certificate[] trustedCerts = pathCtx.getTrustedCerts();
        if (trustedCerts != null) {
            for (int i = 0; i < trustedCerts.length; ++i) {
                Certificate cert = trustedCerts[i];
                if (!(cert instanceof X509Certificate)) continue;
                X509Certificate x509Cert = (X509Certificate)cert;
                if (baseName != null && !x509Cert.getSubjectName().contains(baseName) || !CertJUtils.compareExtensions(extensions, x509Cert.getExtensions()) || result.contains(x509Cert)) continue;
                result.addElement(x509Cert);
            }
        }
        try {
            pathCtx.getDatabase().selectCertificateByExtensions(baseName, extensions, result);
        }
        catch (NoServiceException e) {
            throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension,", e);
        }
        catch (DatabaseException e) {
            throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension.", e);
        }
    }

    private Vector<byte[]> createPolicySet(byte[][] policies) {
        Vector<byte[]> vector = new Vector<byte[]>();
        if (policies == null) {
            return vector;
        }
        for (int i = 0; i < policies.length; ++i) {
            byte[] policy = policies[i];
            if (CertJUtils.containsByteArray(vector, policy)) continue;
            vector.addElement(policy);
        }
        return vector;
    }

    private JSAFE_PublicKey getWorkingPublicKey(Object pathState, X509Certificate cert) throws CertificateException {
        JSAFE_PublicKey publicKey;
        CertPathState certPathState = (CertPathState)pathState;
        if (!"DSA".equals(certPathState.workingPubKeyAlg) || certPathState.workingPubKeyParams == null) {
            return cert.getSubjectPublicKey(this.certJ.getDevice());
        }
        try {
            publicKey = JSAFEFactory.getPublicKey(certPathState.workingPubKeyAlg, this.certJ.getDevice(), this.context.jsafe);
        }
        catch (JSAFE_Exception e) {
            throw new CertificateException((Exception)((Object)e));
        }
        int paramsSize = certPathState.workingPubKeyParams.length;
        byte[][] keyData = new byte[paramsSize + 1][];
        System.arraycopy(certPathState.workingPubKeyParams, 0, keyData, 0, paramsSize);
        keyData[paramsSize] = certPathState.workingPubKey;
        try {
            publicKey.setKeyData((byte[][])keyData);
        }
        catch (JSAFE_InvalidKeyException e) {
            throw new CertificateException((Exception)((Object)e));
        }
        return publicKey;
    }

    @Override
    protected void getNextCertInPathInternal(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> certList) throws CertPathException {
        Vector<Certificate> candidates = new Vector<Certificate>();
        this.getNextCertCandidates(pathCtx, baseObject, candidates);
        CertJUtils.mergeLists(certList, candidates);
    }

    private void updateWorkingKey(CertPathState pathState, X509Certificate cert) throws CertPathException {
        byte[][] keyData;
        JSAFE_PublicKey pubKey;
        try {
            pubKey = cert.getSubjectPublicKey(this.certJ.getDevice());
        }
        catch (CertificateException e) {
            throw new CertPathException(e);
        }
        if (!"DSA".equals(pubKey.getAlgorithm())) {
            pathState.workingPubKeyAlg = pubKey.getAlgorithm();
            pathState.workingPubKey = null;
            pathState.workingPubKeyParams = null;
            return;
        }
        try {
            keyData = pubKey.getKeyData("DSAPublicValue");
        }
        catch (JSAFE_UnimplementedException e) {
            throw new CertPathException((Exception)((Object)e));
        }
        if (keyData.length == 0) {
            throw new CertPathException("Could not retrieve DSA public key form certificate!");
        }
        pathState.workingPubKey = keyData[0];
        keyData = pubKey.getKeyData();
        if (keyData.length == 0) {
            if (!"DSA".equals(pathState.workingPubKeyAlg)) {
                pathState.workingPubKeyAlg = "DSA";
                pathState.workingPubKeyParams = null;
            }
            return;
        }
        if (pathState.workingPubKeyParams == null) {
            pathState.workingPubKeyParams = new byte[keyData.length - 1][];
        }
        System.arraycopy(keyData, 0, pathState.workingPubKeyParams, 0, keyData.length - 1);
        pathState.workingPubKeyAlg = "DSA";
    }

    private CertPathState createCertPathState(CertPathCtx pathCtx, X509Certificate anchor, int certCount, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees) throws CertPathException {
        GeneralNames excludedSubtrees;
        JSAFE_PublicKey pubKey;
        byte[][] policies = pathCtx.getPolicies();
        Vector<byte[]> initialPolicySet = null;
        int policyMapping = certCount + 1;
        int explicitPolicy = certCount + 1;
        int inhibitAnyPolicy = certCount + 1;
        byte[] workingPubKey = null;
        Object workingPubKeyParams = null;
        if (policies != null) {
            initialPolicySet = this.createPolicySet(policies);
        }
        if (pathCtx.isFlagRaised(65536)) {
            policyMapping = 0;
        }
        if (pathCtx.isFlagRaised(32768)) {
            explicitPolicy = 0;
        }
        if (pathCtx.isFlagRaised(131072)) {
            inhibitAnyPolicy = 0;
        }
        try {
            pubKey = anchor.getSubjectPublicKey(this.certJ.getDevice());
        }
        catch (CertificateException e) {
            throw new CertPathException(e);
        }
        String workingPubKeyAlg = pubKey.getAlgorithm();
        if ("DSA".equals(workingPubKeyAlg)) {
            byte[][] keyData = pubKey.getKeyData();
            if (keyData.length == 0) {
                throw new CertPathException("Anchor certificate must have valid public key parameters in subjectPublicKeyInfo!");
            }
            workingPubKeyParams = new byte[keyData.length - 1][];
            System.arraycopy(keyData, 0, workingPubKeyParams, 0, keyData.length - 1);
            workingPubKey = keyData[keyData.length - 1];
        }
        ValidPolicyTree validPlicyTree = new ValidPolicyTree();
        HashMap<Integer, GeneralNames> constrainedSubtrees = new HashMap<Integer, GeneralNames>();
        try {
            excludedSubtrees = initialExcludedSubtrees != null ? (GeneralNames)initialExcludedSubtrees.clone() : new GeneralNames();
            if (initialPermittedSubtrees != null) {
                this.intersectNameSubtrees(constrainedSubtrees, (GeneralSubtrees)initialPermittedSubtrees.clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new CertPathException(e);
        }
        if (DEBUG_ON) {
            Debug.println("Creating Certificate path state.");
            Debug.println("    Trust anchor       : " + anchor.getSubjectName().toString());
            Debug.println("    No of certs in path: " + certCount);
            if (initialPermittedSubtrees != null) {
                Debug.println("    Init perm subtrees : " + initialPermittedSubtrees.toString());
            }
            if (initialExcludedSubtrees != null) {
                Debug.println("    Init excl subtrees : " + initialExcludedSubtrees.toString());
            }
        }
        return new CertPathState(initialPolicySet, validPlicyTree, (Map<Integer, GeneralNames>)constrainedSubtrees, excludedSubtrees, explicitPolicy, policyMapping, inhibitAnyPolicy, certCount, workingPubKeyAlg, workingPubKey, (byte[][])workingPubKeyParams);
    }

    @Override
    protected CertPathResult createCertPathResult() {
        return new PKIXCertPathResult(this.context);
    }

    @Override
    public boolean validateCertificate(CertPathCtx pathCtx, Certificate cert, JSAFE_PublicKey validationKey) throws NotSupportedException, CertPathException {
        if (!(cert instanceof X509Certificate)) {
            throw new NotSupportedException("Only X509Certificate validation is supported.");
        }
        try {
            this.certValidator.validateCertificate((X509Certificate)cert, pathCtx, validationKey);
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    private static ValidPolicyTreeNode findNodeByOID(byte[] oid, Vector<ValidPolicyTreeNode> nodes) {
        for (ValidPolicyTreeNode node : nodes) {
            if (!Arrays.equals(node.getPolicyOID(), oid)) continue;
            return node;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CertPathState {
        protected Vector<byte[]> initialPolicySet;
        protected ValidPolicyTree validPolicyTree;
        protected Map<Integer, GeneralNames> constrainedSubtrees;
        protected GeneralNames excludedSubtrees;
        protected int explicitPolicy;
        protected int policyMapping;
        protected int inhibitAnyPolicy;
        protected int maxPathLen;
        protected String workingPubKeyAlg;
        protected byte[] workingPubKey;
        protected byte[][] workingPubKeyParams;

        protected CertPathState(Vector<byte[]> initialPolicySet, ValidPolicyTree validPolicyTree, Map<Integer, GeneralNames> constrainedSubtrees, GeneralNames excludedSubtrees, int explicitPolicy, int policyMapping, int inhibitAnyPolicy, int maxPathLen, String workingPubKeyAlg, byte[] workingPubKey, byte[][] workingPubKeyParams) {
            this.initialPolicySet = initialPolicySet;
            this.validPolicyTree = validPolicyTree;
            this.constrainedSubtrees = constrainedSubtrees;
            this.excludedSubtrees = excludedSubtrees;
            this.explicitPolicy = explicitPolicy;
            this.policyMapping = policyMapping;
            this.inhibitAnyPolicy = inhibitAnyPolicy;
            this.maxPathLen = maxPathLen;
            this.workingPubKeyAlg = workingPubKeyAlg;
            this.workingPubKey = workingPubKey;
            this.workingPubKeyParams = workingPubKeyParams;
        }
    }
}

