/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.path.PolicyInformation;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PKIXCertPathResult
implements CertPathResult {
    private boolean validationResult;
    private String message;
    private Vector<PolicyInformation> validPolicies;
    private String workingPubKeyAlg;
    private byte[] workingPubKey;
    private byte[][] workingPubKeyParams;
    private final CertJContext context;

    PKIXCertPathResult(CertJContext context) {
        this.context = context;
    }

    @Override
    public Vector<PolicyInformation> getValidPolicies() {
        return this.validPolicies;
    }

    byte[] getWorkingPubKey() {
        return this.workingPubKey;
    }

    String getWorkingPubKeyAlg() {
        return this.workingPubKeyAlg;
    }

    byte[][] getWorkingPubKeyParams() {
        return this.workingPubKeyParams;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public boolean getValidationResult() {
        return this.validationResult;
    }

    void setValidPolicies(Vector<PolicyInformation> validPolicyList) {
        this.validPolicies = validPolicyList;
    }

    void setWorkingPubKey(byte[] workingPublicKey) {
        this.workingPubKey = workingPublicKey;
    }

    void setWorkingPubKeyAlg(String workingPublicKeyAlg) {
        this.workingPubKeyAlg = workingPublicKeyAlg;
    }

    void setWorkingPubKeyParams(byte[][] workingPublicKeyParams) {
        this.workingPubKeyParams = workingPublicKeyParams;
    }

    void setMessage(String validationMessage) {
        this.message = validationMessage;
    }

    @Override
    public void setValidationResult(boolean pathValidationResult) {
        this.validationResult = pathValidationResult;
    }

    @Override
    public JSAFE_PublicKey getSubjectPublicKey(String device) throws CertificateException {
        JSAFE_PublicKey publicKey;
        if (!"DSA".equals(this.workingPubKeyAlg) || this.workingPubKeyParams == null) {
            return null;
        }
        try {
            publicKey = JSAFEFactory.getPublicKey(this.workingPubKeyAlg, device, this.context.jsafe);
        }
        catch (JSAFE_Exception e) {
            throw new CertificateException((Exception)((Object)e));
        }
        int paramsSize = this.workingPubKeyParams.length;
        byte[][] keyData = new byte[paramsSize + 1][];
        System.arraycopy(this.workingPubKeyParams, 0, keyData, 0, paramsSize);
        keyData[paramsSize] = this.workingPubKey;
        try {
            publicKey.setKeyData((byte[][])keyData);
        }
        catch (JSAFE_InvalidKeyException e) {
            throw new CertificateException((Exception)((Object)e));
        }
        return publicKey;
    }
}

