/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.PolicyInformation;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidPolicyTreeNode {
    private byte[] policyOID;
    private PolicyQualifiers policyQualifiers;
    private Vector<byte[]> expectedPolicyOIDs;
    private ValidPolicyTreeNode parent;
    private Vector<ValidPolicyTreeNode> children;

    private ValidPolicyTreeNode(byte[] validPolicyOID, PolicyQualifiers policyQualifiers, Vector<byte[]> expectedPolicyOIDs) {
        this.policyOID = validPolicyOID;
        this.policyQualifiers = policyQualifiers;
        this.expectedPolicyOIDs = expectedPolicyOIDs;
    }

    static ValidPolicyTreeNode createNode(byte[] validPolicyOID, PolicyQualifiers policyQualifiers, Vector<byte[]> expectedPolicyOIDs) throws CertPathException {
        if (validPolicyOID == null || expectedPolicyOIDs == null) {
            throw new CertPathException("ValidPolicyTreeNode parameters cannot be null!");
        }
        return new ValidPolicyTreeNode(validPolicyOID, policyQualifiers, expectedPolicyOIDs);
    }

    ValidPolicyTreeNode getParent() {
        return this.parent;
    }

    void addChild(ValidPolicyTreeNode child) {
        if (child == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(child);
        child.parent = this;
    }

    void removeChild(ValidPolicyTreeNode child) {
        if (child == null || this.children == null) {
            return;
        }
        this.children.remove(child);
        if (this.children.size() == 0) {
            this.children = null;
        }
    }

    void removeChildren() {
        this.children = null;
    }

    Vector<ValidPolicyTreeNode> getChildren() {
        return this.children;
    }

    boolean hasChildren() {
        return this.children != null;
    }

    byte[] getPolicyOID() {
        return this.policyOID;
    }

    Vector<byte[]> getExpectedPolicyOIDs() {
        return this.expectedPolicyOIDs;
    }

    ValidPolicyTreeNode getChildByOID(byte[] oid) {
        if (this.children == null) {
            return null;
        }
        for (ValidPolicyTreeNode currentChild : this.children) {
            if (!Arrays.equals(currentChild.getPolicyOID(), oid)) continue;
            return currentChild;
        }
        return null;
    }

    PolicyQualifiers getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    PolicyInformation asPolicyInfo() throws CertPathException {
        return new PolicyInformation(this.policyOID, this.policyQualifiers);
    }

    boolean hasPolicyOID(byte[] oid) {
        return CertJUtils.byteArraysEqual(this.policyOID, oid);
    }

    boolean hasAnyPolicyOID() {
        return this.hasPolicyOID(X509V3Extension.ANY_POLICY_OID);
    }
}

