/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.FreshestCRL;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.InhibitAnyPolicy;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyMappings;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectInfoAccess;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.internal.ConvertUtil;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

final class X509CertificateValidator {
    private static final int OID_BYTE_ONE = 85;
    private static final int OID_BYTE_TWO = 29;
    private static final Set<String> KNOWN_EXTENSION_OIDS = new HashSet<String>();
    private final CertJ certJ;

    X509CertificateValidator(CertJ certJ) {
        this.certJ = certJ;
    }

    private static void addStandardOID(int extensionType) {
        byte[] oid = new byte[]{85, 29, (byte)extensionType};
        X509CertificateValidator.addSpecialOID(oid);
    }

    private static void addSpecialOID(byte[] oid) {
        KNOWN_EXTENSION_OIDS.add(ConvertUtil.byteArrayToHexString(oid));
    }

    void validateCertificate(X509Certificate x509cert, CertPathCtx pathCtx, JSAFE_PublicKey validationKey) throws CertPathException, CertificateException {
        this.validateBasics(x509cert, pathCtx, validationKey);
        this.validateSerialNumber(x509cert.getSerialNumber());
        this.validateMustExtensions(x509cert, pathCtx);
    }

    void validateBasics(X509Certificate x509cert, CertPathCtx pathCtx, JSAFE_PublicKey validationKey) throws CertificateException, CertPathException {
        x509cert.getSubjectPublicKey(this.certJ.getDevice());
        if (x509cert.getIssuerName() == null || x509cert.getIssuerName().getRDNCount() == 0) {
            throw new CertificateException("Issuer name MUST be present");
        }
        if (!pathCtx.isFlagRaised(2)) {
            Date validationTime = pathCtx.getValidationTime();
            if (validationTime == null) {
                validationTime = new Date();
            }
            if (!x509cert.checkValidityDate(validationTime)) {
                throw new CertificateException("Certificate is not valid at validation time.");
            }
        }
        try {
            if (!pathCtx.isFlagRaised(1) && !x509cert.verifyCertificateSignature(this.certJ.getDevice(), validationKey, (SecureRandom)this.certJ.getRandomObject())) {
                throw new CertificateException("Certificate signature could not be validated.");
            }
        }
        catch (NoServiceException e) {
            throw new CertPathException(e);
        }
        catch (RandomException e) {
            throw new CertPathException(e);
        }
    }

    private void validateMustExtensions(X509Certificate x509cert, CertPathCtx pathCtx) throws CertPathException, CertificateException {
        X509V3Extensions extensions = x509cert.getExtensions();
        if (extensions == null || extensions.getExtensionCount() == 0) {
            if (x509cert.getSubjectName() == null || x509cert.getSubjectName().getRDNCount() == 0) {
                throw new CertificateException("Subject name MUST NOT be empty when no extensions are specified");
            }
            return;
        }
        boolean isCACert = false;
        BasicConstraints basicConstraint = (BasicConstraints)extensions.getExtensionByType(19);
        if (!pathCtx.isFlagRaised(32) && basicConstraint != null && basicConstraint.getCA() && basicConstraint.getPathLen() >= 0) {
            isCACert = true;
        }
        if (x509cert.getVersion() != 2) {
            throw new CertificateException("Version number MUST be V3 if extensions are present");
        }
        this.checkInstantiatedTwice(extensions);
        this.checkNonStandardExtensions(extensions, pathCtx);
        this.checkSubjectName(x509cert, pathCtx, extensions, isCACert);
        this.checkAuthKeyId(x509cert, extensions);
        this.checkSubjectKeyID(extensions, isCACert);
        this.checkKeyUsage(basicConstraint, extensions, pathCtx, isCACert);
        InhibitAnyPolicy inhibitAnyPolicy = (InhibitAnyPolicy)extensions.getExtensionByType(54);
        if (inhibitAnyPolicy != null && !inhibitAnyPolicy.getCriticality()) {
            throw new CertificateException("Inhibit anyPolicy extension MUST be marked as critical");
        }
        this.checkDistributionPoints(extensions);
        this.checkFreshestCRL(extensions);
        SubjectInfoAccess subjectInfoAccess = (SubjectInfoAccess)extensions.getExtensionByType(125);
        if (subjectInfoAccess != null && subjectInfoAccess.getCriticality()) {
            throw new CertificateException("SubjectInfoAccess extension MUST NOT be set as critical");
        }
        AuthorityInfoAccess authInfoAccess = (AuthorityInfoAccess)extensions.getExtensionByType(100);
        if (authInfoAccess != null && authInfoAccess.getCriticality()) {
            throw new CertificateException("AuthorityInfoAccess extension MUST NOT be set as critical");
        }
        this.checkNameConstraints(extensions, isCACert);
        this.checkPolicyConstraints(extensions, isCACert);
        SubjectAltName subjectAltName = (SubjectAltName)extensions.getExtensionByType(17);
        if (subjectAltName != null && subjectAltName.getGeneralNames().getNameCount() == 0) {
            throw new CertificateException("SubjectAltName MUST contain at least one entry");
        }
        this.checkPolicyMappings(extensions);
    }

    private void validateSerialNumber(byte[] serialNumber) throws CertificateException {
        if (serialNumber == null || serialNumber.length == 0) {
            return;
        }
        if (serialNumber[0] < 0) {
            throw new CertificateException("Serial number cannot be negative");
        }
        if (serialNumber.length > 20) {
            throw new CertificateException("Serial number cannot be have more than 20 bytes");
        }
    }

    private void checkInstantiatedTwice(X509V3Extensions extensions) throws CertificateException {
        HashSet<String> extensionsPresent = new HashSet<String>();
        for (int i = 0; i < extensions.getExtensionCount(); ++i) {
            X509V3Extension extension = extensions.getExtensionByIndex(i);
            String extOID = ConvertUtil.byteArrayToHexString(extension.getOID());
            if (extensionsPresent.contains(extOID)) {
                throw new CertificateException("Found duplicate extension: " + extension.getExtensionTypeString());
            }
            extensionsPresent.add(extOID);
        }
    }

    private void checkNonStandardExtensions(X509V3Extensions extensions, CertPathCtx pathCtx) throws CertificateException {
        if (pathCtx.isFlagRaised(128)) {
            return;
        }
        for (int i = 0; i < extensions.getExtensionCount(); ++i) {
            X509V3Extension extension = extensions.getExtensionByIndex(i);
            if (!extension.isExtensionType(-1)) continue;
            String extOID = ConvertUtil.byteArrayToHexString(extension.getOID());
            if (KNOWN_EXTENSION_OIDS.contains(extOID)) {
                throw new CertificateException("Standard extension found defined as non-standard with OID: " + extOID);
            }
            if (!extension.getCriticality()) continue;
            throw new CertificateException("Non-standard extension is marked as critical.");
        }
    }

    private void checkSubjectName(X509Certificate x509cert, CertPathCtx pathCtx, X509V3Extensions extensions, boolean isCACert) throws CertificateException {
        if (x509cert.getSubjectName() == null || x509cert.getSubjectName().getRDNCount() == 0) {
            if (isCACert) {
                throw new CertificateException("Subject name MUST be present for CA certificates");
            }
            KeyUsage keyUsage = (KeyUsage)extensions.getExtensionByType(15);
            if (keyUsage != null && keyUsage.verifyKeyUsage(0x2000000)) {
                throw new CertificateException("Subject name MUST be present for CRL Issuers");
            }
            SubjectAltName subjectAltName = (SubjectAltName)extensions.getExtensionByType(17);
            if (subjectAltName == null || subjectAltName.getGeneralNames().getNameCount() == 0) {
                throw new CertificateException("Subject alternate name MUST be present if subject name field is empty");
            }
            if (!subjectAltName.getCriticality()) {
                throw new CertificateException("Subject alternate name MUST be critical if subject name is not specified");
            }
        }
    }

    private void checkAuthKeyId(X509Certificate x509cert, X509V3Extensions extensions) throws CertificateException {
        AuthorityKeyID authKeyId = (AuthorityKeyID)extensions.getExtensionByType(35);
        if (authKeyId == null) {
            if (x509cert.getSubjectName() != null && !x509cert.getSubjectName().equals(x509cert.getIssuerName())) {
                throw new CertificateException("Authority key identifier extension MUST be present");
            }
        } else if (authKeyId.getCriticality()) {
            throw new CertificateException("Auth key ID MUST NOT be set as critical");
        }
    }

    private void checkSubjectKeyID(X509V3Extensions extensions, boolean isCACert) throws CertificateException {
        SubjectKeyID subjectKeyId = (SubjectKeyID)extensions.getExtensionByType(14);
        if (subjectKeyId == null || subjectKeyId.getKeyID().length == 0) {
            if (isCACert) {
                throw new CertificateException("SubjectKeyIdentifier extension MUST be present for CA certificates");
            }
        } else if (subjectKeyId.getCriticality()) {
            throw new CertificateException("SubjectKeyIdentifier MUST NOT be set as critical");
        }
    }

    private void checkKeyUsage(BasicConstraints basicConstraint, X509V3Extensions extensions, CertPathCtx pathCtx, boolean isCACert) throws CertificateException {
        if (pathCtx.isFlagRaised(64)) {
            return;
        }
        KeyUsage keyUsage = (KeyUsage)extensions.getExtensionByType(15);
        if (keyUsage == null) {
            return;
        }
        if (keyUsage.getKeyUsage() == 0) {
            throw new CertificateException("At least one bit in the key usage extension MUST be set");
        }
        if (keyUsage.verifyKeyUsage(0x4000000)) {
            if (!isCACert) {
                throw new CertificateException("BasicConstraints extension MUST be set if keyCertSign bit is set");
            }
            if (!basicConstraint.getCriticality()) {
                throw new CertificateException("BasicConstraint extension MUST be marked as critical if the keyCertSign bit is set");
            }
        }
    }

    private void checkDistributionPoints(X509V3Extensions extensions) throws CertPathException, CertificateException {
        CRLDistributionPoints distributionPoints = (CRLDistributionPoints)extensions.getExtensionByType(31);
        if (distributionPoints == null) {
            return;
        }
        this.checkCRLDistPoints(distributionPoints);
    }

    private void checkFreshestCRL(X509V3Extensions extensions) throws CertPathException, CertificateException {
        FreshestCRL freshestCRL = (FreshestCRL)extensions.getExtensionByType(46);
        if (freshestCRL == null) {
            return;
        }
        if (freshestCRL.getCriticality()) {
            throw new CertificateException("Freshest CRL extension MUST NOT be set as critical");
        }
        this.checkCRLDistPoints(freshestCRL);
    }

    private void checkCRLDistPoints(CRLDistributionPoints distributionPoints) throws CertificateException, CertPathException {
        int dpCount = distributionPoints.getDistributionPointCount();
        boolean coversAllReasons = false;
        for (int i = 0; i < dpCount; ++i) {
            try {
                GeneralNames crlIssuer;
                int reasonFlag = distributionPoints.getReasonFlags(i);
                if (reasonFlag == -8388608 || reasonFlag == -1) {
                    coversAllReasons = true;
                }
                if ((crlIssuer = distributionPoints.getCRLIssuer(i)) == null || crlIssuer.getNameCount() == 1 && crlIssuer.getGeneralName(0).getGeneralNameType() == 5) continue;
                throw new CertificateException("The CRLIssuer MUST only contain the distinguished name from the issuer field of the CRL");
            }
            catch (NameException e) {
                throw new CertPathException(e);
            }
        }
        if (!coversAllReasons) {
            throw new CertificateException("At least one Distribution Point MUST cover all reasons");
        }
    }

    private void checkNameConstraints(X509V3Extensions extensions, boolean isCACert) throws CertificateException, CertPathException {
        NameConstraints nameConstraints = (NameConstraints)extensions.getExtensionByType(30);
        if (nameConstraints == null) {
            return;
        }
        GeneralSubtrees excludedNameConstraints = nameConstraints.getExcludedSubtrees();
        GeneralSubtrees permittedNameConstraints = nameConstraints.getPermittedSubtrees();
        if (excludedNameConstraints == null && permittedNameConstraints == null) {
            throw new CertificateException("Either the permittedSubtrees field or the excludedSubtrees MUST be present");
        }
        this.validateNamedConstraints(nameConstraints, excludedNameConstraints, isCACert);
        this.validateNamedConstraints(nameConstraints, permittedNameConstraints, isCACert);
    }

    private void validateNamedConstraints(NameConstraints nameConstraints, GeneralSubtrees subtrees, boolean isCACert) throws CertificateException, CertPathException {
        if (subtrees == null) {
            return;
        }
        if (!isCACert) {
            throw new CertificateException("Named constraints MUST only be applied to CA certificates");
        }
        if (!nameConstraints.getCriticality()) {
            throw new CertificateException("Named constraint extension MUST be set as critical");
        }
        for (int i = 0; i < subtrees.getSubtreeCount(); ++i) {
            try {
                if (subtrees.getMinimum(i) == 0 && subtrees.getMaximum(i) == -1) continue;
                throw new CertificateException("Named constraints minimum field MUST be 0 and the maximum field MUST be absent");
            }
            catch (NameException e) {
                throw new CertPathException(e);
            }
        }
    }

    private void checkPolicyConstraints(X509V3Extensions extensions, boolean isCACert) throws CertificateException {
        PolicyConstraints policyConstraints = (PolicyConstraints)extensions.getExtensionByType(36);
        if (policyConstraints == null) {
            return;
        }
        if (isCACert && !policyConstraints.getCriticality()) {
            throw new CertificateException("Policy constraints extension for CAs MUST be set as critical");
        }
        if (policyConstraints.getPolicyMapping() == -1 && policyConstraints.getExplicitPolicy() == -1) {
            throw new CertificateException("Either the inhibitPolicyMapping field or the requireExplicitPolicy field MUST be present");
        }
    }

    private void checkPolicyMappings(X509V3Extensions extensions) throws CertificateException {
        PolicyMappings policyMappings = (PolicyMappings)extensions.getExtensionByType(33);
        if (policyMappings == null) {
            return;
        }
        for (int i = 0; i < policyMappings.getPolicyCount(); ++i) {
            byte[] issuerDomainPolicy = policyMappings.getIssuerDomainPolicy(i);
            byte[] subjectDomainPolicy = policyMappings.getSubjectDomainPolicy(i);
            if (!CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, issuerDomainPolicy) && !CertJUtils.byteArraysEqual(X509V3Extension.ANY_POLICY_OID, subjectDomainPolicy)) continue;
            throw new CertificateException("Policies MUST NOT be mapped to or from the special value anyPolicy");
        }
    }

    static {
        X509CertificateValidator.addStandardOID(9);
        X509CertificateValidator.addStandardOID(14);
        X509CertificateValidator.addStandardOID(15);
        X509CertificateValidator.addStandardOID(16);
        X509CertificateValidator.addStandardOID(17);
        X509CertificateValidator.addStandardOID(18);
        X509CertificateValidator.addStandardOID(19);
        X509CertificateValidator.addStandardOID(20);
        X509CertificateValidator.addStandardOID(21);
        X509CertificateValidator.addStandardOID(23);
        X509CertificateValidator.addStandardOID(24);
        X509CertificateValidator.addStandardOID(27);
        X509CertificateValidator.addStandardOID(28);
        X509CertificateValidator.addStandardOID(29);
        X509CertificateValidator.addStandardOID(30);
        X509CertificateValidator.addStandardOID(31);
        X509CertificateValidator.addStandardOID(32);
        X509CertificateValidator.addStandardOID(33);
        X509CertificateValidator.addStandardOID(35);
        X509CertificateValidator.addStandardOID(36);
        X509CertificateValidator.addStandardOID(37);
        X509CertificateValidator.addStandardOID(54);
        X509CertificateValidator.addSpecialOID(X509V3Extension.AUTHORITY_INFO_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_CERT_TYPE_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_BASE_URL_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_REVOCATION_URL_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_CA_REVOCATION_URL_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_CERT_RENEWAL_URL_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_CA_POLICY_URL_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_SSL_SERVER_NAME_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.NETSCAPE_COMMENT_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_CZAG_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_FIDELITY_ID_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_NETSCAPE_INBOX_V1_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_NETSCAPE_INBOX_V2_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_JURISDICTION_HASH_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_TOKEN_TYPE_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_SERIAL_NUMBER_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.VERISIGN_NON_VERIFIED_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.OCSP_NOCHECK_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.ARCHIVE_CUTOFF_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.CRL_REFERENCE_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.OCSP_NONCE_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.OCSP_ACCEPTABLE_RESPONSES_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.OCSP_SERVICE_LOCATOR_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.QC_STATEMENTS_OID);
        X509CertificateValidator.addSpecialOID(X509V3Extension.BIO_INFO_OID);
    }
}

