/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.pki.CRS;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.ProtectInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class CRSDebug
extends CRS {
    private File messageStore;
    private String requestCN;

    public CRSDebug(String name, File configFile, File messageStore) throws InvalidParameterException {
        super(name, configFile);
        this.messageStore = messageStore;
    }

    public void saveMessage(byte[] bytes, PKIMessage message, ProtectInfo protectInfo) throws PKIException {
        String cn;
        String typeString;
        if (message instanceof PKIRequestMessage) {
            typeString = "req";
            this.requestCN = cn = this.getCN((X509Certificate)((PKIRequestMessage)message).getCertificateTemplate());
        } else if (message instanceof PKIResponseMessage) {
            typeString = "res";
            cn = this.requestCN;
        } else {
            throw new PKIException("CRSDebug.saveMessage: message should be an instance of either PKIRequestMessage or PKIResponseMessage.");
        }
        this.writeDataToFile(bytes, this.getOutputFileName(cn, typeString));
    }

    public void saveCertificate(PKIResponseMessage response) throws PKIException {
        Certificate cert = response.getCertificate();
        if (cert == null) {
            return;
        }
        byte[] der = new byte[((X509Certificate)cert).getDERLen(0)];
        try {
            ((X509Certificate)cert).getDEREncoding(der, 0, 0);
        }
        catch (CertificateException e) {
            // empty catch block
        }
        String cn = this.getCN((X509Certificate)cert);
        File file = new File(this.messageStore, cn + ".cer");
        int index = 0;
        while (file.exists()) {
            file = new File(this.messageStore, cn + "." + ++index + ".cer");
        }
        this.writeDataToFile(der, file);
    }

    public void saveData(byte[] data, String fileName) throws PKIException {
        this.writeDataToFile(data, new File(this.messageStore, fileName));
    }

    private File getOutputFileName(String filename, String typeString) {
        File file = new File(this.messageStore, filename + "." + typeString + ".ber");
        int index = 0;
        while (file.exists()) {
            file = new File(this.messageStore, filename + "." + typeString + ++index + ".ber");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataToFile(byte[] data, File file) {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(file);
            fileOut.write(data);
        }
        catch (IOException e) {
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String getCN(X509Certificate cert) {
        if (cert == null) {
            return "unknown";
        }
        return this.getCN(cert.getSubjectName());
    }

    private String getCN(X500Name name) {
        if (name == null) {
            return "unknown";
        }
        AttributeValueAssertion ava = name.getAttribute(0);
        if (ava == null) {
            return "unknwon";
        }
        try {
            return ava.getStringAttribute();
        }
        catch (NameException e) {
            return "unknown";
        }
    }
}

