/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;

public final class CMPErrorMessage
extends CMPResponseCommon {
    private boolean errorCodePresent;
    private int errorCode;
    private String[] errorDetails;

    private CMPErrorMessage(PKIHeader header, PKIStatusInfo statusInfo, boolean errorCodePresent, int errorCode, String[] errorDetails) throws CMPException {
        super(23, header, statusInfo);
        this.errorCodePresent = errorCodePresent;
        this.errorCode = errorCode;
        this.errorDetails = errorDetails;
    }

    static CMPErrorMessage berDecodeBody(PKIHeader header, byte[] body, int bodyOffset) throws CMPException {
        PKIStatusInfo statusInfo;
        OfContainer errorDetailsContainer;
        IntegerContainer errorCodeContainer;
        EncodedContainer statusInfoContainer;
        try {
            statusInfoContainer = new EncodedContainer(12288);
            errorCodeContainer = new IntegerContainer(65536);
            errorDetailsContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(3072));
            ASN1Container[] def = new ASN1Container[]{new SequenceContainer(10551319), statusInfoContainer, errorCodeContainer, errorDetailsContainer, new EndContainer()};
            ASN1.berDecode((byte[])body, (int)bodyOffset, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPErrorMessage.berDecodeBody: decoding ErrorMsgContent failed.", (Exception)((Object)e));
        }
        try {
            statusInfo = new PKIStatusInfo(statusInfoContainer.data, statusInfoContainer.dataOffset, 0);
        }
        catch (PKIException e) {
            throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to instantiate PKIStatusInfo.", e);
        }
        boolean errorCodePresent = errorCodeContainer.dataPresent;
        int errorCode = -1;
        if (errorCodePresent) {
            try {
                errorCode = errorCodeContainer.getValueAsInt();
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to get ErrorMsgContent.errorCode as int.", (Exception)((Object)e));
            }
        }
        String[] errorDetails = null;
        if (errorDetailsContainer.dataPresent) {
            int count = errorDetailsContainer.getContainerCount();
            errorDetails = new String[count];
            for (int i = 0; i < count; ++i) {
                try {
                    ASN1Container encodedContainer = errorDetailsContainer.containerAt(i);
                    UTF8StringContainer utf8Container = new UTF8StringContainer(0);
                    ASN1Container[] utf8Def = new ASN1Container[]{utf8Container};
                    ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])utf8Def);
                    if (utf8Container.dataPresent && utf8Container.dataLen != 0) {
                        errorDetails[i] = new String(utf8Container.data, utf8Container.dataOffset, utf8Container.dataLen);
                        continue;
                    }
                    errorDetails[i] = null;
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to extract and decode an errorDetails.", (Exception)((Object)e));
                }
            }
        }
        return new CMPErrorMessage(header, statusInfo, errorCodePresent, errorCode, errorDetails);
    }

    public boolean errorCodePresent() {
        return this.errorCodePresent;
    }

    public int getErrorCode() throws CMPException {
        if (!this.errorCodePresent) {
            throw new CMPException("CMPErrorMessage.getErrorCode: error code not returned.");
        }
        return this.errorCode;
    }

    public String[] getErrorDetails() {
        return this.errorDetails;
    }
}

