/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.spi.pki.ProtectInfo;

public final class CMPProtectInfo
extends ProtectInfo {
    private static final String DEFAULT_PBM_ALGORITHM = "PBE/HMAC/SHA1/PKIXPBE-1024";
    boolean pbmProtected;
    private String algorithm;
    private X509Certificate senderCert;
    private X509Certificate recipCert;
    private char[] sharedSecret;
    private byte[] keyID;
    private X509Certificate[] caCerts;
    private DatabaseService database;

    public CMPProtectInfo(String algorithm, Certificate senderCert, Certificate recipCert, Certificate[] caCerts, DatabaseService database) throws InvalidParameterException {
        this.pbmProtected = false;
        if (algorithm == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: algorithm should not be null.");
        }
        this.algorithm = algorithm;
        if (!(senderCert instanceof X509Certificate)) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: senderCert should be an instance of X509Certificate.");
        }
        this.senderCert = (X509Certificate)senderCert;
        if (recipCert != null) {
            if (!(recipCert instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: recipCert should be an instance of X509Certificate.");
            }
            this.recipCert = (X509Certificate)recipCert;
        }
        if (database == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: database should not be null.");
        }
        this.database = database;
        this.setCACerts(caCerts, true);
    }

    public CMPProtectInfo(String algorithm, char[] sharedSecret, byte[] keyID, Certificate recipCert, Certificate[] caCerts, DatabaseService database) throws InvalidParameterException {
        this.pbmProtected = true;
        this.algorithm = algorithm == null ? DEFAULT_PBM_ALGORITHM : algorithm;
        if (sharedSecret == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: sharedSecret should not be null.");
        }
        this.sharedSecret = sharedSecret;
        if (keyID == null) {
            throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: keyID should not be null.");
        }
        this.keyID = keyID;
        if (recipCert != null) {
            if (!(recipCert instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.CMPProtectInfo: recipCert should be an instance of X509Certificate.");
            }
            this.recipCert = (X509Certificate)recipCert;
        }
        this.setCACerts(caCerts, false);
        this.database = database;
    }

    private void setCACerts(Certificate[] caCerts, boolean required) throws InvalidParameterException {
        if (required && (caCerts == null || caCerts.length == 0)) {
            throw new InvalidParameterException("CMPProtectInfo.setCACerts: caCerts should not be empty.");
        }
        if (caCerts == null) {
            return;
        }
        this.caCerts = new X509Certificate[caCerts.length];
        for (int i = 0; i < caCerts.length; ++i) {
            Certificate cert = caCerts[i];
            if (!(cert instanceof X509Certificate)) {
                throw new InvalidParameterException("CMPProtectInfo.setCACerts: every member of the caCerts array should be an instance of X509Certificate.");
            }
            this.caCerts[i] = (X509Certificate)caCerts[i];
        }
    }

    boolean pbmProtected() {
        return this.pbmProtected;
    }

    String getAlgorithm() {
        return this.algorithm;
    }

    X509Certificate getSenderCert() {
        return this.senderCert;
    }

    X509Certificate getRecipCert() {
        return this.recipCert;
    }

    X509Certificate[] getCACerts() {
        return this.caCerts;
    }

    char[] getSharedSecret() {
        return this.sharedSecret;
    }

    byte[] getKeyID() {
        return this.keyID;
    }

    DatabaseService getDatabase() {
        return this.database;
    }
}

