/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPCertResponseCommon;
import com.rsa.certj.provider.pki.cmp.CMPConfirmMessage;
import com.rsa.certj.provider.pki.cmp.CMPErrorMessage;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPRevokeResponseMessage;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.provider.pki.cmp.TypeAndValue;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.Date;

public abstract class CMPResponseCommon
extends PKIResponseMessage {
    private GeneralName senderName;
    private GeneralName recipientName;
    private byte[] senderKID;
    private byte[] recipKID;
    private byte[] senderNonce;
    private byte[] recipNonce;
    private TypeAndValue[] generalInfo;
    private int messageType = -1;

    protected CMPResponseCommon(int messageType, PKIHeader header, PKIStatusInfo statusInfo) {
        super(statusInfo);
        this.messageType = messageType;
        this.senderName = header.sender;
        this.recipientName = header.recipient;
        this.senderKID = header.getSenderKID();
        this.recipKID = header.getRecipKID();
        this.senderNonce = header.getSenderNonce();
        this.recipNonce = header.getRecipNonce();
        this.generalInfo = header.generalInfo;
    }

    protected int getMessageType() {
        return this.messageType;
    }

    public GeneralName getSenderName() {
        return this.senderName;
    }

    public GeneralName getRecipientName() {
        return this.recipientName;
    }

    public byte[] getSenderKID() {
        return this.senderKID;
    }

    public byte[] getRecipKID() {
        return this.recipKID;
    }

    public byte[] getSenderNonce() {
        return this.senderNonce;
    }

    public byte[] getRecipNonce() {
        return this.recipNonce;
    }

    public TypeAndValue[] getGeneralInfo() {
        return this.generalInfo;
    }

    protected static CMPResponseCommon berDecode(byte[] encodedResponse, CMPProtectInfo protectInfo, CMPRequestCommon request, CertJ certJ) throws CMPException {
        OfContainer extraCertsContainer;
        BitStringContainer protectionContainer;
        EncodedContainer bodyContainer;
        EncodedContainer headerContainer;
        try {
            SequenceContainer pkiMessageContainer = new SequenceContainer(0);
            headerContainer = new EncodedContainer(12288);
            bodyContainer = new EncodedContainer(65280);
            protectionContainer = new BitStringContainer(0xA10000);
            extraCertsContainer = new OfContainer(0xA10001, 12288, (ASN1Container)new EncodedContainer(12288));
            EndContainer endContainer = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{pkiMessageContainer, headerContainer, bodyContainer, protectionContainer, extraCertsContainer, endContainer};
            ASN1.berDecode((byte[])encodedResponse, (int)0, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPResponseCommon.berDecode: unable to decode response message.", (Exception)((Object)e));
        }
        PKIHeader pkiHeader = new PKIHeader(headerContainer.data, headerContainer.dataOffset);
        CMPResponseCommon response = CMPResponseCommon.berDecodeBody(pkiHeader, bodyContainer.data, bodyContainer.dataOffset, protectInfo, request, certJ);
        Certificate[] extraCerts = CMPResponseCommon.decodeExtraCerts(extraCertsContainer);
        response.setExtraCerts(extraCerts);
        response.setFreeText(pkiHeader.freeText);
        response.setMessageTime(pkiHeader.messageTime);
        response.setTransactionID(pkiHeader.getTransactionID());
        Certificate[] caCertsReturned = response.getCACerts();
        if (!CMPResponseCommon.verifyProtection(protectInfo, (ASN1Container)protectionContainer, (ASN1Container)headerContainer, (ASN1Container)bodyContainer, pkiHeader, extraCerts, caCertsReturned, certJ)) {
            throw new CMPException("CMPResponseCommon.berDecode: unable to verify protection.");
        }
        return response;
    }

    protected static CMPResponseCommon berDecodeBody(PKIHeader header, byte[] body, int bodyOffset, CMPProtectInfo protectInfo, CMPRequestCommon request, CertJ certJ) throws CMPException {
        CMPResponseCommon response;
        int messageType = 0xFF & body[bodyOffset] - 160;
        switch (messageType) {
            case 1: 
            case 3: {
                response = CMPCertResponseCommon.berDecodeBody(messageType, header, body, bodyOffset, protectInfo, request, certJ);
                break;
            }
            case 19: {
                response = CMPConfirmMessage.berDecodeBody(header, body, bodyOffset);
                break;
            }
            case 23: {
                response = CMPErrorMessage.berDecodeBody(header, body, bodyOffset);
                break;
            }
            case 12: {
                response = CMPRevokeResponseMessage.berDecodeBody(header, body, bodyOffset);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                throw new CMPException("CMPResponseCommon.berDecodeBody: unsupported response message type(" + messageType + ").");
            }
            default: {
                throw new CMPException("CMPResponseCommon.berDecodeBody: unexpected response message type(" + messageType + ").");
            }
        }
        return response;
    }

    private static boolean verifyProtection(CMPProtectInfo protectInfo, ASN1Container protectionContainer, ASN1Container headerContainer, ASN1Container bodyContainer, PKIHeader pkiHeader, Certificate[] extraCerts, Certificate[] caCertsReturned, CertJ certJ) throws CMPException {
        if (!protectionContainer.dataPresent) {
            return true;
        }
        if (protectInfo == null) {
            throw new CMPException("CMPResponseCommon.verifyProtection: protectInfo should be null.");
        }
        byte[] protectedPart = CMP.derEncodeProtectedPart(headerContainer.data, headerContainer.dataOffset, headerContainer.dataLen, bodyContainer.data, bodyContainer.dataOffset, bodyContainer.dataLen);
        byte[] protectionAlg = pkiHeader.getProtectionAlg();
        JSAFE_Signature signatureObject = null;
        try {
            int offset = 1 + ASN1Lengths.determineLengthLen((byte[])protectionAlg, (int)1);
            signatureObject = JSAFEFactory.getSignature(protectionAlg, offset, certJ.getDevice(), certJ);
        }
        catch (JSAFE_Exception e) {
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPResponseCommon.verifyProtection.", (Exception)((Object)e));
        }
        if (signatureObject != null) {
            return CMPResponseCommon.verifyProtection(signatureObject, protectInfo, protectionContainer, protectedPart, extraCerts, caCertsReturned, certJ);
        }
        if (!protectInfo.pbmProtected()) {
            throw new CMPException("CMPResponseCommon.verifyProtection: protectInfo should contain PBM protection info.");
        }
        return CMPResponseCommon.verifyProtection(protectionAlg, protectInfo, protectionContainer, protectedPart, certJ);
    }

    private static boolean verifyProtection(JSAFE_Signature signature, CMPProtectInfo protectInfo, ASN1Container protectionContainer, byte[] protectedPart, Certificate[] extraCerts, Certificate[] caCertsReturned, CertJ certJ) throws CMPException {
        int i;
        JSAFE_SecureRandom random;
        Certificate[] caCerts = protectInfo.getCACerts();
        CertPathCtx pathCtx = new CertPathCtx(0, caCerts, null, new Date(), protectInfo.getDatabase());
        try {
            random = certJ.getRandomObject();
        }
        catch (CertJException e) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to get a registered random service.", e);
        }
        X509Certificate recipCert = protectInfo.getRecipCert();
        if (recipCert != null && CMPResponseCommon.verifySignature(signature, pathCtx, recipCert, protectedPart, protectionContainer, random, certJ)) {
            return true;
        }
        if (caCerts != null) {
            for (i = 0; i < caCerts.length; ++i) {
                if (caCerts[i] == null || !CMPResponseCommon.verifySignature(signature, pathCtx, caCerts[i], protectedPart, protectionContainer, random, certJ)) continue;
                return true;
            }
        }
        if (caCertsReturned != null) {
            for (i = 0; i < caCertsReturned.length; ++i) {
                if (caCertsReturned[i] == null || !CMPResponseCommon.verifySignature(signature, pathCtx, caCertsReturned[i], protectedPart, protectionContainer, random, certJ)) continue;
                return true;
            }
        }
        if (extraCerts != null) {
            for (i = 0; i < extraCerts.length; ++i) {
                if (extraCerts[i] == null || !CMPResponseCommon.verifySignature(signature, pathCtx, extraCerts[i], protectedPart, protectionContainer, random, certJ)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean verifySignature(JSAFE_Signature signature, CertPathCtx pathCtx, Certificate cert, byte[] protectedPart, ASN1Container protectionContainer, JSAFE_SecureRandom random, CertJ certJ) {
        try {
            if (certJ.verifyCertPath(pathCtx, cert)) {
                signature.verifyInit(cert.getSubjectPublicKey(certJ.getDevice()), null, (SecureRandom)random, certJ.getPKCS11Sessions());
                signature.verifyUpdate(protectedPart, 0, protectedPart.length);
                byte[] sig = new byte[protectionContainer.dataLen];
                System.arraycopy(protectionContainer.data, protectionContainer.dataOffset, sig, 0, sig.length);
                if (signature.verifyFinal(sig, 0, sig.length)) {
                    return true;
                }
            }
        }
        catch (CertificateException e) {
        }
        catch (CertJException e) {
        }
        catch (JSAFE_Exception e) {
            // empty catch block
        }
        return false;
    }

    private static boolean verifyProtection(byte[] protectionAlg, CMPProtectInfo protectInfo, ASN1Container protectionContainer, byte[] protectedPart, CertJ certJ) throws CMPException {
        int iterations;
        char[] sharedSecret = protectInfo.getSharedSecret();
        SequenceContainer algorithmIdentifierContainer = new SequenceContainer(0xA10001);
        OIDContainer algorithmIdContainer = new OIDContainer(0x1000000);
        EncodedContainer algorithmParamContainer = new EncodedContainer(77824);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] algDef = new ASN1Container[]{algorithmIdentifierContainer, algorithmIdContainer, algorithmParamContainer, endContainer};
        try {
            ASN1.berDecode((byte[])protectionAlg, (int)0, (ASN1Container[])algDef);
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPResponseCommon.verifyProtection: Decoding PKIHeader.protectionAlg failed.", (Exception)((Object)e));
        }
        if (!CMPResponseCommon.oidsEqual(CMP.PASSWORD_BASED_MAC_OID, 0, CMP.PASSWORD_BASED_MAC_OID.length, algorithmIdContainer.data, algorithmIdContainer.dataOffset, algorithmIdContainer.dataLen)) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unsupported PBM algorithm.");
        }
        SequenceContainer pbmParameterContainer = new SequenceContainer(0);
        OctetStringContainer saltContainer = new OctetStringContainer(0);
        EncodedContainer owfContainer = new EncodedContainer(12288);
        IntegerContainer iterationCountContainer = new IntegerContainer(0);
        EncodedContainer macContainer = new EncodedContainer(12288);
        endContainer = new EndContainer();
        ASN1Container[] paramDef = new ASN1Container[]{pbmParameterContainer, saltContainer, owfContainer, iterationCountContainer, macContainer, endContainer};
        try {
            ASN1.berDecode((byte[])algorithmParamContainer.data, (int)algorithmParamContainer.dataOffset, (ASN1Container[])paramDef);
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPResponseCommon.verifyProtection: decoding PKIHeader.protectionAlg failed.", (Exception)((Object)e));
        }
        JSAFE_MAC macObject = null;
        try {
            iterations = iterationCountContainer.getValueAsInt();
        }
        catch (ASN_Exception e) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to get iterationCount as integer.", (Exception)((Object)e));
        }
        try {
            macObject = JSAFEFactory.getMAC("PBE/HMAC/SHA1/PKIXPBE-" + iterations, certJ.getDevice(), certJ);
            macObject.setSalt(saltContainer.data, saltContainer.dataOffset, saltContainer.dataLen);
            JSAFE_SecretKey macKey = macObject.getBlankKey();
            macKey.setPassword(sharedSecret, 0, sharedSecret.length);
            macObject.verifyInit(macKey, null);
            macObject.verifyUpdate(protectedPart, 0, protectedPart.length);
            boolean bl = macObject.verifyFinal(protectionContainer.data, protectionContainer.dataOffset, protectionContainer.dataLen);
            return bl;
        }
        catch (JSAFE_Exception e) {
            throw new CMPException("CMPResponseCommon.verifyProtection: unable to verify PBM.", (Exception)((Object)e));
        }
        finally {
            if (macObject != null) {
                macObject.clearSensitiveData();
            }
        }
    }

    private static Certificate[] decodeExtraCerts(OfContainer extraCertsContainer) throws CMPException {
        if (!extraCertsContainer.dataPresent) {
            return null;
        }
        int count = extraCertsContainer.getContainerCount();
        Certificate[] certs = new Certificate[count];
        for (int i = 0; i < count; ++i) {
            try {
                ASN1Container cert = extraCertsContainer.containerAt(i);
                certs[i] = new X509Certificate(cert.data, cert.dataOffset, 0);
                continue;
            }
            catch (ASN_Exception e) {
                throw new CMPException("CMPResponseCommon.decodeExtraCerts: unable to get an element container of OfContainer.", (Exception)((Object)e));
            }
            catch (CertificateException e) {
                throw new CMPException("CMPResponseCommon.decodeExtraCerts: unable to decode a certificate.", e);
            }
        }
        return certs;
    }

    private static boolean oidsEqual(byte[] oid1, int offset1, int len1, byte[] oid2, int offset2, int len2) {
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (oid1[offset1 + i] == oid2[offset2 + i]) continue;
            return false;
        }
        return true;
    }
}

