/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.random;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.random.RandomInterface;
import com.rsa.jsafe.JSAFE_SecureRandom;

public final class DefaultRandom
extends Provider {
    private static final int SEED_APP = 0;
    private static final int SEED_OS = 2;
    private byte[] seed;

    public DefaultRandom(String name) throws InvalidParameterException {
        super(0, name);
    }

    public DefaultRandom(String name, long seed) throws InvalidParameterException {
        super(0, name);
        this.seed = new byte[8];
        for (int i = 0; i < 8; ++i) {
            this.seed[7 - i] = (byte)(0xFFL & seed);
            seed >>= 8;
        }
    }

    public DefaultRandom(String name, byte[] seed) throws InvalidParameterException {
        super(0, name);
        this.seed = seed;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException("DefaultRandom.instantiate.", e);
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements RandomInterface {
        private JSAFE_SecureRandom random;
        private int seedType;

        private Implementation(CertJ certJ, String name) throws InvalidParameterException {
            super(certJ, name);
            this.createRandom();
            if (DefaultRandom.this.seed != null) {
                this.seedType = 0;
                this.random.seed(DefaultRandom.this.seed);
            }
            this.updateRandom();
        }

        private void createRandom() {
            this.random = JSAFEFactory.getRandom(this.context);
            this.seedType = 2;
        }

        public JSAFE_SecureRandom getRandomObject() {
            return this.random;
        }

        public void updateRandom() {
            switch (this.seedType) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this.random.getAlgorithm().equals("FIPS186Random")) break;
                    this.random.autoseed();
                    break;
                }
            }
        }

        public String toString() {
            return "Default Random provider named: " + super.getName();
        }
    }
}

