/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.NameMatcher;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.CertificateIssuer;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.IssuingDistributionPoint;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.ReasonCode;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.internal.Debug;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRLStatusCommon
extends ProviderImplementation
implements CertStatusInterface {
    protected static final String SUITEB_COMPLIANCE_FAILED = "SuiteB compliance checks failed for CRL with issuer: ";
    private static final boolean DEBUG_ON = Debug.isCertPathSet();

    protected CRLStatusCommon(CertJ certJ, String name) throws InvalidParameterException {
        super(certJ, name);
    }

    @Override
    public CertRevocationInfo checkCertRevocation(CertPathCtx pathCtx, Certificate cert) throws NotSupportedException, CertStatusException {
        CertRevocationInfo result;
        if (!(cert instanceof X509Certificate)) {
            throw new NotSupportedException("CRLCertStatus$Implementation.checkCertRevocation: does not support certificate types other than X509Certificate.");
        }
        X509Certificate x509Cert = (X509Certificate)cert;
        CRLDistributionPoints distributionPoints = (CRLDistributionPoints)this.getExtension(x509Cert, 31);
        if (distributionPoints != null && !pathCtx.isFlagRaised(1024)) {
            result = this.doCheckCertRevocation(pathCtx, x509Cert, distributionPoints);
        } else {
            distributionPoints = new CRLDistributionPoints();
            GeneralNames certIssuer = new GeneralNames();
            GeneralName certIssuerName = new GeneralName();
            try {
                certIssuerName.setGeneralName(x509Cert.getIssuerName(), 5);
            }
            catch (NameException e) {
                throw new CertStatusException(e);
            }
            certIssuer.addGeneralName(certIssuerName);
            distributionPoints.addDistributionPoints(certIssuer, -1, null);
            result = this.doCheckCertRevocation(pathCtx, x509Cert, distributionPoints);
        }
        return result;
    }

    private CertRevocationInfo doCheckCertRevocation(CertPathCtx pathCtx, X509Certificate cert, CRLDistributionPoints distributionPoints) throws CertStatusException {
        CertRevocationInfo result = new CertRevocationInfo();
        RevocationStatus status = new RevocationStatus();
        Vector<Certificate> certList = new Vector<Certificate>();
        Vector<CRL> crlList = new Vector<CRL>();
        Vector<Certificate> crlCerts = new Vector<Certificate>();
        Date validationTime = pathCtx.getValidationTime() == null ? new Date() : pathCtx.getValidationTime();
        int distributionPointCount = distributionPoints.getDistributionPointCount();
        block4: for (int i = 0; i < distributionPointCount; ++i) {
            Vector<X509CRL> crls;
            GeneralNames crlIssuer = null;
            try {
                crlIssuer = distributionPoints.getCRLIssuer(i);
            }
            catch (NameException e) {
                this.internalError(e);
            }
            boolean indirectCRL = false;
            if (crlIssuer != null) {
                X500Name crlIssuerName = this.findX500Name(crlIssuer);
                this.validateIssuerDn(crlIssuerName);
                crls = this.obtainCrls(pathCtx, crlIssuerName, validationTime);
                indirectCRL = true;
            } else {
                crls = this.obtainCrls(pathCtx, cert.getIssuerName(), validationTime);
            }
            Iterator<X509CRL> crlIter = crls.iterator();
            while (crlIter.hasNext()) {
                CRLEvidence evidence;
                if (status.isAllReasons() || !status.isUnrevoked()) break block4;
                X509CRL crl = crlIter.next();
                if (this.isCRLObsolete(pathCtx, crl, validationTime) || indirectCRL && !this.assertsIndirectCRL(crl)) continue;
                this.updateLocalCrlCache();
                try {
                    if (!this.verifyIssuerAndScope(pathCtx, crl, cert, distributionPoints, i)) {
                        continue;
                    }
                }
                catch (NameException e) {
                    this.internalError(e);
                }
                this.verifyIssuerAndScopeOnDeltaCrl();
                if (!pathCtx.isFlagRaised(16384)) {
                    this.updateInterimReasonsMask(status, crl, distributionPoints, i);
                    if (!this.verifyInterimReasonsMask(status)) continue;
                }
                if (!this.verifyPath(pathCtx, crl, certList, crlList, crlCerts)) continue;
                if (crlList != null && !crlList.contains(crl)) {
                    crlList.add(crl);
                }
                CertJUtils.mergeLists(crlCerts, certList);
                if (this.findSerialNumberInCrl(cert, crl, indirectCRL)) {
                    ReasonCode reasonCode = (ReasonCode)this.getExtension(crl, 21);
                    status.certStatus = reasonCode != null ? reasonCode.getReasonCode() : 0;
                    result.setStatus(1);
                    result.setType(1);
                    CRLEvidence evidence2 = new CRLEvidence(crl, null, null);
                    result.setEvidence(evidence2);
                } else if (!pathCtx.isFlagRaised(128) && this.hasUnknownCriticalExtension(crl)) {
                    status.certStatus = 0;
                    result.setStatus(2);
                    result.setType(1);
                    evidence = new CRLEvidence(crl, null, null);
                    result.setEvidence(evidence);
                } else if (pathCtx.isFlagRaised(16384)) {
                    result.setStatus(0);
                    result.setType(1);
                    evidence = new CRLEvidence(null, crlCerts, crlList);
                    result.setEvidence(evidence);
                }
                if (status.certStatus == 8) {
                    status.setUnrevoked();
                }
                status.reasonsMask |= status.interimReasonsMask;
            }
        }
        if (pathCtx.isFlagRaised(16384)) {
            return result;
        }
        if (status.isAllReasons() || !status.isUnrevoked()) {
            if (status.isUnrevoked()) {
                CRLEvidence evidence = new CRLEvidence(null, crlCerts, crlList);
                result.setStatus(0);
                result.setType(1);
                result.setEvidence(evidence);
            }
        } else {
            result.setStatus(2);
            result.setEvidence(null);
            result.setType(0);
        }
        return result;
    }

    protected abstract boolean checkCompliance(X509CRL var1) throws CertStatusException;

    private boolean assertsIndirectCRL(X509CRL crl) {
        IssuingDistributionPoint idp = (IssuingDistributionPoint)this.getExtension(crl, 28);
        return idp != null && idp.getIndirectCRL();
    }

    private X500Name findX500Name(GeneralNames generalNames) {
        Vector<GeneralName> names = generalNames.getGeneralNames();
        for (int i = 0; i < names.size(); ++i) {
            GeneralName name = names.get(i);
            Object nameObject = name.getGeneralName();
            if (!(nameObject instanceof X500Name)) continue;
            return (X500Name)nameObject;
        }
        return null;
    }

    private void internalError(Exception e) throws CertStatusException {
        throw new CertStatusException("Internal error! ", e);
    }

    private boolean verifyInterimReasonsMask(RevocationStatus status) {
        return (status.interimReasonsMask & ~status.reasonsMask) != 0;
    }

    private void updateInterimReasonsMask(RevocationStatus status, X509CRL crl, CRLDistributionPoints distributionPoints, int index) throws CertStatusException {
        int reasons;
        try {
            reasons = distributionPoints.getReasonFlags(index);
        }
        catch (NameException e) {
            throw new CertStatusException("Internal error! ", e);
        }
        IssuingDistributionPoint idp = (IssuingDistributionPoint)this.getExtension(crl, 28);
        if (idp == null) {
            status.interimReasonsMask = reasons != -1 ? reasons : -8388608;
            return;
        }
        int onlySomeResons = idp.getReasonFlags();
        if (onlySomeResons == -1) {
            status.interimReasonsMask = reasons != -1 ? reasons : -8388608;
            return;
        }
        status.interimReasonsMask = onlySomeResons;
        if (reasons != -1) {
            status.interimReasonsMask &= reasons;
        }
    }

    private Vector<X509CRL> obtainCrls(CertPathCtx pathCtx, X500Name issuer, Date validationTime) throws CertStatusException {
        Vector<X509CRL> result = new Vector<X509CRL>();
        try {
            DatabaseService db = pathCtx.getDatabase();
            db.setupCRLIterator();
            while (db.hasMoreCRLs()) {
                Date lastUpdate;
                X509CRL x509Crl;
                X500Name testName;
                CRL nextCrl = db.nextCRL();
                if (!(nextCrl instanceof X509CRL) || !issuer.equals(testName = (x509Crl = (X509CRL)nextCrl).getIssuerName()) || (lastUpdate = x509Crl.getThisUpdate()).after(validationTime) || result.contains(x509Crl) || !this.checkCompliance(x509Crl)) continue;
                result.add((X509CRL)x509Crl.clone());
            }
        }
        catch (Exception e) {
            throw new CertStatusException("CRLCertStatus$Implementation.checkCertRevocation.", e);
        }
        return this.getBestCrls(result);
    }

    private boolean verifyIssuerAndScopeOnDeltaCrl() {
        return true;
    }

    private boolean verifyIssuerAndScope(CertPathCtx pathCtx, X509CRL crl, X509Certificate cert, CRLDistributionPoints distributionPoints, int index) throws NameException, CertStatusException {
        GeneralNames crlIssuer = distributionPoints.getCRLIssuer(index);
        IssuingDistributionPoint issuingDp = (IssuingDistributionPoint)this.getExtension(crl, 28);
        if (crlIssuer != null) {
            X500Name crlIssuerDn = this.findX500Name(crlIssuer);
            this.validateIssuerDn(crlIssuerDn);
            if (!NameMatcher.matchDirectoryNames(crl.getIssuerName(), crlIssuerDn)) {
                return false;
            }
            if (!(pathCtx.isFlagRaised(16384) || issuingDp != null && issuingDp.getIndirectCRL())) {
                return false;
            }
        } else if (!NameMatcher.matchDirectoryNames(crl.getIssuerName(), cert.getIssuerName())) {
            return false;
        }
        if (issuingDp == null || pathCtx.isFlagRaised(16384)) {
            return true;
        }
        if (!this.verifyIssuingDistributionPointName(crlIssuer, crl, cert, issuingDp, distributionPoints, index)) {
            return false;
        }
        BasicConstraints basicConstraints = (BasicConstraints)this.getExtension(cert, 19);
        if (issuingDp.getUserCerts() && basicConstraints != null && basicConstraints.getCA()) {
            return false;
        }
        if (issuingDp.getCACerts() && (basicConstraints == null || !basicConstraints.getCA())) {
            return false;
        }
        return !issuingDp.getAttributeCerts();
    }

    private boolean verifyIssuingDistributionPointName(GeneralNames crlIssuer, X509CRL crl, X509Certificate cert, IssuingDistributionPoint idp, CRLDistributionPoints distributionPoints, int index) throws NameException, CertStatusException {
        Object issuingDpNames = idp.getDistributionPointName();
        Object distributionPointNames = distributionPoints.getDistributionPointName(index);
        if (issuingDpNames == null) {
            return true;
        }
        if (distributionPointNames != null) {
            if (issuingDpNames instanceof RDN) {
                X500Name issuingDpDn = crl.getIssuerName();
                issuingDpDn.addRDN((RDN)issuingDpNames);
                if (distributionPointNames instanceof RDN) {
                    X500Name issuerDn;
                    if (crlIssuer != null) {
                        issuerDn = this.findX500Name(crlIssuer);
                        this.validateIssuerDn(issuerDn);
                    } else {
                        issuerDn = cert.getIssuerName();
                    }
                    issuerDn.addRDN((RDN)distributionPointNames);
                    if (!issuingDpDn.equals(issuerDn)) {
                        return false;
                    }
                } else {
                    GeneralNames dpGenNames = (GeneralNames)distributionPointNames;
                    GeneralName issuerDpGenName = new GeneralName();
                    issuerDpGenName.setGeneralName(issuingDpDn, 5);
                    if (!this.existsMatchingName(issuerDpGenName, dpGenNames)) {
                        return false;
                    }
                }
            } else {
                GeneralNames genDpNames;
                GeneralNames genIdpNames = (GeneralNames)issuingDpNames;
                if (distributionPointNames instanceof GeneralNames) {
                    genDpNames = (GeneralNames)distributionPointNames;
                } else {
                    X500Name dpDn;
                    if (crlIssuer != null) {
                        dpDn = this.findX500Name(crlIssuer);
                        this.validateIssuerDn(dpDn);
                    } else {
                        dpDn = cert.getIssuerName();
                    }
                    dpDn.addRDN((RDN)distributionPointNames);
                    genDpNames = this.convertDnToGeneralNames(dpDn);
                }
                if (!this.existsMatchingNamePair(genIdpNames, genDpNames)) {
                    return false;
                }
            }
        } else {
            GeneralNames genIdpNames;
            if (crlIssuer == null) {
                return false;
            }
            if (issuingDpNames instanceof RDN) {
                X500Name crlIssuerDn = crl.getIssuerName();
                crlIssuerDn.addRDN((RDN)issuingDpNames);
                genIdpNames = this.convertDnToGeneralNames(crlIssuerDn);
            } else {
                genIdpNames = (GeneralNames)issuingDpNames;
            }
            if (!this.existsMatchingNamePair(genIdpNames, crlIssuer)) {
                return false;
            }
        }
        return true;
    }

    private boolean existsMatchingName(GeneralName name, GeneralNames targetNames) throws NameException {
        if (name == null || targetNames == null) {
            return false;
        }
        for (int i = 0; i < targetNames.getNameCount(); ++i) {
            if (!name.equals(targetNames.getGeneralName(i))) continue;
            return true;
        }
        return false;
    }

    private boolean existsMatchingNamePair(GeneralNames sourceNames, GeneralNames targetNames) throws NameException {
        if (sourceNames == null) {
            return false;
        }
        for (int i = 0; i < sourceNames.getNameCount(); ++i) {
            GeneralName sourceName = sourceNames.getGeneralName(i);
            if (!this.existsMatchingName(sourceName, targetNames)) continue;
            return true;
        }
        return false;
    }

    private GeneralNames convertDnToGeneralNames(X500Name dn) throws NameException {
        GeneralNames result = new GeneralNames();
        GeneralName generalName = new GeneralName();
        generalName.setGeneralName(dn, 5);
        result.addGeneralName(generalName);
        return result;
    }

    private void validateIssuerDn(X500Name crlIssuerDn) throws CertStatusException {
        if (crlIssuerDn == null) {
            throw new CertStatusException("the cRLIssuer MUST contain at least one X.500 distinguished name.");
        }
    }

    private void updateLocalCrlCache() {
    }

    private Vector<X509CRL> getBestCrls(Vector<X509CRL> crls) {
        HashMap<IssuingDistributionPoint, X509CRL> scopeToBestCrlMap = new HashMap<IssuingDistributionPoint, X509CRL>();
        IssuingDistributionPoint defaultScope = new IssuingDistributionPoint();
        for (X509CRL crl : crls) {
            X509CRL bestCrl;
            IssuingDistributionPoint scope = (IssuingDistributionPoint)this.getExtension(crl, 28);
            if (scope == null) {
                scope = defaultScope;
            }
            if ((bestCrl = (X509CRL)scopeToBestCrlMap.get(scope)) != null && !crl.getThisUpdate().after(bestCrl.getThisUpdate())) continue;
            scopeToBestCrlMap.put(scope, crl);
        }
        return new Vector<X509CRL>(scopeToBestCrlMap.values());
    }

    private boolean verifyPath(CertPathCtx pathCtx, X509CRL crl, Vector<Certificate> certList, Vector<CRL> crlList, Vector<Certificate> crlCerts) throws CertStatusException {
        Vector crlCertList = (Vector)pathCtx.getAttribute(crl);
        if (crlCertList != null) {
            CertJUtils.mergeLists(crlCerts, crlCertList);
            return true;
        }
        pathCtx.setAttribute(crl, new Vector());
        Vector<Certificate> nextCertInPath = new Vector<Certificate>();
        try {
            this.certJ.getNextCertInPath(pathCtx, crl, nextCertInPath);
        }
        catch (Exception e) {
            pathCtx.removeAttribute(crl);
            throw new CertStatusException(e);
        }
        if (nextCertInPath.isEmpty()) {
            pathCtx.removeAttribute(crl);
            return false;
        }
        if (DEBUG_ON) {
            Debug.println("Validating certificate path for CRL issued by " + crl.getIssuerName().toString());
        }
        for (Certificate next : nextCertInPath) {
            CertPathResult result;
            X509Certificate nextInPath = (X509Certificate)next;
            try {
                result = this.certJ.buildCertPath(pathCtx, nextInPath, certList, crlList, crlCerts);
            }
            catch (Exception e) {
                pathCtx.removeAttribute(crl);
                throw new CertStatusException(e);
            }
            if (!result.getValidationResult() || !this.verifyCRLSignature(crl, nextInPath, result) || !this.verifyKeyUsage(pathCtx, nextInPath)) continue;
            pathCtx.setAttribute(crl, certList.clone());
            if (DEBUG_ON) {
                Debug.println("Certificate path validation for CRL issued by " + crl.getIssuerName().toString() + " passed.");
            }
            return true;
        }
        pathCtx.removeAttribute(crl);
        if (DEBUG_ON) {
            Debug.println("Certificate path validation for CRL issued by " + crl.getIssuerName().toString() + " failed.");
        }
        return false;
    }

    private boolean verifyCRLSignature(X509CRL crl, X509Certificate issuer, CertPathResult result) {
        try {
            String device = this.certJ.getDevice();
            JSAFE_PublicKey pubKey = result.getSubjectPublicKey(device);
            if (pubKey == null) {
                pubKey = issuer.getSubjectPublicKey(device);
            }
            return crl.verifyCRLSignature(device, pubKey, (SecureRandom)this.certJ.getRandomObject());
        }
        catch (NoServiceException e) {
            return false;
        }
        catch (RandomException e) {
            return false;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    private boolean verifyKeyUsage(CertPathCtx pathCtx, X509Certificate cert) {
        if (pathCtx.isFlagRaised(64)) {
            return true;
        }
        KeyUsage keyUsage = (KeyUsage)this.getExtension(cert, 15);
        return keyUsage == null || (keyUsage.getKeyUsage() & 0x2000000) != 0;
    }

    private X509V3Extension getExtension(X509V3Extensions extensions, int type) {
        X509V3Extension result = null;
        if (extensions != null) {
            try {
                result = extensions.getExtensionByType(type);
            }
            catch (CertificateException e) {
                // empty catch block
            }
        }
        return result;
    }

    private X509V3Extension getExtension(X509CRL crl, int type) {
        if (crl == null) {
            return null;
        }
        return this.getExtension(crl.getExtensions(), type);
    }

    private X509V3Extension getExtension(X509Certificate cert, int type) {
        if (cert == null) {
            return null;
        }
        return this.getExtension(cert.getExtensions(), type);
    }

    private boolean hasUnknownCriticalExtension(X509CRL crl) throws CertStatusException {
        X509V3Extensions extensions = crl.getExtensions();
        if (extensions == null) {
            return false;
        }
        try {
            for (int i = 0; i < extensions.getExtensionCount(); ++i) {
                X509V3Extension extension = extensions.getExtensionByIndex(i);
                int extensionType = extension.getExtensionType();
                if (extensionType == 28 || !extension.getCriticality()) continue;
                return true;
            }
        }
        catch (CertificateException e) {
            this.internalError(e);
        }
        return false;
    }

    private boolean findSerialNumberInCrl(X509Certificate cert, X509CRL crl, boolean indirectCRL) throws CertStatusException {
        RevokedCertificates entries = crl.getRevokedCertificates();
        byte[] serialNumber = cert.getSerialNumber();
        if (entries == null) {
            return false;
        }
        X500Name certIssuer = crl.getIssuerName();
        try {
            for (int i = 0; i < entries.getCertificateCount(); ++i) {
                CertificateIssuer certIssuerExt;
                if (indirectCRL && (certIssuerExt = (CertificateIssuer)this.getExtension(entries.getExtensions(i), 29)) != null) {
                    certIssuer = this.findX500Name(certIssuerExt.getGeneralNames());
                }
                if (!CertJUtils.byteArraysEqual(serialNumber, entries.getSerialNumber(i))) continue;
                if (indirectCRL) {
                    return cert.getIssuerName().equals(certIssuer);
                }
                return true;
            }
        }
        catch (CertificateException e) {
            this.internalError(e);
        }
        return false;
    }

    private boolean isCRLObsolete(CertPathCtx pathCtx, X509CRL crl, Date validationTime) {
        if (pathCtx.isFlagRaised(262144)) {
            return false;
        }
        Date nextUpdate = crl.getNextUpdate();
        return nextUpdate != null && validationTime.after(nextUpdate);
    }

    private final class RevocationStatus {
        static final int UNREVOKED = 100;
        int reasonsMask;
        int certStatus = 100;
        int interimReasonsMask;

        private RevocationStatus() {
        }

        boolean isAllReasons() {
            return this.reasonsMask == -8388608;
        }

        boolean isUnrevoked() {
            return this.certStatus == 100;
        }

        void setUnrevoked() {
            this.certStatus = 100;
        }
    }
}

