/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.revocation.ocsp.OCSPRevocationInfo;
import java.util.Date;

public final class OCSPEvidence {
    public static final int NONCE_IGNORED = 1;
    private int flags;
    private Date producedAt;
    private Date thisUpdate;
    private Date nextUpdate;
    private X509V3Extensions responseExtensions;
    private OCSPRevocationInfo revocationInfo;

    public OCSPEvidence(int flags, Date producedAtTime, Date thisUpdateTime, Date nextUpdateTime, X509V3Extensions responseExtensions, OCSPRevocationInfo revocationInfo) throws InvalidParameterException {
        if (producedAtTime == null) {
            throw new InvalidParameterException("producedAtTime == null");
        }
        if (thisUpdateTime == null) {
            throw new InvalidParameterException("thisUpdateTime == null");
        }
        this.flags = flags;
        this.producedAt = producedAtTime;
        this.thisUpdate = thisUpdateTime;
        this.nextUpdate = nextUpdateTime;
        this.responseExtensions = responseExtensions;
        this.revocationInfo = revocationInfo;
    }

    public String toString() {
        return "{flags=" + Integer.toHexString(this.flags) + ",producedAt=" + this.producedAt + ",thisUpdate=" + this.thisUpdate + ",nextUpdate=" + this.nextUpdate + ",responseExtensions=" + this.responseExtensions + ",revocationInfo=" + this.revocationInfo + "}";
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public Date getProducedAt() {
        return this.producedAt;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public X509V3Extensions getResponseExtensions() {
        return this.responseExtensions;
    }

    public OCSPRevocationInfo getRevocationInfo() {
        return this.revocationInfo;
    }
}

