/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;

public final class OCSPRequestControl
implements Cloneable {
    private X509Certificate requestSignerCert;
    private String digestAlg;
    private String signatureAlg;
    private X509Certificate[] extraCerts;
    private X509V3Extensions requestExtensions;

    public OCSPRequestControl(X509Certificate requestSignerCert, String digestAlg, String signatureAlg, X509Certificate[] extraCerts, X509V3Extensions requestExtensions) throws InvalidParameterException {
        try {
            if (requestSignerCert != null) {
                this.requestSignerCert = (X509Certificate)requestSignerCert.clone();
            }
            if (digestAlg != null) {
                this.digestAlg = digestAlg;
            }
            if (signatureAlg != null) {
                this.signatureAlg = signatureAlg;
            }
            if (extraCerts != null) {
                this.extraCerts = new X509Certificate[extraCerts.length];
                for (int i = 0; i < extraCerts.length; ++i) {
                    this.extraCerts[i] = (X509Certificate)extraCerts[i].clone();
                }
            }
            if (requestExtensions != null) {
                this.requestExtensions = (X509V3Extensions)requestExtensions.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public OCSPRequestControl(X509Certificate requestSignerCert) throws InvalidParameterException {
        try {
            if (requestSignerCert != null) {
                this.requestSignerCert = (X509Certificate)requestSignerCert.clone();
                this.digestAlg = "SHA1";
                this.signatureAlg = "SHA1/RSA/PKCS1Block01Pad";
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OCSPRequestControl(this.requestSignerCert, this.digestAlg, this.signatureAlg, this.extraCerts, this.requestExtensions);
        }
        catch (InvalidParameterException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    public void setDigestAlgorithm(String digestAlg) throws InvalidParameterException {
        this.digestAlg = digestAlg == null ? null : digestAlg;
    }

    public void setSignatureAlgorithm(String signatureAlg) throws InvalidParameterException {
        this.signatureAlg = signatureAlg == null ? null : signatureAlg;
    }

    public void setExtraCerts(X509Certificate[] extraCerts) throws InvalidParameterException {
        try {
            if (extraCerts == null) {
                this.extraCerts = null;
            } else {
                this.extraCerts = new X509Certificate[extraCerts.length];
                for (int i = 0; i < extraCerts.length; ++i) {
                    this.extraCerts[i] = (X509Certificate)extraCerts[i].clone();
                }
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public void setSignerCert(X509Certificate cert) throws InvalidParameterException {
        try {
            if (cert != null) {
                this.requestSignerCert = (X509Certificate)cert.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public void setRequestExtensions(X509V3Extensions requestExtensions) throws InvalidParameterException {
        try {
            this.requestExtensions = requestExtensions == null ? null : (X509V3Extensions)requestExtensions.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InvalidParameterException(ex);
        }
    }

    public String getDigestAlgorithm() {
        return this.digestAlg;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlg;
    }

    public X509Certificate getSignerCert() {
        return this.requestSignerCert;
    }

    public X509Certificate[] getExtraCerts() {
        return this.extraCerts;
    }

    public X509V3Extensions getRequestExtensions() {
        return this.requestExtensions;
    }
}

