/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequestControl;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponder;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public class OCSPResponderInternal
extends OCSPResponder {
    private static final int NO_SPECIAL = 0;
    private byte[] taggedSignerNameDER;

    protected OCSPResponderInternal(CertJ certJ, OCSPResponder r) throws InvalidParameterException, NameException, CertificateException {
        super(r.getProfile(), r.getFlags(), r.getDestList(), r.getProxyList(), r.getRequestControl(), r.getResponderCert(), r.getResponderCACerts(), r.getDatabase(), r.getTimeTolerance());
        X509Certificate signerCert = null;
        OCSPRequestControl control = r.getRequestControl();
        if (control != null) {
            signerCert = control.getSignerCert();
        }
        if (signerCert != null) {
            byte[][] keyDERs;
            X500Name signerName = signerCert.getSubjectName();
            this.taggedSignerNameDER = new byte[signerName.getDERLen(0)];
            signerName.getDEREncoding(this.taggedSignerNameDER, 0, 0);
            String device = certJ.getDevice();
            JSAFE_PublicKey key = signerCert.getSubjectPublicKey(device);
            try {
                keyDERs = key.getKeyData("RSAPublicKeyBER");
            }
            catch (JSAFE_UnimplementedException ex) {
                try {
                    keyDERs = key.getKeyData("DSAPublicKeyBER");
                }
                catch (JSAFE_UnimplementedException e) {
                    throw new CertificateException("Cannot get key BER");
                }
            }
            if (keyDERs.length != 1) {
                throw new CertificateException("#keys>1");
            }
        }
    }

    protected String getSignatureAlgorithm() {
        return super.getRequestControl().getSignatureAlgorithm();
    }
}

