/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSPutil {
    private OCSPutil() {
    }

    public static String getAIALocation(X509Certificate cert) {
        X509V3Extensions extns = cert.getExtensions();
        if (extns == null) {
            return null;
        }
        try {
            AuthorityInfoAccess aia = (AuthorityInfoAccess)extns.getExtensionByType(100);
            if (aia == null) {
                return null;
            }
            for (int i = 0; i < aia.getAccessDescriptionCount(); ++i) {
                GeneralName gn;
                byte[] am = aia.getAccessMethod(i);
                if (!CertJUtils.byteArraysEqual(am, AuthorityInfoAccess.ID_AD_OCSP) || (gn = aia.getAccessLocation(i)).getGeneralNameType() != 7) continue;
                return (String)gn.getGeneralName();
            }
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return null;
    }

    public static byte[] makeDataDigest(CertJ certJ, String digestAlg, byte[] data, int offset, int len) throws InvalidParameterException {
        byte[] returnDER = null;
        try {
            JSAFE_MessageDigest digestObj = JSAFEFactory.getDigest(digestAlg, certJ.getDevice(), certJ);
            returnDER = new byte[digestObj.getDigestSize()];
            digestObj.digestInit();
            digestObj.digestUpdate(data, offset, len);
            digestObj.digestFinal(returnDER, 0);
        }
        catch (Exception ex) {
            throw new InvalidParameterException("makeDataDigest:" + ex.toString());
        }
        return returnDER;
    }

    public static byte[] extractKeyDER(byte[] ber, int offset) throws ASN_Exception {
        EndContainer anEnd = new EndContainer();
        SequenceContainer seq = new SequenceContainer(0);
        EncodedContainer alg = new EncodedContainer(65280);
        BitStringContainer keybits = new BitStringContainer(0);
        ASN1Container[] def = new ASN1Container[]{seq, alg, keybits, anEnd};
        ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        byte[] ret = new byte[keybits.dataLen];
        System.arraycopy(keybits.data, keybits.dataOffset, ret, 0, keybits.dataLen);
        return ret;
    }

    public static int selectCertificateByKeyHash(CertJ certJ, DatabaseService db, byte[] hash, int hashOffset, int hashLen, Vector<Certificate> certs) throws DatabaseException, NoServiceException, CertificateException, InvalidParameterException {
        int found = 0;
        boolean first = true;
        while (db.hasMoreCertificates()) {
            Certificate cert;
            if (first) {
                cert = db.firstCertificate();
                first = false;
            } else {
                cert = db.nextCertificate();
            }
            try {
                byte[] keyDER = OCSPutil.extractKeyDER(cert.getSubjectPublicKeyBER(), 0);
                byte[] thisHash = OCSPutil.makeDataDigest(certJ, "SHA1", keyDER, 0, keyDER.length);
                if (!CertJUtils.byteArraysEqual(thisHash, 0, thisHash.length, hash, hashOffset, hashLen)) continue;
                certs.addElement(cert);
                ++found;
            }
            catch (Exception e) {}
        }
        return found;
    }
}

