/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.path;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class CertPathCtx {
    public static final int PF_NONE = 0;
    public static final int PF_IGNORE_SIGNATURE = 1;
    public static final int PF_IGNORE_VALIDATION_TIME = 2;
    public static final int PF_IGNORE_REVOCATION = 4;
    public static final int PF_IGNORE_NAME_CHAINING = 8;
    public static final int PF_IGNORE_NAME_CONSTRAINTS = 16;
    public static final int PF_IGNORE_BASIC_CONSTRAINTS = 32;
    public static final int PF_IGNORE_KEY_USAGE = 64;
    public static final int PF_IGNORE_CRITICALITY = 128;
    public static final int PF_IGNORE_UID_CHAINING = 256;
    public static final int PF_IGNORE_KEY_ID_CHAINING = 512;
    public static final int PF_IGNORE_CRL_DP = 1024;
    public static final int PF_IGNORE_AIA = 2048;
    public static final int PF_IGNORE_CRL_NUMBER = 4096;
    public static final int PF_IGNORE_DELTA_CRL = 8192;
    public static final int PF_IGNORE_CRL_IDP = 16384;
    public static final int PF_INITIAL_EXPLICIT_POLICY = 32768;
    public static final int PF_INITIAL_POLICY_MAPPING_INHIBIT = 65536;
    public static final int PF_INITIAL_ANY_POLICY_INHIBIT = 131072;
    public static final int PF_IGNORE_OBSOLETE_CRL = 262144;
    private int pathOptions;
    private Certificate[] trustedCerts;
    private byte[][] policies;
    private Date validationTime;
    private DatabaseService database;
    private Map<Object, Object> attributes = new HashMap<Object, Object>();

    public CertPathCtx(int pathOptions, Certificate[] trustedCerts, byte[][] policies, Date validationTime, DatabaseService database) {
        this.pathOptions = pathOptions;
        this.trustedCerts = trustedCerts;
        this.validationTime = validationTime;
        this.database = database;
        this.policies = policies == null ? (Object)new byte[][]{X509V3Extension.ANY_POLICY_OID} : policies;
    }

    public int getPathOptions() {
        return this.pathOptions;
    }

    public Certificate[] getTrustedCerts() {
        if (this.trustedCerts == null) {
            return null;
        }
        return (Certificate[])this.trustedCerts.clone();
    }

    public byte[][] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        return (byte[][])this.policies.clone();
    }

    public Date getValidationTime() {
        return this.validationTime;
    }

    public DatabaseService getDatabase() {
        return this.database;
    }

    public boolean isFlagRaised(int flag) {
        return (flag & this.getPathOptions()) != 0;
    }

    public void setAttribute(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }
}

