/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.path;

import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.spi.path.CertPathException;
import java.util.Arrays;

public final class PolicyInformation {
    private byte[] policyIdentifier;
    private PolicyQualifiers policyQualifiers;

    public PolicyInformation(byte[] id, PolicyQualifiers qualifiers) throws CertPathException {
        this.policyIdentifier = id;
        try {
            if (qualifiers != null) {
                this.policyQualifiers = (PolicyQualifiers)qualifiers.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertPathException("Error in clone qualifiers.");
        }
    }

    public byte[] getCertPolicyID() {
        if (this.policyIdentifier == null) {
            return null;
        }
        byte[] result = new byte[this.policyIdentifier.length];
        System.arraycopy(this.policyIdentifier, 0, result, 0, this.policyIdentifier.length);
        return result;
    }

    public PolicyQualifiers getPolicyQualifiers() throws CertPathException {
        try {
            if (this.policyQualifiers == null) {
                return null;
            }
            return (PolicyQualifiers)this.policyQualifiers.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertPathException("Error in clone qualifiers.");
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation policyInfo = (PolicyInformation)object;
        if (!CertJUtils.byteArraysEqual(policyInfo.policyIdentifier, this.policyIdentifier)) {
            return false;
        }
        if (this.policyQualifiers == null) {
            return policyInfo.policyQualifiers == null;
        }
        return this.policyQualifiers.equals(policyInfo.policyQualifiers);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.policyIdentifier);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.policyQualifiers);
        return result;
    }
}

