/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.pki;

import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.core.config.CertJConfiguration;
import com.rsa.certj.internal.CertificateUtil;
import com.rsa.certj.spi.pki.PKIMessage;
import java.util.Properties;

public class PKIRequestMessage
extends PKIMessage {
    public static final int PKI_POP_RA_VERIFIED = 0;
    public static final int PKI_POP_SIGNATURE = 1;
    public static final int PKI_POP_ENCRYPTION = 2;
    public static final int PKI_POP_KEY_AGREE = 3;
    private Certificate certificateTemplate;
    private int popType = -1;
    private Properties regInfo;

    public PKIRequestMessage(Certificate certificateTemplate, Properties regInfo, boolean autoGenerateSerialNumbers) {
        this.initialize(certificateTemplate, regInfo, autoGenerateSerialNumbers);
    }

    public PKIRequestMessage(Certificate certificateTemplate, Properties regInfo) {
        this.initialize(certificateTemplate, regInfo, CertJConfiguration.isAutoGenSerialNumEnabled());
    }

    private void initialize(Certificate certificateTemplate, Properties regInfo, boolean autoGenerateSerialNumbers) {
        this.certificateTemplate = certificateTemplate;
        this.regInfo = regInfo;
        if (autoGenerateSerialNumbers && certificateTemplate != null) {
            this.autoGenerateSerialNumber(this.certificateTemplate);
        }
    }

    public int getPopType() {
        return this.popType;
    }

    public void setPopType(int popType) {
        this.popType = popType;
    }

    public Certificate getCertificateTemplate() {
        return this.certificateTemplate;
    }

    public Properties getRegInfo() {
        return this.regInfo;
    }

    private void autoGenerateSerialNumber(Certificate cert) {
        X500Name subj = ((X509Certificate)cert).getSubjectName();
        CertificateUtil.checkSerialNumber(subj);
        try {
            ((X509Certificate)cert).setSubjectName(subj);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

