/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.spi.pki;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.spi.pki.PKIException;

public class PKIStatusInfo {
    public static final int PKI_STATUS_GRANTED = 0;
    public static final int PKI_STATUS_GRANTED_MODS = 1;
    public static final int PKI_STATUS_REJECTED = 2;
    public static final int PKI_STATUS_WAITING = 3;
    public static final int PKI_STATUS_WARNING_REVOCATION = 4;
    public static final int PKI_REVOCATION = 5;
    public static final int PKI_STATUS_REVOCATION = 5;
    public static final int PKI_STATUS_WARNING_KEY_UPDATE = 6;
    public static final int PKI_FAIL_BAD_ALG = Integer.MIN_VALUE;
    public static final int PKI_FAIL_BAD_MESSAGE_CHECK = 0x40000000;
    public static final int PKI_FAIL_BAD_REQUEST = 0x20000000;
    public static final int PKI_FAIL_BAD_TIME = 0x10000000;
    public static final int PKI_FAIL_BAD_CERT_ID = 0x8000000;
    public static final int PKI_FAIL_BAD_DATA_FORMAT = 0x4000000;
    public static final int PKI_FAIL_WRONG_AUTHORITY = 0x2000000;
    public static final int PKI_FAIL_INCORRECT_DATA = 0x1000000;
    public static final int PKI_FAIL_MISSING_TIMESTAMP = 0x800000;
    public static final int PKI_FAIL_BAD_POP = 0x400000;
    public static final int PKI_FAIL_SERVER_ERROR = 0x200000;
    public static final int PKI_FAIL_REMOTE_SERVER_ERROR = 0x100000;
    public static final int PKI_FAIL_CERT_REVOKED = 524288;
    public static final int PKI_FAIL_CERT_CONFIRMED = 262144;
    public static final int PKI_FAIL_WRONG_INTEGRITY = 131072;
    public static final int PKI_FAIL_BAD_RECIPIENT_NONCE = 65536;
    public static final int PKI_FAIL_TIME_NOT_AVALIABLE = 32768;
    public static final int PKI_FAIL_UNACCEPTED_POLICY = 16384;
    public static final int PKI_FAIL_UNACCEPTED_EXTENSION = 8192;
    public static final int PKI_FAIL_ADD_INFO_NOT_AVAILABLE = 4096;
    public static final int PKI_FAIL_BAD_SENDER_NONCE = 2048;
    public static final int PKI_FAIL_BAD_CERT_TEMPLATE = 1024;
    public static final int PKI_FAIL_SIGNER_NOT_TRUSTED = 512;
    public static final int PKI_FAIL_TRANSACTION_ID_IN_USE = 256;
    public static final int PKI_FAIL_UNSUPPORTED_VERSION = 128;
    private int status;
    private int failInfo;
    private String[] statusStrings;
    private int failInfoAux;
    private ASN1Template asn1Template;

    public PKIStatusInfo(byte[] ber, int offset, int special) throws PKIException {
        BitStringContainer failInfoContainer;
        OfContainer statusStringContainer;
        IntegerContainer statusContainer;
        try {
            SequenceContainer sequence = new SequenceContainer(special);
            statusContainer = new IntegerContainer(0);
            statusStringContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(3072));
            failInfoContainer = new BitStringContainer(65536);
            EndContainer end = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{sequence, statusContainer, statusStringContainer, failInfoContainer, end};
            ASN1.berDecode((byte[])ber, (int)offset, (ASN1Container[])def);
        }
        catch (ASN_Exception e) {
            throw new PKIException("PKIStatusInfo.PKIStatusInfo: decoding PKIStatusInfo failed.", (Exception)((Object)e));
        }
        try {
            this.status = statusContainer.getValueAsInt();
        }
        catch (ASN_Exception e) {
            throw new PKIException("CertResponse.CertResponse: unable to get PKIStatusInfo.status as int.", (Exception)((Object)e));
        }
        if (statusStringContainer.dataPresent) {
            int count = statusStringContainer.getContainerCount();
            this.statusStrings = new String[count];
            for (int i = 0; i < count; ++i) {
                try {
                    ASN1Container encodedContainer = statusStringContainer.containerAt(i);
                    UTF8StringContainer utf8Container = new UTF8StringContainer(0);
                    ASN1Container[] utf8Def = new ASN1Container[]{utf8Container};
                    ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])utf8Def);
                    if (utf8Container.dataPresent && utf8Container.dataLen != 0) {
                        this.statusStrings[i] = new String(utf8Container.data, utf8Container.dataOffset, utf8Container.dataLen);
                        continue;
                    }
                    this.statusStrings[i] = null;
                    continue;
                }
                catch (ASN_Exception e) {
                    throw new PKIException("PKIStatusInfo.PKIStatusInfo: unable to extract and decode a component of statuString.", (Exception)((Object)e));
                }
            }
        }
        if (failInfoContainer.dataPresent) {
            this.failInfo = this.bitStringToInt(failInfoContainer);
        }
    }

    public PKIStatusInfo(int status, int failInfo, String[] statusStrings, int failInfoAux) {
        this.status = status;
        this.failInfo = failInfo;
        this.statusStrings = statusStrings;
        this.failInfoAux = failInfoAux;
    }

    public int getStatus() {
        return this.status;
    }

    public int getFailInfo() {
        return this.failInfo;
    }

    public String[] getStatusStrings() {
        if (this.statusStrings == null) {
            return null;
        }
        return (String[])this.statusStrings.clone();
    }

    public int getFailInfoAux() {
        return this.failInfoAux;
    }

    public int getDERLen(int special) throws PKIException {
        try {
            OfContainer statusStringContainer;
            SequenceContainer sequence = new SequenceContainer(special, true, 0);
            IntegerContainer statusContainer = new IntegerContainer(0, true, 0, this.status);
            if (this.statusStrings == null) {
                statusStringContainer = new OfContainer(65536, false, 0, 12288, null);
            } else {
                statusStringContainer = new OfContainer(65536, true, 0, 12288, (ASN1Container)new UTF8StringContainer(0));
                for (int i = 0; i < this.statusStrings.length; ++i) {
                    byte[] bytes = this.statusStrings[i].getBytes();
                    try {
                        statusStringContainer.addContainer((ASN1Container)new UTF8StringContainer(0, true, 0, bytes, 0, bytes.length));
                        continue;
                    }
                    catch (ASN_Exception e) {
                        throw new PKIException("PKIStatusInfo.getDERLen: failed to add an element of statusString.", (Exception)((Object)e));
                    }
                }
            }
            BitStringContainer failInfoContainer = this.failInfo == 0 ? new BitStringContainer(65536, false, 0, 0, 0, false) : new BitStringContainer(65536, true, 0, this.failInfo, 32, false);
            EndContainer end = new EndContainer();
            ASN1Container[] def = new ASN1Container[]{sequence, statusContainer, statusStringContainer, failInfoContainer, end};
            this.asn1Template = new ASN1Template(def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception e) {
            this.asn1Template = null;
            throw new PKIException("PKIStatusInfo.getDERLen: failed to encode PKIStatusInfo.", (Exception)((Object)e));
        }
    }

    public int getDEREncoding(byte[] der, int offset, int special) throws PKIException {
        if (der == null) {
            throw new PKIException("PKIStatus.getDEREncoding: der should not be null.");
        }
        if (offset < 0) {
            throw new PKIException("PKIStatus.getDEREncoding: offset should not be a negative number.");
        }
        if (this.asn1Template == null && der.length - offset < this.getDERLen(special)) {
            throw new PKIException("PKIStatus.getDEREncoding: der is too small to hold the DER-encoding. Use getDERLen to find out how big it should be.");
        }
        try {
            int n = this.asn1Template.derEncode(der, offset);
            return n;
        }
        catch (ASN_Exception e) {
            throw new PKIException("PKIStatus.getDEREncoding: unable to encode PKIStatusInfo.", (Exception)((Object)e));
        }
        finally {
            this.asn1Template = null;
        }
    }

    private int bitStringToInt(BitStringContainer container) {
        int i;
        int value = 0;
        for (i = 0; i < container.dataLen; ++i) {
            value = (value << 8) + container.data[container.dataOffset + i];
        }
        for (i = 0; i < 4 - container.dataLen; ++i) {
            value <<= 8;
        }
        return value;
    }
}

