/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;

public class X500Name
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected int special;
    protected ASN1Template asn1Template = null;
    private Vector b = new Vector();
    private static final char[] c = new char[]{',', '=', '+', '<', '>', '#', ';', '\"', '\\'};

    public X500Name(byte[] byArray, int n, int n2) throws NameException, RuntimeException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n2, 12288, (ASN1Container)new EncodedContainer(12544));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                RDN rDN = new RDN(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(rDN);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the name." + aSN_Exception.getMessage());
        }
    }

    public X500Name() throws RuntimeException {
    }

    public X500Name(String string) throws NameException, RuntimeException {
        int n;
        Object object;
        if (string == null) {
            throw new NameException("The string is null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\,;", true);
        int n2 = stringTokenizer.countTokens();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        String string2 = new String();
        for (int i = 0; i < n2; ++i) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("\\")) {
                stringBuffer.append(string2);
                stringBuffer.append(stringTokenizer.nextToken());
                ++i;
                continue;
            }
            if (!string2.equals(",") && !string2.equals(";")) {
                stringBuffer.append(string2);
                continue;
            }
            object = stringTokenizer.nextToken();
            ++i;
            if (((String)object).indexOf("=") == -1) {
                stringBuffer.append(",");
                stringBuffer.append((String)object);
                continue;
            }
            n = 0;
            while (((String)object).substring(n).startsWith(" ")) {
                ++n;
            }
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer((String)object);
        }
        if (stringBuffer.length() != 0) {
            vector.addElement(stringBuffer.toString());
        }
        RDN rDN = new RDN();
        object = null;
        for (n = vector.size() - 1; n >= 0; --n) {
            CharSequence charSequence;
            int n3;
            string2 = (String)vector.elementAt(n);
            stringTokenizer = new StringTokenizer(string2, "\\+", true);
            int n4 = stringTokenizer.countTokens();
            Vector<String> vector2 = new Vector<String>();
            StringBuffer stringBuffer2 = new StringBuffer();
            for (n3 = 0; n3 < n4; ++n3) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("\\")) {
                    charSequence = new StringBuffer(stringTokenizer.nextToken());
                    this.a((StringBuffer)charSequence);
                    stringBuffer2.append(((StringBuffer)charSequence).toString());
                    ++n3;
                    continue;
                }
                stringBuffer2.append(this.a());
                if (!string3.equals("+")) {
                    stringBuffer2.append(string3);
                    continue;
                }
                vector2.addElement(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer2.append(this.a());
            if (stringBuffer2.length() != 0) {
                vector2.addElement(stringBuffer2.toString());
            }
            rDN = new RDN();
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                int n5;
                charSequence = (String)vector2.elementAt(n3);
                int n6 = ((String)charSequence).indexOf(61);
                if (n6 == -1) {
                    throw new NameException("AVA representation is invalid, should be 'type=value'");
                }
                for (int i = n5 = 0; i < n6; ++i) {
                    if (((String)charSequence).substring(i, i + 1).equals(" ")) continue;
                    n5 = i;
                    break;
                }
                String string4 = ((String)charSequence).substring(n5, n6);
                n5 = n6 + 1;
                int n7 = AttributeValueAssertion.findAttributeType(string4);
                if (n7 == -1) {
                    byte[] byArray = this.b(string4);
                    byte[] byArray2 = this.a(((String)charSequence).substring(n5));
                    object = new AttributeValueAssertion(byArray, byArray2);
                } else {
                    object = new AttributeValueAssertion(n7, AttributeValueAssertion.getAttributeOID(n7), 0, ((String)charSequence).substring(n5));
                }
                rDN.addNameAVA((AttributeValueAssertion)object);
            }
            this.a.addElement(rDN);
        }
    }

    private void a(StringBuffer stringBuffer) throws NameException {
        if (X500Name.b(stringBuffer)) {
            return;
        }
        byte by = X500Name.c(stringBuffer);
        this.b.addElement(new Byte(by));
        if (stringBuffer.length() > 2) {
            stringBuffer.reverse();
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.reverse();
            stringBuffer.insert(0, this.a());
            return;
        }
        stringBuffer.setLength(0);
    }

    private String a() {
        int n = this.b.size();
        if (n == 0) {
            return new String();
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (Byte)this.b.elementAt(i);
        }
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.b.removeAllElements();
        return string;
    }

    private static boolean b(StringBuffer stringBuffer) {
        int n;
        char c = Character.toUpperCase(stringBuffer.charAt(0));
        for (n = 0; n < X500Name.c.length && c != X500Name.c[n]; ++n) {
        }
        return n != X500Name.c.length;
    }

    private static byte c(StringBuffer stringBuffer) throws NameException {
        if (stringBuffer.length() < 2) {
            throw new NameException("Invalid UTF-8 escape sequence: Two characters per hex byte required");
        }
        try {
            String string = stringBuffer.toString().substring(0, 2);
            int n = Integer.parseInt(string, 16);
            return (byte)(n & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NameException("Invalid UTF-8 escape sequence: Escaped hex byte invalid");
        }
    }

    private byte[] a(String string) throws NameException {
        String string2 = string.startsWith("#") ? string.substring(1) : string;
        int n = string2.length();
        byte[] byArray = null;
        byArray = n % 2 == 0 ? new byte[n / 2] : new byte[n / 2 + 1];
        int n2 = byArray.length - 1;
        int n3 = n;
        while (n2 >= 0) {
            byArray[n2] = n3 == 1 ? (byte)Integer.parseInt(string2.substring(n3 - 1, n3), 16) : (n3 == n ? (byte)Integer.parseInt(string2.substring(n3 - 2), 16) : (byte)Integer.parseInt(string2.substring(n3 - 2, n3), 16));
            --n2;
            n3 -= 2;
        }
        return byArray;
    }

    private byte[] b(String string) throws NameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n < 2) {
            throw new NameException("Invalid OID: should be the dotted-decimal encoding with at least 2 components.");
        }
        Integer[] integerArray = new Integer[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                integerArray[i] = new Integer(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NameException("Cannot convert String to int. " + numberFormatException.getMessage());
        }
        byte[] byArray = new byte[]{(byte)(integerArray[0] * 40 + integerArray[1])};
        for (int i = 2; i < n; ++i) {
            byte[] byArray2 = new byte[5];
            int n2 = 4;
            for (int j = integerArray[i].intValue(); j != 0; j >>>= 7) {
                byArray2[n2] = (byte)(j & 0x7F);
                int n3 = n2--;
                byArray2[n3] = (byte)(byArray2[n3] | 0x80);
            }
            byArray2[4] = (byte)(byArray2[4] & 0x7F);
            byte[] byArray3 = new byte[5 - (n2 + 1)];
            System.arraycopy(byArray2, n2 + 1, byArray3, 0, byArray3.length);
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = new byte[byArray.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        }
        return byArray;
    }

    public Object clone() throws CloneNotSupportedException {
        X500Name x500Name = new X500Name();
        for (int i = 0; i < this.a.size(); ++i) {
            RDN rDN = (RDN)this.a.elementAt(i);
            x500Name.a.addElement(rDN.clone());
        }
        x500Name.special = this.special;
        if (this.asn1Template != null) {
            x500Name.b();
        }
        return x500Name;
    }

    private String a(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.size() == 0) {
            return "";
        }
        if (bl) {
            for (int i = this.a.size() - 1; i >= 1; --i) {
                RDN rDN = (RDN)this.a.elementAt(i);
                stringBuffer.append(rDN.toString(bl2));
                stringBuffer.append(",");
            }
            RDN rDN = (RDN)this.a.elementAt(0);
            stringBuffer.append(rDN.toString(bl2));
        } else {
            for (int i = 0; i < this.a.size() - 1; ++i) {
                RDN rDN = (RDN)this.a.elementAt(i);
                stringBuffer.append(rDN.toString(bl2));
                stringBuffer.append(",");
            }
            RDN rDN = (RDN)this.a.elementAt(this.a.size() - 1);
            stringBuffer.append(rDN.toString(bl2));
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        return this.a(bl, false);
    }

    public String toString() {
        return this.a(true, true);
    }

    public String toStringRFC2253() {
        return this.a(true, false);
    }

    public int getRDNCount() {
        return this.a.size();
    }

    public int getAttributeCount() {
        int n = 0;
        for (int i = 0; i < this.a.size(); ++i) {
            n += ((RDN)this.a.elementAt(i)).getAttributeCount();
        }
        return n;
    }

    public RDN getRDN(int n) throws NameException {
        int n2 = this.a.size();
        if (n >= 0 && n2 > n) {
            return (RDN)this.a.elementAt(n);
        }
        throw new NameException("Invalid Index.");
    }

    public void removeRDN(int n) throws NameException {
        if (n >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.removeElementAt(n);
    }

    public void addRDN(RDN rDN, int n) throws NameException {
        if (rDN == null) {
            throw new NameException("Specified RDN is null.");
        }
        if (n >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(rDN, n);
    }

    public AttributeValueAssertion getAttribute(int n) {
        int n2 = this.a.size();
        for (int i = 0; i < n2; ++i) {
            RDN rDN = (RDN)this.a.elementAt(i);
            AttributeValueAssertion attributeValueAssertion = rDN.getAttribute(n);
            if (attributeValueAssertion == null) continue;
            return attributeValueAssertion;
        }
        return null;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER" + aSN_Exception.getMessage());
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.b();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
                if (this.asn1Template == null) {
                    throw new NameException("Unable to encode X500Name.");
                }
            }
            int n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode X500Name." + aSN_Exception.getMessage());
        }
    }

    private int b() {
        try {
            OfContainer ofContainer;
            int n = this.a.size();
            if (n == 0) {
                ofContainer = new OfContainer(this.special, false, 0, 12288, (ASN1Container)new EncodedContainer(12544));
            } else {
                ofContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12544));
                for (int i = 0; i < n; ++i) {
                    RDN rDN = (RDN)this.a.elementAt(i);
                    byte[] byArray = new byte[rDN.getDERLen(0)];
                    int n2 = rDN.getDEREncoding(byArray, 0, 0);
                    EncodedContainer encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n2);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public void addRDN(RDN rDN) throws NameException {
        if (rDN == null) {
            throw new NameException("Specified RDN is null.");
        }
        this.a.addElement(rDN);
    }

    public void addRDN(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        RDN rDN = new RDN(byArray, n, 0);
        this.a.addElement(rDN);
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof X500Name)) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        int n2 = this.getRDNCount();
        if (n2 != (n = x500Name.getRDNCount())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (((RDN)this.a.elementAt(i)).equals((RDN)x500Name.a.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(X500Name x500Name) {
        if (x500Name == null) {
            return false;
        }
        int n = this.getRDNCount();
        int n2 = x500Name.getRDNCount();
        for (int i = 0; i < n2; ++i) {
            int n3;
            RDN rDN = (RDN)x500Name.a.elementAt(i);
            for (n3 = 0; n3 < n && !rDN.equals((RDN)this.a.elementAt(n3)); ++n3) {
            }
            if (n3 >= n) {
                return false;
            }
            if (rDN.equals((RDN)this.a.elementAt(n3))) continue;
            return false;
        }
        return true;
    }
}

