/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.PKCS10CertRequest;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Vector;

public class X509Certificate
extends Certificate
implements Cloneable,
Serializable {
    public static final int X509_VERSION_1 = 0;
    public static final int X509_VERSION_2 = 1;
    public static final int X509_VERSION_3 = 2;
    private byte[] a;
    private int b;
    private int c = 2;
    private X500Name d;
    private X500Name e;
    private byte[] f;
    private byte[] g;
    private byte[] h;
    private boolean i = false;
    private Date j;
    private Date k;
    private X509V3Extensions l;
    protected int special;
    private ASN1Template m;
    protected int innerSpecial;
    private ASN1Template n;
    private ASN1Template o;

    public X509Certificate() {
    }

    public X509Certificate(CertJ certJ) {
        this.setCertJ(certJ);
    }

    public X509Certificate(byte[] byArray, int n, int n2) throws CertificateException {
        this(byArray, n, n2, null);
    }

    public X509Certificate(byte[] byArray, int n, int n2, CertJ certJ) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a(byArray, n, n2);
        this.setCertJ(certJ);
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    private void a(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearComponents();
        ASN1Container[] aSN1ContainerArray = X509Certificate.decodeCert(byArray, n, n2);
        this.setInnerDER(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset);
        this.signature = new byte[aSN1ContainerArray[3].dataLen];
        System.arraycopy(aSN1ContainerArray[3].data, aSN1ContainerArray[3].dataOffset, this.signature, 0, aSN1ContainerArray[3].dataLen);
        if (!this.b(aSN1ContainerArray[2].data, aSN1ContainerArray[2].dataOffset, aSN1ContainerArray[2].dataLen)) {
            throw new CertificateException("Unknown or invalid signature algorithm.");
        }
    }

    protected static ASN1Container[] decodeCert(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(n2);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(768);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the cert." + aSN_Exception.getMessage());
        }
        return aSN1ContainerArray;
    }

    public int getDERLen(int n) {
        return this.a(n);
    }

    private int a(int n) {
        this.special = n;
        if (this.a == null) {
            this.b = this.getInnerDERLen();
        }
        if (this.b == 0) {
            return 0;
        }
        if (this.signatureAlgorithmBER == null || this.signature == null) {
            return 0;
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, null, 0, this.b);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer encodedContainer3 = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, encodedContainer2, encodedContainer3, endContainer};
            this.m = new ASN1Template(aSN1ContainerArray);
            return this.m.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CertificateException {
        int n3;
        if (byArray == null) {
            throw new CertificateException("Specified array is null.");
        }
        int n4 = 0;
        try {
            if ((this.m == null || n2 != this.special) && (n3 = this.a(n2)) == 0) {
                throw new CertificateException("Could not encode: Possibly some of the required fields of this certificate object are not set.");
            }
            n4 += this.m.derEncode(byArray, n);
            this.m = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.m = null;
            throw new CertificateException("Could not encode: " + aSN_Exception.getMessage());
        }
        if (this.a != null && this.b != 0) {
            System.arraycopy(this.a, 0, byArray, n + n4, this.b);
            n4 += this.b;
        } else {
            n3 = this.getInnerDER(byArray, n + n4);
            if (n3 == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            n4 += n3;
        }
        System.arraycopy(this.signatureAlgorithmBER, 0, byArray, n + n4, this.signatureAlgorithmBER.length);
        System.arraycopy(this.signature, 0, byArray, n + (n4 += this.signatureAlgorithmBER.length), this.signature.length);
        return n4 + this.signature.length;
    }

    public void setInnerDER(byte[] byArray, int n) throws CertificateException {
        Cloneable cloneable;
        this.clearSignature();
        this.clearTemplate();
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(this.special);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0xA20000);
        IntegerContainer integerContainer2 = new IntegerContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        EncodedContainer encodedContainer4 = new EncodedContainer(12288);
        EncodedContainer encodedContainer5 = new EncodedContainer(12288);
        EncodedContainer encodedContainer6 = new EncodedContainer(8454913);
        EncodedContainer encodedContainer7 = new EncodedContainer(8454914);
        EncodedContainer encodedContainer8 = new EncodedContainer(10563587);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, encodedContainer, encodedContainer2, encodedContainer3, encodedContainer4, encodedContainer5, encodedContainer6, encodedContainer7, encodedContainer8, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not BER decode the cert info." + aSN_Exception.getMessage());
        }
        if (integerContainer.dataPresent) {
            this.checkVersionNumber(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
        }
        this.setSerialNumber(integerContainer2.data, integerContainer2.dataOffset, integerContainer2.dataLen);
        if (!this.b(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen)) {
            throw new CertificateException("Unknown or invalid signature algorithm.");
        }
        try {
            cloneable = new X500Name(encodedContainer2.data, encodedContainer2.dataOffset, 0);
            this.setIssuerName((X500Name)cloneable);
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid issuer name: " + nameException.getMessage());
        }
        this.a(encodedContainer3.data, encodedContainer3.dataOffset);
        try {
            cloneable = new X500Name(encodedContainer4.data, encodedContainer4.dataOffset, 0);
            this.setSubjectName((X500Name)cloneable);
        }
        catch (NameException nameException) {
            throw new CertificateException("Invalid subject name: " + nameException.getMessage());
        }
        this.setSubjectPublicKey(encodedContainer5.data, encodedContainer5.dataOffset);
        if (encodedContainer6.dataPresent) {
            if (this.c == 0) {
                throw new CertificateException("Version 1 certs not allowed to have issuer unique ID.");
            }
            this.g = new byte[encodedContainer6.dataLen];
            System.arraycopy(encodedContainer6.data, encodedContainer6.dataOffset, this.g, 0, encodedContainer6.dataLen);
        }
        if (encodedContainer7.dataPresent) {
            if (this.c == 0) {
                throw new CertificateException("Version 1 certs not allowed to have subject unique ID.");
            }
            this.h = new byte[encodedContainer7.dataLen];
            System.arraycopy(encodedContainer7.data, encodedContainer7.dataOffset, this.h, 0, encodedContainer7.dataLen);
        }
        if (encodedContainer8.dataPresent) {
            cloneable = new X509V3Extensions(encodedContainer8.data, encodedContainer8.dataOffset, 0xA00003, 1);
            this.setExtensions((X509V3Extensions)cloneable);
        }
        this.b = X509Certificate.getNextBEROffset(byArray, n) - n;
        this.a = new byte[this.b];
        System.arraycopy(byArray, n, this.a, 0, this.b);
    }

    protected void checkVersionNumber(int n) throws CertificateException {
        if (n != 0 && n != 1 && n != 2) {
            throw new CertificateException("Invalid X.509 Certificate version.");
        }
        this.c = n;
    }

    protected void checkVersionNumber(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null || n2 > 4) {
            throw new CertificateException("Invalid X.509 Certificate version.");
        }
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 = n3 << 8 | byArray[n] & 0xFF;
        }
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new CertificateException("Invalid X.509 Certificate version.");
        }
        this.c = n3;
    }

    private boolean b(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return false;
        }
        try {
            if (this.signatureAlgorithmBER == null) {
                this.signatureAlgorithmBER = new byte[n2];
                System.arraycopy(byArray, n, this.signatureAlgorithmBER, 0, n2);
                String string = AlgorithmID.berDecodeAlgID((byte[])byArray, (int)n, (int)1, null);
                return string != null;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            return false;
        }
        if (n2 != this.signatureAlgorithmBER.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n] != this.signatureAlgorithmBER[n3]) {
                return false;
            }
            ++n3;
            ++n;
        }
        return true;
    }

    public int getInnerDERLen() {
        if (this.b != 0) {
            return this.b;
        }
        return this.a();
    }

    private int a() {
        this.innerSpecial = this.special;
        if (this.subjectPublicKeyInfo == null || this.signatureAlgorithmBER == null || this.f == null || this.j == null || this.k == null) {
            return 0;
        }
        if (this.d == null && !this.b(17)) {
            return 0;
        }
        if (this.e == null && !this.b(18)) {
            return 0;
        }
        int n = this.b();
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            boolean bl = true;
            if (this.c == 0) {
                bl = false;
            }
            IntegerContainer integerContainer = new IntegerContainer(0xA20000, bl, 0, this.c);
            IntegerContainer integerContainer2 = null;
            integerContainer2 = (this.f[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.f, 0, this.f.length, true) : new IntegerContainer(0, true, 0, this.f, 0, this.f.length, false);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, null, 0, n);
            EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, null, 0, this.subjectPublicKeyInfo.length);
            bl = false;
            int n2 = 0;
            n2 = this.e != null ? this.e.getDERLen(0) : 2;
            EncodedContainer encodedContainer4 = new EncodedContainer(12288, true, 0, null, 0, n2);
            n2 = this.d != null ? this.d.getDERLen(0) : 2;
            EncodedContainer encodedContainer5 = new EncodedContainer(12288, true, 0, null, 0, n2);
            bl = false;
            n2 = 0;
            if (this.c != 0 && this.g != null) {
                bl = true;
                n2 = this.g.length;
            }
            EncodedContainer encodedContainer6 = new EncodedContainer(8454913, bl, 0, null, 0, n2);
            bl = false;
            n2 = 0;
            if (this.c != 0 && this.h != null) {
                bl = true;
                n2 = this.h.length;
            }
            EncodedContainer encodedContainer7 = new EncodedContainer(8454914, bl, 0, null, 0, n2);
            bl = false;
            n2 = 0;
            if (this.c == 2 && this.l != null && (n2 = this.l.getDERLen(10551299)) != 0) {
                bl = true;
            }
            EncodedContainer encodedContainer8 = new EncodedContainer(10563587, bl, 0, null, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, encodedContainer, encodedContainer4, encodedContainer2, encodedContainer5, encodedContainer3, encodedContainer6, encodedContainer7, encodedContainer8, endContainer};
            this.n = new ASN1Template(aSN1ContainerArray);
            return this.n.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int getInnerDER(byte[] byArray, int n) throws CertificateException {
        int n2;
        if (byArray == null) {
            throw new CertificateException("Passed array is null");
        }
        int n3 = 0;
        try {
            if (this.n == null && (n2 = this.a()) == 0) {
                throw new CertificateException("Cannot encode innerDER, information missing.");
            }
            n3 += this.n.derEncode(byArray, n);
            this.n = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.n = null;
            throw new CertificateException("Could not encode: " + aSN_Exception.getMessage());
        }
        try {
            if (this.e != null) {
                n3 += this.e.getDEREncoding(byArray, n + n3, 0);
            } else {
                byArray[n + n3] = 48;
                byArray[n + n3 + 1] = 0;
                n3 += 2;
            }
            n2 = this.b(byArray, n + n3);
            if (n2 == 0) {
                throw new CertificateException("Could not encode Validity.");
            }
            n3 += n2;
            if (this.d != null) {
                n3 += this.d.getDEREncoding(byArray, n + n3, 0);
            } else {
                byArray[n + n3] = 48;
                byArray[n + n3 + 1] = 0;
                n3 += 2;
            }
            System.arraycopy(this.subjectPublicKeyInfo, 0, byArray, n + n3, this.subjectPublicKeyInfo.length);
            n3 += this.subjectPublicKeyInfo.length;
            if (this.c != 0 && this.g != null) {
                System.arraycopy(this.g, 0, byArray, n + n3, this.g.length);
                n3 += this.g.length;
            }
            if (this.c != 0 && this.h != null) {
                System.arraycopy(this.h, 0, byArray, n + n3, this.h.length);
                n3 += this.h.length;
            }
            if (this.c == 2 && this.l != null) {
                n3 += this.l.getDEREncoding(byArray, n + n3, 10551299);
            }
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not encode a Name: " + nameException.getMessage());
        }
        return n3;
    }

    public void setUnsignedCertFromPKCS10Request(PKCS10CertRequest pKCS10CertRequest) throws CertificateException {
        this.clearComponents();
        if (pKCS10CertRequest == null) {
            throw new CertificateException("Cert Request is null.");
        }
        this.setSubjectName(pKCS10CertRequest.getSubjectName());
        this.setSubjectPublicKey(pKCS10CertRequest.getSubjectPublicKey("Java"));
        X501Attributes x501Attributes = pKCS10CertRequest.getAttributes();
        if (x501Attributes == null) {
            return;
        }
        X501Attribute x501Attribute = x501Attributes.getAttributeByType(2);
        if (x501Attribute == null) {
            this.setVersion(0);
            return;
        }
        this.setVersion(2);
        this.setExtensions(((V3ExtensionAttribute)x501Attribute).getV3ExtensionAttribute());
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        try {
            ASN1.berDecode((byte[])this.signature, (int)0, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot extract the signature." + aSN_Exception.getMessage());
        }
        byte[] byArray = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, byArray, 0, bitStringContainer.dataLen);
        return byArray;
    }

    public void setVersion(int n) throws CertificateException {
        if (n == this.c) {
            return;
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new CertificateException("Invalid cert version: " + n);
        }
        this.clearSignature();
        this.clearTemplate();
        switch (n) {
            case 0: {
                if (!this.a(this.l)) {
                    throw new CertificateException("You can not use X509 V1 version for a certificate with extensions.");
                }
                if (this.g != null) {
                    throw new CertificateException("You can not use X509 V1 version for a certificate with issuer unique ID.");
                }
                if (this.h == null) break;
                throw new CertificateException("You can not use X509 V1 version for a certificate with subject unique ID.");
            }
            case 1: {
                if (this.a(this.l)) break;
                throw new CertificateException("You can not use X509 V2 version for a certificate with extensions.");
            }
        }
        this.c = n;
    }

    public int getVersion() {
        return this.c;
    }

    public void setSubjectName(X500Name x500Name) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (x500Name == null) {
            if (!this.b(17)) {
                throw new CertificateException("Cannot set the cert with the given subjectName.");
            }
        } else {
            try {
                this.d = (X500Name)x500Name.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CertificateException("Cannot set the cert with the given subjectName.");
            }
        }
    }

    public X500Name getSubjectName() {
        if (this.d == null) {
            return null;
        }
        try {
            return (X500Name)this.d.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setIssuerName(X500Name x500Name) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (x500Name == null) {
            if (!this.b(18)) {
                throw new CertificateException("Cannot set the cert with the given issuerName.");
            }
        } else {
            try {
                this.e = (X500Name)x500Name.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CertificateException("Cannot set the cert with the given issuerName.");
            }
        }
    }

    public X500Name getIssuerName() {
        if (this.e == null) {
            return null;
        }
        try {
            return (X500Name)this.e.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setSerialNumber(byte[] byArray, int n, int n2) {
        this.clearSignature();
        this.clearTemplate();
        this.f = new byte[n2];
        if (byArray == null) {
            return;
        }
        System.arraycopy(byArray, n, this.f, 0, n2);
    }

    public byte[] getSerialNumber() {
        if (this.f == null) {
            return new byte[0];
        }
        return (byte[])this.f.clone();
    }

    public byte[] getIssuerAndSerialNumber() throws CertificateException {
        if (this.e == null || this.f == null) {
            throw new CertificateException("Cannot get issuerSerial, not all values set.");
        }
        try {
            int n = this.e.getDERLen(0);
            byte[] byArray = new byte[n];
            n = this.e.getDEREncoding(byArray, 0, 0);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = null;
            integerContainer = (this.f[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.f, 0, this.f.length, true) : new IntegerContainer(0, true, 0, this.f, 0, this.f.length, false);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
            return ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot encode issuerSerial: " + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot encode issuerSerial: " + nameException.getMessage());
        }
    }

    public boolean compareIssuerAndSerialNumber(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return false;
        }
        try {
            byte[] byArray2 = this.getIssuerAndSerialNumber();
            if (byArray2.length != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (byArray[n] != byArray2[n3]) {
                    return false;
                }
                ++n3;
                ++n;
            }
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    public boolean compareSubjectName(X500Name x500Name) {
        if (this.d == null || x500Name == null) {
            return false;
        }
        return this.d.equals(x500Name);
    }

    public void setTimeType(boolean bl) {
        this.i = bl;
    }

    private void a(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(0);
        UTCTimeContainer uTCTimeContainer = new UTCTimeContainer(0);
        UTCTimeContainer uTCTimeContainer2 = new UTCTimeContainer(0);
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        GenTimeContainer genTimeContainer2 = new GenTimeContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, uTCTimeContainer, genTimeContainer, endContainer, choiceContainer2, uTCTimeContainer2, genTimeContainer2, endContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot extract Validity." + aSN_Exception.getMessage());
        }
        Date date = genTimeContainer.theTime;
        if (!genTimeContainer.dataPresent) {
            date = uTCTimeContainer.theTime;
        }
        Date date2 = genTimeContainer2.theTime;
        if (!genTimeContainer2.dataPresent) {
            date2 = uTCTimeContainer2.theTime;
        }
        this.setValidity(date, date2);
    }

    public void setValidity(Date date, Date date2) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (date == null || date2 == null) {
            throw new CertificateException("Cannot set the validity with the given dates.");
        }
        this.j = new Date(date.getTime());
        this.k = new Date(date2.getTime());
        if (!this.k.after(this.j)) {
            throw new CertificateException("Cannot set the validity with the given dates.");
        }
    }

    private int b() {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        GenTimeContainer genTimeContainer = null;
        GenTimeContainer genTimeContainer2 = null;
        if (this.i) {
            genTimeContainer = new GenTimeContainer(0, true, 0, this.j);
            genTimeContainer2 = new GenTimeContainer(0, true, 0, this.k);
        } else {
            genTimeContainer = new UTCTimeContainer(0, true, 0, this.j);
            genTimeContainer2 = new UTCTimeContainer(0, true, 0, this.k);
        }
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, genTimeContainer2, endContainer};
        this.o = new ASN1Template(aSN1ContainerArray);
        try {
            return this.o.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private int b(byte[] byArray, int n) {
        if (this.o == null && this.b() == 0) {
            return 0;
        }
        try {
            int n2 = this.o.derEncode(byArray, n);
            this.o = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.o = null;
            return 0;
        }
    }

    public Date getStartDate() {
        if (this.j == null) {
            return null;
        }
        return new Date(this.j.getTime());
    }

    public Date getEndDate() {
        if (this.k == null) {
            return null;
        }
        return new Date(this.k.getTime());
    }

    public boolean checkValidityDate(Date date) {
        if (this.j == null || this.k == null || date == null) {
            return false;
        }
        if (!this.j.before(date)) {
            return false;
        }
        return this.k.after(date);
    }

    public void setIssuerUniqueID(byte[] byArray, int n, int n2) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (this.c == 0) {
            throw new CertificateException("Cannot set unique ID on a version 1 cert.");
        }
        if (byArray == null) {
            return;
        }
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0x800001, true, 0, byArray, n, n2, n2 * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.g = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot set issuerUniqueID: " + aSN_Exception.getMessage());
        }
    }

    public byte[] getIssuerUniqueID() {
        if (this.g == null) {
            return null;
        }
        try {
            int n = 2 + ASN1Lengths.determineLengthLen((byte[])this.g, (int)1);
            byte[] byArray = new byte[this.g.length - n];
            System.arraycopy(this.g, n, byArray, 0, byArray.length);
            return byArray;
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }

    public void setSubjectUniqueID(byte[] byArray, int n, int n2) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (this.c == 0) {
            throw new CertificateException("Cannot set unique ID on a version 1 cert.");
        }
        if (byArray == null) {
            return;
        }
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0x800002, true, 0, byArray, n, n2, n2 * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.h = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot set subjectUniqueID: " + aSN_Exception.getMessage());
        }
    }

    public byte[] getSubjectUniqueID() {
        if (this.h == null) {
            return null;
        }
        try {
            int n = 2 + ASN1Lengths.determineLengthLen((byte[])this.h, (int)1);
            byte[] byArray = new byte[this.h.length - n];
            System.arraycopy(this.h, n, byArray, 0, byArray.length);
            return byArray;
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
    }

    public void setExtensions(X509V3Extensions x509V3Extensions) throws CertificateException {
        if (this.a(x509V3Extensions)) {
            return;
        }
        if (x509V3Extensions.getExtensionsType() != 1) {
            throw new CertificateException("Wrong extensions type: should be Cert extensions.");
        }
        this.clearSignature();
        this.clearTemplate();
        try {
            this.l = (X509V3Extensions)x509V3Extensions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CertificateException("Cannot set the cert with the given extensions(" + cloneNotSupportedException.getMessage() + ").");
        }
        if (this.c != 2) {
            this.setVersion(2);
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.l == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.l.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void signCertificate(String string, String string2, JSAFE_PrivateKey jSAFE_PrivateKey, SecureRandom secureRandom) throws CertificateException {
        Object object;
        this.clearSignature();
        this.clearTemplate();
        if (string == null || string2 == null || jSAFE_PrivateKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            object = this.getSignatureFormat(string);
            this.signatureAlgorithmBER = object == null ? AlgorithmID.derEncodeAlgID((String)string, (int)1, null, (int)0, (int)0) : AlgorithmID.derEncodeAlgID((String)object, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot sign, unknown algorithm.(" + aSN_Exception.getMessage() + ")");
        }
        this.b = this.getInnerDERLen();
        if (this.b == 0) {
            throw new CertificateException("Cannot sign certificate, values not set.");
        }
        this.a = new byte[this.b];
        this.b = this.getInnerDER(this.a, 0);
        object = this.performSignature(string, string2, jSAFE_PrivateKey, secureRandom, this.a, 0, this.b);
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, (byte[])object, 0, ((Object)object).length, ((Object)object).length * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.signature = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the cert as presently set." + aSN_Exception.getMessage());
        }
    }

    public boolean verifyCertificateSignature(String string, JSAFE_PublicKey jSAFE_PublicKey, SecureRandom secureRandom) throws CertificateException {
        if (string == null || jSAFE_PublicKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        if (this.a == null) {
            throw new CertificateException("Cannot verify certificate, values not set.");
        }
        byte[] byArray = this.getSignature();
        return this.performSignatureVerification(string, jSAFE_PublicKey, secureRandom, this.a, 0, this.b, byArray, 0, byArray.length);
    }

    private boolean b(int n) {
        if (this.c == 2 && this.l != null) {
            Vector vector = this.l.theExtensions;
            X509V3Extension x509V3Extension = null;
            for (int i = 0; i < vector.size(); ++i) {
                x509V3Extension = (X509V3Extension)vector.elementAt(i);
                if (x509V3Extension.getExtensionType() != n || !x509V3Extension.getCriticality()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)object;
        try {
            int n = this.getDERLen(0);
            int n2 = x509Certificate.getDERLen(0);
            if (n != n2) {
                return false;
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n2];
            n = this.getDEREncoding(byArray, 0, 0);
            if (n != (n2 = x509Certificate.getDEREncoding(byArray2, 0, 0))) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (CertificateException certificateException) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        X509Certificate x509Certificate = (X509Certificate)super.clone();
        if (this.subjectPublicKeyInfo != null) {
            x509Certificate.subjectPublicKeyInfo = (byte[])this.subjectPublicKeyInfo.clone();
        }
        if (this.signatureAlgorithmBER != null) {
            x509Certificate.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        if (this.signature != null) {
            x509Certificate.signature = (byte[])this.signature.clone();
        }
        x509Certificate.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        if (this.theDevice != null) {
            x509Certificate.theDevice = new String(this.theDevice);
        }
        if (this.theDeviceList != null) {
            x509Certificate.theDeviceList = (String[])this.theDeviceList.clone();
        }
        if (this.a != null) {
            x509Certificate.a = (byte[])this.a.clone();
        }
        x509Certificate.b = this.b;
        x509Certificate.c = this.c;
        if (this.d != null) {
            x509Certificate.d = (X500Name)this.d.clone();
        }
        if (this.e != null) {
            x509Certificate.e = (X500Name)this.e.clone();
        }
        if (this.f != null) {
            x509Certificate.f = (byte[])this.f.clone();
        }
        if (this.g != null) {
            x509Certificate.g = (byte[])this.g.clone();
        }
        if (this.h != null) {
            x509Certificate.h = (byte[])this.h.clone();
        }
        x509Certificate.i = this.i;
        if (this.j != null) {
            x509Certificate.j = new Date(this.j.getTime());
        }
        if (this.k != null) {
            x509Certificate.k = new Date(this.k.getTime());
        }
        if (this.l != null) {
            x509Certificate.l = (X509V3Extensions)this.l.clone();
        }
        x509Certificate.special = this.special;
        x509Certificate.innerSpecial = this.innerSpecial;
        if (this.m != null) {
            x509Certificate.a(this.special);
        }
        if (this.n != null) {
            x509Certificate.a();
        }
        if (this.o != null) {
            x509Certificate.b();
        }
        return x509Certificate;
    }

    protected void clearTemplate() {
        this.m = null;
        this.n = null;
        this.a = null;
        this.b = 0;
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.a = null;
        this.b = 0;
        this.c = 0;
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        this.j = null;
        this.k = null;
        this.l = null;
    }

    private boolean a(X509V3Extensions x509V3Extensions) {
        return x509V3Extensions == null || x509V3Extensions.getExtensionCount() == 0;
    }
}

