/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class ContentType
extends X501Attribute
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;

    public ContentType() {
        super(14, "ContentType");
    }

    public ContentType(byte[] byArray, int n, int n2) {
        this();
        this.setContentType(byArray, n, n2);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        try {
            SetContainer setContainer = new SetContainer(0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, oIDContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = new byte[oIDContainer.dataLen];
            System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, this.a, 0, oIDContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode ContentType.");
        }
    }

    public void setContentType(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.a = new byte[n2];
            System.arraycopy(byArray, n, this.a, 0, n2);
        }
    }

    public byte[] getContentType() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    protected int derEncodeValueInit() {
        this.b = null;
        int n = 0;
        if (this.a != null) {
            n = this.a.length;
        }
        try {
            SetContainer setContainer = new SetContainer(0, true, 0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, this.a, 0, n);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, oIDContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContentType contentType = new ContentType();
        if (this.a != null) {
            contentType.a = new byte[this.a.length];
            System.arraycopy(this.a, 0, contentType.a, 0, this.a.length);
        }
        super.copyValues(contentType);
        return contentType;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ContentType)) {
            return false;
        }
        ContentType contentType = (ContentType)object;
        return CertJUtils.byteArraysEqual(contentType.a, this.a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

