/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;
import java.math.BigInteger;

public class VeriSignCRSTransactionID
extends X501Attribute
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;

    public VeriSignCRSTransactionID() {
        super(11, "VeriSignCRSTransactionID");
    }

    public VeriSignCRSTransactionID(byte[] byArray, int n, int n2) {
        this();
        this.setTransactionID(byArray, n, n2);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        block6: {
            if (byArray == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer setContainer = new SetContainer(0);
                EndContainer endContainer = new EndContainer();
                IntegerContainer integerContainer = new IntegerContainer(65536);
                PrintStringContainer printStringContainer = new PrintStringContainer(65536);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, integerContainer, printStringContainer, endContainer};
                ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
                if (integerContainer.dataPresent) {
                    if (integerContainer.dataLen > 0) {
                        this.a = new byte[integerContainer.dataLen];
                        System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.a, 0, integerContainer.dataLen);
                    }
                    break block6;
                }
                if (printStringContainer.dataPresent) {
                    String string = printStringContainer.getValueAsString();
                    BigInteger bigInteger = new BigInteger(string, 10);
                    byte[] byArray2 = bigInteger.toByteArray();
                    this.a = byArray2;
                    break block6;
                }
                throw new AttributeException("Unexpected encoding.");
            }
            catch (ASN_Exception aSN_Exception) {
                throw new AttributeException("Could not BER decode VeriSignCRSTransactionID.");
            }
        }
    }

    public void setTransactionID(byte[] byArray, int n, int n2) {
        this.reset();
        if (byArray != null && n2 != 0) {
            this.a = new byte[n2];
            System.arraycopy(byArray, n, this.a, 0, n2);
        }
    }

    public byte[] getTransactionID() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected int derEncodeValueInit() {
        this.b = null;
        int n = 0;
        if (this.a != null) {
            n = this.a.length;
        }
        SetContainer setContainer = new SetContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[3];
        aSN1ContainerArray[0] = setContainer;
        aSN1ContainerArray[2] = endContainer;
        try {
            if (CertJ.isCompatibilityTypeSet(CompatibilityType.CERTJ_COMPATIBILITY_SCEP)) {
                BigInteger bigInteger;
                String string;
                if (n == 0) {
                    string = "0";
                } else {
                    bigInteger = new BigInteger(this.a);
                    string = bigInteger.toString();
                }
                bigInteger = new PrintStringContainer(0, true, 0, string);
                aSN1ContainerArray[1] = bigInteger;
            } else {
                IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.a, 0, n, true);
                aSN1ContainerArray[1] = integerContainer;
            }
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignCRSTransactionID veriSignCRSTransactionID = new VeriSignCRSTransactionID();
        if (this.a != null) {
            veriSignCRSTransactionID.a = (byte[])this.a.clone();
        }
        super.copyValues(veriSignCRSTransactionID);
        return veriSignCRSTransactionID;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof VeriSignCRSTransactionID)) {
            return false;
        }
        VeriSignCRSTransactionID veriSignCRSTransactionID = (VeriSignCRSTransactionID)object;
        return CertJUtils.byteArraysEqual(veriSignCRSTransactionID.a, this.a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

