/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class EDIPartyName
implements Cloneable,
Serializable {
    private static final int a = 0xA10000;
    private static final int b = 0xA00001;
    private String c;
    private int d;
    private String e;
    private int f;
    protected static int special;
    private ASN1Template g;

    public EDIPartyName(byte[] byArray, int n, int n2) throws NameException {
        block18: {
            this.c = null;
            this.d = 0;
            this.e = null;
            this.f = 0;
            this.g = null;
            if (byArray == null) {
                throw new NameException("Encoding is null.");
            }
            try {
                SequenceContainer sequenceContainer = new SequenceContainer(n2);
                EndContainer endContainer = new EndContainer();
                ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                BMPStringContainer bMPStringContainer = new BMPStringContainer(0);
                ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA00001);
                TeletexStringContainer teletexStringContainer2 = new TeletexStringContainer(0);
                PrintStringContainer printStringContainer2 = new PrintStringContainer(0);
                UniversalStringContainer universalStringContainer2 = new UniversalStringContainer(0);
                UTF8StringContainer uTF8StringContainer2 = new UTF8StringContainer(0);
                BMPStringContainer bMPStringContainer2 = new BMPStringContainer(0);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, teletexStringContainer, printStringContainer, universalStringContainer, uTF8StringContainer, bMPStringContainer, endContainer, choiceContainer2, teletexStringContainer2, printStringContainer2, universalStringContainer2, uTF8StringContainer2, bMPStringContainer2, endContainer, endContainer};
                ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
                if (choiceContainer.dataPresent) {
                    if (teletexStringContainer.dataPresent) {
                        this.c = teletexStringContainer.getValueAsString();
                        this.d = 5120;
                    } else if (printStringContainer.dataPresent) {
                        this.c = printStringContainer.getValueAsString();
                        this.d = 4864;
                    } else if (universalStringContainer.dataPresent) {
                        this.c = universalStringContainer.getValueAsString();
                        this.d = 7168;
                    } else if (uTF8StringContainer.dataPresent) {
                        this.c = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        this.d = 3072;
                    } else if (bMPStringContainer.dataPresent) {
                        this.c = bMPStringContainer.getValueAsString();
                        this.d = 7680;
                    }
                }
                if (teletexStringContainer2.dataPresent) {
                    this.e = teletexStringContainer2.getValueAsString();
                    this.f = 5120;
                    break block18;
                }
                if (printStringContainer2.dataPresent) {
                    this.e = printStringContainer2.getValueAsString();
                    this.f = 4864;
                    break block18;
                }
                if (universalStringContainer2.dataPresent) {
                    this.e = universalStringContainer2.getValueAsString();
                    this.f = 7168;
                    break block18;
                }
                if (uTF8StringContainer2.dataPresent) {
                    this.e = new String(uTF8StringContainer2.data, uTF8StringContainer2.dataOffset, uTF8StringContainer2.dataLen);
                    this.f = 3072;
                    break block18;
                }
                if (bMPStringContainer2.dataPresent) {
                    this.e = bMPStringContainer2.getValueAsString();
                    this.f = 7680;
                    break block18;
                }
                throw new NameException("Party Name field must be set!");
            }
            catch (ASN_Exception aSN_Exception) {
                throw new NameException("Cannot decode the BER of the name.");
            }
        }
    }

    public EDIPartyName() {
        this.c = null;
        this.d = 0;
        this.e = null;
        this.f = 0;
        this.g = null;
    }

    public void addNameAssigner(String string, int n) {
        if (string != null) {
            this.c = string;
            this.d = n == 0 ? 7168 : n;
        }
    }

    public void addPartyName(String string, int n) {
        if (string != null) {
            this.e = string;
            this.f = n == 0 ? 7168 : n;
        }
    }

    public String getNameAssigner() {
        return this.c;
    }

    public String getPartyName() {
        return this.e;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append(this.c);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.e);
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) throws NameException {
        special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            block8: {
                int n3;
                block7: {
                    n3 = 0;
                    if (this.g == null) break block7;
                    if (n2 == special) break block8;
                }
                if ((n3 = this.getDERLen(n2)) == 0) {
                    throw new NameException("Unable to encode EDI Party Name.");
                }
            }
            int n4 = this.g.derEncode(byArray, n);
            this.g = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.g = null;
            throw new NameException("Unable to encode EDI Party Name.");
        }
    }

    private int a() throws NameException {
        Object[] objectArray;
        SequenceContainer sequenceContainer = new SequenceContainer(special, true, 0);
        ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000, 0);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA00001, 0);
        EndContainer endContainer = new EndContainer();
        TeletexStringContainer teletexStringContainer = null;
        TeletexStringContainer teletexStringContainer2 = null;
        int n = Short.MAX_VALUE;
        if (this.e == null) {
            throw new NameException("PartyName is not set.");
        }
        try {
            switch (this.d) {
                case 5120: {
                    teletexStringContainer = new TeletexStringContainer(0, true, 0, this.c, 1, n);
                    break;
                }
                case 4864: {
                    teletexStringContainer = new PrintStringContainer(0, true, 0, this.c, 1, n);
                    break;
                }
                case 7168: {
                    teletexStringContainer = new UniversalStringContainer(0, true, 0, this.c, 1, n);
                    break;
                }
                case 3072: {
                    if (this.c != null) {
                        objectArray = this.c.getBytes();
                        if (objectArray.length > n) {
                            throw new NameException("Illegal name length");
                        }
                        teletexStringContainer = new UTF8StringContainer(0, true, 0, objectArray, 0, objectArray.length);
                        break;
                    }
                    teletexStringContainer = new UTF8StringContainer(0, false, 0, null, 0, 0);
                    break;
                }
                case 7680: {
                    teletexStringContainer = new BMPStringContainer(0, true, 0, this.c, 1, n);
                    break;
                }
            }
            switch (this.f) {
                case 5120: {
                    teletexStringContainer2 = new TeletexStringContainer(0, true, 0, this.e, 1, n);
                    break;
                }
                case 4864: {
                    teletexStringContainer2 = new PrintStringContainer(0, true, 0, this.e, 1, n);
                    break;
                }
                case 7168: {
                    teletexStringContainer2 = new UniversalStringContainer(0, true, 0, this.e, 1, n);
                    break;
                }
                case 3072: {
                    objectArray = this.e.getBytes();
                    if (objectArray.length > n) {
                        throw new NameException("Illegal name length");
                    }
                    teletexStringContainer2 = new UTF8StringContainer(0, true, 0, objectArray, 0, objectArray.length);
                    break;
                }
                case 7680: {
                    teletexStringContainer2 = new BMPStringContainer(0, true, 0, this.e, 1, n);
                    break;
                }
                default: {
                    throw new NameException("Illegal empty partyName value");
                }
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(aSN_Exception.getMessage());
        }
        if (teletexStringContainer == null) {
            objectArray = new ASN1Container[]{sequenceContainer, choiceContainer2, teletexStringContainer2, endContainer, endContainer};
            this.g = new ASN1Template((ASN1Container[])objectArray);
        } else {
            objectArray = new ASN1Container[]{sequenceContainer, choiceContainer, teletexStringContainer, endContainer, choiceContainer2, teletexStringContainer2, endContainer, endContainer};
            this.g = new ASN1Template((ASN1Container[])objectArray);
        }
        try {
            return this.g.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(aSN_Exception.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EDIPartyName)) {
            return false;
        }
        EDIPartyName eDIPartyName = (EDIPartyName)object;
        if (this.c != null ? !this.c.equals(eDIPartyName.c) : eDIPartyName.c != null) {
            return false;
        }
        return !(this.e != null ? !this.e.equals(eDIPartyName.e) : eDIPartyName.e != null);
    }

    public Object clone() throws CloneNotSupportedException {
        EDIPartyName eDIPartyName = new EDIPartyName();
        eDIPartyName.d = this.d;
        eDIPartyName.f = this.f;
        eDIPartyName.c = this.c;
        eDIPartyName.e = this.e;
        try {
            if (this.g != null) {
                eDIPartyName.a();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return eDIPartyName;
    }
}

