/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.EDIPartyName;
import com.rsa.certj.cert.extensions.ORAddress;
import com.rsa.certj.cert.extensions.OtherName;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;

public class GeneralName
implements Cloneable,
Serializable {
    private static final int a = 0x800000;
    private static final int b = 0x800001;
    private static final int c = 0x800002;
    private static final int d = 0x800003;
    private static final int e = 0xA00004;
    private static final int f = 0x800005;
    private static final int g = 0x800006;
    private static final int h = 0x800007;
    private static final int i = 0x800008;
    private String j = null;
    private ORAddress k = null;
    private EDIPartyName l = null;
    private OtherName m = null;
    private X500Name n = null;
    private byte[] o = null;
    private int p = 0;
    public static final int OTHER_NAME_TYPE = 1;
    public static final int RFC822_NAME_TYPE = 2;
    public static final int DNS_NAME_TYPE = 3;
    public static final int X400ADDRESS_NAME_TYPE = 4;
    public static final int DIRECTORY_NAME_TYPE = 5;
    public static final int EDIPARTY_NAME_TYPE = 6;
    public static final int URL_NAME_TYPE = 7;
    public static final int IPADDRESS_NAME_TYPE = 8;
    public static final int REGISTERID_NAME_TYPE = 9;
    protected static int special;
    private ASN1Template q = null;

    public GeneralName(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(n2);
            EncodedContainer encodedContainer = new EncodedContainer(0x803000);
            IA5StringContainer iA5StringContainer = new IA5StringContainer(0x800001);
            IA5StringContainer iA5StringContainer2 = new IA5StringContainer(0x800002);
            EncodedContainer encodedContainer2 = new EncodedContainer(0x803003);
            EncodedContainer encodedContainer3 = new EncodedContainer(10498052);
            EncodedContainer encodedContainer4 = new EncodedContainer(8400901);
            IA5StringContainer iA5StringContainer3 = new IA5StringContainer(0x800006);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0x800007);
            OIDContainer oIDContainer = new OIDContainer(0x1800008);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer, iA5StringContainer, iA5StringContainer2, encodedContainer2, encodedContainer3, encodedContainer4, iA5StringContainer3, octetStringContainer, oIDContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (encodedContainer.dataPresent) {
                byte[] byArray2 = new byte[encodedContainer.dataLen];
                System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, byArray2, 0, encodedContainer.dataLen);
                this.m = new OtherName();
                this.m.decodeValue(byArray2, 0, 0x800000);
                this.p = 1;
            } else if (iA5StringContainer.dataPresent) {
                this.j = iA5StringContainer.getValueAsString();
                this.p = 2;
            } else if (iA5StringContainer2.dataPresent) {
                this.j = iA5StringContainer2.getValueAsString();
                this.p = 3;
            } else if (encodedContainer2.dataPresent) {
                byte[] byArray3 = new byte[encodedContainer2.dataLen];
                System.arraycopy(encodedContainer2.data, encodedContainer2.dataOffset, byArray3, 0, encodedContainer2.dataLen);
                this.k = new ORAddress(byArray3, 0, 0x800003);
                this.p = 4;
            } else if (encodedContainer3.dataPresent) {
                byte[] byArray4 = new byte[encodedContainer3.dataLen];
                System.arraycopy(encodedContainer3.data, encodedContainer3.dataOffset, byArray4, 0, encodedContainer3.dataLen);
                this.n = new X500Name(byArray4, 0, 0xA00004);
                this.p = 5;
            } else if (encodedContainer4.dataPresent) {
                byte[] byArray5 = new byte[encodedContainer4.dataLen];
                System.arraycopy(encodedContainer4.data, encodedContainer4.dataOffset, byArray5, 0, encodedContainer4.dataLen);
                this.l = new EDIPartyName(byArray5, 0, 0x800005);
                this.p = 6;
            } else if (iA5StringContainer3.dataPresent) {
                this.j = iA5StringContainer3.getValueAsString();
                this.p = 7;
            } else if (octetStringContainer.dataPresent) {
                this.o = new byte[octetStringContainer.dataLen];
                System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.o, 0, octetStringContainer.dataLen);
                this.p = 8;
            } else if (oIDContainer.dataPresent) {
                this.o = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, this.o, 0, oIDContainer.dataLen);
                this.p = 9;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the name.");
        }
    }

    public GeneralName() {
    }

    public void setGeneralName(Object object, int n) throws NameException {
        if (object == null) {
            throw new NameException("Name is null.");
        }
        this.p = n;
        switch (n) {
            case 2: 
            case 3: {
                if (object instanceof String) {
                    this.j = (String)object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be a String for type(" + n + ").");
            }
            case 7: {
                if (object instanceof String) {
                    this.j = (String)object;
                    break;
                }
                if (object instanceof URL) {
                    this.j = ((URL)object).toString();
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be either a String or a URL for the URL_NAME_TYPE type.");
            }
            case 1: {
                if (object instanceof OtherName) {
                    this.m = (OtherName)object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an OtherName for the OTHER_NAME_TYPE type.");
            }
            case 4: {
                if (object instanceof ORAddress) {
                    this.k = (ORAddress)object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an ORAddress for the X400ADDRESS_NAME_TYPE type.");
            }
            case 5: {
                if (object instanceof X500Name) {
                    this.n = (X500Name)object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an X500Name for the DIRECTORY_NAME_TYPE type.");
            }
            case 6: {
                if (object instanceof EDIPartyName) {
                    this.l = (EDIPartyName)object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be an EDIPartyName for the EDIPARTY_NAME_TYPE type.");
            }
            case 8: {
                if (object instanceof byte[]) {
                    this.o = (byte[])object;
                    break;
                }
                if (object instanceof InetAddress) {
                    this.o = ((InetAddress)object).getAddress();
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be either a byte array or an InetAddress for the IPADDRESS_NAME_TYPE type.");
            }
            case 9: {
                if (object instanceof byte[]) {
                    this.o = (byte[])object;
                    break;
                }
                throw new NameException("GeneralName.setGeneralName: name argument should be a byte array for the REGISTERID_NAME_TYPE type.");
            }
            default: {
                throw new NameException("GeneralName.setGeneralName: unrecoginized type value(" + n + ").");
            }
        }
    }

    public Object getGeneralName() {
        switch (this.p) {
            case 2: 
            case 3: 
            case 7: {
                return this.j;
            }
            case 8: 
            case 9: {
                return this.o;
            }
            case 1: {
                return this.m;
            }
            case 4: {
                return this.k;
            }
            case 5: {
                return this.n;
            }
            case 6: {
                return this.l;
            }
        }
        return null;
    }

    public int getGeneralNameType() {
        return this.p;
    }

    public String toString() {
        switch (this.p) {
            case 2: 
            case 3: 
            case 7: {
                return this.j;
            }
            case 8: 
            case 9: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("0x");
                for (int i = 0; i < this.o.length; ++i) {
                    String string = Integer.toHexString(this.o[i]);
                    int n = string.length();
                    if (n < 2) {
                        stringBuffer.append('0');
                        stringBuffer.append(string.charAt(0));
                        continue;
                    }
                    if (n > 2) {
                        stringBuffer.append(string.charAt(n - 2));
                        stringBuffer.append(string.charAt(n - 1));
                        continue;
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            case 1: {
                return this.m.toString();
            }
            case 4: {
                return this.k.toString();
            }
            case 5: {
                return this.n.toString();
            }
            case 6: {
                return this.l.toString();
            }
        }
        return null;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) throws NameException {
        special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n3;
            block8: {
                block7: {
                    if (this.q == null) break block7;
                    if (n2 == special) break block8;
                }
                if ((n3 = this.getDERLen(n2)) == 0) {
                    throw new NameException("Unable to encode GeneralName.");
                }
            }
            n3 = this.q.derEncode(byArray, n);
            this.q = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.q = null;
            throw new NameException("Unable to encode GeneralName.");
        }
    }

    private int a() {
        try {
            ChoiceContainer choiceContainer = new ChoiceContainer(special, 0);
            EndContainer endContainer = new EndContainer();
            IA5StringContainer iA5StringContainer = null;
            switch (this.p) {
                case 2: {
                    iA5StringContainer = new IA5StringContainer(0x800001, true, 0, this.j);
                    break;
                }
                case 3: {
                    iA5StringContainer = new IA5StringContainer(0x800002, true, 0, this.j);
                    break;
                }
                case 7: {
                    iA5StringContainer = new IA5StringContainer(0x800006, true, 0, this.j);
                    break;
                }
                case 8: {
                    if (this.o != null) {
                        iA5StringContainer = new OctetStringContainer(0x800007, true, 0, this.o, 0, this.o.length);
                        break;
                    }
                    iA5StringContainer = new OctetStringContainer(0x800007, false, 0, this.o, 0, 0);
                    break;
                }
                case 9: {
                    if (this.o != null) {
                        iA5StringContainer = new OIDContainer(0x1800008, true, 0, this.o, 0, this.o.length);
                        break;
                    }
                    iA5StringContainer = new OIDContainer(0x1800008, true, 0, this.o, 0, 0);
                    break;
                }
                case 1: {
                    int n;
                    if (this.m != null) {
                        n = this.m.getDERLen(0x800000);
                        byte[] byArray = new byte[n];
                        n = this.m.getDEREncoding(byArray, 0, 0x800000);
                        iA5StringContainer = new EncodedContainer(0x803000, true, 0, byArray, 0, n);
                        break;
                    }
                    iA5StringContainer = new EncodedContainer(0x803000, false, 0, null, 0, 0);
                    break;
                }
                case 4: {
                    int n;
                    if (this.k != null) {
                        n = this.k.getDERLen(0x800003);
                        byte[] byArray = new byte[n];
                        n = this.k.getDEREncoding(byArray, 0, 0x800003);
                        iA5StringContainer = new EncodedContainer(0x803003, true, 0, byArray, 0, n);
                        break;
                    }
                    iA5StringContainer = new EncodedContainer(0x803003, false, 0, null, 0, 0);
                    break;
                }
                case 5: {
                    int n;
                    if (this.n != null) {
                        n = this.n.getDERLen(0xA00004);
                        byte[] byArray = new byte[n];
                        int n2 = this.n.getDEREncoding(byArray, 0, 0xA00004);
                        iA5StringContainer = new EncodedContainer(10498052, true, 0, byArray, 0, n2);
                        break;
                    }
                    iA5StringContainer = new EncodedContainer(10498052, false, 0, null, 0, 0);
                    break;
                }
                case 6: {
                    int n;
                    if (this.l != null) {
                        n = this.l.getDERLen(0x800005);
                        byte[] byArray = new byte[n];
                        n = this.l.getDEREncoding(byArray, 0, 0x800005);
                        iA5StringContainer = new EncodedContainer(8400901, true, 0, byArray, 0, n);
                        break;
                    }
                    iA5StringContainer = new EncodedContainer(8400901, false, 0, null, 0, 0);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, iA5StringContainer, endContainer};
            this.q = new ASN1Template(aSN1ContainerArray);
            return this.q.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GeneralName)) {
            return false;
        }
        GeneralName generalName = (GeneralName)object;
        if (this.p != generalName.p) {
            return false;
        }
        if (this.j != null ? !this.j.equals(generalName.j) : generalName.j != null) {
            return false;
        }
        if (this.o != null ? !this.o.equals(generalName.o) : generalName.o != null) {
            return false;
        }
        if (this.k != null ? !this.k.equals(generalName.k) : generalName.k != null) {
            return false;
        }
        if (this.l != null ? !this.l.equals(generalName.l) : generalName.l != null) {
            return false;
        }
        if (this.m != null ? !this.m.equals(generalName.m) : generalName.m != null) {
            return false;
        }
        return !(this.n != null ? !this.n.equals(generalName.n) : generalName.n != null);
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralName generalName = new GeneralName();
        generalName.p = this.p;
        if (this.j != null) {
            generalName.j = new String(this.j);
        }
        generalName.o = this.o;
        generalName.k = this.k;
        generalName.l = this.l;
        generalName.m = this.m;
        generalName.n = this.n;
        if (this.q != null) {
            generalName.a();
        }
        return generalName;
    }
}

