/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class NetscapeCertType
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    public static final int CERT_TYPE_BITS = 8;
    public static final int CERT_TYPE_MASK = -16777216;
    public static final int SSL_CLIENT = Integer.MIN_VALUE;
    public static final int SSL_SERVER = 0x40000000;
    public static final int SMIME_CLIENT = 0x20000000;
    public static final int OBJECT_SIGNING = 0x10000000;
    public static final int RESERVED = 0x8000000;
    public static final int SSL_CA = 0x4000000;
    public static final int SMIME_CA = 0x2000000;
    public static final int OBJECT_SIGNING_CA = 0x1000000;
    private int a;
    ASN1Template b;

    public NetscapeCertType() {
        this.extensionTypeFlag = 101;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.NETSCAPE_CERT_TYPE_OID);
        this.extensionTypeString = "NetscapeCertType";
    }

    public NetscapeCertType(int n, boolean bl) {
        this.extensionTypeFlag = 101;
        this.criticality = bl;
        this.setSpecialOID(X509V3Extension.NETSCAPE_CERT_TYPE_OID);
        this.a = n & 0xFF000000;
        this.extensionTypeString = "NetscapeCertType";
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.a = 0;
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode NetscapeCertType extension.");
        }
        if (bitStringContainer.dataLen == 0) {
            return;
        }
        if (bitStringContainer.dataLen > 4) {
            throw new CertificateException("Could not decode NetscapeCertType extension.");
        }
        int n2 = bitStringContainer.dataOffset;
        int n3 = 24;
        while (n2 < bitStringContainer.dataOffset + bitStringContainer.dataLen) {
            this.a |= (bitStringContainer.data[n2] & 0xFF) << n3;
            ++n2;
            n3 -= 8;
        }
        this.a &= 0xFF000000;
    }

    public void setCertType(int n) {
        this.a = n & 0xFF000000;
    }

    public int getCertType() {
        return this.a;
    }

    public boolean verifyCertType(int n) {
        int n2 = n & this.a & 0xFF000000;
        return n2 == n;
    }

    public int derEncodeValueInit() {
        BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, this.a, 8, true);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
        this.b = new ASN1Template(aSN1ContainerArray);
        try {
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NetscapeCertType netscapeCertType = new NetscapeCertType();
        netscapeCertType.a = this.a;
        if (this.b != null) {
            netscapeCertType.derEncodeValueInit();
        }
        super.copyValues(netscapeCertType);
        return netscapeCertType;
    }

    protected void reset() {
        super.reset();
        this.a = 0;
        this.b = null;
    }
}

