/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class OCSPAcceptableResponses
extends X509V3Extension
implements Cloneable,
Serializable,
OCSPRequestExtension {
    ASN1Template a;
    Vector b;
    public static byte[] ID_PKIX_OCSP_BASIC = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 1};

    public OCSPAcceptableResponses() {
        this.extensionTypeFlag = 121;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.OCSP_ACCEPTABLE_RESPONSES_OID);
        this.extensionTypeString = "OCSPAcceptableResponses";
        this.b = null;
    }

    public void addAcceptableResponse(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null || n2 == 0) {
            throw new CertificateException("Missing values");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (this.b == null) {
            this.b = new Vector();
        }
        this.b.addElement(byArray2);
    }

    public int getAcceptableResponseCount() {
        if (this.b != null) {
            return this.b.size();
        }
        return 0;
    }

    public byte[] getAcceptableResponse(int n) throws InvalidParameterException {
        if (this.b.size() <= n) {
            throw new InvalidParameterException("Specified index is invalid.");
        }
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.elementAt(n);
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(1536));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{oIDContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                if (this.b == null) {
                    this.b = new Vector();
                }
                byte[] byArray2 = new byte[oIDContainer.dataLen];
                System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, byArray2, 0, oIDContainer.dataLen);
                this.b.addElement(byArray2);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Extended Key Usage extension.");
        }
    }

    public int derEncodeValueInit() {
        int n = this.b.size();
        if (n == 0) {
            return 0;
        }
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(1536));
            vector.addElement(ofContainer);
            for (int i = 0; i < n; ++i) {
                try {
                    EncodedContainer encodedContainer = this.a(i);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.a = new ASN1Template((ASN1Container[])objectArray);
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.a == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.a.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    private EncodedContainer a(int n) throws CertificateException {
        try {
            byte[] byArray = (byte[])this.b.elementAt(n);
            int n2 = byArray.length;
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, byArray, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n3 = aSN1Template.derEncodeInit();
            byte[] byArray2 = new byte[n3];
            n3 = aSN1Template.derEncode(byArray2, 0);
            EncodedContainer encodedContainer = new EncodedContainer(1536, true, 0, byArray2, 0, n3);
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode Acceptable Response Type");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPAcceptableResponses oCSPAcceptableResponses = new OCSPAcceptableResponses();
        if (this.b != null) {
            oCSPAcceptableResponses.b = (Vector)this.b.clone();
        }
        if (this.a != null) {
            oCSPAcceptableResponses.derEncodeValueInit();
        }
        super.copyValues(oCSPAcceptableResponses);
        return oCSPAcceptableResponses;
    }

    protected void reset() {
        super.reset();
        this.a = null;
    }
}

