/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class ORName
implements Cloneable,
Serializable {
    public static final int COUNTRY_NAME = 0;
    public static final int ADMIN_DOMAIN_NAME = 1;
    public static final int PRIVATE_DOMAIN_NAME = 2;
    public static final int POSTAL_CODE = 3;
    public static final int PHYSICAL_DELIVERY_COUNTRY_NAME = 4;
    private int a;
    private String b;
    private String c;
    protected int special;
    protected ASN1Template asn1Template = null;
    private static final int d = 0x400001;
    private static final int e = 0x400002;

    public ORName(int n, byte[] byArray, int n2, int n3) throws NameException {
        this.special = n3;
        this.a = n;
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            ChoiceContainer choiceContainer = null;
            NumericStringContainer numericStringContainer = null;
            PrintStringContainer printStringContainer = null;
            EndContainer endContainer = new EndContainer();
            switch (n) {
                case 0: {
                    choiceContainer = new ChoiceContainer(n3 | 0x400001);
                    break;
                }
                case 1: {
                    choiceContainer = new ChoiceContainer(n3 | 0x400002);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    choiceContainer = new ChoiceContainer(n3);
                }
            }
            switch (n) {
                case 0: 
                case 4: {
                    numericStringContainer = new NumericStringContainer(0, 1, 3);
                    printStringContainer = new PrintStringContainer(0, 1, 2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    numericStringContainer = new NumericStringContainer(0, 1, 16);
                    printStringContainer = new PrintStringContainer(0, 1, 16);
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, numericStringContainer, printStringContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n2, (ASN1Container[])aSN1ContainerArray);
            if (numericStringContainer.dataPresent) {
                this.b = new String(numericStringContainer.data, numericStringContainer.dataOffset, numericStringContainer.dataLen);
            }
            if (printStringContainer.dataPresent) {
                this.c = new String(printStringContainer.data, printStringContainer.dataOffset, printStringContainer.dataLen);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the ORName.");
        }
    }

    public ORName(int n) {
        this.a = n;
    }

    public int getNameType() {
        return this.a;
    }

    public void setNumericValue(String string) {
        if (string != null) {
            this.b = string;
        }
    }

    public void setPrintableValue(String string) {
        if (string != null) {
            this.c = string;
        }
    }

    public String getNumericValue() {
        return this.b;
    }

    public String getPrintableValue() {
        return this.c;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append(this.b);
        }
        if (this.c != null) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.c);
        }
        return stringBuffer.toString();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) {
        this.special = n;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || n2 != this.special) {
                this.getDERLen(n2);
            }
            int n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ORName");
        }
    }

    private int a() {
        if (this.asn1Template != null && this.special == this.special) {
            return 0;
        }
        try {
            ChoiceContainer choiceContainer = null;
            NumericStringContainer numericStringContainer = null;
            PrintStringContainer printStringContainer = null;
            EndContainer endContainer = new EndContainer();
            switch (this.a) {
                case 0: {
                    choiceContainer = new ChoiceContainer(this.special | 0x400001, 0);
                    break;
                }
                case 1: {
                    choiceContainer = new ChoiceContainer(this.special | 0x400002, 0);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    choiceContainer = new ChoiceContainer(this.special, 0);
                }
            }
            if (this.b != null) {
                switch (this.a) {
                    case 0: 
                    case 4: {
                        numericStringContainer = new NumericStringContainer(0, true, 0, this.b, 1, 3);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        numericStringContainer = new NumericStringContainer(0, true, 0, this.b, 1, 16);
                    }
                }
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, numericStringContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
            } else {
                switch (this.a) {
                    case 0: 
                    case 4: {
                        printStringContainer = new PrintStringContainer(0, true, 0, this.c, 1, 2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        printStringContainer = new PrintStringContainer(0, true, 0, this.c, 1, 16);
                    }
                }
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, printStringContainer, endContainer};
                this.asn1Template = new ASN1Template(aSN1ContainerArray);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ORName)) {
            return false;
        }
        ORName oRName = (ORName)object;
        if (this.a != oRName.a) {
            return false;
        }
        if (this.b != null ? !this.b.equals(oRName.b) : oRName.b != null) {
            return false;
        }
        return !(this.c != null ? !this.c.equals(oRName.c) : oRName.c != null);
    }

    public Object clone() throws CloneNotSupportedException {
        ORName oRName = new ORName(this.a);
        if (this.c != null) {
            oRName.c = new String(this.c);
        }
        if (this.b != null) {
            oRName.b = new String(this.b);
        }
        oRName.special = this.special;
        if (this.asn1Template != null) {
            oRName.a();
        }
        return oRName;
    }
}

