/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Date;

public class CertTemplate
implements Cloneable,
Serializable {
    private int a = -1;
    private X500Name b;
    private X500Name c;
    private byte[] d;
    protected byte[] subjectPublicKeyInfo;
    protected byte[] signatureAlgorithmBER;
    private byte[] e;
    private byte[] f;
    private boolean g = false;
    private Date h;
    private Date i;
    private X509V3Extensions j;
    protected int special;
    private ASN1Template k;
    private ASN1Template l;
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected int signatureAlgorithmFormat = -1;

    public CertTemplate() {
    }

    public CertTemplate(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        this.setCertTemplateBER(byArray, n, n2);
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public void setCertTemplateBER(byte[] byArray, int n, int n2) throws CRMFException {
        Cloneable cloneable;
        if (byArray == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(n2);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0x810000);
        IntegerContainer integerContainer2 = new IntegerContainer(0x810001);
        EncodedContainer encodedContainer = new EncodedContainer(8466434);
        EncodedContainer encodedContainer2 = new EncodedContainer(10563587);
        EncodedContainer encodedContainer3 = new EncodedContainer(8466436);
        EncodedContainer encodedContainer4 = new EncodedContainer(10563589);
        EncodedContainer encodedContainer5 = new EncodedContainer(8466438);
        EncodedContainer encodedContainer6 = new EncodedContainer(8454919);
        EncodedContainer encodedContainer7 = new EncodedContainer(8454920);
        EncodedContainer encodedContainer8 = new EncodedContainer(8466441);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, encodedContainer, encodedContainer2, encodedContainer3, encodedContainer4, encodedContainer5, encodedContainer6, encodedContainer7, encodedContainer8, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the cert template info. " + aSN_Exception.getMessage());
        }
        if (integerContainer.dataPresent) {
            this.setVersionNumber(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
        }
        if (integerContainer2.dataPresent) {
            this.setSerialNumber(integerContainer2.data, integerContainer2.dataOffset, integerContainer2.dataLen);
        }
        if (encodedContainer.dataPresent) {
            this.setSignatureAlgorithm(encodedContainer.data, encodedContainer.dataOffset, encodedContainer.dataLen);
        }
        if (encodedContainer2.dataPresent) {
            try {
                cloneable = new X500Name(encodedContainer2.data, encodedContainer2.dataOffset, 10551299);
                this.setIssuerName((X500Name)cloneable);
            }
            catch (NameException nameException) {
                throw new CRMFException("Invalid issuer name: " + nameException.getMessage());
            }
        }
        if (encodedContainer3.dataPresent) {
            this.a(encodedContainer3.data, encodedContainer3.dataOffset);
        }
        if (encodedContainer4.dataPresent) {
            try {
                cloneable = new X500Name(encodedContainer4.data, encodedContainer4.dataOffset, 10551301);
                this.setSubjectName((X500Name)cloneable);
            }
            catch (NameException nameException) {
                throw new CRMFException("Invalid subject name: " + nameException.getMessage());
            }
        }
        if (encodedContainer5.dataPresent) {
            this.setSubjectPublicKey(encodedContainer5.data, encodedContainer5.dataOffset);
        }
        if (encodedContainer6.dataPresent) {
            this.e = new byte[encodedContainer6.dataLen];
            System.arraycopy(encodedContainer6.data, encodedContainer6.dataOffset, this.e, 0, encodedContainer6.dataLen);
        }
        if (encodedContainer7.dataPresent) {
            this.f = new byte[encodedContainer7.dataLen];
            System.arraycopy(encodedContainer7.data, encodedContainer7.dataOffset, this.f, 0, encodedContainer7.dataLen);
        }
        try {
            if (encodedContainer8.dataPresent) {
                cloneable = new X509V3Extensions(encodedContainer8.data, encodedContainer8.dataOffset, 0x800009, 1);
                this.setExtensions((X509V3Extensions)cloneable);
            }
        }
        catch (CertificateException certificateException) {
            throw new CRMFException("Cannot decode extensions. " + certificateException.getMessage());
        }
    }

    protected void setVersionNumber(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 > 4) {
            throw new CRMFException("Invalid Certificate version.");
        }
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 = n3 << 8 | byArray[n] & 0xFF;
        }
        this.a = n3;
    }

    public void setVersion(int n) {
        this.a = n;
    }

    public int getVersion() {
        return this.a;
    }

    public void setSignatureAlgorithm(String string) throws CRMFException {
        if (string == null) {
            throw new CRMFException("Specified SignatureAlgorithm value is null.");
        }
        try {
            String string2 = this.getSignatureFormat(string);
            this.signatureAlgorithmBER = string2 == null ? AlgorithmID.derEncodeAlgID((String)string, (int)1, null, (int)0, (int)0) : AlgorithmID.derEncodeAlgID((String)string2, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot set, unknown algorithm." + aSN_Exception.getMessage());
        }
    }

    public void setSignatureAlgorithm(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 == 0) {
            throw new CRMFException("Signature Algorithm is null.");
        }
        try {
            this.signatureAlgorithmBER = new byte[n2];
            byArray[n] = 48;
            System.arraycopy(byArray, n, this.signatureAlgorithmBER, 0, n2);
            String string = AlgorithmID.berDecodeAlgID((byte[])byArray, (int)n, (int)1, null);
            if (string == null) {
                throw new CRMFException("Cannot recognize the signature algorithm.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public void setSignatureStandard(int n) {
        this.signatureAlgorithmFormat = n;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat(String string) {
        if (string == null) {
            return null;
        }
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                if (string.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1PKCS";
                }
                return null;
            }
            case 1: {
                if (string.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1ISO_OIW";
                }
                return null;
            }
            case 2: {
                if (string.equals("SHA1/DSA") || string.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X930";
                }
                return null;
            }
            case 3: {
                if (string.equals("SHA1/DSA") || string.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X957";
                }
                return null;
            }
        }
        if (string.equals("SHA1/DSA")) {
            return "SHA1/DSA/NoPad";
        }
        return null;
    }

    public int getDERLen(int n) throws CRMFException {
        return this.a(n);
    }

    private int a(int n) throws CRMFException {
        this.special = n;
        byte[] byArray = null;
        int n2 = 0;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
            EndContainer endContainer = new EndContainer();
            boolean bl = false;
            if (this.a != -1) {
                bl = true;
            }
            IntegerContainer integerContainer = new IntegerContainer(0x810000, bl, 0, this.a);
            IntegerContainer integerContainer2 = null;
            integerContainer2 = this.d == null ? new IntegerContainer(0x810001, false, 0, 0) : ((this.d[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0x810001, true, 0, this.d, 0, this.d.length, true) : new IntegerContainer(0x810001, true, 0, this.d, 0, this.d.length, false));
            if (this.signatureAlgorithmBER == null) {
                bl = false;
                n2 = 0;
            } else {
                bl = true;
                n2 = this.signatureAlgorithmBER.length;
                this.signatureAlgorithmBER[0] = -94;
            }
            EncodedContainer encodedContainer = new EncodedContainer(8466434, bl, 0, this.signatureAlgorithmBER, 0, n2);
            if (this.h == null && this.i == null) {
                bl = false;
                n2 = 0;
            } else {
                n2 = this.b(8454148);
                bl = true;
                byArray = new byte[n2];
                n2 = this.a(byArray, 0, 8454148);
            }
            EncodedContainer encodedContainer2 = new EncodedContainer(8466436, bl, 0, byArray, 0, n2);
            if (this.subjectPublicKeyInfo != null) {
                bl = true;
                this.subjectPublicKeyInfo[0] = -90;
                n2 = this.subjectPublicKeyInfo.length;
            } else {
                bl = false;
                n2 = 0;
            }
            EncodedContainer encodedContainer3 = new EncodedContainer(8466438, bl, 0, this.subjectPublicKeyInfo, 0, n2);
            try {
                if (this.c != null) {
                    n2 = this.c.getDERLen(10551299);
                    byArray = new byte[n2];
                    n2 = this.c.getDEREncoding(byArray, 0, 10551299);
                    bl = true;
                } else {
                    bl = false;
                    n2 = 0;
                }
            }
            catch (NameException nameException) {
                throw new CRMFException(nameException.getMessage());
            }
            EncodedContainer encodedContainer4 = new EncodedContainer(10563587, bl, 0, byArray, 0, n2);
            try {
                if (this.b != null) {
                    n2 = this.b.getDERLen(10551301);
                    byArray = new byte[n2];
                    n2 = this.b.getDEREncoding(byArray, 0, 10551301);
                    bl = true;
                } else {
                    bl = false;
                    n2 = 0;
                }
            }
            catch (NameException nameException) {
                throw new CRMFException(nameException.getMessage());
            }
            EncodedContainer encodedContainer5 = new EncodedContainer(10563589, bl, 0, byArray, 0, n2);
            if (this.e != null) {
                bl = true;
                n2 = this.e.length;
            } else {
                bl = false;
                n2 = 0;
            }
            EncodedContainer encodedContainer6 = new EncodedContainer(8454919, bl, 0, this.e, 0, n2);
            if (this.f != null) {
                bl = true;
                n2 = this.f.length;
            } else {
                bl = false;
                n2 = 0;
            }
            EncodedContainer encodedContainer7 = new EncodedContainer(8454920, bl, 0, this.f, 0, n2);
            if (this.j != null) {
                n2 = this.j.getDERLen(8466441);
                bl = true;
                byArray = new byte[n2];
                n2 = this.j.getDEREncoding(byArray, 0, 8466441);
            } else {
                bl = false;
                n2 = 0;
            }
            EncodedContainer encodedContainer8 = new EncodedContainer(8466441, bl, 0, byArray, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, encodedContainer, encodedContainer4, encodedContainer2, encodedContainer5, encodedContainer3, encodedContainer6, encodedContainer7, encodedContainer8, endContainer};
            this.k = new ASN1Template(aSN1ContainerArray);
            return this.k.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed array is null in the cert template ");
        }
        int n3 = 0;
        try {
            if (this.k == null && (n3 = this.a(n2)) == 0) {
                throw new CRMFException("Cannot encode cert template, information missing.");
            }
            n3 = this.k.derEncode(byArray, n);
            this.k = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.k = null;
            throw new CRMFException("Could not encode the cert template: " + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int b(int n) throws CRMFException {
        SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
        EndContainer endContainer = new EndContainer();
        GenTimeContainer genTimeContainer = null;
        GenTimeContainer genTimeContainer2 = null;
        if (this.h == null && this.i == null) {
            throw new CRMFException("Validity dates are not set.");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.h != null) {
            bl = true;
        }
        if (this.i != null) {
            bl2 = true;
        }
        if (this.g) {
            genTimeContainer = new GenTimeContainer(0xA10000, bl, 0, this.h);
            genTimeContainer2 = new GenTimeContainer(0xA10001, bl2, 0, this.i);
        } else {
            genTimeContainer = new UTCTimeContainer(0xA10000, bl, 0, this.h);
            genTimeContainer2 = new UTCTimeContainer(0xA10001, bl2, 0, this.i);
        }
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, genTimeContainer2, endContainer};
        this.l = new ASN1Template(aSN1ContainerArray);
        try {
            return this.l.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    public Date getStartDate() {
        if (this.h == null) {
            return null;
        }
        return new Date(this.h.getTime());
    }

    public Date getEndDate() {
        if (this.i == null) {
            return null;
        }
        return new Date(this.i.getTime());
    }

    public void setTimeType(boolean bl) {
        this.g = bl;
    }

    private int a(byte[] byArray, int n, int n2) throws CRMFException {
        if (this.l == null && this.b(n2) == 0) {
            return 0;
        }
        try {
            int n3 = this.l.derEncode(byArray, n);
            this.l = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.l = null;
            throw new CRMFException(aSN_Exception.getMessage());
        }
    }

    private void a(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("The cert template encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(8454148);
        EndContainer endContainer = new EndContainer();
        ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000);
        ChoiceContainer choiceContainer2 = new ChoiceContainer(0xA10001);
        UTCTimeContainer uTCTimeContainer = new UTCTimeContainer(0);
        UTCTimeContainer uTCTimeContainer2 = new UTCTimeContainer(0);
        GenTimeContainer genTimeContainer = new GenTimeContainer(0);
        GenTimeContainer genTimeContainer2 = new GenTimeContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, uTCTimeContainer, genTimeContainer, endContainer, choiceContainer2, uTCTimeContainer2, genTimeContainer2, endContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot extract Validity. " + aSN_Exception.getMessage());
        }
        Date date = genTimeContainer.theTime;
        if (!genTimeContainer.dataPresent) {
            date = uTCTimeContainer.theTime;
        } else {
            this.g = true;
        }
        Date date2 = genTimeContainer2.theTime;
        if (!genTimeContainer2.dataPresent) {
            date2 = uTCTimeContainer2.theTime;
        } else {
            this.g = true;
        }
        this.setValidity(date, date2);
    }

    public void setValidity(Date date, Date date2) throws CRMFException {
        if (date == null && date2 == null) {
            throw new CRMFException("Cannot set the validity with the NULL dates.");
        }
        if (date != null) {
            this.h = new Date(date.getTime());
        }
        if (date2 != null) {
            this.i = new Date(date2.getTime());
        }
        if (this.i != null && this.h != null && !this.i.after(this.h)) {
            throw new CRMFException("Cannot set the validity with the given dates.");
        }
    }

    public void setSerialNumber(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 == 0) {
            throw new CRMFException("Passed in SerialNumber value is null.");
        }
        this.d = new byte[n2];
        System.arraycopy(byArray, n, this.d, 0, n2);
    }

    public byte[] getSerialNumber() {
        if (this.d == null) {
            return null;
        }
        return (byte[])this.d.clone();
    }

    public void setIssuerName(X500Name x500Name) throws CRMFException {
        if (x500Name == null) {
            throw new CRMFException("Passed in IssuerName value is null.");
        }
        try {
            this.c = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Cannot set the cert template with the given issuerName." + cloneNotSupportedException.getMessage());
        }
    }

    public X500Name getIssuerName() {
        if (this.c == null) {
            return null;
        }
        try {
            return (X500Name)this.c.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setSubjectName(X500Name x500Name) throws CRMFException {
        if (x500Name == null) {
            throw new CRMFException("Passed in SubjectName value is null.");
        }
        try {
            this.b = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Cannot set the cert template with the given subjectName." + cloneNotSupportedException.getMessage());
        }
    }

    public X500Name getSubjectName() {
        if (this.b == null) {
            return null;
        }
        try {
            return (X500Name)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setIssuerUniqueID(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 == 0) {
            throw new CRMFException("Passed in IssuerUniqueID value is null.");
        }
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0x800007, true, 0, byArray, n, n2, n2 * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.e = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot set issuerUniqueID: " + aSN_Exception.getMessage());
        }
    }

    public byte[] getIssuerUniqueID() {
        if (this.e == null) {
            return null;
        }
        int n = 0;
        try {
            n = 2 + ASN1Lengths.determineLengthLen((byte[])this.e, (int)1);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
        byte[] byArray = new byte[this.e.length - n];
        System.arraycopy(this.e, n, byArray, 0, byArray.length);
        return byArray;
    }

    public void setSubjectUniqueID(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 == 0) {
            throw new CRMFException("Passed in SubjectUniqueID value is null.");
        }
        try {
            BitStringContainer bitStringContainer = new BitStringContainer(0x800008, true, 0, byArray, n, n2, n2 * 8, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{bitStringContainer};
            this.f = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot set subjectUniqueID: " + aSN_Exception.getMessage());
        }
    }

    public byte[] getSubjectUniqueID() {
        if (this.f == null) {
            return null;
        }
        int n = 0;
        try {
            n = 2 + ASN1Lengths.determineLengthLen((byte[])this.f, (int)1);
        }
        catch (ASN_Exception aSN_Exception) {
            return null;
        }
        byte[] byArray = new byte[this.f.length - n];
        System.arraycopy(this.f, n, byArray, 0, byArray.length);
        return byArray;
    }

    public String getSignatureAlgorithm() throws CRMFException {
        try {
            if (this.signatureAlgorithmBER == null) {
                throw new CRMFException("Object not set with signature algorithm.");
            }
            this.signatureAlgorithmBER[0] = 48;
            return AlgorithmID.berDecodeAlgID((byte[])this.signatureAlgorithmBER, (int)0, (int)1, null);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Invalid Signature Algorithm." + aSN_Exception.getMessage());
        }
    }

    public byte[] getSignatureAlgorithmDER() throws CRMFException {
        if (this.signatureAlgorithmBER == null) {
            throw new CRMFException("Object not set with signature algorithm.");
        }
        this.signatureAlgorithmBER[0] = 48;
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CRMFException {
        if (jSAFE_PublicKey == null) {
            throw new CRMFException("Public key is null.");
        }
        try {
            String string = null;
            string = jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.subjectPublicKeyInfo = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key. " + jSAFE_Exception.getMessage());
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Public key encoding is null.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            byArray[n] = 48;
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])byArray, (int)n, (String)"Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key. " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            this.subjectPublicKeyInfo[0] = 48;
            return JSAFE_PublicKey.getInstance((byte[])this.subjectPublicKeyInfo, (int)0, (String)"Java");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Cannot retrieve the public key: " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        this.subjectPublicKeyInfo[0] = 48;
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    public void setExtensions(X509V3Extensions x509V3Extensions) throws CRMFException {
        try {
            if (x509V3Extensions == null) {
                throw new CRMFException("Extensions are null.");
            }
            if (x509V3Extensions.getExtensionsType() != 1) {
                throw new CRMFException("Wrong extensions type: should be Cert extensions.");
            }
            this.j = (X509V3Extensions)x509V3Extensions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException("Cannot set the cert with the given extensions." + cloneNotSupportedException.getMessage());
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.j == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.j.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CertTemplate)) {
            return false;
        }
        CertTemplate certTemplate = (CertTemplate)object;
        try {
            int n = this.getDERLen(0);
            int n2 = certTemplate.getDERLen(0);
            if (n != n2) {
                return false;
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n2];
            n = this.getDEREncoding(byArray, 0, 0);
            if (n != (n2 = certTemplate.getDEREncoding(byArray2, 0, 0))) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (CRMFException cRMFException) {
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        CertTemplate certTemplate = (CertTemplate)super.clone();
        if (this.subjectPublicKeyInfo != null) {
            certTemplate.subjectPublicKeyInfo = (byte[])this.subjectPublicKeyInfo.clone();
        }
        if (this.signatureAlgorithmBER != null) {
            certTemplate.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        certTemplate.a = this.a;
        certTemplate.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        if (this.b != null) {
            certTemplate.b = (X500Name)this.b.clone();
        }
        if (this.c != null) {
            certTemplate.c = (X500Name)this.c.clone();
        }
        if (this.d != null) {
            certTemplate.d = (byte[])this.d.clone();
        }
        if (this.e != null) {
            certTemplate.e = (byte[])this.e.clone();
        }
        if (this.f != null) {
            certTemplate.f = (byte[])this.f.clone();
        }
        certTemplate.g = this.g;
        if (this.h != null) {
            certTemplate.h = new Date(this.h.getTime());
        }
        if (this.i != null) {
            certTemplate.i = new Date(this.i.getTime());
        }
        if (this.j != null) {
            certTemplate.j = (X509V3Extensions)this.j.clone();
        }
        certTemplate.special = this.special;
        try {
            if (this.k != null) {
                certTemplate.a(this.special);
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return certTemplate;
    }
}

