/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.provider.pki.HTTPResult;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.pki.PKITransportException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class TransportImplementation
extends ProviderImplementation {
    public static final String MIME_CONTENT_TYPE_PREFIX = "Content-type: ";
    public static final String MIME_CONTENT_LENGTH_PREFIX = "Content-length: ";
    protected static final String MIME_USER_AGENT_STRING = "User-Agent: Cert-J/2.0";
    protected static final String HTTP_HEADER_CACHE_CONTROL_NO_CACHE = "Cache-Control: no-cache";
    protected static final String HTTP_HEADER_PRAGMA_NO_CACHE = "Pragma: no-cache";
    private static final int a = 80;
    private static final int b = 30000;
    private static final char c = '\r';
    private static final char d = '\n';
    private static final String e = "\r\n";
    protected String[] destList;
    protected String[] proxyList;
    protected String profile;
    protected int timeoutSecs;
    protected String host;
    protected int port;
    protected Socket socket = null;
    private String f = null;
    protected boolean closeConnection = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket a(String string, int n, int n2) throws InterruptedIOException, IOException {
        MakeSocketThr makeSocketThr = new MakeSocketThr(string, n);
        Object object = makeSocketThr.lock;
        synchronized (object) {
            makeSocketThr.start();
            try {
                makeSocketThr.lock.wait(n2);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (makeSocketThr.socket != null) {
            return makeSocketThr.socket;
        }
        if (makeSocketThr.exception != null) {
            throw makeSocketThr.exception;
        }
        makeSocketThr.interrupt();
        throw new InterruptedIOException("connect timed out");
    }

    public TransportImplementation(CertJ certJ, String string) throws InvalidParameterException {
        super(certJ, string);
    }

    public synchronized void unregister() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PKIResult sendAndReceiveHttp(URL uRL, String[] stringArray, String[] stringArray2, byte[] byArray, String[] stringArray3) throws PKIException {
        int n;
        Object object;
        HTTPResult hTTPResult = this.http("POST", uRL, stringArray2, stringArray, byArray);
        String[] stringArray4 = hTTPResult.getHeaders();
        int n2 = hTTPResult.getStatus();
        int n3 = this.a(n2);
        int n4 = this.b(n2);
        if (n3 == 0) {
            object = null;
            for (n = 0; n < stringArray4.length; ++n) {
                String string = stringArray4[n];
                int n5 = MIME_CONTENT_TYPE_PREFIX.length();
                if (string.length() <= n5 || !MIME_CONTENT_TYPE_PREFIX.equalsIgnoreCase(string.substring(0, n5))) continue;
                object = string;
                break;
            }
            if (object == null) {
                throw new PKIException("TransportImplementation.sendAndReceiveHttp: no Content-type found.");
            }
            n = 0;
            for (int i = 0; i < stringArray3.length; ++i) {
                String string = stringArray3[i];
                if (((String)object).length() < string.length() || !string.equalsIgnoreCase(((String)object).substring(0, string.length()))) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                n3 = 2;
                n4 = 0x200000;
            }
        }
        if (n3 != 0 && hTTPResult.getMessage().length > 0) {
            object = stringArray4;
            n = ((String[])object).length;
            stringArray4 = new String[n + 2];
            System.arraycopy(object, 0, stringArray4, 0, n);
            stringArray4[n] = null;
            stringArray4[n + 1] = new String(hTTPResult.getMessage());
        }
        return new PKIResult(new PKIStatusInfo(n3, n4, stringArray4, n2), hTTPResult.getMessage());
    }

    public synchronized HTTPResult http(String string, URL uRL, String[] stringArray, String[] stringArray2, byte[] byArray) throws PKIException {
        if (this.socket != null) {
            return this.a(string, stringArray2, byArray);
        }
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (n > 0) {
            String string2 = uRL.getHost();
            int n2 = uRL.getPort();
            for (int i = 0; i < n; ++i) {
                URL uRL2;
                String string3 = null;
                try {
                    string3 = stringArray[i];
                    uRL2 = new URL(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new PKIException("TransportImplementation.http: unable to parse proxy specification" + string3 + "(" + malformedURLException.getMessage() + ").");
                }
                try {
                    this.host = uRL2.getHost();
                    this.port = uRL2.getPort();
                    String string4 = ":" + (n2 <= 0 ? 80 : n2);
                    this.f = "http://" + string2 + string4 + this.b(uRL);
                    return this.a(string, stringArray2, byArray);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            throw new PKIException("TransportImplementation.http: no proxy succeeds.");
        }
        this.host = uRL.getHost();
        this.port = this.a(uRL);
        this.f = this.b(uRL);
        return this.a(string, stringArray2, byArray);
    }

    private int a(int n) {
        if (n >= 200 && n < 300) {
            return 0;
        }
        return 2;
    }

    private int b(int n) {
        if (n < 200) {
            return 0x200000;
        }
        if (n >= 200 && n < 300) {
            return 0;
        }
        if (n >= 300 && n < 400) {
            return 0x200000;
        }
        if (n >= 400 && n < 500) {
            return 0x20000000;
        }
        if (n >= 500 && n < 600) {
            return 0x100000;
        }
        return 0x200000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HTTPResult a(String string, String[] stringArray, byte[] byArray) throws PKIException {
        int n;
        int n2;
        byte[] byArray2;
        byte[] byArray3;
        block19: {
            Object object;
            if (string == null) throw new PKIException("TransportImplementation.httpSend: only POST is supported.");
            if (!string.equalsIgnoreCase("POST")) {
                throw new PKIException("TransportImplementation.httpSend: only POST is supported.");
            }
            StringBuffer stringBuffer = new StringBuffer(string + " " + this.f + " HTTP/1.0" + e);
            int n3 = 0;
            if (stringArray != null) {
                n3 = stringArray.length;
            }
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                object = stringArray[i];
                if (((String)object).length() >= MIME_CONTENT_TYPE_PREFIX.length() && MIME_CONTENT_TYPE_PREFIX.equalsIgnoreCase(((String)object).substring(0, MIME_CONTENT_TYPE_PREFIX.length()))) {
                    bl = true;
                }
                if (((String)object).length() >= MIME_CONTENT_LENGTH_PREFIX.length() && MIME_CONTENT_LENGTH_PREFIX.equalsIgnoreCase(((String)object).substring(0, MIME_CONTENT_LENGTH_PREFIX.length()))) {
                    throw new PKIException("TransportImplementation.httpSend: found Content-Length.");
                }
                stringBuffer.append((String)object + e);
            }
            if (!bl) {
                throw new PKIException("TransportImplementation.httpSend: Content-Type not found.");
            }
            stringBuffer.append(MIME_CONTENT_LENGTH_PREFIX + byArray.length + e + e);
            byArray3 = null;
            try {
                this.openSocketIfNecessary();
                object = new String(stringBuffer).getBytes();
                byArray3 = this.a((byte[])object, byArray, true);
                byArray2 = null;
                if (this.socket == null || !this.closeConnection) break block19;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (this.socket == null) throw throwable;
                if (!this.closeConnection) throw throwable;
                try {
                    this.socket.close();
                    this.socket = null;
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new PKITransportException("TransportImplementation.httpSend: unable to close a socket(" + iOException.getMessage() + ").");
                }
            }
            try {}
            catch (IOException iOException) {
                throw new PKITransportException("TransportImplementation.httpSend: unable to close a socket(" + iOException.getMessage() + ").");
            }
            this.socket.close();
            this.socket = null;
        }
        int n4 = this.a(byArray3);
        String string2 = new String(byArray3, 0, n4);
        byArray2 = new byte[byArray3.length - n4];
        System.arraycopy(byArray3, n4, byArray2, 0, byArray3.length - n4);
        Vector<String> vector = new Vector<String>();
        int n5 = 0;
        boolean bl = false;
        block10: for (n2 = 0; n2 < string2.length(); ++n2) {
            n = string2.charAt(n2);
            switch (n) {
                case 13: {
                    bl = true;
                    continue block10;
                }
                case 10: {
                    if (bl) {
                        vector.addElement(string2.substring(n5, n2 - 1));
                        n5 = n2 + 1;
                    }
                    bl = false;
                    continue block10;
                }
                default: {
                    bl = false;
                }
            }
        }
        n2 = vector.size();
        if (n2 == 0) {
            throw new PKIException("TransportImplementation.httpSend: no headers received.");
        }
        n = this.a((String)vector.elementAt(0));
        String[] stringArray2 = new String[n2 - 1];
        int n6 = 1;
        while (n6 < n2) {
            stringArray2[n6 - 1] = (String)vector.elementAt(n6);
            ++n6;
        }
        return new HTTPResult(n, stringArray2, byArray2);
    }

    private byte[] a(byte[] byArray, byte[] byArray2, boolean bl) throws PKITransportException {
        try {
            this.writeToSocket(byArray);
            this.writeToSocket(byArray2, 0, byArray2.length);
            byte[] byArray3 = this.a();
            if (bl && byArray3.length == 0) {
                this.openSocket();
                return this.a(byArray, byArray2, false);
            }
            return byArray3;
        }
        catch (IOException iOException) {
            if (bl) {
                this.openSocket();
                return this.a(byArray, byArray2, false);
            }
            throw new PKITransportException("TransportImplementation.httpTrasfer: socket I/O faild(" + iOException.getMessage() + ").");
        }
    }

    protected void openSocket() throws PKITransportException {
        try {
            this.socket = this.timeoutSecs >= 0 ? this.a(this.host, this.port, this.timeoutSecs * 1000) : new Socket(this.host, this.port);
            if (this.timeoutSecs >= 0) {
                this.socket.setSoTimeout(this.timeoutSecs * 1000);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new PKITransportException("TransportImplementation.openSocket: unknown host(" + this.host + ")" + unknownHostException.getMessage());
        }
        catch (SocketException socketException) {
            throw new PKITransportException("TransportImplementation.openSocket: socket operation failed(" + socketException.getMessage() + ").");
        }
        catch (IOException iOException) {
            throw new PKITransportException("TransportImplementation.openSocket: IO operation failed(" + iOException.getMessage() + ").");
        }
    }

    protected void writeToSocket(byte[] byArray) throws PKITransportException, IOException {
        this.writeToSocket(byArray, 0, byArray.length);
    }

    protected void writeToSocket(byte[] byArray, int n, int n2) throws PKITransportException, IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(byArray, n, n2);
        outputStream.flush();
    }

    private byte[] a() throws IOException {
        int n;
        byte[] byArray;
        byte[] byArray2 = new byte[30000];
        byte[] byArray3 = byArray = new byte[0];
        InputStream inputStream = this.socket.getInputStream();
        while ((n = inputStream.read(byArray2)) >= 0) {
            byArray3 = new byte[byArray.length + n];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, n);
            byArray = byArray3;
        }
        return byArray3;
    }

    private int a(byte[] byArray) throws PKIException {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 13: {
                    if (n != 0 && n != 2) break;
                    ++n;
                    break;
                }
                case 10: {
                    if (n != 1 && n != 3) break;
                    ++n;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            if (n != 4) continue;
            return i + 1;
        }
        throw new PKIException("TransportImplementation.getHTTPHeaderLen: HTTP header not found.");
    }

    private int a(URL uRL) throws PKIException {
        int n = uRL.getPort();
        if (n != -1) {
            return n;
        }
        if (uRL.getProtocol().equalsIgnoreCase("http")) {
            return 80;
        }
        throw new PKIException("TransportImplementation.getPort: make sure to specify the port number for URLs.");
    }

    private String b(URL uRL) {
        String string = uRL.getFile();
        if (string == null || string.equals("")) {
            return "/";
        }
        return string;
    }

    private int a(String string) throws PKIException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        if (n < 2) {
            throw new PKIException("PKICommonImplementation.findStatusNumber: invalid status line.");
        }
        String string2 = stringTokenizer.nextToken();
        string2 = stringTokenizer.nextToken();
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c < '0' || c > '9') {
                throw new PKIException("PKICommonImplementation.findStatusNumber: non-decimal digit found in status code.");
            }
            n2 = n2 * 10 + c - 48;
        }
        return n2;
    }

    protected void openSocketIfNecessary() throws PKITransportException {
        if (this.socket == null) {
            this.openSocket();
        }
    }

    public String getName() {
        return super.getName();
    }

    static class MakeSocketThr
    extends Thread {
        public Object lock = null;
        public Socket socket = null;
        public IOException exception = null;
        private String a = null;
        private int b = 0;

        public MakeSocketThr(String string, int n) {
            this.a = string;
            this.b = n;
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket = null;
            try {
                socket = new Socket(this.a, this.b);
            }
            catch (IOException iOException) {
                if (Thread.interrupted()) {
                    return;
                }
                this.exception = iOException;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notify();
                }
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.socket = socket;
                this.lock.notify();
            }
        }
    }
}

