/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.path.CertPathCommon;
import com.rsa.certj.provider.path.Cq;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import java.util.Vector;

public final class X509V1CertPath
extends Provider {
    public X509V1CertPath(String string) throws InvalidParameterException {
        super(3, string);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("X509V1CertPath.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private final class Implementation
    extends CertPathCommon {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        protected void getNextCertCandidates(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
            X500Name x500Name = null;
            if (object instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)object;
                x500Name = x509Certificate.getIssuerName();
            } else if (object instanceof X509CRL) {
                X509CRL x509CRL = (X509CRL)object;
                x500Name = x509CRL.getIssuerName();
            } else {
                throw new CertPathException("X509V1CertPath$Implementation.getNextCertCandidates: does not support startObjects other than X509Certificate or X509CRL.");
            }
            this.findCertBySubject(certPathCtx, x500Name, vector);
        }

        protected boolean verifyPath(CertPathCtx certPathCtx, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
            Vector vector5 = vector2 == null ? null : new Vector();
            Vector vector6 = vector3 == null ? null : new Vector();
            int n = vector.size() - 1;
            while (n > 0) {
                X509Certificate x509Certificate;
                if (!this.verifyRevocation(certPathCtx, x509Certificate = (X509Certificate)vector.elementAt(--n), vector5, vector6)) {
                    return false;
                }
                X509Certificate x509Certificate2 = x509Certificate;
            }
            CertJUtils.mergeLists(vector2, vector5);
            CertJUtils.mergeLists(vector3, vector6);
            return true;
        }

        public String toString() {
            return "X509V1 Certification Path provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cq cq) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

