/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.TransportImplementation;
import com.rsa.certj.provider.pki.URLDecoder;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIRequestMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class PKICommonImplementation
extends TransportImplementation {
    private static final char a = '\r';
    private static final char b = '\n';

    protected PKICommonImplementation(CertJ certJ, String string) throws InvalidParameterException {
        super(certJ, string);
    }

    public String urlEncodeRegInfo(Properties properties) {
        if (properties == null) {
            return null;
        }
        int n = ((Hashtable)properties).size();
        Enumeration<?> enumeration = properties.propertyNames();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = (String)enumeration.nextElement();
            int n3 = 0;
            int n4 = i - 1;
            while (n4 >= n3) {
                n2 = (n3 + n4) / 2;
                int n5 = string.compareTo(stringArray[n2]);
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            for (n2 = i - 1; n2 >= n3; --n2) {
                stringArray[n2 + 1] = stringArray[n2];
            }
            stringArray[n3] = string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            stringBuffer.append(URLEncoder.encode(string));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(properties.getProperty(string)));
            stringBuffer.append('&');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public Properties urlDecodeRegInfo(String string) throws PKIException {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: no property found.");
            }
            String string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: property does not conform to the valid format (name=value).");
            }
            try {
                ((Hashtable)properties).put(URLDecoder.decode(string3), URLDecoder.decode(string4));
            }
            catch (Exception exception) {
                throw new PKIException("PKICommonImplementation.urlDecodeRegInfo: error in URL-decoding(" + exception.getMessage() + ").");
            }
        }
        return properties;
    }

    protected Certificate findCertificateReturned(PKIRequestMessage pKIRequestMessage, PKIResponseMessage pKIResponseMessage) throws PKIException {
        try {
            Certificate certificate = pKIRequestMessage.getCertificateTemplate();
            if (certificate == null) {
                return null;
            }
            JSAFE_PublicKey jSAFE_PublicKey = certificate.getSubjectPublicKey(this.certJ.getDevice());
            Certificate[] certificateArray = pKIResponseMessage.getExtraCerts();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
                    if (!jSAFE_PublicKey.equals(x509Certificate.getSubjectPublicKey(this.certJ.getDevice()))) continue;
                    return x509Certificate;
                }
            }
            return null;
        }
        catch (CertificateException certificateException) {
            throw new PKIException("PKICommonImplementation.findCertificateReturned: " + certificateException.getMessage());
        }
    }

    protected void disperseCertsAndCRLs(PKIResponseMessage pKIResponseMessage, DatabaseService databaseService) throws PKIException {
        try {
            CRL[] cRLArray;
            Certificate[] certificateArray = pKIResponseMessage.getExtraCerts();
            if (certificateArray != null) {
                databaseService.insertCertificates(certificateArray);
            }
            if ((cRLArray = pKIResponseMessage.getExtraCRLs()) != null) {
                databaseService.insertCRLs(pKIResponseMessage.getExtraCRLs());
            }
        }
        catch (NoServiceException noServiceException) {
            throw new PKIException("PKICommonImplementation.disperseCertsAndCRLs: " + noServiceException.getMessage());
        }
        catch (DatabaseException databaseException) {
            throw new PKIException("PKICommonImplementation.disperseCertsAndCRLs: " + databaseException.getMessage());
        }
    }

    private int a(int n) {
        if (n >= 200 && n < 300) {
            return 0;
        }
        return 2;
    }

    protected void loadConfig(Hashtable hashtable) throws PKIException {
        Vector vector = (Vector)hashtable.get("dest");
        if (vector == null) {
            this.destList = new String[0];
        } else {
            this.destList = new String[vector.size()];
            vector.copyInto(this.destList);
        }
        vector = (Vector)hashtable.get("http.proxy");
        if (vector == null) {
            this.proxyList = new String[0];
        } else {
            this.proxyList = new String[vector.size()];
            vector.copyInto(this.proxyList);
        }
        vector = (Vector)hashtable.get("profile");
        this.profile = vector == null || vector.size() == 0 ? null : (String)vector.elementAt(0);
        vector = (Vector)hashtable.get("timeoutSecs");
        if (vector == null || vector.size() == 0) {
            this.timeoutSecs = -1;
        } else {
            String string = (String)vector.elementAt(0);
            this.timeoutSecs = 0;
            for (int i = 0; i < string.length(); ++i) {
                int n = Character.digit(string.charAt(i), 10);
                if (n == -1) {
                    throw new PKIException("PKICommonImplementation.PKICommonImplementation: non-numeric character used in timeoutSecs.");
                }
                this.timeoutSecs = this.timeoutSecs * 10 + n;
            }
        }
    }

    public static Hashtable loadProperties(InputStream inputStream) throws InvalidParameterException {
        String string;
        Hashtable hashtable = new Hashtable();
        while ((string = PKICommonImplementation.a(inputStream)) != null) {
            int n = string.length();
            int n2 = string.indexOf(61, 0);
            if (n2 < 0 || n2 == n) continue;
            String string2 = PKICommonImplementation.a(string.substring(0, n2));
            Vector<String> vector = (Vector<String>)hashtable.get(string2);
            if (vector == null) {
                vector = new Vector<String>();
                hashtable.put(string2, vector);
            }
            String string3 = string.substring(n2 + 1, n);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(PKICommonImplementation.a(stringTokenizer.nextToken()));
            }
        }
        return hashtable;
    }

    private static String a(InputStream inputStream) throws InvalidParameterException {
        StringBuffer stringBuffer;
        try {
            int n = inputStream.read();
            if (n == -1) {
                return null;
            }
            stringBuffer = new StringBuffer();
            while (n != -1 && n != 10) {
                if (n != 13) {
                    stringBuffer.append((char)n);
                }
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            throw new InvalidParameterException("PKICommonImplementation.readLine: reading from " + inputStream.toString() + " failed(" + iOException.getMessage() + ").");
        }
        return stringBuffer.toString();
    }

    private static String a(String string) {
        int n = 0;
        int n2 = string.length();
        while (string.charAt(n) == ' ') {
            ++n;
        }
        while (string.charAt(n2 - 1) == ' ') {
            --n2;
        }
        return string.substring(n, n2);
    }
}

