/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertReqMessages;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.crmf.Controls;
import com.rsa.certj.crmf.POPOPrivKey;
import com.rsa.certj.crmf.POPOSigningKeyInput;
import com.rsa.certj.crmf.ProofOfPossession;
import com.rsa.certj.crmf.RegInfo;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoNonSignature;
import com.rsa.certj.provider.pki.cmp.CMPPOPGenerationInfoSignature;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import java.security.SecureRandom;
import java.util.Date;

public abstract class CMPCertRequestCommon
extends CMPRequestCommon {
    protected Controls controls = null;
    protected CertTemplate certTemplate = null;
    private CertRequest a = null;
    private ProofOfPossession b;

    protected CMPCertRequestCommon(int n, CertTemplate certTemplate, Controls controls) throws InvalidParameterException {
        super(n, null);
        if (certTemplate == null) {
            throw new InvalidParameterException("CMPCertRequestCommon.CMPCertRequestCommon: certTemplate should not be null.");
        }
        this.certTemplate = certTemplate;
        this.controls = controls;
    }

    protected CMPCertRequestCommon(int n, CertTemplate certTemplate, Control control) throws InvalidParameterException {
        super(n, null);
        if (certTemplate == null) {
            throw new InvalidParameterException("CMPCertRequestCommon.CMPCertRequestCommon: certTemplate should not be null.");
        }
        this.certTemplate = certTemplate;
        if (control != null) {
            try {
                Controls controls = new Controls();
                controls.addControl(control);
                this.controls = controls;
            }
            catch (CRMFException cRMFException) {
                throw new InvalidParameterException("CMPCertRequestCommon:CMPCertRequestCommon: creation of Controls object failed(" + cRMFException.getMessage() + ").");
            }
        }
    }

    public Certificate getCertificateTemplate() {
        try {
            X509V3Extensions x509V3Extensions;
            byte[] byArray;
            JSAFE_PublicKey jSAFE_PublicKey;
            X500Name x500Name;
            X509Certificate x509Certificate = new X509Certificate();
            byte[] byArray2 = this.certTemplate.getSerialNumber();
            if (byArray2 != null && byArray2.length > 0) {
                x509Certificate.setSerialNumber(byArray2, 0, byArray2.length);
            }
            if ((x500Name = this.certTemplate.getIssuerName()) != null) {
                x509Certificate.setIssuerName(x500Name);
            }
            Date date = this.certTemplate.getStartDate();
            Date date2 = this.certTemplate.getEndDate();
            if (date != null && date2 != null) {
                x509Certificate.setValidity(date, date2);
            }
            if ((x500Name = this.certTemplate.getSubjectName()) != null) {
                x509Certificate.setSubjectName(x500Name);
            }
            if ((jSAFE_PublicKey = this.certTemplate.getSubjectPublicKey()) != null) {
                x509Certificate.setSubjectPublicKey(jSAFE_PublicKey);
            }
            if ((byArray = this.certTemplate.getIssuerUniqueID()) != null) {
                x509Certificate.setIssuerUniqueID(byArray, 0, byArray.length);
            }
            if ((byArray = this.certTemplate.getSubjectUniqueID()) != null) {
                x509Certificate.setSubjectUniqueID(byArray, 0, byArray.length);
            }
            if ((x509V3Extensions = this.certTemplate.getExtensions()) != null) {
                x509Certificate.setExtensions(x509V3Extensions);
            }
            return x509Certificate;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected CertTemplate getCertTemplate() {
        return this.certTemplate;
    }

    protected byte[] derEncodeBody(CertJ certJ) throws CMPException {
        int n = this.getMessageType();
        try {
            if (this.certTemplate.getSubjectPublicKey() != null && this.b == null) {
                throw new CMPException("CMPCertRequestCommon.derEncode: pop has not been set. Use generateProofOfPossession method to create pop.");
            }
            RegInfo regInfo = CMP.convertRegInfo(this.getRegInfo());
            if (this.a == null) {
                this.a = this.a();
            }
            CertReqMessages certReqMessages = new CertReqMessages(this.a, this.b, regInfo);
            byte[] byArray = new byte[certReqMessages.getDERLen(0xA00000 | n)];
            certReqMessages.getDEREncoding(byArray, 0, 0xA00000 | n);
            return byArray;
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPCertRequestCommon.derEncode: unable to encode CertReqMessages(" + cRMFException.getMessage() + ").");
        }
    }

    protected void setPop(CMPPOPGenerationInfoSignature cMPPOPGenerationInfoSignature, JSAFE_PrivateKey jSAFE_PrivateKey, CertJ certJ) throws CMPException {
        JSAFE_SecureRandom jSAFE_SecureRandom;
        try {
            jSAFE_SecureRandom = certJ.getRandomObject();
        }
        catch (CertJException certJException) {
            throw new CMPException("CMPCertRequestCommon.setPop: unable to get a registered random service(" + certJException.getMessage() + ").");
        }
        try {
            this.b = new ProofOfPossession(1, certJ);
            this.b.setSignatureAlgorithm(cMPPOPGenerationInfoSignature.getSignatureAlgorithm());
            X500Name x500Name = this.certTemplate.getSubjectName();
            if (x500Name == null) {
                POPOSigningKeyInput pOPOSigningKeyInput = new POPOSigningKeyInput();
                pOPOSigningKeyInput.setSubjectPublicKey(this.certTemplate.getSubjectPublicKey());
                if (cMPPOPGenerationInfoSignature.authBySenderName()) {
                    GeneralName generalName = cMPPOPGenerationInfoSignature.getSender();
                    pOPOSigningKeyInput.setSenderName(generalName);
                } else {
                    char[] cArray = cMPPOPGenerationInfoSignature.getSharedSecret();
                    pOPOSigningKeyInput.setSharedSecret(cArray, 0, cArray.length);
                    byte[] byArray = cMPPOPGenerationInfoSignature.getSalt();
                    pOPOSigningKeyInput.setSalt(byArray, 0, byArray.length);
                    pOPOSigningKeyInput.setIterationCount(cMPPOPGenerationInfoSignature.getIterationCount());
                }
                this.b.setPOPOSigningKeyInput(pOPOSigningKeyInput);
            } else {
                this.b.setCertRequest(this.a());
            }
            this.b.signPOP(certJ.getDevice(), jSAFE_PrivateKey, (SecureRandom)jSAFE_SecureRandom);
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPCertRequestCommon.setPop: " + cRMFException.getMessage());
        }
    }

    protected void setPop(int n, CMPPOPGenerationInfoNonSignature cMPPOPGenerationInfoNonSignature) throws CMPException {
        try {
            this.b = new ProofOfPossession(n);
            POPOPrivKey pOPOPrivKey = new POPOPrivKey();
            int n2 = cMPPOPGenerationInfoNonSignature.getMethod();
            switch (n2) {
                case 2: {
                    pOPOPrivKey.setType(1);
                    pOPOPrivKey.setSubsequentMessage(0);
                    break;
                }
                default: {
                    throw new CMPException("CMPCertRequestCommon.setPop: unsupported POP method(" + n2 + ").");
                }
            }
            this.b.setPOPOPrivKey(pOPOPrivKey);
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPCertRequestCommon.setPop: " + cRMFException.getMessage());
        }
    }

    protected void setPop(int n) throws CMPException {
        try {
            this.b = new ProofOfPossession(n);
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPCertRequestCommon.setPop: " + cRMFException.getMessage());
        }
    }

    protected Controls getControls() {
        return this.controls;
    }

    private CertRequest a() throws CMPException {
        try {
            return new CertRequest(0, this.certTemplate, this.controls);
        }
        catch (CRMFException cRMFException) {
            throw new CMPException("CMPCertRequestCommon.createCertRequest: unable to instantiate CertRequest(" + cRMFException.getMessage() + ").");
        }
    }
}

