/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.provider.pki.cmp.CMP;
import com.rsa.certj.provider.pki.cmp.CMPCertConfirmMessage;
import com.rsa.certj.provider.pki.cmp.CMPCertRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPProtectInfo;
import com.rsa.certj.provider.pki.cmp.CMPRequestCommon;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.spi.pki.PKIMessage;
import com.rsa.certj.spi.pki.PKIResponseMessage;
import com.rsa.certj.spi.pki.ProtectInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class CMPDebug
extends CMP {
    private File a = null;
    private String b = null;

    public CMPDebug(String string, File file, File file2) throws InvalidParameterException {
        super(string, file);
        this.a = file2;
    }

    public void saveMessage(byte[] byArray, PKIMessage pKIMessage, ProtectInfo protectInfo) throws CMPException {
        String string;
        int n;
        if (byArray == null) {
            return;
        }
        if (pKIMessage instanceof CMPRequestCommon) {
            n = ((CMPRequestCommon)pKIMessage).getMessageType();
            string = protectInfo == null ? "unknown" : this.a((CMPRequestCommon)pKIMessage, (CMPProtectInfo)protectInfo);
            this.b = string;
        } else if (pKIMessage instanceof CMPResponseCommon) {
            n = ((CMPResponseCommon)pKIMessage).getMessageType();
            string = this.b;
        } else {
            throw new CMPException("CMPDebug.saveMessage: message should be an instance of either CMPRequestCommon or CMPResponseCommon.");
        }
        this.a(byArray, this.a(string, n));
    }

    public void saveCertificate(PKIResponseMessage pKIResponseMessage) throws CMPException {
        if (pKIResponseMessage == null) {
            return;
        }
        Certificate certificate = pKIResponseMessage.getCertificate();
        if (certificate == null) {
            return;
        }
        byte[] byArray = new byte[((X509Certificate)certificate).getDERLen(0)];
        try {
            ((X509Certificate)certificate).getDEREncoding(byArray, 0, 0);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        int n = 0;
        String string = this.a((X509Certificate)certificate);
        File file = new File(this.a, string + "." + n + ".cer");
        while (file.exists()) {
            file = new File(this.a, string + "." + ++n + ".cer");
        }
        this.a(byArray, file);
    }

    public void saveData(byte[] byArray, String string) throws CMPException {
        if (byArray == null) {
            return;
        }
        if (string == null) {
            throw new CMPException("CMPDebug.saveData: fileName should not be null.");
        }
        this.a(byArray, new File(this.a, string));
    }

    private String a(int n) {
        switch (n) {
            case 0: {
                return "ir";
            }
            case 1: {
                return "ip";
            }
            case 2: {
                return "cr";
            }
            case 3: {
                return "cp";
            }
            case 11: {
                return "rr";
            }
            case 12: {
                return "rp";
            }
            case 24: {
                return "certconf";
            }
            case 19: {
                return "pkiconf";
            }
            case 23: {
                return "error";
            }
        }
        return "unknown";
    }

    private int b(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return -1;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: {
                return 1;
            }
        }
        return 0;
    }

    private File a(String string, int n) {
        String string2 = this.a(n);
        int n2 = this.b(n);
        if (n2 < 0) {
            return new File(this.a, string + "." + string2 + ".ber");
        }
        File file = new File(this.a, string + "." + string2 + n2 + ".ber");
        while (file.exists()) {
            file = new File(this.a, string + "." + string2 + ++n2 + ".ber");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(byte[] byArray, File file) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        Object var6_4 = null;
        if (fileOutputStream == null) return;
        try {
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                Object var6_5 = null;
                if (fileOutputStream == null) return;
                try {
                    fileOutputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String a(CMPRequestCommon cMPRequestCommon, CMPProtectInfo cMPProtectInfo) {
        Object var3_3 = null;
        switch (cMPRequestCommon.getMessageType()) {
            case 0: {
                CertTemplate certTemplate = ((CMPCertRequestCommon)cMPRequestCommon).getCertTemplate();
                return this.a(certTemplate.getSubjectName());
            }
            case 2: 
            case 11: {
                return this.a(cMPProtectInfo.getSenderCert());
            }
            case 24: {
                X509Certificate x509Certificate = (X509Certificate)((CMPCertConfirmMessage)cMPRequestCommon).getCertificateReturned();
                if (x509Certificate != null) {
                    return this.a(x509Certificate);
                }
                if (!cMPProtectInfo.pbmProtected()) {
                    return this.a(cMPProtectInfo.getSenderCert());
                }
                return "unknwon";
            }
        }
        return "unknown";
    }

    private String a(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "unknown";
        }
        return this.a(x509Certificate.getSubjectName());
    }

    private String a(X500Name x500Name) {
        if (x500Name == null) {
            return "unknown";
        }
        AttributeValueAssertion attributeValueAssertion = x500Name.getAttribute(0);
        if (attributeValueAssertion == null) {
            return "unknwon";
        }
        try {
            return attributeValueAssertion.getStringAttribute();
        }
        catch (NameException nameException) {
            return "unknown";
        }
    }
}

