/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.pki.PKICommonImplementation;
import com.rsa.certj.provider.revocation.ocsp.Caf;
import com.rsa.certj.provider.revocation.ocsp.OCSPEvidence;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequest;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponder;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponderInternal;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponse;
import com.rsa.certj.provider.revocation.ocsp.OCSPutil;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIResult;
import com.rsa.certj.spi.pki.PKIStatusInfo;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;

public final class OCSP
extends Provider {
    private OCSPResponder[] a;
    private OCSPResponderInternal[] b;
    protected static final int SUPPORTED_VERSION = 0;
    protected static final int NONCE_LEN = 16;
    private static String c = "application/ocsp-request";
    private static String d = "application/ocsp-response";
    private boolean e = false;
    private Hashtable f = null;

    public final void setDebugWriteDERs(boolean bl) {
        this.e = bl;
    }

    public OCSP(String string, OCSPResponder oCSPResponder) throws InvalidParameterException, CertificateException, NameException {
        super(2, string);
        if (oCSPResponder == null) {
            throw new InvalidParameterException("responder == null");
        }
        this.a = new OCSPResponder[1];
        this.a[0] = new OCSPResponder(oCSPResponder);
    }

    public OCSP(String string, OCSPResponder[] oCSPResponderArray) throws InvalidParameterException, CertificateException, NameException {
        super(2, string);
        if (oCSPResponderArray == null) {
            throw new InvalidParameterException("responder == null");
        }
        int n = oCSPResponderArray.length;
        this.a = new OCSPResponder[n];
        for (int i = 0; i < n; ++i) {
            if (oCSPResponderArray[i] == null) {
                throw new InvalidParameterException("responders[" + i + "] == null");
            }
            this.a[i] = new OCSPResponder(oCSPResponderArray[i]);
        }
    }

    public OCSP(String string, OCSPResponder oCSPResponder, InputStream inputStream) throws InvalidParameterException, CertificateException, NameException {
        this(string, oCSPResponder);
        if (inputStream == null) {
            throw new InvalidParameterException("OCSP: configStream should not be null.");
        }
        this.f = PKICommonImplementation.loadProperties(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OCSP(String string, OCSPResponder oCSPResponder, File file) throws InvalidParameterException, CertificateException, NameException {
        this(string, oCSPResponder);
        if (file == null) {
            throw new InvalidParameterException("OCSP: configFile should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.f = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("OCSP: " + file.toString() + " does not exist.");
            }
            Object var7_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    public OCSP(String string, OCSPResponder[] oCSPResponderArray, InputStream inputStream) throws InvalidParameterException, CertificateException, NameException {
        this(string, oCSPResponderArray);
        if (inputStream == null) {
            throw new InvalidParameterException("OCSP: configStream should not be null.");
        }
        this.f = PKICommonImplementation.loadProperties(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OCSP(String string, OCSPResponder[] oCSPResponderArray, File file) throws InvalidParameterException, CertificateException, NameException {
        this(string, oCSPResponderArray);
        if (file == null) {
            throw new InvalidParameterException("OCSP: configFile should not be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.f = PKICommonImplementation.loadProperties(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidParameterException("OCSP: " + file.toString() + " does not exist.");
            }
            Object var7_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)fileInputStream).close();
        return;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        int n = this.a.length;
        try {
            this.b = new OCSPResponderInternal[n];
            for (int i = 0; i < n; ++i) {
                this.b[i] = new OCSPResponderInternal(certJ, this.a[i]);
                this.a[i] = null;
            }
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("OCSP.instantiate: " + invalidParameterException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new ProviderManagementException("OCSP.instantiate: " + certificateException.getMessage());
        }
        catch (NameException nameException) {
            throw new ProviderManagementException("OCSP.instantiate: " + nameException.getMessage());
        }
        catch (PKIException pKIException) {
            throw new ProviderManagementException("OCSP.instantiate: " + pKIException.getMessage());
        }
    }

    private final class Implementation
    extends PKICommonImplementation
    implements CertStatusInterface {
        CertJ a;

        private Implementation(CertJ certJ, String string) throws InvalidParameterException, PKIException {
            super(certJ, string);
            if (OCSP.this.f != null) {
                this.loadConfig(OCSP.this.f);
            }
            this.a = certJ;
        }

        public CertRevocationInfo checkCertRevocation(CertPathCtx certPathCtx, Certificate certificate) throws NotSupportedException, CertStatusException {
            if (certPathCtx == null) {
                throw new NotSupportedException("pathCtx==null");
            }
            Certificate[] certificateArray = new Certificate[]{certificate};
            CertRevocationInfo[] certRevocationInfoArray = this.a(certPathCtx, certificateArray);
            return certRevocationInfoArray[0];
        }

        private void a(String string, byte[] byArray) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private CertRevocationInfo[] a(CertPathCtx certPathCtx, Certificate[] certificateArray) throws NotSupportedException, CertStatusException {
            int n;
            if (certificateArray == null) {
                return null;
            }
            int n2 = certificateArray.length;
            CertRevocationInfo[] certRevocationInfoArray = new CertRevocationInfo[n2];
            OCSPMatchedResponder[] oCSPMatchedResponderArray = new OCSPMatchedResponder[n2];
            for (n = 0; n < n2; ++n) {
                if (certificateArray[n] == null) {
                    oCSPMatchedResponderArray[n] = null;
                    certRevocationInfoArray[n] = null;
                    continue;
                }
                oCSPMatchedResponderArray[n] = this.a(certPathCtx.getPathOptions(), (X509Certificate)certificateArray[n]);
            }
            try {
                for (n = 0; n < n2; ++n) {
                    Object object;
                    byte[] byArray;
                    Object object2;
                    String string = null;
                    if (certificateArray[n] == null) continue;
                    X509V3Extensions x509V3Extensions = ((X509Certificate)certificateArray[n]).getExtensions();
                    if (x509V3Extensions != null && x509V3Extensions.getExtensionByType(117) != null) {
                        certRevocationInfoArray[n] = new CertRevocationInfo(0, 0, null);
                        continue;
                    }
                    certRevocationInfoArray[n] = new CertRevocationInfo(2, 0, null);
                    if (oCSPMatchedResponderArray[n] == null) continue;
                    OCSPRequest oCSPRequest = new OCSPRequest(this.a, oCSPMatchedResponderArray[n].responder, certificateArray);
                    byte[] byArray2 = oCSPRequest.encode(certPathCtx);
                    if (OCSP.this.e) {
                        object2 = certificateArray[n].getUniqueID();
                        string = object2 == null ? "" : new String((byte[])object2);
                        this.a("ocspreq." + string + ".der", byArray2);
                    }
                    try {
                        object2 = this.a(oCSPMatchedResponderArray[n].destList, oCSPMatchedResponderArray[n].proxyList, byArray2);
                        byArray = object2.getEncodedResponse();
                        object = object2.getStatusInfo();
                        if (((PKIStatusInfo)object).getStatus() != 0) {
                            throw new CertStatusException("OCSP Transport status != 0 (" + ((PKIStatusInfo)object).getStatus() + ")");
                        }
                        if (((PKIStatusInfo)object).getFailInfoAux() != 200) {
                            throw new CertStatusException("OCSP Transport HTTP status != 200\n" + ((PKIStatusInfo)object).getStatusStrings());
                        }
                        if (OCSP.this.e) {
                            this.a("ocspresp." + string + ".der", byArray);
                        }
                    }
                    catch (PKIException pKIException) {
                        throw new CertStatusException(pKIException.getMessage());
                    }
                    object2 = new OCSPResponse(this.a, OCSP.this.b[n], (X509Certificate)certificateArray[n]);
                    object2.decode(certPathCtx, byArray, oCSPRequest);
                    object = object2.getRevocationInfo(oCSPRequest.getCertID(n));
                    byte[] byArray3 = oCSPRequest.getNonce();
                    if (byArray3 != null) {
                        byte[] byArray4 = object2.getNonce();
                        if (byArray4 == null) {
                            OCSPEvidence oCSPEvidence = null;
                            if (((CertRevocationInfo)object).getType() == 2) {
                                oCSPEvidence = (OCSPEvidence)((CertRevocationInfo)object).getEvidence();
                            }
                            if (oCSPEvidence != null) {
                                oCSPEvidence.setFlags(oCSPEvidence.getFlags() | 1);
                            }
                        } else if (!CertJUtils.byteArraysEqual(byArray3, byArray4)) {
                            throw new NotSupportedException("OCSP nonce mismatch");
                        }
                    }
                    if (object == null) continue;
                    certRevocationInfoArray[n] = object;
                }
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CertStatusException(aSN_Exception.getMessage());
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new NotSupportedException(invalidParameterException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new NotSupportedException(certificateException.getMessage());
            }
            catch (NoServiceException noServiceException) {
                throw new NotSupportedException(noServiceException.getMessage());
            }
            return certRevocationInfoArray;
        }

        private PKIResult a(String[] stringArray, String[] stringArray2, byte[] byArray) throws NotSupportedException, PKIException {
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray3;
                URL uRL;
                String string = stringArray[i];
                try {
                    uRL = new URL(string);
                }
                catch (Exception exception) {
                    continue;
                }
                String string2 = uRL.getProtocol();
                if (!string2.equals("http")) continue;
                bl = true;
                String[] stringArray4 = new String[]{"User-Agent: Cert-J/2.0", "Content-type: " + c};
                PKIResult pKIResult = this.sendAndReceiveHttp(uRL, stringArray4, stringArray2, byArray, stringArray3 = new String[]{"Content-type: " + d});
                PKIStatusInfo pKIStatusInfo = pKIResult.getStatusInfo();
                if (pKIStatusInfo.getStatus() == 2 && (pKIStatusInfo.getFailInfo() & 0x200000) != 0) continue;
                return pKIResult;
            }
            throw new PKIException(bl ? "Unable to connect to an OCSP responder." : "Unable to choose an OCSP responder.");
        }

        private OCSPMatchedResponder a(int n, X509Certificate x509Certificate) {
            OCSPResponderInternal oCSPResponderInternal = null;
            OCSPResponderInternal oCSPResponderInternal2 = null;
            X500Name x500Name = x509Certificate.getIssuerName();
            String string = null;
            if ((n & 0x800) == 0) {
                string = OCSPutil.getAIALocation(x509Certificate);
            }
            if (string == null) {
                for (int i = 0; i < OCSP.this.b.length; ++i) {
                    String[] stringArray;
                    oCSPResponderInternal = OCSP.this.b[i];
                    if (oCSPResponderInternal.getResponderCACert(x509Certificate) == null || (stringArray = oCSPResponderInternal.getDestList()) == null) continue;
                    return new OCSPMatchedResponder(oCSPResponderInternal, stringArray, oCSPResponderInternal.getProxyList());
                }
                return null;
            }
            String[] stringArray = new String[]{string};
            for (int i = 0; i < OCSP.this.b.length; ++i) {
                oCSPResponderInternal = OCSP.this.b[i];
                if (oCSPResponderInternal.getResponderCACert(x509Certificate, string) == null) {
                    if (oCSPResponderInternal.getResponderCACert(x509Certificate) == null || oCSPResponderInternal2 != null) continue;
                    oCSPResponderInternal2 = oCSPResponderInternal;
                    continue;
                }
                return new OCSPMatchedResponder(oCSPResponderInternal, stringArray, oCSPResponderInternal.getProxyList());
            }
            return oCSPResponderInternal2 == null ? null : new OCSPMatchedResponder(oCSPResponderInternal2, stringArray, oCSPResponderInternal.getProxyList());
        }

        public String toString() {
            return "OCSP Certificate Status provider named: " + this.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Caf caf) throws InvalidParameterException, PKIException {
            this(certJ, string);
        }
    }

    private class OCSPMatchedResponder {
        public OCSPResponderInternal responder;
        public String[] destList;
        public String[] proxyList;

        protected OCSPMatchedResponder(OCSPResponderInternal oCSPResponderInternal, String[] stringArray, String[] stringArray2) {
            this.responder = oCSPResponderInternal;
            this.destList = stringArray;
            this.proxyList = stringArray2;
        }
    }
}

