/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.felix;

import coldfusion.Version;
import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.log.CFLogs;
import coldfusion.log.LogService;
import coldfusion.log.Logger;
import coldfusion.osgi.servlet.ModulesServlet;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.server.CFService;
import coldfusion.server.LoggingService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.server.felix.BundlesSort;
import coldfusion.server.felix.CFBundle;
import coldfusion.server.felix.DependentBundle;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.InMemoryOutputStream;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.BOMReader;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FelixUtil {
    private static final String BIN = "bin";
    private static final String WWWROOT = "wwwroot";
    private static final String SCRIPTS = "scripts";
    private static final String CF_SCRIPTS = "cf_scripts";
    public static final String DEFAULT_VERSION = "0.0.1-SNAPSHOT";
    public static String serverBaseVersion = null;
    private static Map<String, Integer> installedJarsCounterMap = new ConcurrentHashMap<String, Integer>();
    private static JsonArray bundlesDependencies = null;
    private static List<CFBundle> bundles = new ArrayList<CFBundle>();
    public static String libFolder;
    public static boolean invokedFromClient;
    private static InMemoryFile installedBundlesFile;
    public static final String odbcserver = "ColdFusion 2025 ODBC Server";
    public static final String odbcagent = "ColdFusion 2025 ODBC Agent";
    public static final String dotnetService = "ColdFusion 2025 .NET Service";
    public static final String addOnService = "ColdFusion2025Add-onServices";
    private static final String PROXY = "proxy";
    private static final String PROXY_HOSTNAME = "hostname";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "username";
    private static final String PROXY_PASSWORD = "password";
    private static final String URL = "url";
    private static final String DEFAULT_URL = "defaulturl";
    private static final String PACKAGES_URL = "packagesurl";
    private static final String DEFAULT_PACKAGES_URL = "defaultpackagesurl";
    private static final String UPDATES_DIR = "hf-updates";
    private static final String configFileName = "instances.xml";
    private static boolean felixInitializedForServerless;
    private static Map updatesSettingsMap;
    public static final String UPDATE_INSTALLERS_REPO_DIR = "updateinstallers";
    public static final String HOTFIX_FILE_PREFIX = "hotfix-";
    public static final String PARENT_DIR_IDENTIFIER = "..";
    public static final String FRAGMENT_HOST = "Fragment-Host";
    public static final String DIRECTORY_SEPARATOR = "/";
    private static Map<String, Long> bundlesIdMap;
    public static String CFDownloadRepositoryBaseURL;
    public static String CFDownloadRepositoryURL;

    public static void deployBundle(String bundleName) throws Exception {
        FelixUtil.deployBundle(bundleName, ServiceFactory.getRuntimeService().getLibDir());
    }

    public static void createWatcher(String libPath) {
        if (null == libPath) {
            libPath = CFService.getLibPath();
        }
        final String lib = libPath;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WatchKey key;
                    WatchService watchService = FileSystems.getDefault().newWatchService();
                    Path path = Paths.get(lib + File.separator, new String[0]);
                    path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                    boolean anyPackageInstalled = false;
                    while ((key = watchService.take()) != null) {
                        try {
                            for (WatchEvent<?> event : key.pollEvents()) {
                                String cversion;
                                String[] name;
                                String[] split;
                                Path changed = (Path)event.context();
                                int eventCount = event.count();
                                if (!changed.endsWith("installedBundles.txt")) continue;
                                FelixUtil.reloadBundlesAndBundlesDependencies(lib);
                                HashSet<CFBundle> oldBundles = new HashSet<CFBundle>(bundles);
                                Thread.sleep(3000L);
                                FileReader bundlesFr = new FileReader(lib + "/installedBundles.txt");
                                Properties props = new Properties();
                                props.load(bundlesFr);
                                String content = props.getProperty("packages", "");
                                String contentOrdered = ModulesServlet.getOrderedBundles(content, true);
                                for (String ibundle : contentOrdered.split(",")) {
                                    split = ibundle.split(":");
                                    name = split[0];
                                    cversion = FelixUtil.getDefaultVersion();
                                    if (split.length == 2) {
                                        cversion = split[1];
                                    }
                                    for (CFBundle bundle : oldBundles) {
                                        if (!bundle.getName().equals(name) || !bundle.getCurrentVersion().equals(cversion) || bundle.isInstalled()) continue;
                                        for (CFBundle bundle2 : bundles) {
                                            if (!bundle2.getName().equals(name) || bundle2.getCurrentVersion().equals(cversion) || !bundle2.isInstalled()) continue;
                                            ModulesServlet.uninstallBundle((String)name);
                                            bundle2.setInstalled(false);
                                        }
                                    }
                                }
                                for (String ibundle : contentOrdered.split(",")) {
                                    split = ibundle.split(":");
                                    name = split[0];
                                    cversion = FelixUtil.getDefaultVersion();
                                    if (split.length == 2) {
                                        cversion = split[1];
                                    }
                                    for (CFBundle bundle : oldBundles) {
                                        if (!bundle.getName().equals(name) || !bundle.getCurrentVersion().equals(cversion) || bundle.isInstalled()) continue;
                                        try {
                                            ModulesServlet.installBundle((String)name, cversion);
                                            anyPackageInstalled = true;
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                                Object modulesUninstall = "";
                                for (CFBundle bundle : oldBundles) {
                                    if (!bundle.isInstalled()) continue;
                                    boolean notFound = true;
                                    boolean versionChange = false;
                                    for (String ibundle : content.split(",")) {
                                        String[] split2 = ibundle.split(":");
                                        String name2 = split2[0];
                                        String cversion2 = FelixUtil.getDefaultVersion();
                                        if (split2.length == 2) {
                                            cversion2 = split2[1];
                                        }
                                        if (!name2.equals(bundle.getName()) || cversion2.equals("UNINSTALLED")) continue;
                                        notFound = false;
                                        if (cversion2.equals("UNINSTALLED") || cversion2.equals(bundle.getCurrentVersion())) continue;
                                        versionChange = true;
                                    }
                                    try {
                                        if ((notFound || versionChange) && !bundle.getName().equals("felixclassloader")) {
                                            modulesUninstall = (String)modulesUninstall + bundle.getName() + ",";
                                        }
                                        if (!versionChange || bundle.getName().equals("felixclassloader")) continue;
                                        ModulesServlet.installBundle(bundle.getName(), bundle.getCurrentVersion());
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (((String)modulesUninstall).endsWith(",")) {
                                    modulesUninstall = ((String)modulesUninstall).substring(0, ((String)modulesUninstall).length() - 1);
                                }
                                ModulesServlet.uninstallBundle((String)modulesUninstall, false);
                                if (eventCount != 1 || !anyPackageInstalled || new File(CFService.getRoot() + "/../src").exists()) continue;
                                try {
                                    FelixUtil.downloadBundleFromCFDownloadRepository(CFService.getRoot() + "/../bundles" + File.separator + "bundlesdependency.json", "bundlesdependency.json");
                                }
                                catch (Exception e) {
                                    if (invokedFromClient) continue;
                                    CFLogs.SERVER_LOG.error((Throwable)e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                        finally {
                            key.reset();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static synchronized void deployBundle(String bundleName, String lib) throws Exception {
        FelixUtil.deployBundle(bundleName, FelixUtil.getDefaultVersion(), lib);
    }

    private static String getProcessCommand(String name, List<String> args) {
        Object command = name;
        for (String arg : args) {
            if (arg.contains(" ")) {
                command = (String)command + " \"" + arg + "\"";
                continue;
            }
            command = (String)command + " " + arg;
        }
        return command;
    }

    private static Process executeProcess(final String command) throws Throwable {
        if (System.getSecurityManager() == null) {
            Process p = Runtime.getRuntime().exec(command);
            return p;
        }
        try {
            return (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Process p = Runtime.getRuntime().exec(command);
                    return p;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public static String execute(String name, List<String> args, boolean wait, int waitTimeInSecs) {
        String command = FelixUtil.getProcessCommand(name, args);
        return FelixUtil.execute(command, wait, waitTimeInSecs);
    }

    public static String execute(String command, boolean wait, int waitTimeInSecs) {
        StringBuffer result = null;
        try {
            Process p = FelixUtil.executeProcess(command);
            try {
                if (wait) {
                    p.waitFor(waitTimeInSecs, TimeUnit.SECONDS);
                    InputStream esteam = p.getErrorStream();
                    InputStream isteam = p.getInputStream();
                    InputStreamReader isr = new InputStreamReader(isteam);
                    InputStreamReader esr = new InputStreamReader(esteam);
                    BufferedReader br = new BufferedReader(isr);
                    BufferedReader er = new BufferedReader(esr);
                    String line = null;
                    String line1 = null;
                    StringBuffer err = null;
                    result = new StringBuffer();
                    err = new StringBuffer();
                    while ((line1 = er.readLine()) != null) {
                        err.append(line1);
                    }
                    while ((line = br.readLine()) != null) {
                        result.append(line);
                    }
                }
            }
            catch (InterruptedException e) {
                return "";
            }
        }
        catch (IOException ioe) {
            return "";
        }
        catch (Throwable e) {
            return "";
        }
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    public static String executeService(String command, String serviceName, boolean blocking) {
        ArrayList<String> argsForCommand = new ArrayList<String>();
        argsForCommand.add(command);
        argsForCommand.add(serviceName);
        String exceutionResult = FelixUtil.execute("sc.exe", argsForCommand, blocking, 30);
        return exceutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeCommand(String command, boolean wait) {
        int exitValue = -1;
        try {
            Process p = FelixUtil.executeProcess(command);
            try {
                if (wait) {
                    new Thread(new ProcessLogger(p.getInputStream())).start();
                    new Thread(new ProcessLogger(p.getErrorStream())).start();
                    new Thread(new ProcessWaitLogger(p)).start();
                    p.waitFor();
                }
            }
            catch (InterruptedException e) {
                if (invokedFromClient) {
                    System.out.println(e.getMessage());
                } else {
                    FelixUtil.auditLog(e.getMessage());
                }
            }
            finally {
                exitValue = p.exitValue();
            }
        }
        catch (Throwable e) {
            if (invokedFromClient) {
                System.out.println(e.getMessage());
            }
            FelixUtil.auditLog(e.getMessage());
        }
        return exitValue;
    }

    public static void uninstallOdbcService(String serverRootPath) {
        ArrayList<String> argsODBCServerStop = new ArrayList<String>();
        argsODBCServerStop.add("stop");
        argsODBCServerStop.add(odbcserver);
        String resultODBCServerStop = FelixUtil.execute("sc.exe", argsODBCServerStop, true, 30);
        ArrayList<String> argsODBCAgentStop = new ArrayList<String>();
        argsODBCAgentStop.add("stop");
        argsODBCAgentStop.add(odbcagent);
        FelixUtil.execute("sc.exe", argsODBCAgentStop, true, 30);
        ArrayList<String> argsODBCServerDelete = new ArrayList<String>();
        argsODBCServerDelete.add("delete");
        argsODBCServerDelete.add(odbcserver);
        FelixUtil.execute("sc.exe", argsODBCServerDelete, true, 30);
        ArrayList<String> argsODBCAgentDelete = new ArrayList<String>();
        argsODBCAgentDelete.add("delete");
        argsODBCAgentDelete.add(odbcagent);
        FelixUtil.execute("sc.exe", argsODBCAgentDelete, true, 30);
        FelixUtil.deleteDirectoryRecusrively(new File(serverRootPath + "\\db\\slserver54"));
        FelixUtil.deleteDirectoryRecusrively(new File(serverRootPath + "\\db\\SequeLink Setup"));
    }

    static boolean _deleteDirectoryRecusrively(File directoryForDelete) {
        File[] files = directoryForDelete.listFiles();
        if (files != null) {
            for (File file : files) {
                FelixUtil.deleteDirectoryRecusrively(file);
            }
        }
        try {
            Files.delete(Paths.get(directoryForDelete.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static boolean deleteDirectoryRecusrively(final File directoryForDeleteS) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FelixUtil._deleteDirectoryRecusrively(directoryForDeleteS);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void installOdbcService(String lib, String version) {
        String swclaini;
        File loggingPathF;
        if (FelixUtil.installed("odbc", lib, version)) {
            return;
        }
        Object serverRootPath = "";
        try {
            serverRootPath = new File(lib + "\\..\\").getCanonicalPath() + "\\";
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        String odbcserverdesc = "The middle-tier service for ODBC connections that use the DataDirect drivers for Microsoft Access and ODBC Socket.";
        String odbcagentdesc = "Configures data sources for the ColdFusion 2025 ODBC Server.";
        String serviceControllerExe = (String)serverRootPath + "db\\SequeLink Setup\\CFServiceController.exe";
        String swstrtrExe = (String)serverRootPath + "db\\slserver54\\bin\\swstrtr.exe";
        String swagentExe = (String)serverRootPath + "db\\slserver54\\bin\\swagent.exe";
        String loggingPath = (String)serverRootPath + "db\\slserver54\\logging";
        String tracingPath = (String)serverRootPath + "db\\slserver54\\tracing";
        String dataModel = (String)serverRootPath + "db\\slserver54\\cfg\\swandm.ini";
        String odbcserverServices = "SYSTEM\\CurrentControlSet\\Services\\ColdFusion 2025 ODBC Server";
        String swclainiPath = (String)serverRootPath + "db\\slserver54\\admin\\swcla.ini";
        String slxperfiniPath = (String)serverRootPath + "db\\slserver54\\bin\\slxperf.ini";
        ArrayList<String> argsODBCServerStop = new ArrayList<String>();
        argsODBCServerStop.add("stop");
        argsODBCServerStop.add(odbcserver);
        FelixUtil.execute("net.exe", argsODBCServerStop, true, 30);
        ArrayList<String> argsODBCAgentStop = new ArrayList<String>();
        argsODBCAgentStop.add("stop");
        argsODBCAgentStop.add(odbcagent);
        FelixUtil.execute("net.exe", argsODBCAgentStop, true, 30);
        ArrayList<String> argsODBCServer0 = new ArrayList<String>();
        argsODBCServer0.add("/R");
        argsODBCServer0.add(odbcserver);
        ArrayList<String> argsODBCServer1 = new ArrayList<String>();
        argsODBCServer1.add("/A");
        argsODBCServer1.add(odbcserver);
        argsODBCServer1.add(swstrtrExe);
        argsODBCServer1.add("-quoteparams");
        argsODBCServer1.add(odbcserver);
        ArrayList<String> argsODBCServer2 = new ArrayList<String>();
        argsODBCServer2.add("/P");
        argsODBCServer2.add(odbcserver);
        argsODBCServer2.add("ServiceName");
        argsODBCServer2.add(odbcserver);
        ArrayList<String> argsODBCServer3 = new ArrayList<String>();
        argsODBCServer3.add("/P");
        argsODBCServer3.add(odbcserver);
        argsODBCServer3.add("ServiceDescription");
        argsODBCServer3.add(odbcserver);
        ArrayList<String> argsODBCServer4 = new ArrayList<String>();
        argsODBCServer4.add("/P");
        argsODBCServer4.add(odbcserver);
        argsODBCServer4.add("DataModel");
        argsODBCServer4.add(dataModel);
        ArrayList<String> argsODBCServer5 = new ArrayList<String>();
        argsODBCServer5.add("/P");
        argsODBCServer5.add(odbcserver);
        argsODBCServer5.add("LoggingPath");
        argsODBCServer5.add(loggingPath);
        ArrayList<String> argsODBCServer6 = new ArrayList<String>();
        argsODBCServer6.add("/X");
        argsODBCServer6.add(odbcserverServices);
        argsODBCServer6.add("FailureActions");
        argsODBCServer6.add("80,51,01,00,00,00,00,00,00,00,00,00,03,00,00,00,53,00,65,00,01,00,00,00,60,ea,00,00,01,00,00,00,60,ea,00,00,01,00,00,00,60,ea,00,00");
        argsODBCServer6.add("BINARY");
        argsODBCServer6.add("cheese");
        FelixUtil.execute(serviceControllerExe, argsODBCServer0, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer1, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer2, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer3, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer4, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer5, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCServer6, true, 30);
        ArrayList<String> argsODBCServerDesc = new ArrayList<String>();
        argsODBCServerDesc.add("description");
        argsODBCServerDesc.add(odbcserver);
        argsODBCServerDesc.add(odbcserverdesc);
        FelixUtil.execute("sc.exe", argsODBCServerDesc, true, 30);
        ArrayList<String> argsODBCAgent0 = new ArrayList<String>();
        argsODBCAgent0.add("/R");
        argsODBCAgent0.add(odbcagent);
        ArrayList<String> argsODBCAgent1 = new ArrayList<String>();
        argsODBCAgent1.add("/A");
        argsODBCAgent1.add(odbcagent);
        argsODBCAgent1.add(swagentExe);
        argsODBCAgent1.add("-quoteparams");
        argsODBCAgent1.add(odbcagent);
        ArrayList<String> argsODBCAgent2 = new ArrayList<String>();
        argsODBCAgent2.add("/P");
        argsODBCAgent2.add(odbcagent);
        argsODBCAgent2.add("ServiceName");
        argsODBCAgent2.add(odbcagent);
        ArrayList<String> argsODBCAgent3 = new ArrayList<String>();
        argsODBCAgent3.add("/P");
        argsODBCAgent3.add(odbcagent);
        argsODBCAgent3.add("ServiceDescription");
        argsODBCAgent3.add(odbcagent);
        ArrayList<String> argsODBCAgent4 = new ArrayList<String>();
        argsODBCAgent4.add("/P");
        argsODBCAgent4.add(odbcagent);
        argsODBCAgent4.add("DataModel");
        argsODBCAgent4.add(dataModel);
        ArrayList<String> argsODBCAgent5 = new ArrayList<String>();
        argsODBCAgent5.add("/P");
        argsODBCAgent5.add(odbcagent);
        argsODBCAgent5.add("LoggingPath");
        argsODBCAgent5.add(loggingPath);
        ArrayList<String> argsODBCAgent6 = new ArrayList<String>();
        argsODBCAgent6.add("/P");
        argsODBCAgent6.add(odbcagent);
        argsODBCAgent6.add("Agent");
        argsODBCAgent6.add(" ");
        FelixUtil.execute(serviceControllerExe, argsODBCAgent0, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent1, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent2, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent3, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent4, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent5, true, 30);
        FelixUtil.execute(serviceControllerExe, argsODBCAgent6, true, 30);
        ArrayList<String> argsODBCAgentDesc = new ArrayList<String>();
        argsODBCAgentDesc.add("description");
        argsODBCAgentDesc.add(odbcagent);
        argsODBCAgentDesc.add(odbcagentdesc);
        FelixUtil.execute("sc.exe", argsODBCAgentDesc, true, 30);
        File tracingPathF = new File(tracingPath);
        if (tracingPathF != null && !tracingPathF.exists()) {
            tracingPathF.mkdirs();
        }
        if ((loggingPathF = new File(loggingPath)) != null && !loggingPathF.exists()) {
            loggingPathF.mkdirs();
        }
        String pathToBeReplaced = "C:\\Program Files\\DataDirect";
        String odbcServerNameToBeReplaced = "ColdFusion ODBC Server";
        String odbcAgentNameToBeReplaced = "ColdFusion ODBC Agent";
        String swandmini = FelixUtil.readFile(dataModel, "UTF-8");
        if (swandmini.contains(pathToBeReplaced)) {
            swandmini = swandmini.replace(pathToBeReplaced, (String)serverRootPath + "db");
            swandmini = swandmini.replace(odbcServerNameToBeReplaced, odbcserver);
            swandmini = swandmini.replace(odbcAgentNameToBeReplaced, odbcagent);
            if (((String)serverRootPath).contains("WEB-INF")) {
                swandmini = swandmini.replace("cmgss_an.dll", "cmgss_sp.dll");
            }
            FelixUtil.writeFile(dataModel, swandmini, "UTF-8");
        }
        if ((swclaini = FelixUtil.readFile(swclainiPath, "UTF-8")).contains(pathToBeReplaced)) {
            swclaini = swclaini.replace(pathToBeReplaced, (String)serverRootPath + "db");
            FelixUtil.writeFile(swclainiPath, swclaini, "UTF-8");
        }
        String slxperfini = FelixUtil.readFile(slxperfiniPath, "UTF-8");
        if (slxperfiniPath.contains(pathToBeReplaced)) {
            slxperfini = slxperfini.replace(pathToBeReplaced, (String)serverRootPath + "db");
            FelixUtil.writeFile(slxperfiniPath, slxperfini, "UTF-8");
        }
        ArrayList<String> argsODBCServerStart = new ArrayList<String>();
        argsODBCServerStart.add("start");
        argsODBCServerStart.add(odbcserver);
        FelixUtil.execute("net.exe", argsODBCServerStart, false, 30);
        ArrayList<String> argsODBCAgentStart = new ArrayList<String>();
        argsODBCAgentStart.add("start");
        argsODBCAgentStart.add(odbcagent);
        FelixUtil.execute("net.exe", argsODBCAgentStart, false, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String file, String charset) {
        char[] buf = new char[1024];
        File f = new File(file);
        StringBuilder builder = new StringBuilder((int)f.length());
        Reader in = null;
        try {
            int count;
            in = new BOMReader(new BufferedInputStream(new FileInputStream(f)), charset, true);
            while ((count = in.read(buf)) != -1) {
                builder.append(buf, 0, count);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String file, Object content, String charset) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] bytes = content instanceof byte[] ? (byte[])content : ((String)content).getBytes(charset);
            ((OutputStream)fos).write(bytes, 0, bytes.length);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (fos != null) {
                    ((OutputStream)fos).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean isAllowedToDeployBundle(String bundleName, String version) throws Exception {
        String libPath = libFolder;
        Object rootPath = "";
        rootPath = libPath != null ? libPath + "/../" : CFService.getPath();
        int currentServerUpdateLevel = Integer.parseInt(Version.getUpdateLevel((String)rootPath));
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.getCurrentVersion().equals(version)) continue;
            int minimumCoreServerUpdateRequired = bundle.getMinimumCoreServerUpdateRequired();
            if (currentServerUpdateLevel < minimumCoreServerUpdateRequired) break;
            return true;
        }
        return false;
    }

    public static void deployBundle(String bundleName, String version, String lib) throws Exception {
        boolean newBundle;
        if (bundleName.equals("axis")) {
            return;
        }
        FelixUtil.auditLog("Deploying bundle : " + bundleName);
        if (version == null || version.equals(DEFAULT_VERSION)) {
            version = FelixUtil.getDefaultVersion();
        }
        if (null == lib && libFolder != null) {
            lib = libFolder;
        }
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        FelixUtil.initializeInstalledBundles(lib);
        if (!CFService.loadingServicesAtStartup) {
            FelixUtil.initializeDownloadBaseURL(lib, false);
        }
        boolean bl = newBundle = !CFService.loadingServicesAtStartup;
        if (newBundle && FelixUtil.installed(bundleName, lib, version)) {
            return;
        }
        Object bundlePath = null;
        FelixUtil.deployDependencies(bundleName, lib, version);
        if (version != null && version.length() > 0) {
            String alias = "";
            for (CFBundle bun : bundles) {
                if (!bun.getName().equals(bundleName) || !bun.getCurrentVersion().equals(version)) continue;
                alias = bun.getAlias();
                break;
            }
            if (!new File(cfHomePath + "//bundles").exists()) {
                new File(cfHomePath + "//bundles").mkdir();
            }
            bundlePath = cfHomePath + File.separator + "bundles" + File.separator + alias + "-" + version + ".jar";
            bundlePath = ((String)bundlePath).replace("\\", DIRECTORY_SEPARATOR);
            try {
                if (!bundlesIdMap.containsKey(bundlePath) && !FelixUtil.isJarValid((String)bundlePath)) {
                    FelixUtil.downloadBundleFromCFDownloadRepository((String)bundlePath, alias + "-" + version + ".jar");
                }
            }
            catch (FileNotFoundException fnfe) {
                if (!invokedFromClient) {
                    throw fnfe;
                }
            }
            try {
                FelixUtil.installBundle((String)bundlePath);
            }
            catch (BundleException e) {
                FelixUtil.undeployBundle(bundleName);
                ModulesServlet.printError("Error while deploying " + (String)bundlePath + "." + e.getMessage() + "." + e.getCause() + "." + e);
                throw e;
            }
            for (CFBundle bundle : bundles) {
                if (!bundle.getName().equals(bundleName) || !bundle.getCurrentVersion().equals(version)) continue;
                bundle.setInstalled(true);
                for (CFBundle bundle2 : bundles) {
                    if (!bundle2.getName().equals(bundleName) || bundle2.getCurrentVersion().equals(version) || !bundle2.isInstalled()) continue;
                    bundle2.setInstalled(false);
                }
            }
            if (newBundle && !invokedFromClient) {
                FelixUtil.updateInstalledBundlesFile(lib);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static synchronized void deployAXISBundle(String bundleName, String version, String lib) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleAjaxBundle(String lib, String alias, String version) throws Exception {
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        String bundlePath = cfHomePath + File.separator + "bundles" + File.separator + alias + "-" + version + ".zip";
        if (!new File(bundlePath).exists()) {
            System.out.println(RB.getString(FelixUtil.class, (String)"FelixUtil.ajaxinfo"));
            FelixUtil.downloadBundleFromCFDownloadRepository(bundlePath, alias + "-" + version + ".zip");
        }
        if (!invokedFromClient) {
            if (new File(FelixUtil.getCFScriptsPath(lib, "ext")).exists()) {
                return;
            }
            String script = FelixUtil.getCFScriptsPath(lib, "");
            if (!new File(script).exists()) {
                String scriptPath = FelixUtil._getDefaultCFScriptsPath();
                throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.scriptnotfound", (Object)new File(scriptPath).getCanonicalPath(), (Object)bundlePath));
            }
            FelixUtil.unzip(bundlePath, script);
        }
    }

    private static String getCFScriptsPath(String lib, String folder) {
        String path;
        String ajax;
        Object cf_scripts;
        String fullPath = FelixUtil._getDefaultCFScriptsPath();
        if (!new File(fullPath).exists()) {
            fullPath = FelixUtil._getAlternateCFScriptsPath();
        }
        if (!new File(fullPath).exists()) {
            String scriptsrc = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getCFFormScriptSrc();
            String serverxml = String.join((CharSequence)File.separator, Arrays.asList(ServiceFactory.getRuntimeService().getLibDir(), PARENT_DIR_IDENTIFIER, "runtime", "conf", "server.xml"));
            if (new File(serverxml).exists()) {
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(serverxml);
                    doc.getDocumentElement().normalize();
                    Node server = FelixUtil.getElementByName(doc, "server");
                    Node service = FelixUtil.getElementByName(server, "service");
                    Node engine = FelixUtil.getElementByName(service, "engine");
                    Node host = FelixUtil.getElementByName(engine, "host");
                    Node context = FelixUtil.getElementByName(host, "context");
                    Node resources = FelixUtil.getElementByName(context, "resources");
                    Node preresources = FelixUtil.getElementByName(resources, "preresources");
                    NamedNodeMap attrs = preresources.getAttributes();
                    Node webAppMount = attrs.getNamedItem("webAppMount");
                    String webAppMountValue = webAppMount.getNodeValue();
                    if (webAppMountValue.contains(scriptsrc) || scriptsrc.contains(webAppMountValue)) {
                        String baseValue;
                        Node base = attrs.getNamedItem("base");
                        fullPath = baseValue = base.getNodeValue();
                        FelixUtil.auditLog("Found mapped cf_scripts folder : " + fullPath);
                    }
                }
                catch (Throwable dbFactory) {
                    // empty catch block
                }
            }
        }
        if (!new File((String)(cf_scripts = fullPath + File.separator + (ajax = "ajax"))).exists() && new File(path = String.join((CharSequence)File.separator, Arrays.asList(lib, PARENT_DIR_IDENTIFIER, PARENT_DIR_IDENTIFIER, PARENT_DIR_IDENTIFIER, CF_SCRIPTS, SCRIPTS, ajax))).exists()) {
            cf_scripts = path;
        }
        return (String)cf_scripts + File.separator + folder;
    }

    private static Node getElementByName(Node doc, String name) {
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase(name)) continue;
            return child;
        }
        return null;
    }

    private static String _getDefaultCFScriptsPath() {
        return FelixUtil.formCFScriptsPath(ServiceFactory.getRuntimeService().getWebRoot());
    }

    private static String _getAlternateCFScriptsPath() {
        return FelixUtil.formCFScriptsPath(ServiceFactory.getRuntimeService().getRootDir() + File.separatorChar + WWWROOT);
    }

    private static String formCFScriptsPath(String webRoot) {
        Object scritSrc = ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).getCFFormScriptSrc();
        if (scritSrc == null || ((String)scritSrc).length() == 0) {
            scritSrc = CF_SCRIPTS + File.separator + SCRIPTS;
        }
        String fullPath = webRoot + File.separator + (String)scritSrc;
        return fullPath;
    }

    public static void initializeDownloadBaseURL(String lib, boolean refresh) {
        if (null == CFDownloadRepositoryBaseURL || refresh) {
            String rootDir = ModulesServlet.getServerRoot();
            Map updatesSettings = null;
            if (rootDir != null) {
                updatesSettings = FelixUtil.getUpdatesSettings(rootDir);
            }
            CFDownloadRepositoryURL = Boolean.getBoolean("coldfusion.build.stripbuildpathfromadminpages") ? rootDir + "/../bundles/bundlesdependency.json" : (String)updatesSettings.get(PACKAGES_URL);
            boolean isValidUrl = false;
            try {
                new URL(CFDownloadRepositoryURL).toURI();
                isValidUrl = true;
            }
            catch (URISyntaxException exception) {
                isValidUrl = false;
            }
            catch (MalformedURLException exception) {
                isValidUrl = false;
            }
            if (isValidUrl) {
                try {
                    String redirectURL = FelixUtil.getRedirectURL(CFDownloadRepositoryURL, updatesSettings);
                    if (redirectURL != null) {
                        CFDownloadRepositoryURL = redirectURL;
                    }
                }
                catch (Exception redirectURL) {
                    // empty catch block
                }
            }
            int slashIndexURL = CFDownloadRepositoryURL.lastIndexOf(47);
            int slashIndexSysPath = CFDownloadRepositoryURL.lastIndexOf(92);
            if (slashIndexURL > 0) {
                CFDownloadRepositoryBaseURL = CFDownloadRepositoryURL.substring(0, slashIndexURL);
            } else if (slashIndexSysPath > 0) {
                CFDownloadRepositoryBaseURL = CFDownloadRepositoryURL.substring(0, slashIndexSysPath);
            }
            if (!CFDownloadRepositoryBaseURL.endsWith(DIRECTORY_SEPARATOR)) {
                CFDownloadRepositoryBaseURL = CFDownloadRepositoryBaseURL + DIRECTORY_SEPARATOR;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeInstalledBundles(String lib) {
        String felixCache;
        File felixCacheFolder;
        if ((bundlesIdMap == null || bundlesIdMap.size() == 0) && (felixCacheFolder = new File(felixCache = FelixUtil.getFelixCache(lib))).exists()) {
            String[] installedBundles;
            for (String installedBundle : installedBundles = felixCacheFolder.list()) {
                String infoFile = felixCache + File.separator + installedBundle + File.separator + "bundle.info";
                if (!new File(infoFile).exists()) continue;
                BufferedReader reader = null;
                String installedBundlePath = null;
                long bundleId = -1L;
                try {
                    reader = new BufferedReader(new FileReader(infoFile));
                    String line = "";
                    int counter = 0;
                    int state = -1;
                    while (line != null) {
                        line = reader.readLine();
                        if (counter == 0) {
                            bundleId = Long.valueOf(line);
                        }
                        if (counter == 1) {
                            installedBundlePath = line.substring(5, line.length());
                        }
                        if (counter == 2) {
                            state = Integer.valueOf(line);
                        }
                        ++counter;
                        if (state != 1) continue;
                        new File(felixCache + File.separator + installedBundle).delete();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (null != reader) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                installedBundlePath = installedBundlePath.replace("\\", DIRECTORY_SEPARATOR);
                bundlesIdMap.put(installedBundlePath, bundleId);
            }
        }
    }

    public static String getFelixCache(String lib) {
        if (null == lib) {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        String felixCache = String.join((CharSequence)File.separator, Arrays.asList(lib, PARENT_DIR_IDENTIFIER, BIN, "felix-cache"));
        if (ServerlessUtil.isLambdaEnv()) {
            felixCache = "/tmp/felix-cache";
        }
        File cacheFolderObj = new File(felixCache);
        if (ServerlessUtil.isLambdaEnv() && !felixInitializedForServerless) {
            felixInitializedForServerless = true;
            if (cacheFolderObj.exists()) {
                FileUtils.deleteDirectory((String)felixCache, (boolean)true);
            }
            cacheFolderObj.mkdirs();
        }
        return felixCache;
    }

    public static boolean installed(String bundleName, String lib) {
        if (null == bundles || bundles.size() == 0) {
            try {
                FelixUtil.loadBundlesDependency(lib);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equalsIgnoreCase(bundleName) || !bundle.isInstalled()) continue;
            return true;
        }
        return false;
    }

    public static boolean installed(String bundleName, String lib, String version) {
        if (null == bundles || bundles.size() == 0) {
            try {
                FelixUtil.loadBundlesDependency(lib);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (CFBundle bundle : bundles) {
            String cBundleVesrion = bundle.getCurrentVersion();
            if (!bundle.getName().equalsIgnoreCase(bundleName) || cBundleVesrion == null || !cBundleVesrion.equals(version) || !bundle.isInstalled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isLambdaModuleInstalled(String bundleName) throws Exception {
        if (bundles.size() == 0 && ServerlessUtil.isLambdaEnv()) {
            FelixUtil.loadBundlesDependency("/var/task/cfusion/lib");
        }
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled() || !bundleName.equals(bundle.getName())) continue;
            return true;
        }
        return false;
    }

    public static void updateInstalledBundlesFile(final String lib) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    FelixUtil._updateInstalledBundlesFile(lib);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _updateInstalledBundlesFile(String lib) {
        boolean isServerRunning = false;
        try {
            isServerRunning = ModulesServlet.isServerRunning();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (lib == null && ServiceFactory.isRuntimeServiceInitialized()) {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        if (lib == null) {
            lib = libFolder;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder uninstallSb = new StringBuilder();
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            if (bundle.getCurrentVersion().equals("UNINSTALLED")) {
                uninstallSb.append(bundle.getName()).append(":").append("UNINSTALLED").append(",");
                continue;
            }
            sb.append(bundle.getName()).append(":").append(bundle.getCurrentVersion()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (ServerlessUtil.isLambdaEnv()) {
            if (installedBundlesFile == null) {
                installedBundlesFile = new InMemoryFile(lib, new File(lib));
            }
            InMemoryOutputStream os = null;
            try {
                os = new InMemoryOutputStream(installedBundlesFile);
                os.write(sb.toString().getBytes());
            }
            catch (Exception e) {
                ModulesServlet.printError(e.getMessage());
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (CFService.loadingServicesAtStartup || isServerRunning || FelixUtil.isLambdaPackageManager()) {
            OutputStreamWriter fw = null;
            FileReader bundlesFr = null;
            try {
                bundlesFr = new FileReader(lib + File.separator + "installedBundles.txt");
                Properties propsImport = new Properties();
                propsImport.load(bundlesFr);
                String serverHotfixUpdateLevel = propsImport.getProperty("server_hotfix_updatelevel", "0");
                fw = new FileWriter(lib + File.separator + "installedBundles.txt");
                String bundlesContent = sb.toString();
                Properties bundlesProps = new Properties();
                bundlesProps.put("packages", bundlesContent);
                bundlesProps.put("server_hotfix_updatelevel", serverHotfixUpdateLevel);
                bundlesProps.store(fw, "");
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(RB.getString(FelixUtil.class, (String)"FelixUtil.permissiondenied"));
            }
            catch (IOException e) {
                ModulesServlet.printError(e.getMessage());
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        ModulesServlet.printError(e.getMessage());
                    }
                }
                if (bundlesFr != null) {
                    try {
                        bundlesFr.close();
                    }
                    catch (IOException e) {
                        ModulesServlet.printError(e.getMessage());
                    }
                }
            }
        } else if (!isServerRunning && uninstallSb.length() > 0) {
            ModulesServlet.storeToBeInstalledBundles(uninstallSb.toString());
        }
    }

    public static void setRepositoryPath(String repositoryPath) throws Exception {
        String rootDir = ModulesServlet.getServerRoot();
        Map updateSettings = updatesSettingsMap;
        if (updateSettings == null) {
            updateSettings = FelixUtil.getUpdatesSettings(rootDir);
        }
        String packagesURLExisting = (String)updateSettings.get(PACKAGES_URL);
        Path settingsFile = Paths.get(rootDir + File.separator + "lib" + File.separator + "neo_updates.xml", new String[0]);
        try {
            String updatesXmlContent = new String(Files.readAllBytes(settingsFile), StandardCharsets.UTF_8);
            if (updatesXmlContent.contains(packagesURLExisting)) {
                updatesXmlContent = updatesXmlContent.replace("<packagesurl>" + packagesURLExisting, "<packagesurl>" + repositoryPath);
            }
            Files.write(settingsFile, updatesXmlContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        ModulesServlet.printInfo(RB.getString(FelixUtil.class, (String)"FelixUtil.updaterepopath"));
    }

    public static void replicateRepository(String downloadPath) throws Exception {
        if (!new File(downloadPath + "/repo/").exists()) {
            new File(downloadPath + "/repo/").mkdirs();
        }
        if (null == bundles || bundles.size() == 0) {
            try {
                FelixUtil.loadBundlesDependency(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String dependsFilePathTo = downloadPath + File.separator + "bundlesdependency.json";
        try {
            FelixUtil.downloadBundleFromCFDownloadRepository(dependsFilePathTo, "bundlesdependency.json");
        }
        catch (Exception e) {
            ModulesServlet.printError(e.getMessage());
        }
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            String moduleExtension;
            String bundleJarName;
            String toBundle;
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            if (bundle.containsKey((Object)"alias")) {
                bName = bundle.getString("alias");
            }
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (bVersion.equals(DEFAULT_VERSION) || bVersion.trim().length() == 0) {
                bVersion = FelixUtil.getDefaultVersion();
            }
            if (!new File(toBundle = downloadPath + File.separator + (bundleJarName = bName + "-" + bVersion + (moduleExtension = ".jar"))).exists()) {
                try {
                    FelixUtil.downloadBundleFromCFDownloadRepository(toBundle, bundleJarName);
                }
                catch (Exception e) {
                    ModulesServlet.printError(e.getMessage());
                }
            }
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            JsonArray extrastoinstall = bundle.getJsonArray("extrastoinstall");
            JsonArray[] dependenciesArrays = new JsonArray[]{dependencies, extrastoinstall};
            for (int j = 0; j < dependenciesArrays.length; ++j) {
                for (int y = 0; dependenciesArrays[j] != null && y < dependenciesArrays[j].size(); ++y) {
                    boolean embedded;
                    String type;
                    JsonObject dependency = dependenciesArrays[j].getJsonObject(y);
                    Object dependencyName = dependency.getString("name");
                    String dependencyVersion = null;
                    if (dependency.containsKey((Object)"version") && (dependencyVersion = dependency.getString("version")).equals(DEFAULT_VERSION)) {
                        dependencyVersion = FelixUtil.getDefaultVersion();
                    }
                    if (dependencyVersion == null) {
                        dependencyVersion = FelixUtil.getDefaultVersion();
                    }
                    if (dependencyVersion != null && dependency.containsKey((Object)"type") && (type = dependency.getString("type")) != null && type.equals("cfdependency") || dependency.containsKey((Object)"embedded") && (embedded = dependency.getBoolean("embedded"))) continue;
                    if (dependencyVersion != null && dependencyVersion.length() > 0) {
                        dependencyName = (String)dependencyName + "-" + dependencyVersion;
                    }
                    String extension = ".jar";
                    if (dependency.containsKey((Object)"extension")) {
                        extension = dependency.getString("extension");
                    }
                    Object to = "";
                    Object fromPath = "";
                    if (extension.endsWith(".zip")) {
                        to = downloadPath + File.separator + (String)dependencyName + extension;
                        fromPath = (String)dependencyName + extension;
                    } else {
                        to = downloadPath + File.separator + "repo/" + (String)dependencyName + extension;
                        fromPath = "repo/" + (String)dependencyName + extension;
                    }
                    if (new File((String)to).exists()) continue;
                    try {
                        try {
                            FelixUtil.downloadBundleFromCFDownloadRepository((String)to, (String)fromPath);
                        }
                        catch (Exception e) {
                            System.err.println(e.getMessage());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        ModulesServlet.printError(e.getMessage());
                        throw e;
                    }
                }
            }
        }
        String updatesURL = FelixUtil.getUpdatesURL(ModulesServlet.getServerRoot());
        FelixUtil.downloadCoreServerUpdates(updatesURL, downloadPath);
    }

    public static List<String> getAxisDependencies(String bundleName, String version) {
        if (version == null) {
            version = FelixUtil.getCurrentVersionToInstall(bundleName);
        }
        ArrayList<String> axisDependenciesList = new ArrayList<String>();
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            axisDependenciesList.add(bundleName + "-" + version + ".jar");
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            for (int y = 0; y < dependencies.size(); ++y) {
                JsonObject dependency = dependencies.getJsonObject(y);
                String dependencyName = dependency.getString("name");
                String dependencyVersion = dependency.getString("version");
                String dependencyNameVersionJar = dependencyName + "-" + dependencyVersion + ".jar";
                axisDependenciesList.add(dependencyNameVersionJar);
            }
        }
        return axisDependenciesList;
    }

    public static List<String> downloadDependencies(String bundleName, String lib, String version) throws Exception {
        String downloadPath;
        ArrayList<String> dependenciesList;
        block20: {
            dependenciesList = new ArrayList<String>();
            String cfHomePath = "";
            try {
                cfHomePath = new File(lib + "/../../").getCanonicalPath();
            }
            catch (IOException e) {
                ModulesServlet.printError(e.getMessage());
            }
            downloadPath = cfHomePath + "/bundles";
            String alias = "";
            for (CFBundle bun : bundles) {
                if (!bun.getName().equals(bundleName) || !bun.getCurrentVersion().equals(version)) continue;
                alias = bun.getAlias();
                break;
            }
            Object bundlePath = "";
            if (!new File(cfHomePath + "//bundles").exists()) {
                new File(cfHomePath + "//bundles").mkdir();
            }
            bundlePath = cfHomePath + File.separator + "bundles" + File.separator + alias + "-" + version + ".jar";
            bundlePath = ((String)bundlePath).replace("\\", DIRECTORY_SEPARATOR);
            dependenciesList.add(alias + "-" + version + ".jar");
            if (!new File((String)bundlePath).exists()) {
                try {
                    if (!FelixUtil.isJarValid((String)bundlePath)) {
                        FelixUtil.downloadBundleFromCFDownloadRepository((String)bundlePath, alias + "-" + version + ".jar");
                    }
                }
                catch (FileNotFoundException fnfe) {
                    if (invokedFromClient) break block20;
                    throw fnfe;
                }
            }
        }
        if (!CFService.loadingServicesAtStartup || bundlesDependencies == null) {
            FelixUtil.loadBundlesDependency(lib);
        }
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            JsonArray extrastoinstall = bundle.getJsonArray("extrastoinstall");
            JsonArray[] dependenciesArrays = new JsonArray[]{dependencies, extrastoinstall};
            for (int j = 0; j < dependenciesArrays.length; ++j) {
                for (int y = 0; dependenciesArrays[j] != null && y < dependenciesArrays[j].size(); ++y) {
                    String type;
                    boolean embedded;
                    JsonObject dependency = dependenciesArrays[j].getJsonObject(y);
                    Object dependencyName = dependency.getString("name");
                    String dependencyVersion = null;
                    if (dependency.containsKey((Object)"version")) {
                        dependencyVersion = dependency.getString("version");
                        if (dependencyVersion != null && dependencyVersion.equals(DEFAULT_VERSION)) {
                            dependencyVersion = FelixUtil.getDefaultVersion();
                        }
                    } else {
                        dependencyVersion = FelixUtil.getDefaultVersion();
                    }
                    if (dependency.containsKey((Object)"embedded") && (embedded = dependency.getBoolean("embedded")) || dependency.containsKey((Object)"type") && (type = dependency.getString("type")).equals("cfdependency")) continue;
                    if (dependencyVersion != null && dependencyVersion.length() > 0) {
                        dependencyName = (String)dependencyName + "-" + dependencyVersion;
                    }
                    String extension = ".jar";
                    if (dependency.containsKey((Object)"extension")) {
                        extension = dependency.getString("extension");
                    }
                    Object to = "";
                    Object fromPath = "";
                    if (extension.endsWith(".zip")) {
                        to = downloadPath + File.separator + (String)dependencyName + extension;
                        fromPath = (String)dependencyName + extension;
                        dependenciesList.add((String)fromPath);
                    } else {
                        to = downloadPath + File.separator + "repo/" + (String)dependencyName + extension;
                        fromPath = "repo/" + (String)dependencyName + extension;
                        dependenciesList.add((String)fromPath);
                    }
                    if (FelixUtil.isJarValid((String)to)) continue;
                    FelixUtil.downloadBundleFromCFDownloadRepository((String)to, (String)fromPath);
                }
            }
            break;
        }
        return dependenciesList;
    }

    private static boolean isLambdaPackageManager() {
        return Boolean.getBoolean("LAMBDAMODE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployDependencies(String bundleName, String lib, String version) throws Exception {
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        int threads = 1;
        if (invokedFromClient) {
            threads = Runtime.getRuntime().availableProcessors() * 3;
        }
        if (threads > 10) {
            threads = 10;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(threads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "cf-dependency-download-thread");
            }
        });
        ArrayList<DownloadAndInstalThread> futureList = new ArrayList<DownloadAndInstalThread>();
        ArrayList<Exception> exc = new ArrayList<Exception>();
        if (!CFService.loadingServicesAtStartup || bundlesDependencies == null) {
            FelixUtil.loadBundlesDependency(lib);
        }
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            if (null == dependencies) break;
            for (int y = 0; y < dependencies.size(); ++y) {
                boolean embedded;
                JsonObject dependency = dependencies.getJsonObject(y);
                Object dependencyName = dependency.getString("name");
                String dependencyVersion = dependency.getString("version");
                if (dependencyVersion != null && dependencyVersion.equals(DEFAULT_VERSION)) {
                    dependencyVersion = FelixUtil.getDefaultVersion();
                }
                if (dependency.containsKey((Object)"embedded") && (embedded = dependency.getBoolean("embedded"))) continue;
                if (dependency.containsKey((Object)"type")) {
                    String type = dependency.getString("type");
                    if (!type.equals("cfdependency")) continue;
                    if (FelixUtil.installed((String)dependencyName, lib, dependencyVersion)) continue;
                    boolean b = CFService.loadingServicesAtStartup;
                    CFService.loadingServicesAtStartup = false;
                    HashMap<String, String> msgs = new HashMap<String, String>();
                    ModulesServlet.installBundle((String)dependencyName, dependencyVersion, msgs);
                    CFService.loadingServicesAtStartup = b;
                    if (!msgs.containsKey("error")) continue;
                    throw new Exception((String)msgs.get("error"));
                }
                if (dependencyVersion != null && dependencyVersion.length() > 0) {
                    dependencyName = (String)dependencyName + "-" + dependencyVersion;
                }
                Object to = cfHomePath + File.separator + "bundles" + File.separator + "repo" + File.separator + (String)dependencyName + ".jar";
                to = ((String)to).replace("\\", DIRECTORY_SEPARATOR);
                String from = lib + "//bundles//repo//" + (String)dependencyName + ".jar";
                if (!new File(cfHomePath + "//bundles").exists()) {
                    new File(cfHomePath + "//bundles").mkdir();
                }
                if (!new File(cfHomePath + "/bundles/repo/").exists()) {
                    new File(cfHomePath + "/bundles/repo/").mkdir();
                }
                futureList.add(new DownloadAndInstalThread((String)to, from, (String)dependencyName, bundleName, exc));
            }
            try {
                executorService.invokeAll(futureList, 60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                CFLogs.SERVER_LOG.error((Object)RB.getString(CFService.class, (String)"bundle_installation_interrupted"), (Throwable)ex);
            }
            finally {
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        executorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    executorService.shutdownNow();
                }
            }
            if (exc.size() <= 0) break;
            throw (Exception)exc.get(0);
        }
        FelixUtil.deployNonJarDependencies(bundleName, lib, version);
    }

    public static Bundle downloadAndInstall(String to, String from, String dependencyName, String bundleName) throws Exception {
        Bundle bundle = null;
        if (!(bundlesIdMap.containsKey(to = to.replace("\\", DIRECTORY_SEPARATOR)) || FelixUtil.isJarValid(to) || ServerlessUtil.isLambdaEnv())) {
            try {
                if (null != from && new File(from).exists()) {
                    FelixUtil.downloadBundle(to, from);
                } else {
                    FelixUtil.downloadBundleFromCFDownloadRepository(to, "repo/" + dependencyName + ".jar");
                }
            }
            catch (Exception e) {
                if (!invokedFromClient) {
                    CFLogs.SERVER_LOG.error((Throwable)e);
                }
                throw e;
            }
        }
        try {
            bundle = FelixUtil.installBundle(to);
        }
        catch (BundleException e) {
            ModulesServlet.printError(RB.getString(FelixUtil.class, (String)"FelixUtil.errorDeploy2", (Object)bundleName, (Object)dependencyName, (Object)to, (Object)e.getMessage(), (Object)e.getCause()));
            throw e;
        }
        Integer count = installedJarsCounterMap.get(dependencyName);
        if (null == count) {
            installedJarsCounterMap.put(dependencyName, 1);
        } else {
            installedJarsCounterMap.put(dependencyName, count + 1);
        }
        return bundle;
    }

    public static void deployNonJarDependencies(String bundleName, String lib, String version) throws Exception {
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            JsonArray extrastoinstall = bundle.getJsonArray("extrastoinstall");
            for (int y = 0; extrastoinstall != null && y < extrastoinstall.size(); ++y) {
                boolean embedded;
                JsonObject nonJardependency = extrastoinstall.getJsonObject(y);
                Object dependencyName = nonJardependency.getString("name");
                String dependencyVersion = null;
                if (nonJardependency.containsKey((Object)"version") && (dependencyVersion = nonJardependency.getString("version")).equals(DEFAULT_VERSION)) {
                    dependencyVersion = FelixUtil.getDefaultVersion();
                }
                if (dependencyVersion == null) {
                    dependencyVersion = FelixUtil.getDefaultVersion();
                }
                String extension = nonJardependency.getString("extension");
                String targetDir = nonJardependency.getString("targetdir");
                String cfHome = "";
                cfHome = !invokedFromClient ? CFService.getPath() : System.getProperty("CFUSION_HOME");
                if (new File(cfHome + File.separator + PARENT_DIR_IDENTIFIER).getCanonicalPath().endsWith("WEB-INF") && targetDir.contains(WWWROOT)) {
                    targetDir = targetDir.replace(WWWROOT, File.separator + PARENT_DIR_IDENTIFIER + File.separator + PARENT_DIR_IDENTIFIER);
                }
                boolean targetInstalledAlready = true;
                if (CFService.loadingServicesAtStartup && (bundleName.equals("adminapi") && new File(cfHome + File.separator + targetDir + "/base.cfc").exists() || bundleName.equals("administrator") && new File(cfHome + File.separator + targetDir + "/header.cfm").exists()) && FelixUtil.isModuleInstalled(bundleName, version)) {
                    return;
                }
                if (nonJardependency.containsKey((Object)"embedded") && (embedded = nonJardependency.getBoolean("embedded"))) continue;
                if (!new File(cfHomePath + "/bundles").exists()) {
                    new File(cfHomePath + "/bundles").mkdir();
                }
                if (!new File(cfHomePath + "/bundles/repo/").exists()) {
                    new File(cfHomePath + "/bundles/repo/").mkdir();
                }
                if (dependencyVersion != null && dependencyVersion.length() > 0) {
                    dependencyName = (String)dependencyName + "-" + dependencyVersion;
                }
                Object to = cfHomePath + File.separator + "bundles" + File.separator + (String)dependencyName + extension;
                to = ((String)to).replace("\\", DIRECTORY_SEPARATOR);
                String from = cfHomePath + "/bundles/" + (String)dependencyName + extension;
                if (bundlesIdMap.containsKey(to)) continue;
                if (!new File((String)to).exists()) {
                    try {
                        if (new File(from).exists()) {
                            FelixUtil.downloadBundle((String)to, from);
                        } else {
                            String repoPath = DIRECTORY_SEPARATOR + (String)dependencyName + extension;
                            FelixUtil.downloadBundleFromCFDownloadRepository((String)to, repoPath);
                        }
                    }
                    catch (Exception e) {
                        if (!invokedFromClient) {
                            CFLogs.SERVER_LOG.error((Throwable)e);
                        }
                        throw e;
                    }
                }
                if (!FelixUtil.isLambdaPackageManager() && invokedFromClient && !bundleName.equals("odbc")) continue;
                Object targetDirFullPath = cfHome + File.separator + targetDir;
                String targetDirExistCheckPath = targetDirFullPath;
                if (bundleName.equals("odbc")) {
                    targetDirExistCheckPath = (String)targetDirFullPath + "/SequeLink Setup";
                    String serviceStatusDetails = FelixUtil.executeService("query", odbcserver, true);
                    boolean serviceStatus = serviceStatusDetails != null && !serviceStatusDetails.contains("RUNNING") && !serviceStatusDetails.contains("STOPPED");
                    boolean targetDirExists = new File(targetDirExistCheckPath).exists();
                    if (targetDir.equalsIgnoreCase("cfusion") && !targetDirExists || serviceStatus) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("derby")) {
                    targetDirExistCheckPath = (String)targetDirFullPath + "/derby.properties";
                    if (!new File(targetDirExistCheckPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("websocket")) {
                    if (!new File((String)targetDirFullPath + "/lib/wsproxyconfig.jar").exists() || !new File((String)targetDirFullPath + "/bin/wsproxyconfig.exe").exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("eventgateways")) {
                    if (!new File((String)targetDirFullPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("adminapi")) {
                    targetDirExistCheckPath = (String)targetDirFullPath + "/base.cfc";
                    if (!new File(targetDirExistCheckPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("graphqlclient")) {
                    if (!new File((String)targetDirFullPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("administrator")) {
                    targetDirExistCheckPath = (String)targetDirFullPath + "/header.cfm";
                    if (!new File(targetDirExistCheckPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("ccs")) {
                    targetDirExistCheckPath = (String)targetDirFullPath + "/cfcentralconfigserver.jar";
                    if (!new File(targetDirExistCheckPath).exists()) {
                        targetInstalledAlready = false;
                    }
                } else if (bundleName.equals("ajax")) {
                    String scriptExt = FelixUtil.getCFScriptsPath(lib, "ext");
                    targetDirExistCheckPath = scriptExt + "/ext-all.js";
                    if (!new File(targetDirExistCheckPath).exists()) {
                        targetInstalledAlready = false;
                    }
                    if (!targetInstalledAlready) {
                        String script = FelixUtil.getCFScriptsPath(lib, "");
                        targetDirFullPath = script;
                        if (!new File(script).exists()) {
                            String scriptPath = FelixUtil._getDefaultCFScriptsPath();
                            throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.scriptnotfound", (Object)new File(scriptPath).getCanonicalPath(), (Object)to));
                        }
                    }
                }
                if (targetInstalledAlready) continue;
                if (bundleName.equals("odbc")) {
                    FelixUtil.stopODBCServices();
                }
                FelixUtil.unzip((String)to, (String)targetDirFullPath);
                if (!bundleName.equals("odbc")) continue;
                FelixUtil.installOdbcService(lib, version);
            }
        }
    }

    private static void stopODBCServices() {
        ArrayList<String> argsODBCServerStop = new ArrayList<String>();
        argsODBCServerStop.add("stop");
        argsODBCServerStop.add(odbcserver);
        FelixUtil.execute("net.exe", argsODBCServerStop, true, 30);
        ArrayList<String> argsODBCAgentStop = new ArrayList<String>();
        argsODBCAgentStop.add("stop");
        argsODBCAgentStop.add(odbcagent);
        FelixUtil.execute("net.exe", argsODBCAgentStop, true, 30);
    }

    private static void loadBundlesDependency(String lib) throws Exception {
        FelixUtil.loadBundlesDependency(lib, !ServerlessUtil.isLambdaEnv());
    }

    public static void loadBundlesDependency(String lib, boolean createWatch) throws Exception {
        FelixUtil.loadBundlesDependency(lib, createWatch, false);
    }

    public static void reloadBundlesDependency(String lib) throws Exception {
        String bVersion;
        String bName;
        JsonObject bundle;
        int i;
        if (null == lib) {
            try {
                lib = ServiceFactory.getRuntimeService().getLibDir();
            }
            catch (Throwable e) {
                lib = libFolder;
            }
        }
        if (lib == null) {
            lib = System.getenv("CFUSION_HOME");
        }
        if (lib != null && ((String)lib).endsWith("\\\\..")) {
            int pos = ((String)lib).lastIndexOf("\\\\..");
            lib = ((String)lib).substring(0, pos + 1);
            lib = (String)lib + PARENT_DIR_IDENTIFIER + File.separator + "lib";
        }
        if (!CFService.loadingServicesAtStartup) {
            FelixUtil.initializeDownloadBaseURL((String)lib, true);
        }
        String path = (String)lib + "/../.." + File.separator + "bundles" + File.separator + "bundlesdependency.json";
        String path2 = (String)lib + "/../.." + File.separator + "bundles" + File.separator + "bundlesdependency_custom.json";
        String contentLocalBundles = null;
        String contentLocalBundles_UserCustom = null;
        String contentHostedBundles = null;
        String bundlesJsonUrl = CFDownloadRepositoryBaseURL + "bundlesdependency.json";
        String bundlesPath = new File((String)lib + "/../.." + File.separator + "bundles").getCanonicalPath();
        if (new File(path).exists()) {
            contentLocalBundles = new String(Files.readAllBytes(Paths.get(path, new String[0])));
        }
        if (new File(path2).exists()) {
            contentLocalBundles_UserCustom = new String(Files.readAllBytes(Paths.get(path2, new String[0])));
        }
        if (new File(CFDownloadRepositoryBaseURL + "bundlesdependency.json").exists()) {
            contentHostedBundles = new String(Files.readAllBytes(Paths.get(bundlesJsonUrl, new String[0])));
        } else if (!CFService.loadingServicesAtStartup || !new File(path).exists()) {
            try {
                contentHostedBundles = FelixUtil.isLambdaPackageManager() ? contentLocalBundles : FelixUtil.getBundlesDependencyJSONData(bundlesJsonUrl);
            }
            catch (Exception ex) {
                String message = RB.getString(FelixUtil.class, (String)"FelixUtil.inaccessibleRepo", (Object)CFDownloadRepositoryURL, (Object)bundlesPath);
                ModulesServlet.printInfo2(message);
                CFDownloadRepositoryBaseURL = bundlesPath + File.separatorChar;
            }
        }
        ArrayList<CallSite> bundleNameVersions = new ArrayList<CallSite>();
        JsonArrayBuilder jsonArBuilder = Json.createArrayBuilder();
        if (contentLocalBundles_UserCustom != null && contentLocalBundles_UserCustom.length() > 0) {
            JsonReader jsonReaderLocalBundles_UserCustom = Json.createReader((Reader)new StringReader(contentLocalBundles_UserCustom));
            JsonArray bundlesDependenciesLocal_UserCustom = jsonReaderLocalBundles_UserCustom.readArray();
            for (i = 0; i < bundlesDependenciesLocal_UserCustom.size(); ++i) {
                bundle = bundlesDependenciesLocal_UserCustom.getJsonObject(i);
                bName = bundle.getString("bundle");
                bVersion = FelixUtil.getDefaultVersion();
                if (bundle.containsKey((Object)"version")) {
                    bVersion = bundle.getString("version");
                }
                bundleNameVersions.add((CallSite)((Object)(bName + "-" + bVersion)));
                jsonArBuilder.add((JsonValue)bundle);
            }
        }
        if (contentHostedBundles != null && contentHostedBundles.length() > 0) {
            JsonReader jsonReaderHostedBundles = Json.createReader((Reader)new StringReader(contentHostedBundles));
            JsonArray bundlesDependenciesHosted = jsonReaderHostedBundles.readArray();
            for (i = 0; i < bundlesDependenciesHosted.size(); ++i) {
                bundle = bundlesDependenciesHosted.getJsonObject(i);
                bName = bundle.getString("bundle");
                bVersion = FelixUtil.getDefaultVersion();
                if (bundle.containsKey((Object)"version")) {
                    bVersion = bundle.getString("version");
                }
                if (bundleNameVersions.contains(bName + "-" + bVersion)) continue;
                bundleNameVersions.add((CallSite)((Object)(bName + "-" + bVersion)));
                jsonArBuilder.add((JsonValue)bundle);
            }
        }
        if (contentLocalBundles != null && contentLocalBundles.length() > 0) {
            JsonReader jsonReaderLocalBundles = Json.createReader((Reader)new StringReader(contentLocalBundles));
            JsonArray bundlesDependenciesLocal = jsonReaderLocalBundles.readArray();
            for (i = 0; i < bundlesDependenciesLocal.size(); ++i) {
                bundle = bundlesDependenciesLocal.getJsonObject(i);
                bName = bundle.getString("bundle");
                bVersion = FelixUtil.getDefaultVersion();
                if (bundle.containsKey((Object)"version")) {
                    bVersion = bundle.getString("version");
                }
                if (bundleNameVersions.contains(bName + "-" + bVersion)) continue;
                jsonArBuilder.add((JsonValue)bundle);
            }
        }
        bundlesDependencies = jsonArBuilder.build();
    }

    public static void loadBundlesDependency(String lib, boolean createWatch, boolean reload) throws Exception {
        if (bundlesDependencies == null || reload) {
            FelixUtil.reloadBundlesDependency(lib);
        }
        if (bundles == null || bundles.size() == 0 || reload) {
            if (reload || bundles == null) {
                bundles = new ArrayList<CFBundle>();
            }
            try {
                FelixUtil.loadCFBundles(lib, false);
                try {
                    if (createWatch && !invokedFromClient) {
                        FelixUtil.createWatcher(lib);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void reloadBundles() throws Exception {
        HashMap<CallSite, CFBundle> refreshBundles = new HashMap<CallSite, CFBundle>();
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            int minimumCoreServerUpdateRequired = 0;
            if (bundle.containsKey((Object)"minimumcoreserverupdaterequired")) {
                minimumCoreServerUpdateRequired = bundle.getInt("minimumcoreserverupdaterequired");
            }
            CFBundle cfb = new CFBundle();
            cfb.setName(bName);
            cfb.setMinimumCoreServerUpdateRequired(minimumCoreServerUpdateRequired);
            String alias = bName;
            if (bundle.containsKey((Object)"alias")) {
                alias = bundle.getString("alias");
            }
            cfb.setAlias(alias);
            if (bundle.containsKey((Object)"awsserverless")) {
                cfb.setLambdaSupport(bundle.getBoolean("awsserverless"));
            }
            HashSet<String> versions = new HashSet<String>();
            if (bundle.containsKey((Object)"version")) {
                String version = bundle.getString("version");
                versions.add(version);
                cfb.setCurrentVersion(version);
            }
            if (cfb.getCurrentVersion() == null) {
                cfb.setCurrentVersion(FelixUtil.getDefaultVersion());
            }
            versions.add(FelixUtil.getDefaultVersion());
            if (bundle.containsKey((Object)"description")) {
                cfb.setDescription(bundle.getString("description"));
            }
            if (bundle.containsKey((Object)"type")) {
                cfb.setType(bundle.getString("type"));
            }
            if (bundle.containsKey((Object)"dependencies")) {
                JsonArray dependencies = bundle.getJsonArray("dependencies");
                ArrayList<DependentBundle> depBundles = new ArrayList<DependentBundle>();
                for (int j = 0; j < dependencies.size(); ++j) {
                    JsonObject dependency = dependencies.getJsonObject(j);
                    String name = dependency.getString("name");
                    String version = dependency.getString("version");
                    if (version != null && version.equals(DEFAULT_VERSION)) {
                        version = FelixUtil.getDefaultVersion();
                    }
                    String type = "jardependency";
                    if (dependency.containsKey((Object)"type")) {
                        type = dependency.getString("type");
                    }
                    DependentBundle dp = new DependentBundle();
                    dp.setName(name);
                    dp.setVersion(version);
                    dp.setType(type);
                    depBundles.add(dp);
                }
                cfb.setDependentBundles(depBundles);
            }
            cfb.setVersions(versions);
            refreshBundles.put((CallSite)((Object)(bName + ":" + cfb.getCurrentVersion())), cfb);
        }
        Map<String, CFBundle> allBundlesMap = FelixUtil.getAllBundlesMap();
        for (String bunNameVer : refreshBundles.keySet()) {
            CFBundle cfb = (CFBundle)refreshBundles.get(bunNameVer);
            if (allBundlesMap.containsKey(bunNameVer)) {
                CFBundle cfbundle = allBundlesMap.get(bunNameVer);
                cfbundle.setMinimumCoreServerUpdateRequired(cfb.getMinimumCoreServerUpdateRequired());
                cfbundle.setDependentBundles(cfb.getDependentBundles());
                cfbundle.setVersions(cfb.getVersions());
                continue;
            }
            bundles.add(cfb);
        }
        for (String bunNameVer : allBundlesMap.keySet()) {
            CFBundle cfbundle = allBundlesMap.get(bunNameVer);
            if (refreshBundles.containsKey(bunNameVer) || cfbundle.isInstalled()) continue;
            bundles.remove(cfbundle);
        }
    }

    public static void reloadBundlesAndBundlesDependencies(String lib) throws Exception {
        FelixUtil.reloadBundlesDependency(lib);
        FelixUtil.reloadBundles();
    }

    public static String createHotfixInstallerFile(String rootPath, String hfID) throws PrivilegedActionException {
        Object cfInstallHome = rootPath + "/../";
        try {
            cfInstallHome = new File((String)cfInstallHome).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cfInstallHome = ((String)cfInstallHome).replace("\\", "$/$");
        String serverName = FelixUtil.getInstanceName(rootPath);
        final String fileContent = "INSTALLER_UI=silent\r\nUSER_INSTALL_DIR=" + (String)cfInstallHome + "\r\nINSTANCE_LIST=" + serverName + "\r\nIS_INSTALLED_BY_CFPM=true";
        final String hfInstallerProps = rootPath + File.separatorChar + UPDATES_DIR + File.separatorChar + hfID + ".properties";
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                File propertiesFile = new File(hfInstallerProps);
                if (!propertiesFile.exists()) {
                    propertiesFile.getParentFile().mkdirs();
                    propertiesFile.createNewFile();
                }
                FileOutputStream fileOP = null;
                PrintStream pOut = null;
                try {
                    fileOP = new FileOutputStream(propertiesFile);
                    pOut = new PrintStream(fileOP);
                    pOut.print(fileContent);
                }
                finally {
                    if (pOut != null) {
                        pOut.close();
                    }
                    if (fileOP != null) {
                        fileOP.close();
                    }
                }
                return null;
            }
        });
        return hfInstallerProps;
    }

    public static String getInstanceName(String serverPath) {
        String defautServer = "cfusion";
        String configFile = serverPath + "/../config/instances.xml";
        File fXmlFile = new File(configFile);
        Document doc = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(fXmlFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ModulesServlet.printError(e.getMessage());
        }
        NodeList nList = null;
        if (doc != null) {
            doc.getDocumentElement().normalize();
            nList = doc.getElementsByTagName("server");
        }
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            NamedNodeMap nodeAttribs = nNode.getAttributes();
            Node rNode = nodeAttribs.getNamedItem("remote");
            if (rNode != null || nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            String iserverName = FelixUtil.getTagValue("name", eElement);
            String iserverPath = FelixUtil.getTagValue("directory", eElement);
            if (!iserverPath.equals(serverPath)) continue;
            return iserverName;
        }
        return defautServer;
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
        Node nValue = nlList.item(0);
        return nValue.getNodeValue().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadAndInstallCoreHotfix(int updateLevelToInstall) throws Exception {
        block52: {
            String hfJarFileToPath;
            boolean isJarValidExists;
            String serverRoot = ModulesServlet.getServerRoot();
            String updatesURL = "";
            updatesURL = FelixUtil.getUpdatesURL(serverRoot);
            OutputStreamWriter fw = null;
            InputStreamReader bundlesFrPostInstall = null;
            Object hfJarFileName = "";
            String[] updatesData = null;
            hfJarFileName = updateLevelToInstall <= 9 ? "hotfix-00" + updateLevelToInstall + ".jar" : (updateLevelToInstall >= 10 && updateLevelToInstall < 100 ? "hotfix-0" + updateLevelToInstall + ".jar" : HOTFIX_FILE_PREFIX + updateLevelToInstall + ".jar");
            String hfJarDownloadDir = ModulesServlet.getServerRoot() + "/../bundles/updateinstallers";
            Object localHostedUpdatesXml = "";
            if (new File(hfJarDownloadDir + "/updates.xml").exists()) {
                localHostedUpdatesXml = hfJarDownloadDir + "/updates.xml";
            } else if (new File(CFDownloadRepositoryBaseURL + "updateinstallers/updates.xml").exists()) {
                localHostedUpdatesXml = CFDownloadRepositoryBaseURL + "updateinstallers/updates.xml";
            }
            if (((String)localHostedUpdatesXml).length() > 0 && (updatesData = FelixUtil.getcoreServerUpdatesData(updatesURL, updateLevelToInstall)) != null && updatesData.length >= 5) {
                hfJarFileName = updatesData[4];
            }
            if (!(isJarValidExists = FelixUtil.isJarValid(hfJarFileToPath = hfJarDownloadDir + File.separatorChar + (String)hfJarFileName))) {
                hfJarFileToPath = CFDownloadRepositoryBaseURL + UPDATE_INSTALLERS_REPO_DIR + File.separatorChar + (String)hfJarFileName;
                isJarValidExists = FelixUtil.isJarValid(hfJarFileToPath);
            }
            try {
                String hfInstallStatusMessage;
                if (!isJarValidExists) {
                    updatesData = FelixUtil.getcoreServerUpdatesData(updatesURL, updateLevelToInstall);
                    if (updatesData == null || updatesData != null && updatesData[3] == null) {
                        FelixUtil.auditLog(RB.getString(FelixUtil.class, (String)"FelixUtil.updatenotfound", (Object)updateLevelToInstall, (Object)updatesURL));
                        throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.updatenotfound", (Object)updateLevelToInstall, (Object)updatesURL));
                    }
                    String from = updatesData[3];
                    hfJarFileName = updatesData[4];
                    hfJarFileToPath = hfJarDownloadDir + File.separatorChar + (String)hfJarFileName;
                    isJarValidExists = FelixUtil.isJarValid(hfJarFileToPath);
                    if (!isJarValidExists) {
                        File installerDir = new File(hfJarFileToPath + "/../");
                        if (!installerDir.exists()) {
                            installerDir.mkdirs();
                        }
                        InputStream is = null;
                        is = FelixUtil.downloadFromURL(from);
                        if (is != null) {
                            try (BufferedInputStream bis = new BufferedInputStream(is);
                                 FileOutputStream fis = new FileOutputStream(hfJarFileToPath);){
                                byte[] buffer = new byte[1024];
                                int count = 0;
                                while ((count = bis.read(buffer, 0, 1024)) != -1) {
                                    fis.write(buffer, 0, count);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                is.close();
                            }
                            boolean isJarValid = FelixUtil.isJarValid(hfJarFileToPath);
                            if (!isJarValid) {
                                FelixUtil.auditLog(RB.getString(FelixUtil.class, (String)"FelixUtil.invalidfile", (Object)hfJarFileToPath));
                                throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.invalidfile", (Object)hfJarFileToPath));
                            }
                        }
                    }
                }
                Object installerPopsFile = FelixUtil.createHotfixInstallerFile(serverRoot, ((String)hfJarFileName).replace(".jar", ""));
                String javaPath = System.getProperty("java.home") + "/bin/java";
                if (javaPath.contains(" ")) {
                    javaPath = "\"" + javaPath + "\"";
                }
                if (((String)installerPopsFile).contains(" ")) {
                    installerPopsFile = "\"" + (String)installerPopsFile + "\"";
                }
                String command = javaPath + " -jar " + hfJarFileToPath + " -i silent -f " + (String)installerPopsFile;
                FelixUtil.executeCommand(command, true);
                int serverUpdateLevelAfterInstallation = Integer.parseInt(Version.getUpdateLevel((String)serverRoot, (boolean)true));
                if (serverUpdateLevelAfterInstallation == updateLevelToInstall) {
                    hfInstallStatusMessage = RB.getString(FelixUtil.class, (String)"FelixUtil.hotfixsuccess");
                    if (invokedFromClient) {
                        System.out.println(hfInstallStatusMessage);
                    } else {
                        FelixUtil.auditLog(hfInstallStatusMessage);
                    }
                    bundlesFrPostInstall = new FileReader(serverRoot + "/lib/installedBundles.txt");
                    Properties propsPostInstall = new Properties();
                    propsPostInstall.load(bundlesFrPostInstall);
                    fw = new FileWriter(serverRoot + "/lib/installedBundles.txt");
                    propsPostInstall.put("server_hotfix_updatelevel", "" + updateLevelToInstall);
                    propsPostInstall.store(fw, "");
                    break block52;
                }
                hfInstallStatusMessage = RB.getString(FelixUtil.class, (String)"FelixUtil.hotfixerror", (Object)new File(serverRoot + "/hf-updates").getCanonicalPath());
                if (invokedFromClient) {
                    System.out.println(hfInstallStatusMessage);
                } else {
                    FelixUtil.auditLog(hfInstallStatusMessage);
                }
                return;
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (bundlesFrPostInstall != null) {
                    try {
                        bundlesFrPostInstall.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFromURLToFile(String fromUrl, String filePath) throws Exception {
        InputStream is = null;
        is = FelixUtil.downloadFromURL(fromUrl);
        if (is != null) {
            try (BufferedInputStream bis = new BufferedInputStream(is);
                 FileOutputStream fis = new FileOutputStream(filePath);){
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((count = bis.read(buffer, 0, 1024)) != -1) {
                    fis.write(buffer, 0, count);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstallGivenHotfixUpdateLevel(int updateLevelToUnInstall, int expectedUpdateLevelAfterUninstall) {
        block33: {
            String serverRoot = ModulesServlet.getServerRoot();
            Map updateSettings = FelixUtil.getUpdatesSettings(serverRoot);
            Object updatesURL = "";
            updatesURL = (String)updateSettings.get(URL);
            if (updatesURL == null) {
                updatesURL = (String)updateSettings.get(DEFAULT_URL);
            }
            updatesURL = serverRoot + "/hf-updates/updates.xml";
            OutputStreamWriter fw = null;
            InputStreamReader bundlesFrPostInstall = null;
            try {
                String[] updatesData = FelixUtil.getcoreServerInstalledUpdatesData((String)updatesURL, updateLevelToUnInstall);
                String hotfixID = updatesData[0];
                String uninstallerJarPath = serverRoot + File.separatorChar + UPDATES_DIR + File.separatorChar + hotfixID + File.separatorChar + "uninstall" + File.separatorChar + "uninstaller.jar";
                String javaPath = System.getProperty("java.home") + "/bin/java";
                if (javaPath.contains(" ")) {
                    javaPath = "\"" + javaPath + "\"";
                }
                if (uninstallerJarPath.contains(" ")) {
                    uninstallerJarPath = "\"" + uninstallerJarPath + "\"";
                }
                String command = javaPath + " -jar " + uninstallerJarPath + " -i silent";
                FelixUtil.executeCommand(command, true);
                int serverUpdateLevelAfterInstallation = Integer.parseInt(Version.getUpdateLevel((String)serverRoot, (boolean)true));
                if (serverUpdateLevelAfterInstallation == expectedUpdateLevelAfterUninstall) {
                    String hfInstallStatusMessage = RB.getString(FelixUtil.class, (String)"FelixUtil.hotfixsuccess");
                    if (invokedFromClient) {
                        System.out.println(hfInstallStatusMessage);
                    } else {
                        FelixUtil.auditLog(hfInstallStatusMessage);
                    }
                    bundlesFrPostInstall = new FileReader(serverRoot + "/lib/installedBundles.txt");
                    Properties propsPostInstall = new Properties();
                    propsPostInstall.load(bundlesFrPostInstall);
                    fw = new FileWriter(serverRoot + "/lib/installedBundles.txt");
                    propsPostInstall.put("server_hotfix_updatelevel", "" + expectedUpdateLevelAfterUninstall);
                    propsPostInstall.store(fw, "");
                    break block33;
                }
                String hfInstallStatusMessage = RB.getString(FelixUtil.class, (String)"FelixUtil.hotfixerror", (Object)new File(serverRoot + "/hf-updates").getCanonicalPath());
                if (invokedFromClient) {
                    System.out.println(hfInstallStatusMessage);
                } else {
                    FelixUtil.auditLog(hfInstallStatusMessage);
                }
                return;
            }
            catch (Exception e) {
                if (invokedFromClient) {
                    System.out.println(e.getMessage());
                } else {
                    FelixUtil.auditLog(e.getMessage());
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (bundlesFrPostInstall != null) {
                    try {
                        bundlesFrPostInstall.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUpdatesURL(String serverRoot) {
        Map updateSettings = FelixUtil.getUpdatesSettings(serverRoot);
        String updatesURL = "";
        updatesURL = (String)updateSettings.get(URL);
        if (updatesURL == null) {
            updatesURL = (String)updateSettings.get(DEFAULT_URL);
        }
        boolean isHotfixUrlAccessible = true;
        InputStream is = null;
        try {
            is = FelixUtil.downloadFromURL(updatesURL);
        }
        catch (Exception e) {
            isHotfixUrlAccessible = false;
        }
        finally {
            if (is == null) {
                isHotfixUrlAccessible = false;
            } else {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String hfJarDownloadDir = ModulesServlet.getServerRoot() + "/../bundles/updateinstallers";
        Object localHostedUpdatesXml = "";
        if (new File(hfJarDownloadDir + "/updates.xml").exists()) {
            localHostedUpdatesXml = hfJarDownloadDir + "/updates.xml";
        } else if (new File(CFDownloadRepositoryBaseURL + "updateinstallers/updates.xml").exists()) {
            localHostedUpdatesXml = CFDownloadRepositoryBaseURL + "updateinstallers/updates.xml";
        }
        Object hotfixUrlToUse = updatesURL;
        if (isHotfixUrlAccessible) {
            hotfixUrlToUse = updatesURL;
        } else if (((String)localHostedUpdatesXml).length() > 0) {
            hotfixUrlToUse = localHostedUpdatesXml;
        }
        return hotfixUrlToUse;
    }

    public static int getLatestUpdateLevel() throws Exception {
        int latestUpdateLevel = 0;
        String serverRoot = ModulesServlet.getServerRoot();
        String coreServerUpdatesURL = FelixUtil.getUpdatesURL(serverRoot);
        List<String[]> updatesData = null;
        try {
            updatesData = FelixUtil.getcoreServerUpdatesData(coreServerUpdatesURL);
        }
        catch (Throwable e) {
            return latestUpdateLevel;
        }
        for (String[] updateData : updatesData) {
            int updateLevel = Integer.parseInt(updateData[1]);
            if (updateLevel <= latestUpdateLevel) continue;
            latestUpdateLevel = updateLevel;
        }
        return latestUpdateLevel;
    }

    public static String[] getcoreServerUpdatesData(String coreServerUpdatesURL, int updateLevelToGet) throws Exception {
        List<String[]> updatesData = FelixUtil.getcoreServerUpdatesData(coreServerUpdatesURL);
        for (String[] updateData : updatesData) {
            int updateLevel = Integer.parseInt(updateData[1]);
            if (updateLevel != updateLevelToGet) continue;
            return updateData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getcoreServerUpdatesData(String coreServerUpdatesURL) throws Exception {
        Node node;
        int i;
        ArrayList<String[]> updateDataFiltered = new ArrayList<String[]>();
        ArrayList<Node> updateData = new ArrayList<Node>();
        InputStream is = null;
        is = new File(coreServerUpdatesURL).exists() ? new FileInputStream(new File(coreServerUpdatesURL)) : FelixUtil.downloadFromURL(coreServerUpdatesURL);
        if (is != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(is);
                NodeList nodes = doc.getElementsByTagName("cfhf_updatelevel");
                if (nodes != null) {
                    for (i = 0; i < nodes.getLength(); ++i) {
                        node = nodes.item(i);
                        updateData.add(node);
                    }
                }
            }
            catch (Exception builder) {
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        Iterator iterator = updateData.iterator();
        while (iterator.hasNext()) {
            String[] updateValues = new String[6];
            Node nodeItr = (Node)iterator.next();
            NodeList givenUpdateNodes = nodeItr.getParentNode().getChildNodes();
            if (givenUpdateNodes != null) {
                block7: for (i = 0; i < givenUpdateNodes.getLength(); ++i) {
                    node = givenUpdateNodes.item(i);
                    String nodeName = node.getNodeName();
                    if (nodeName.equals("cfhf_id")) {
                        String hotfix_ID;
                        updateValues[0] = hotfix_ID = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (nodeName.equals("cfhf_updatelevel")) {
                        String hotfix_updatelevel;
                        updateValues[1] = hotfix_updatelevel = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (nodeName.equals("cfhf_buildnumber")) {
                        String hotfix_buildnumber;
                        updateValues[2] = hotfix_buildnumber = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!nodeName.equals("cfhf_servers")) continue;
                    NodeList downloadDetails = node.getChildNodes();
                    for (int j = 0; j < downloadDetails.getLength(); ++j) {
                        NodeList list;
                        String versionInstalled;
                        String[] versionInstalledValues;
                        String majorVersionInstalled;
                        Node serverVersionNode;
                        String version;
                        String[] versionValues;
                        String majorVersion;
                        NamedNodeMap versionNode;
                        node = downloadDetails.item(j);
                        String nodeName1 = node.getNodeName();
                        if (!nodeName1.equals("cfhf_server") || (versionNode = node.getAttributes()) == null || !(majorVersion = (versionValues = (version = (serverVersionNode = versionNode.getNamedItem("version")).getNodeValue()).split(","))[0]).equals(majorVersionInstalled = (versionInstalledValues = (versionInstalled = Version.getBaseVersion()).split(","))[0]) || (list = node.getChildNodes()) == null) continue;
                        for (int k = 0; k < list.getLength(); ++k) {
                            String itemValue;
                            Node item = list.item(k);
                            String itemName = item.getNodeName();
                            if (itemName.equals("cfhf_downloadlink")) {
                                updateValues[3] = itemValue = item.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (itemName.equals("cfhf_filename")) {
                                updateValues[4] = itemValue = item.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (!itemName.equals("cfhf_checksum")) continue;
                            updateValues[5] = itemValue = item.getFirstChild().getNodeValue().trim();
                        }
                        continue block7;
                    }
                }
            }
            if (updateValues[3] == null) continue;
            updateDataFiltered.add(updateValues);
        }
        return updateDataFiltered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadCoreServerUpdates(String coreServerUpdatesURL, String repoDownloadPath) throws Exception {
        String coreUpdatesDownloadDir = repoDownloadPath + File.separatorChar + UPDATE_INSTALLERS_REPO_DIR;
        ArrayList<Node> updateData = new ArrayList<Node>();
        InputStream is = null;
        FileOutputStream fos = null;
        is = FelixUtil.downloadFromURL(coreServerUpdatesURL);
        if (is != null) {
            new File(coreUpdatesDownloadDir).mkdirs();
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                fos = new FileOutputStream(coreUpdatesDownloadDir + "/updates.xml");
                byte[] buffer = new byte[1024];
                int count = 0;
                while ((count = bis.read(buffer, 0, 1024)) != -1) {
                    fos.write(buffer, 0, count);
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new FileInputStream(coreUpdatesDownloadDir + "/updates.xml"));
                NodeList nodes = doc.getElementsByTagName("cfhf_updatelevel");
                if (nodes != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        updateData.add(node);
                    }
                }
            }
            catch (Exception e) {
                if (invokedFromClient) {
                    System.out.println(e.getMessage());
                } else {
                    FelixUtil.auditLog(e.getMessage());
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        Iterator iterator = updateData.iterator();
        while (iterator.hasNext()) {
            String[] updateValues = new String[6];
            Node nodeItr = (Node)iterator.next();
            NodeList givenUpdateNodes = nodeItr.getParentNode().getChildNodes();
            if (givenUpdateNodes != null) {
                block8: for (int i = 0; i < givenUpdateNodes.getLength(); ++i) {
                    Node node = givenUpdateNodes.item(i);
                    String nodeName = node.getNodeName();
                    if (nodeName.equals("cfhf_id")) {
                        String hotfix_ID;
                        updateValues[0] = hotfix_ID = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (nodeName.equals("cfhf_updatelevel")) {
                        String hotfix_updatelevel;
                        updateValues[1] = hotfix_updatelevel = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (nodeName.equals("cfhf_buildnumber")) {
                        String hotfix_buildnumber;
                        updateValues[2] = hotfix_buildnumber = node.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!nodeName.equals("cfhf_servers")) continue;
                    NodeList downloadDetails = node.getChildNodes();
                    for (int j = 0; j < downloadDetails.getLength(); ++j) {
                        NodeList list;
                        String versionInstalled;
                        String[] versionInstalledValues;
                        String majorVersionInstalled;
                        Node serverVersionNode;
                        String version;
                        String[] versionValues;
                        String majorVersion;
                        NamedNodeMap versionNode;
                        node = downloadDetails.item(j);
                        String nodeName1 = node.getNodeName();
                        if (!nodeName1.equals("cfhf_server") || (versionNode = node.getAttributes()) == null || !(majorVersion = (versionValues = (version = (serverVersionNode = versionNode.getNamedItem("version")).getNodeValue()).split(","))[0]).equals(majorVersionInstalled = (versionInstalledValues = (versionInstalled = Version.getBaseVersion()).split(","))[0]) || (list = node.getChildNodes()) == null) continue;
                        for (int k = 0; k < list.getLength(); ++k) {
                            String itemValue;
                            Node item = list.item(k);
                            String itemName = item.getNodeName();
                            if (itemName.equals("cfhf_downloadlink")) {
                                updateValues[3] = itemValue = item.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (itemName.equals("cfhf_filename")) {
                                updateValues[4] = itemValue = item.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (!itemName.equals("cfhf_checksum")) continue;
                            updateValues[5] = itemValue = item.getFirstChild().getNodeValue().trim();
                        }
                        continue block8;
                    }
                }
            }
            if (updateValues[3] == null) continue;
            ModulesServlet.printInfo2(RB.getString(FelixUtil.class, (String)"FelixUtil.downoadingInfo2", (Object)updateValues[4]));
            FelixUtil.downloadFromURLToFile(updateValues[3], coreUpdatesDownloadDir + DIRECTORY_SEPARATOR + updateValues[4]);
        }
    }

    public static List<String[]> getcoreServerInstalledUpdatesData(String installedUpdatesPath) throws Exception {
        ArrayList<String[]> installedUpdateData = new ArrayList<String[]>();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        FileInputStream inputStream = new FileInputStream(installedUpdatesPath);
        InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        InputSource is = new InputSource(streamReader);
        is.setEncoding("UTF-8");
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName("item");
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            String[] updateValues = new String[3];
            Element eElement = (Element)nNode;
            String hfId = FelixUtil.getTagValue("cfhf_id", eElement);
            String hfUpdateLevel = FelixUtil.getTagValue("cfhf_updatelevel", eElement);
            String hfBuildnumber = FelixUtil.getTagValue("cfhf_buildnumber", eElement);
            updateValues[0] = hfId;
            updateValues[1] = hfUpdateLevel;
            updateValues[2] = hfBuildnumber;
            installedUpdateData.add(updateValues);
        }
        return installedUpdateData;
    }

    public static String[] getcoreServerInstalledUpdatesData(String coreServerUpdatesURL, int updateLevelToGet) throws Exception {
        List<String[]> installedUpdatesData = FelixUtil.getcoreServerInstalledUpdatesData(coreServerUpdatesURL);
        for (String[] updateData : installedUpdatesData) {
            int updateLevel = Integer.parseInt(updateData[1]);
            if (updateLevel != updateLevelToGet) continue;
            return updateData;
        }
        return null;
    }

    public static String getBundlesDependencyJSONData(String bundlesJsonUrl) throws Exception {
        if (ServerlessUtil.isLambdaEnv()) {
            return null;
        }
        String bundlesJsonData = null;
        StringBuffer dependencyData = new StringBuffer();
        InputStream is = null;
        is = FelixUtil.downloadFromURL(bundlesJsonUrl);
        if (is != null) {
            String line;
            InputStreamReader isReader = new InputStreamReader(is);
            BufferedReader reader = new BufferedReader(isReader);
            while ((line = reader.readLine()) != null) {
                dependencyData.append(line);
            }
        }
        bundlesJsonData = dependencyData.toString();
        return bundlesJsonData;
    }

    public static String getRedirectURL(String url, Map updatesSettings) throws Exception {
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUsername = null;
        String proxyPassword = null;
        proxyHost = (String)updatesSettings.get(PROXY_HOSTNAME);
        proxyPort = (Integer)updatesSettings.get(PROXY_PORT);
        proxyUsername = (String)updatesSettings.get(PROXY_USER);
        proxyPassword = (String)updatesSettings.get(PROXY_PASSWORD);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        if (proxyHost != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            requestBuilder.setProxy(proxy);
        }
        requestBuilder.setConnectTimeout(4000);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).build();
        HttpGet httpGet = new HttpGet(url);
        HttpClientContext context = HttpClientContext.create();
        if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
        List redircts = context.getRedirectLocations();
        String redirectURL = null;
        if (redircts != null && redircts.size() > 0) {
            URI redirectURI = (URI)redircts.get(redircts.size() - 1);
            redirectURL = redirectURI.toString();
        }
        return redirectURL;
    }

    public static InputStream downloadFromURL(String url) throws Exception {
        String rootDir = ModulesServlet.getServerRoot();
        Map updatesSettings = null;
        if (rootDir != null) {
            updatesSettings = FelixUtil.getUpdatesSettings(rootDir);
        }
        String proxyHost = null;
        Integer proxyPort = null;
        String proxyUsername = null;
        String proxyPassword = null;
        proxyHost = (String)updatesSettings.get(PROXY_HOSTNAME);
        proxyPort = (Integer)updatesSettings.get(PROXY_PORT);
        proxyUsername = (String)updatesSettings.get(PROXY_USER);
        proxyPassword = (String)updatesSettings.get(PROXY_PASSWORD);
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        HttpGet httpget = new HttpGet(url);
        if (proxyHost != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort.intValue());
            requestBuilder.setProxy(proxy);
            if (proxyUsername != null) {
                String auth = proxyPassword == null ? proxyUsername : proxyUsername + ":" + proxyPassword;
                BasicHeader header = new BasicHeader("Proxy-Authorization", "Basic " + Base64Encoder.encode((byte[])auth.getBytes()));
                httpget.setHeader((Header)header);
            }
        }
        requestBuilder.setConnectTimeout(4000);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).build();
        HttpGet httpGet = new HttpGet(url);
        HttpClientContext context = HttpClientContext.create();
        if (proxyHost != null && proxyUsername != null && proxyPassword != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
        InputStream inp = null;
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            if (response != null) {
                throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.cannotDownload", (Object)url, (Object)response.getStatusLine().getReasonPhrase()));
            }
            throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.downloaderror"));
        }
        inp = response.getEntity().getContent();
        return inp;
    }

    public static Map getUpdatesSettings(String rootDir) {
        if (CFService.loadingServicesAtStartup && updatesSettingsMap != null) {
            return updatesSettingsMap;
        }
        File settingsFile = new File(rootDir + File.separator + "lib" + File.separator + "neo_updates.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(settingsFile);
            NodeList nodeList = doc.getElementsByTagName("update");
            Node node = null;
            updatesSettingsMap = new HashMap();
            nodeList = doc.getElementsByTagName(URL);
            if (nodeList != null && (node = nodeList.item(0)).getFirstChild() != null) {
                updatesSettingsMap.put(URL, node.getFirstChild().getNodeValue());
            }
            if ((nodeList = doc.getElementsByTagName(DEFAULT_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                updatesSettingsMap.put(DEFAULT_URL, node.getFirstChild().getNodeValue());
            }
            if ((nodeList = doc.getElementsByTagName(PACKAGES_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                updatesSettingsMap.put(PACKAGES_URL, node.getFirstChild().getNodeValue());
            }
            if ((nodeList = doc.getElementsByTagName(DEFAULT_PACKAGES_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                updatesSettingsMap.put(DEFAULT_PACKAGES_URL, node.getFirstChild().getNodeValue());
            }
            if ((nodeList = doc.getElementsByTagName(PROXY)) != null) {
                String port;
                nodeList = doc.getElementsByTagName(PROXY_HOSTNAME);
                if (nodeList != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    updatesSettingsMap.put(PROXY_HOSTNAME, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PORT)) != null && (node = nodeList.item(0)).getFirstChild() != null && (port = node.getFirstChild().getNodeValue()) != null && port.length() > 0) {
                    updatesSettingsMap.put(PROXY_PORT, Integer.parseInt(node.getFirstChild().getNodeValue()));
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_USER)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    updatesSettingsMap.put(PROXY_USER, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PASSWORD)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    updatesSettingsMap.put(PROXY_PASSWORD, node.getFirstChild().getNodeValue());
                }
            }
            return updatesSettingsMap;
        }
        catch (Exception e) {
            ModulesServlet.printError(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCFBundles(String lib, boolean clear) throws Exception {
        if (lib == null && ServiceFactory.isRuntimeServiceInitialized()) {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        if (lib == null) {
            lib = libFolder;
        }
        if (clear && bundles != null) {
            bundles.clear();
        }
        if (installedJarsCounterMap.size() > 0) {
            installedJarsCounterMap.clear();
        }
        String toInstallBundlesPath = lib + File.separator + "toInstallBundles.txt";
        String installedBundlesPath = lib + File.separator + "installedBundles.txt";
        String installedBundlesContent1 = "";
        int currentServerUpdateLevel = 0;
        List<String> installedBundlesContent1List = null;
        if (new File(installedBundlesPath).exists()) {
            FileReader bundlesFr = new FileReader(installedBundlesPath);
            Properties props = new Properties();
            props.load(bundlesFr);
            installedBundlesContent1 = props.getProperty("packages", "");
            installedBundlesContent1List = Arrays.asList(installedBundlesContent1.split(","));
            currentServerUpdateLevel = Integer.parseInt(Version.getUpdateLevel((String)(lib + "/../")));
        }
        String content2 = "";
        if (CFService.loadingServicesAtStartup && new File(toInstallBundlesPath).exists()) {
            FileReader bundlesFr2 = new FileReader(toInstallBundlesPath);
            Properties props2 = new Properties();
            props2.load(bundlesFr2);
            content2 = props2.getProperty("packages", "");
        }
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            int minimumCoreServerUpdateRequired = 0;
            if (bundle.containsKey((Object)"minimumcoreserverupdaterequired")) {
                minimumCoreServerUpdateRequired = bundle.getInt("minimumcoreserverupdaterequired");
            }
            CFBundle cfb = new CFBundle();
            cfb.setName(bName);
            cfb.setMinimumCoreServerUpdateRequired(minimumCoreServerUpdateRequired);
            String alias = bName;
            if (bundle.containsKey((Object)"description")) {
                cfb.setDescription(bundle.getString("description"));
            }
            if (bundle.containsKey((Object)"category")) {
                cfb.setCategory(bundle.getString("category"));
            }
            if (bundle.containsKey((Object)"alias")) {
                alias = bundle.getString("alias");
            }
            cfb.setAlias(alias);
            if (bundle.containsKey((Object)"awsserverless")) {
                cfb.setLambdaSupport(bundle.getBoolean("awsserverless"));
            }
            String content = null;
            content = ServerlessUtil.isLambdaEnv() && installedBundlesFile != null ? new String(installedBundlesFile.read()) : installedBundlesContent1;
            content = content.trim();
            HashSet<String> versions = new HashSet<String>();
            if (bundle.containsKey((Object)"version")) {
                String version = bundle.getString("version");
                versions.add(version);
                cfb.setCurrentVersion(version);
            } else {
                versions.add(FelixUtil.getDefaultVersion());
            }
            if (cfb.getCurrentVersion() == null) {
                cfb.setCurrentVersion(FelixUtil.getDefaultVersion());
            }
            if (!FelixUtil.isLambdaPackageManager() || FelixUtil.isLambdaPackageManager() && cfb.isLambdaSupport() && FelixUtil.getUpdateLevelForBundle(cfb) <= currentServerUpdateLevel) {
                bundles.add(cfb);
            }
            String installedVersion = null;
            for (String ibundle : content.split(",")) {
                String[] split = ibundle.split(":");
                String name = split[0];
                if (name.equalsIgnoreCase(bName)) {
                    installedVersion = FelixUtil.getDefaultVersion();
                    if (split.length == 2) {
                        installedVersion = split[1];
                    }
                }
                if (name.equalsIgnoreCase(bName) && installedVersion != null && cfb.getCurrentVersion().contentEquals(installedVersion)) {
                    cfb.setInstalled(true);
                }
                if (!name.equalsIgnoreCase(bName) || installedVersion == null || !installedVersion.equals("UNINSTALLED") || FelixUtil.isLambdaPackageManager()) continue;
                CFBundle cfbUninstalled = new CFBundle();
                cfbUninstalled.setName(bName);
                cfbUninstalled.setMinimumCoreServerUpdateRequired(minimumCoreServerUpdateRequired);
                cfbUninstalled.setAlias(alias);
                cfbUninstalled.setCurrentVersion("UNINSTALLED");
                bundles.add(cfbUninstalled);
            }
            if (bundle.containsKey((Object)"updates")) {
                JsonArray updates = bundle.getJsonArray("updates");
                for (int j = 0; j < updates.size(); ++j) {
                    JsonObject update = updates.getJsonObject(i);
                    String version = update.getString("version");
                    versions.add(version);
                }
            }
            if (bundle.containsKey((Object)"type")) {
                cfb.setType(bundle.getString("type"));
            }
            if (bundle.containsKey((Object)"dependencies")) {
                JsonArray dependencies = bundle.getJsonArray("dependencies");
                ArrayList<DependentBundle> depBundles = new ArrayList<DependentBundle>();
                for (int j = 0; j < dependencies.size(); ++j) {
                    JsonObject dependency = dependencies.getJsonObject(j);
                    String name = dependency.getString("name");
                    String version = dependency.getString("version");
                    if (version != null && version.equals(DEFAULT_VERSION)) {
                        version = FelixUtil.getDefaultVersion();
                    }
                    String dependencyName = name + "-" + version;
                    String type = "jardependency";
                    if (dependency.containsKey((Object)"type")) {
                        type = dependency.getString("type");
                    }
                    Integer count = installedJarsCounterMap.get(dependencyName);
                    if (cfb.isInstalled() && FelixUtil.isLambdaPackageManager()) {
                        if (count == null) {
                            installedJarsCounterMap.put(dependencyName, 1);
                        } else {
                            installedJarsCounterMap.put(dependencyName, count + 1);
                        }
                    }
                    DependentBundle dp = new DependentBundle();
                    dp.setName(name);
                    dp.setVersion(version);
                    dp.setType(type);
                    depBundles.add(dp);
                }
                cfb.setDependentBundles(depBundles);
            }
            cfb.setVersions(versions);
        }
        boolean anyOnStartNewInstallDone = false;
        if (CFService.loadingServicesAtStartup) {
            String[] bundlesSplit1;
            if (content2.equals("all-base")) {
                cfbundles = FelixUtil.getListOfDefaultVersionBundles();
                content2 = ModulesServlet.convertListToCommaBundles(cfbundles);
            } else if (content2.equals("all")) {
                cfbundles = FelixUtil.getListOfLatestVersionOfEachBundle();
                content2 = ModulesServlet.convertListToCommaBundles(cfbundles);
            }
            Object toInstallBundlesFinal = "";
            int serverUpdateLevelRequired = 0;
            if (content2 != null && content2.length() > 0) {
                serverUpdateLevelRequired = FelixUtil.getServerUpdateLevelRequiredForInstall(content2);
            }
            for (String bundle : bundlesSplit1 = content2.split(",")) {
                if (installedBundlesContent1List == null || installedBundlesContent1List.contains(bundle)) continue;
                toInstallBundlesFinal = (String)toInstallBundlesFinal + bundle + ",";
            }
            if (((String)toInstallBundlesFinal).endsWith(",")) {
                toInstallBundlesFinal = ((String)toInstallBundlesFinal).substring(0, ((String)toInstallBundlesFinal).length() - 1);
            }
            if (((String)toInstallBundlesFinal).length() > 0 && currentServerUpdateLevel >= serverUpdateLevelRequired) {
                String bundleName;
                String[] iSplit;
                String[] bundlesSplit;
                anyOnStartNewInstallDone = true;
                toInstallBundlesFinal = ModulesServlet.getOrderedBundles((String)toInstallBundlesFinal, true);
                for (String bun : bundlesSplit = ((String)toInstallBundlesFinal).split(",")) {
                    if (bun.length() == 0) continue;
                    bun = bun.trim();
                    iSplit = bun.split(":");
                    bundleName = iSplit[0];
                    for (CFBundle bundle : bundles) {
                        if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
                        try {
                            FelixUtil.undeployBundle(bundleName);
                        }
                        catch (Exception e) {
                            if (invokedFromClient) {
                                System.out.println(e.getMessage());
                                continue;
                            }
                            FelixUtil.auditLog(e.getMessage());
                        }
                    }
                }
                if (CFService.onStartNewInstalls == null) {
                    CFService.onStartNewInstalls = new HashMap();
                }
                toInstallBundlesFinal = ModulesServlet.getOrderedBundles((String)toInstallBundlesFinal, false);
                for (String bun : bundlesSplit = ((String)toInstallBundlesFinal).split(",")) {
                    if (bun.length() == 0) continue;
                    bun = bun.trim();
                    iSplit = bun.split(":");
                    bundleName = iSplit[0];
                    String version = DEFAULT_VERSION;
                    if (iSplit.length == 2) {
                        version = iSplit[1];
                    }
                    for (CFBundle bundle : bundles) {
                        if (!bundle.getName().equals(bundleName) || !bundle.getCurrentVersion().equals(version) || bundle.isInstalled()) continue;
                        try {
                            if (bundleName.equals("axis")) {
                                FelixUtil.deployAXISBundle(bundleName, version, lib);
                            } else {
                                FelixUtil.deployBundle(bundleName, version, lib);
                            }
                            CFService.onStartNewInstalls.put(bundleName, version);
                        }
                        catch (Exception e) {
                            if (invokedFromClient) {
                                System.out.println(e.getMessage());
                                continue;
                            }
                            FelixUtil.auditLog(e.getMessage());
                        }
                    }
                }
            }
        }
        for (CFBundle bundle : bundles) {
            if (invokedFromClient || bundle.getCurrentVersion() == null || !bundle.getCurrentVersion().equals("UNINSTALLED")) continue;
            try {
                FelixUtil.undeployBundle(bundle.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            bundle.setInstalled(false);
            bundle.setCurrentVersion(FelixUtil.getDefaultVersion());
        }
        if (anyOnStartNewInstallDone) {
            FelixUtil.updateInstalledBundlesFile(lib);
            OutputStreamWriter fw = null;
            FileReader fr = null;
            try {
                fr = new FileReader(toInstallBundlesPath);
                fw = new FileWriter(toInstallBundlesPath);
                Properties props2 = new Properties();
                props2.load(fr);
                props2.setProperty("packages", "");
                props2.store(fw, "");
            }
            catch (IOException e) {
                ModulesServlet.printError(e.getMessage());
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        ModulesServlet.printError(e.getMessage());
                    }
                }
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        ModulesServlet.printError(e.getMessage());
                    }
                }
            }
        }
    }

    private static int getUpdateLevelForBundle(CFBundle cfb) {
        String version = cfb.getCurrentVersion();
        String updateLevel = version.substring(version.indexOf(46) + 1);
        updateLevel = updateLevel.substring(updateLevel.indexOf(46) + 1);
        updateLevel = updateLevel.substring(0, updateLevel.indexOf(46));
        return Integer.valueOf(updateLevel);
    }

    public static String getDependentBundleName(String bundleName) {
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            List<DependentBundle> deps = bundle.getDependentBundles();
            for (DependentBundle dep : deps) {
                if (!dep.getName().equals(bundleName) || !dep.getType().equals("cfdependency") || !FelixUtil.installed(bundle.getName(), null) || bundle.getCurrentVersion().equals("UNINSTALLED")) continue;
                return bundle.getName();
            }
        }
        return null;
    }

    public static synchronized void undeployBundle(String bundleName) throws Exception {
        FelixUtil.undeployBundle(bundleName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void undeployBundle(String bundleName, boolean uninstallDependents) throws Exception {
        String wwwroot;
        String dependentBundleName = FelixUtil.getDependentBundleName(bundleName);
        if (null != dependentBundleName) {
            if (!uninstallDependents) {
                throw new Exception(RB.getString(FelixUtil.class, (String)"FelixUtil.uninstalldependency", (Object)bundleName, (Object)dependentBundleName));
            }
            FelixUtil.undeployBundle(dependentBundleName, uninstallDependents);
        }
        String lib = null;
        try {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        catch (Throwable e) {
            lib = libFolder;
        }
        if (bundleName.equals("ajax") && (!invokedFromClient || FelixUtil.isLambdaPackageManager())) {
            FelixUtil.deleteDirectoryRecusrively(new File(FelixUtil.getCFScriptsPath(lib, "ext")));
            FelixUtil.deleteDirectoryRecusrively(new File(FelixUtil.getCFScriptsPath(lib, "resources")));
            FelixUtil.deleteDirectoryRecusrively(new File(FelixUtil.getCFScriptsPath(lib, "ckeditor")));
        }
        if (bundleName.equals("adminapi") && (!invokedFromClient || FelixUtil.isLambdaPackageManager())) {
            wwwroot = FelixUtil.getWebroot(lib);
            FelixUtil.deleteDirectoryRecusrively(new File(wwwroot + File.separator + "CFIDE" + File.separator + "adminapi"));
        }
        if (bundleName.equals("administrator") && (!invokedFromClient || FelixUtil.isLambdaPackageManager())) {
            wwwroot = FelixUtil.getWebroot(lib);
            FelixUtil.deleteDirectoryRecusrively(new File(wwwroot + File.separator + "CFIDE" + File.separator + "administrator"));
        }
        if (bundleName.equals("ccs") && (!invokedFromClient || FelixUtil.isLambdaPackageManager())) {
            new File(String.join((CharSequence)File.separator, Arrays.asList(lib, PARENT_DIR_IDENTIFIER, BIN, "cfcentralconfigserver.jar"))).delete();
        }
        if (bundleName.equals("axis") && (!invokedFromClient || FelixUtil.isLambdaPackageManager())) {
            FelixUtil.deleteDirectoryRecusrively(new File(lib + "/bundleaxis/"));
        }
        if (!(invokedFromClient && FelixUtil.isLambdaPackageManager() || bundleName.equals("felixclassloader") || bundleName.equals("ajax"))) {
            FelixUtil.undeployBundle("felixclassloader");
        }
        try {
            FelixUtil.uninstallBundle(bundleName);
            String versionToUninstall = DEFAULT_VERSION;
            for (CFBundle cfbundle : bundles) {
                if (!cfbundle.getName().equals(bundleName) || !cfbundle.isInstalled()) continue;
                versionToUninstall = cfbundle.getCurrentVersion();
            }
            for (int i = 0; i < bundlesDependencies.size(); ++i) {
                String bVersion;
                JsonObject bundle = bundlesDependencies.getJsonObject(i);
                String bName = bundle.getString("bundle");
                String string = bVersion = bundle.containsKey((Object)"version") ? bundle.getString("version") : FelixUtil.getDefaultVersion();
                if (!bName.equalsIgnoreCase(bundleName) || !versionToUninstall.equals(bVersion)) continue;
                JsonArray dependencies = bundle.getJsonArray("dependencies");
                if (dependencies == null) {
                    break;
                }
                for (int y = dependencies.size() - 1; y >= 0; --y) {
                    Integer count;
                    String type;
                    JsonObject dependency = dependencies.getJsonObject(y);
                    Object dependencyName = dependency.getString("name");
                    String version = dependency.getString("version");
                    String string2 = type = dependency.containsKey((Object)"type") ? dependency.getString("type") : "";
                    if (type != null && "cfdependency".equals(type)) continue;
                    if (version != null && version.length() > 0) {
                        dependencyName = (String)dependencyName + "-" + version;
                    }
                    if (null == (count = installedJarsCounterMap.get(dependencyName)) || count == 1) {
                        FelixUtil.uninstallBundle((String)dependencyName);
                        installedJarsCounterMap.remove(dependencyName);
                        continue;
                    }
                    installedJarsCounterMap.put((String)dependencyName, count - 1);
                }
            }
        }
        finally {
            if (!(invokedFromClient || bundleName.equals("felixclassloader") || bundleName.equals("ajax"))) {
                try {
                    CFService.setupFelixclassloader();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!invokedFromClient) {
            ClassLoader cl = FelixUtil.class.getClassLoader();
            if (cl instanceof BootstrapClassLoader) {
                ((BootstrapClassLoader)cl).removeTagClasses();
            }
            ((RuntimeServiceImpl)ServiceFactory.getRuntimeService()).clearTrustedCache(false);
        }
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName)) continue;
            if (invokedFromClient && !FelixUtil.isLambdaPackageManager()) {
                if (!bundle.isInstalled()) continue;
                bundle.setCurrentVersion("UNINSTALLED");
                bundle.setInstalled(true);
                continue;
            }
            bundle.setInstalled(false);
        }
        if (!invokedFromClient || FelixUtil.isLambdaPackageManager()) {
            FelixUtil.updateInstalledBundlesFile(lib);
        }
    }

    private static String getWebroot(String lib) {
        String wwwroot = String.join((CharSequence)File.separator, Arrays.asList(lib, PARENT_DIR_IDENTIFIER, WWWROOT));
        if (!new File(wwwroot).exists()) {
            wwwroot = String.join((CharSequence)File.separator, Arrays.asList(lib, PARENT_DIR_IDENTIFIER, PARENT_DIR_IDENTIFIER, PARENT_DIR_IDENTIFIER));
        }
        return wwwroot;
    }

    public static void uninstallBundle(String bundleName) {
        String lib = libFolder;
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            lib = ServiceFactory.getRuntimeService().getLibDir();
        }
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        Object bundlePath = cfHomePath + File.separator + "bundles" + File.separator + "repo" + File.separator + bundleName + ".jar";
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
            bundlePath = cfHomePath + File.separator + "bundles" + File.separator + bundle.getAlias() + "-" + bundle.getCurrentVersion() + ".jar";
        }
        bundlePath = ((String)bundlePath).replace("\\", DIRECTORY_SEPARATOR);
        if (!invokedFromClient) {
            FelixUtil.auditLog("Uninstalling the package : " + bundleName);
            if (!bundleName.equals("felixclassloader")) {
                CFLogs.SERVER_LOG.info((Object)RB.getString(FelixUtil.class, (String)"FelixUtil.uninstallingBundle", (Object)bundleName));
            }
            BundleContext context = CFService.felix.getBundleContext();
            try {
                CFBundle bundle;
                if (bundlesIdMap.size() == 0) {
                    FelixUtil.initializeInstalledBundles(lib);
                }
                if (null != bundlesIdMap.get(bundlePath) && null != (bundle = context.getBundle(bundlesIdMap.get(bundlePath).longValue()))) {
                    bundle.uninstall();
                }
            }
            catch (BundleException e) {
                ModulesServlet.printError(e.getMessage());
            }
        }
        bundlesIdMap.remove(bundlePath);
        if (new File((String)bundlePath).exists() && FelixUtil.isLambdaPackageManager()) {
            new File((String)bundlePath).delete();
        }
    }

    public static Bundle installBundle(String bundlePath) throws BundleException {
        Bundle bundle = null;
        if (!invokedFromClient) {
            FelixUtil.auditLog("Installing the package : " + bundlePath);
            bundlePath = bundlePath.replace("\\", DIRECTORY_SEPARATOR);
            BundleContext context = CFService.felix.getBundleContext();
            if (!bundlesIdMap.containsKey(bundlePath)) {
                try {
                    bundle = context.installBundle("file:" + bundlePath);
                }
                catch (BundleException be) {
                    bundlePath = bundlePath.replace(DIRECTORY_SEPARATOR, "\\");
                    bundle = context.installBundle("file:" + bundlePath);
                }
                bundlesIdMap.put(bundlePath, bundle.getBundleId());
            } else {
                bundle = context.getBundle(bundlesIdMap.get(bundlePath).longValue());
            }
            if (null == bundle) {
                bundle = FelixUtil.handleNullBundle(bundlePath, context);
            }
            if (null == bundle) {
                ModulesServlet.printError("Bundle " + bundlePath + " is null.");
                return null;
            }
            if (bundle.getState() != 32 && bundle.getHeaders().get(FRAGMENT_HOST) == null) {
                bundle.start();
            }
            if (invokedFromClient) {
                System.out.println(RB.getString(FelixUtil.class, (String)"FelixUtil.installingBundle", (Object)bundlePath));
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleExportCommand(String exportPath) {
        RuntimeService rs;
        String libDir = libFolder;
        if (libDir == null && (rs = ServiceFactory.getRuntimeService()) != null) {
            libDir = rs.getLibDir();
        }
        int currentServerUpdateLevel = Integer.parseInt(Version.getUpdateLevel((String)(libDir + "/../"), (boolean)true));
        String currentServerBundleStateFilePath = libDir + File.separatorChar + "installedBundles.txt";
        OutputStreamWriter fw = null;
        FileReader bundlesFr = null;
        try {
            bundlesFr = new FileReader(currentServerBundleStateFilePath);
            Properties propsExisting = new Properties();
            propsExisting.load(bundlesFr);
            fw = new FileWriter(currentServerBundleStateFilePath);
            Properties bundlesProps = new Properties();
            bundlesProps.put("server_hotfix_updatelevel", "" + currentServerUpdateLevel);
            bundlesProps.put("packages", propsExisting.getProperty("packages"));
            bundlesProps.store(fw, "");
        }
        catch (IOException e) {
            if (invokedFromClient) {
                System.out.println(e.getMessage());
            } else {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    if (invokedFromClient) {
                        System.out.println(e.getMessage());
                    }
                    CFLogs.SERVER_LOG.error((Object)e.getMessage());
                }
            }
            if (bundlesFr != null) {
                try {
                    bundlesFr.close();
                }
                catch (IOException e) {
                    if (invokedFromClient) {
                        System.out.println(e.getMessage());
                    }
                    CFLogs.SERVER_LOG.error((Object)e.getMessage());
                }
            }
        }
        if (exportPath != null && exportPath.length() > 0) {
            File parentDir = new File(exportPath).getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            try {
                Files.copy(Paths.get(currentServerBundleStateFilePath, new String[0]), Paths.get(exportPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                System.out.println(RB.getString(FelixUtil.class, (String)"FelixUtil.exportbundlesstate", (Object)exportPath));
            }
            catch (IOException e) {
                if (invokedFromClient) {
                    System.out.println(e.getMessage());
                }
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bundle handleNullBundle(String bundlePath, BundleContext context) {
        String infoFile;
        File felixCacheFolder;
        if (!invokedFromClient) {
            CFLogs.SERVER_LOG.info((Object)("bundlePath : " + bundlePath));
            CFLogs.SERVER_LOG.info((Object)("bundlesIdMap : " + bundlesIdMap));
            CFLogs.SERVER_LOG.info((Object)("is present : " + context.getBundle(bundlesIdMap.get(bundlePath).longValue())));
        }
        if ((felixCacheFolder = new File(infoFile = FelixUtil.getFelixCache(null) + File.separator + "bundle" + bundlesIdMap.get(bundlePath) + File.separator + "bundle.info")).exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(infoFile));
                String line = "";
                while (line != null) {
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String path = bundlePath.substring(0, bundlePath.lastIndexOf("\\"));
        String bun = bundlePath.substring(bundlePath.lastIndexOf("\\") + 1, bundlePath.length());
        String lib = ServiceFactory.getRuntimeService().getLibDir();
        String cfHomePath = "";
        try {
            cfHomePath = new File(lib + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        String to = cfHomePath + File.separator + "bundles" + File.separator + "repo" + File.separator + bun;
        String from = cfHomePath + "//bundles//repo//" + bun;
        try {
            if (new File(from).exists()) {
                FelixUtil.downloadBundle(to, from);
            } else if (path.endsWith("repo")) {
                FelixUtil.downloadBundleFromCFDownloadRepository(to, "repo/" + bun);
            } else {
                FelixUtil.downloadBundleFromCFDownloadRepository(to, bun);
            }
        }
        catch (Exception e) {
            ModulesServlet.printError(e.getMessage());
        }
        Bundle bundle = null;
        try {
            bundle = context.installBundle("file:" + bundlePath);
        }
        catch (BundleException e) {
            ModulesServlet.printError(e.getMessage());
        }
        bundlesIdMap.put(bundlePath, bundle.getBundleId());
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadBundle(String to, String from) throws Exception {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int length;
            is = new FileInputStream(from);
            os = new FileOutputStream(to);
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        finally {
            if (null != is) {
                is.close();
            }
            if (null != os) {
                ((OutputStream)os).close();
            }
        }
    }

    public static boolean isModuleInstalled(String bundleName, File file) {
        if (!CFService.loadingServicesAtStartup) {
            return true;
        }
        if (CFService.loadingServicesAtStartup && CFService.onStartNewInstalls != null && CFService.onStartNewInstalls.containsKey(bundleName)) {
            return true;
        }
        return FelixUtil.installed(bundleName, null);
    }

    public static boolean isModuleInstalled(String bundleName) {
        boolean isModuleInstalled = false;
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
            isModuleInstalled = true;
            break;
        }
        return isModuleInstalled;
    }

    public static boolean isModuleInstalled(String bundleName, String version) {
        boolean isModuleInstalled = false;
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.getCurrentVersion().equals(version) || !bundle.isInstalled()) continue;
            isModuleInstalled = true;
            break;
        }
        return isModuleInstalled;
    }

    public static List<String> getAllVersionsOfAModule(String bundleName) {
        ArrayList<String> versionsOfBundle = new ArrayList<String>();
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName)) continue;
            versionsOfBundle.add(bundle.getCurrentVersion());
        }
        return versionsOfBundle;
    }

    public static String getInstalledVersionOfAModule(String bundleName) {
        String installedVersionOfBundle = "";
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
            installedVersionOfBundle = bundle.getCurrentVersion();
            break;
        }
        return installedVersionOfBundle;
    }

    public static List<String> getInstallableVersionsOfAModule(String bundleName) {
        ArrayList<String> installableVersionsOfBundle = new ArrayList<String>();
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || bundle.isInstalled()) continue;
            installableVersionsOfBundle.add(bundle.getCurrentVersion());
        }
        return installableVersionsOfBundle;
    }

    public boolean isUpdateAvailableToBundle(String bundleName) {
        String installedVersionFull = "";
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
            installedVersionFull = bundle.getCurrentVersion();
            break;
        }
        String[] splitsFullVersion = installedVersionFull.split(Pattern.quote("-"));
        String[] vesrionOfBundleSplits = splitsFullVersion[0].split(Pattern.quote("."));
        double installedVersion = 0.0;
        if (vesrionOfBundleSplits.length >= 4) {
            installedVersion = Double.parseDouble(vesrionOfBundleSplits[0] + vesrionOfBundleSplits[1] + vesrionOfBundleSplits[2] + vesrionOfBundleSplits[3]);
        }
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || bundle.isInstalled()) continue;
            String otherAvailableVesrionOfBundle = bundle.getCurrentVersion();
            String[] otherVersion = otherAvailableVesrionOfBundle.split(Pattern.quote("-"));
            String[] otherVersionSplits = otherVersion[0].split(Pattern.quote("."));
            double availableVersion = 0.0;
            if (otherVersionSplits.length >= 4) {
                availableVersion = Double.parseDouble(otherVersionSplits[0] + otherVersionSplits[1] + otherVersionSplits[2] + otherVersionSplits[3]);
            }
            if (!(availableVersion > installedVersion)) continue;
            return true;
        }
        return false;
    }

    public static List<CFBundle> getListOfDefaultVersionBundles() {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        ArrayList<CFBundle> bundlesForInstall = new ArrayList<CFBundle>();
        for (CFBundle bundle : cfbundles) {
            String vesrionOfBundle = bundle.getCurrentVersion();
            if (!vesrionOfBundle.equals(FelixUtil.getDefaultVersion())) continue;
            bundlesForInstall.add(bundle);
        }
        return bundlesForInstall;
    }

    public static List<CFBundle> getListOfLatestVersionOfEachBundle() {
        double currentBundleVersion;
        String vesrionOfBundle;
        String bundleName;
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        ArrayList<CFBundle> bundlesForInstall = new ArrayList<CFBundle>();
        HashMap<String, Double> latestVersionsMap = new HashMap<String, Double>();
        for (CFBundle bundle : cfbundles) {
            bundleName = bundle.getName();
            vesrionOfBundle = bundle.getCurrentVersion();
            currentBundleVersion = FelixUtil.getVersionAsNumber(vesrionOfBundle);
            if (latestVersionsMap.containsKey(bundleName)) {
                Double versionOfOtherBundle = (Double)latestVersionsMap.get(bundleName);
                if (!(currentBundleVersion > versionOfOtherBundle)) continue;
                latestVersionsMap.put(bundleName, currentBundleVersion);
                continue;
            }
            latestVersionsMap.put(bundleName, currentBundleVersion);
        }
        for (CFBundle bundle : cfbundles) {
            Double highestBundleVersion;
            bundleName = bundle.getName();
            vesrionOfBundle = bundle.getCurrentVersion();
            currentBundleVersion = FelixUtil.getVersionAsNumber(vesrionOfBundle);
            if (currentBundleVersion != (highestBundleVersion = (Double)latestVersionsMap.get(bundleName))) continue;
            bundlesForInstall.add(bundle);
        }
        return bundlesForInstall;
    }

    public static List<CFBundle> getListOfLatestVersionedBundlesOfInstalledBundles() {
        ArrayList<CFBundle> listOfEachInstalledBundleWithUpdates = new ArrayList<CFBundle>();
        List<CFBundle> listOfLatestVersionOfEachBundle = FelixUtil.getListOfLatestVersionOfEachBundle();
        Map<String, CFBundle> installedBundleNames = FelixUtil.getInstalledBundlesMap();
        for (CFBundle bundleLatest : listOfLatestVersionOfEachBundle) {
            String bundleName = bundleLatest.getName();
            if (!installedBundleNames.containsKey(bundleName)) continue;
            CFBundle installedBundle = installedBundleNames.get(bundleName);
            Double latestBundleVersionNum = FelixUtil.getVersionAsNumber(bundleLatest.getCurrentVersion());
            Double installedBundleVersionNum = FelixUtil.getVersionAsNumber(installedBundle.getCurrentVersion());
            if (!(latestBundleVersionNum > installedBundleVersionNum)) continue;
            listOfEachInstalledBundleWithUpdates.add(bundleLatest);
        }
        return listOfEachInstalledBundleWithUpdates;
    }

    public static List<String> getAllBundleNames() {
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (CFBundle bundle : bundles) {
            String bundleName = bundle.getName();
            if (bundleNames.contains(bundleName)) continue;
            bundleNames.add(bundleName);
        }
        return bundleNames;
    }

    public static List<String> getAllInstalledBundleNames() {
        ArrayList<String> bundlesInstalled = new ArrayList<String>();
        for (CFBundle bundle : bundles) {
            String bundleName = bundle.getName();
            if (!bundle.isInstalled() || bundlesInstalled.contains(bundleName)) continue;
            bundlesInstalled.add(bundleName);
        }
        return bundlesInstalled;
    }

    public static String getLatestVersionedBundlesForGivenBundlesAtGivenUpdate(String commaBundles, int updateLevel) {
        String commaBundlesVersioned = "";
        if (commaBundles == null) {
            return commaBundlesVersioned;
        }
        commaBundlesVersioned = Arrays.stream(commaBundles.split(",")).map(bun -> FelixUtil.getBundleNameAndVersion(bun, true, updateLevel)).map(bundleDetails -> bundleDetails[0] + ":" + bundleDetails[1]).collect(Collectors.joining(","));
        return commaBundlesVersioned;
    }

    public static List<CFBundle> getListOfLatestVersionedBundlesOfGivenUpdate(int updateLevel) {
        ArrayList<CFBundle> listOfHighestVersionedBundles = new ArrayList<CFBundle>();
        ArrayList<String> alreadyFetched = new ArrayList<String>();
        ArrayList<String> bundleNames = new ArrayList<String>();
        FelixUtil.listBundles();
        for (CFBundle bundle : bundles) {
            String bundleName = bundle.getName();
            if (bundleNames.contains(bundleName)) continue;
            bundleNames.add(bundleName);
        }
        for (String bundleName : bundleNames) {
            CFBundle bundleToAdd = null;
            for (CFBundle bundle : bundles) {
                int minimumCoreServerUpdateRequired;
                if (!bundle.getName().equals(bundleName) || alreadyFetched.contains(bundleName)) continue;
                double versionBeingChecked = FelixUtil.getVersionAsNumber(bundle.getCurrentVersion());
                double lastStoredVersion = 0.0;
                if (bundleToAdd != null) {
                    lastStoredVersion = FelixUtil.getVersionAsNumber(bundleToAdd.getCurrentVersion());
                }
                if ((minimumCoreServerUpdateRequired = bundle.getMinimumCoreServerUpdateRequired()) > updateLevel || !(versionBeingChecked >= lastStoredVersion)) continue;
                bundleToAdd = bundle;
            }
            alreadyFetched.add(bundleName);
            if (bundleToAdd == null) continue;
            listOfHighestVersionedBundles.add(bundleToAdd);
        }
        return listOfHighestVersionedBundles;
    }

    public static List<CFBundle> getInstalledBundles() {
        ArrayList<CFBundle> installedBundles = new ArrayList<CFBundle>();
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            installedBundles.add(bundle);
        }
        return installedBundles;
    }

    public static Map<String, CFBundle> getInstalledBundlesMap() {
        HashMap<String, CFBundle> installedBundles = new HashMap<String, CFBundle>();
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            installedBundles.put(bundle.getName(), bundle);
        }
        return installedBundles;
    }

    public static Map<String, CFBundle> getAllBundlesMap() {
        HashMap<String, CFBundle> allBundles = new HashMap<String, CFBundle>();
        for (CFBundle bundle : bundles) {
            allBundles.put(bundle.getName() + ":" + bundle.getCurrentVersion(), bundle);
        }
        return allBundles;
    }

    public static double getVersionAsNumber(String vesrionOfBundle) {
        String[] version = vesrionOfBundle.split(Pattern.quote("-"));
        String[] versionSplits = version[0].split(Pattern.quote("."));
        double availableVersion = 0.0;
        if (versionSplits.length >= 4) {
            availableVersion = Double.parseDouble(versionSplits[0] + versionSplits[1] + versionSplits[2] + versionSplits[3]);
        }
        return availableVersion;
    }

    public static List<String> listUpdatesToBundle(String bundleName) {
        ArrayList<String> listOfUpdatesToBundle = new ArrayList<String>();
        String installedVersionFull = "";
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || !bundle.isInstalled()) continue;
            installedVersionFull = bundle.getCurrentVersion();
            break;
        }
        String[] splitsFullVersion = installedVersionFull.split(Pattern.quote("-"));
        String[] vesrionOfBundleSplits = splitsFullVersion[0].split(Pattern.quote("."));
        double installedVersion = 0.0;
        if (vesrionOfBundleSplits.length >= 4) {
            installedVersion = Double.parseDouble(vesrionOfBundleSplits[0] + vesrionOfBundleSplits[1] + vesrionOfBundleSplits[2] + vesrionOfBundleSplits[3]);
        }
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName) || bundle.isInstalled()) continue;
            String otherAvailableVesrionOfBundle = bundle.getCurrentVersion();
            String[] otherVersion = otherAvailableVesrionOfBundle.split(Pattern.quote("-"));
            String[] otherVersionSplits = otherVersion[0].split(Pattern.quote("."));
            double availableVersion = 0.0;
            if (otherVersionSplits.length >= 4) {
                availableVersion = Double.parseDouble(otherVersionSplits[0] + otherVersionSplits[1] + otherVersionSplits[2] + otherVersionSplits[3]);
            }
            if (!(availableVersion > installedVersion)) continue;
            listOfUpdatesToBundle.add(otherAvailableVesrionOfBundle);
        }
        return listOfUpdatesToBundle;
    }

    public static int getServerUpdateLevelRequiredForInstall(String commaBundles) throws Exception {
        String[] bundlesSplit = commaBundles.split(",");
        int serverupdateLevelRequired = 0;
        List<CFBundle> bundlesWithUpdates = FelixUtil.getListOfLatestVersionOfEachBundle();
        block0: for (String bun : bundlesSplit) {
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            String version = FelixUtil.getDefaultVersion();
            if (iSplit.length == 1) {
                for (CFBundle bundleUpd : bundlesWithUpdates) {
                    if (!bundleUpd.getName().equals(bundleName)) continue;
                    version = bundleUpd.getCurrentVersion();
                    break;
                }
            }
            if (iSplit.length > 1) {
                version = iSplit[1];
            }
            for (CFBundle bundle : bundles) {
                if (!bundle.getName().equalsIgnoreCase(bundleName) || !bundle.getCurrentVersion().equalsIgnoreCase(version)) continue;
                int minimumCoreServerUpdateRequiredForThisBundle = bundle.getMinimumCoreServerUpdateRequired();
                if (minimumCoreServerUpdateRequiredForThisBundle <= serverupdateLevelRequired) continue block0;
                serverupdateLevelRequired = minimumCoreServerUpdateRequiredForThisBundle;
                continue block0;
            }
        }
        return serverupdateLevelRequired;
    }

    public static String getBundlesThatRequireServerAtGivenUpdateLevel(String commaBundles, int serverUpdateLevelRequired) {
        String bundlesResult = "";
        if (commaBundles == null) {
            return bundlesResult;
        }
        bundlesResult = Arrays.stream(commaBundles.split(",")).map(bun -> FelixUtil.getBundleNameAndVersion(bun, false, serverUpdateLevelRequired)).filter(bundleDetails -> {
            String bundleName = bundleDetails[0];
            String version = bundleDetails[1];
            return bundles.stream().anyMatch(bundle -> bundle.getName().equalsIgnoreCase(bundleName) && bundle.getCurrentVersion().equalsIgnoreCase(version) && bundle.getMinimumCoreServerUpdateRequired() == serverUpdateLevelRequired);
        }).map(bundleDetails -> bundleDetails[0] + ":" + bundleDetails[1]).collect(Collectors.joining(","));
        return bundlesResult;
    }

    private static String[] getBundleNameAndVersion(String bundle, boolean coreCompatible, int updateLevel) {
        String[] result = new String[2];
        bundle = bundle.trim();
        String[] iSplit = bundle.split(":");
        String bundleName = iSplit[0];
        String version = FelixUtil.getDefaultVersion();
        if (iSplit.length == 1) {
            version = coreCompatible ? FelixUtil.getLatestVersionOfBundleAtGivenUpdate(bundleName, updateLevel) : FelixUtil.getLatestVersionOfBundle(bundleName);
        }
        if (iSplit.length > 1) {
            version = iSplit[1];
        }
        result[0] = bundleName;
        result[1] = version;
        return result;
    }

    private static String getLatestVersionOfBundle(String bundleName) {
        String version = FelixUtil.getDefaultVersion();
        List<CFBundle> bundlesWithUpdates = FelixUtil.getListOfLatestVersionOfEachBundle();
        for (CFBundle bundleUpd : bundlesWithUpdates) {
            if (!bundleUpd.getName().equals(bundleName)) continue;
            version = bundleUpd.getCurrentVersion();
            break;
        }
        return version;
    }

    private static String getLatestVersionOfBundleAtGivenUpdate(String bundleName, int updateLevel) {
        String version = FelixUtil.getDefaultVersion();
        CFBundle bundleToAdd = null;
        for (CFBundle bundle : bundles) {
            int minimumCoreServerUpdateRequired;
            if (!bundle.getName().equals(bundleName)) continue;
            double versionBeingChecked = FelixUtil.getVersionAsNumber(bundle.getCurrentVersion());
            double lastStoredVersion = 0.0;
            if (bundleToAdd != null) {
                lastStoredVersion = FelixUtil.getVersionAsNumber(bundleToAdd.getCurrentVersion());
            }
            if ((minimumCoreServerUpdateRequired = bundle.getMinimumCoreServerUpdateRequired()) > updateLevel || !(versionBeingChecked >= lastStoredVersion)) continue;
            bundleToAdd = bundle;
        }
        if (bundleToAdd != null) {
            version = bundleToAdd.getCurrentVersion();
        }
        return version;
    }

    public static String formatCommaBundlesStr(String commaBundles) {
        if (commaBundles.endsWith(",")) {
            commaBundles = commaBundles.substring(0, commaBundles.length() - 1);
        }
        return commaBundles;
    }

    public static int getServerUpdateLevelRequiredForDowngrade(String commaBundles, Integer currentServerUpdateLevel) throws Exception {
        String[] bundlesSplit = commaBundles.split(",");
        int serverUpdateLevelDowngradeTo = currentServerUpdateLevel;
        for (String bun : bundlesSplit) {
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundleName = iSplit[0];
            String version = FelixUtil.getDefaultVersion();
            if (iSplit.length > 1) {
                version = iSplit[1];
            }
            CFBundle existingInstalledBundle = null;
            CFBundle bundleBeingInstalledNow = null;
            int minServerUpdateRequiredForExistingInstalledBundle = 0;
            int minServerUpdateRequiredForBundleBeingInstalledNow = 0;
            for (CFBundle bundle : bundles) {
                if (bundle.getName().equalsIgnoreCase(bundleName) && bundle.isInstalled()) {
                    existingInstalledBundle = bundle;
                    minServerUpdateRequiredForExistingInstalledBundle = bundle.getMinimumCoreServerUpdateRequired();
                }
                if (bundle.getName().equalsIgnoreCase(bundleName) && bundle.getCurrentVersion().equalsIgnoreCase(version)) {
                    bundleBeingInstalledNow = bundle;
                    minServerUpdateRequiredForBundleBeingInstalledNow = bundle.getMinimumCoreServerUpdateRequired();
                }
                if (existingInstalledBundle == null || bundleBeingInstalledNow == null) continue;
                break;
            }
            if (minServerUpdateRequiredForBundleBeingInstalledNow >= minServerUpdateRequiredForExistingInstalledBundle || minServerUpdateRequiredForBundleBeingInstalledNow >= serverUpdateLevelDowngradeTo) continue;
            serverUpdateLevelDowngradeTo = minServerUpdateRequiredForBundleBeingInstalledNow;
        }
        return serverUpdateLevelDowngradeTo;
    }

    public static List<CFBundle> getLatestBundlesForInstalledBundlesAtGivenServerLevel(int currentServerUpdateLevel) {
        ArrayList<CFBundle> listOfBundlesForUpdation = new ArrayList<CFBundle>();
        String installedVersionFull = "";
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            installedVersionFull = bundle.getCurrentVersion();
            String[] splitsFullVersion = installedVersionFull.split(Pattern.quote("-"));
            String[] vesrionOfBundleSplits = splitsFullVersion[0].split(Pattern.quote("."));
            double installedVersion = 0.0;
            if (vesrionOfBundleSplits.length >= 4) {
                installedVersion = Double.parseDouble(vesrionOfBundleSplits[0] + vesrionOfBundleSplits[1] + vesrionOfBundleSplits[2] + vesrionOfBundleSplits[3]);
            }
            String bundleName = bundle.getName();
            for (CFBundle bundle2 : bundles) {
                int minimumCoreServerUpdateRequired = bundle2.getMinimumCoreServerUpdateRequired();
                if (!bundle2.getName().equals(bundleName) || bundle2.isInstalled() || currentServerUpdateLevel < minimumCoreServerUpdateRequired) continue;
                String otherAvailableVesrionOfBundle = bundle2.getCurrentVersion();
                String[] otherVersion = otherAvailableVesrionOfBundle.split(Pattern.quote("-"));
                String[] otherVersionSplits = otherVersion[0].split(Pattern.quote("."));
                double availableVersion = 0.0;
                if (otherVersionSplits.length >= 4) {
                    availableVersion = Double.parseDouble(otherVersionSplits[0] + otherVersionSplits[1] + otherVersionSplits[2] + otherVersionSplits[3]);
                }
                if (!(availableVersion > installedVersion)) continue;
                listOfBundlesForUpdation.add(bundle2);
            }
        }
        return listOfBundlesForUpdation;
    }

    public static List<CFBundle> listOfDependentModules(String bundleName, String version) throws Exception {
        ArrayList<CFBundle> listOfModules = new ArrayList<CFBundle>();
        FelixUtil.loadBundlesDependency(CFService.getLibPath());
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            for (int y = 0; y < dependencies.size(); ++y) {
                String type;
                JsonObject dependency = dependencies.getJsonObject(y);
                if (!dependency.containsKey((Object)"type") || !(type = dependency.getString("type")).equals("cfdependency")) continue;
                for (CFBundle cfBundle : bundles) {
                    if (!cfBundle.getName().equals(bundleName) || !cfBundle.getCurrentVersion().equals(version)) continue;
                    listOfModules.add(cfBundle);
                }
            }
        }
        return listOfModules;
    }

    public static List<CFBundle> listOfDependentJars(String bundleName, String version) throws Exception {
        ArrayList<CFBundle> listOfJarBundles = new ArrayList<CFBundle>();
        FelixUtil.loadBundlesDependency(CFService.getLibPath());
        for (int i = 0; i < bundlesDependencies.size(); ++i) {
            JsonObject bundle = bundlesDependencies.getJsonObject(i);
            String bName = bundle.getString("bundle");
            String bVersion = FelixUtil.getDefaultVersion();
            if (bundle.containsKey((Object)"version")) {
                bVersion = bundle.getString("version");
            }
            if (!bName.equalsIgnoreCase(bundleName) || !bVersion.equalsIgnoreCase(version)) continue;
            JsonArray dependencies = bundle.getJsonArray("dependencies");
            for (int y = 0; y < dependencies.size(); ++y) {
                JsonObject dependency = dependencies.getJsonObject(y);
                if (dependency.containsKey((Object)"type")) continue;
                for (CFBundle cfBundle : bundles) {
                    if (!cfBundle.getName().equals(bundleName) || !cfBundle.getCurrentVersion().equals(version)) continue;
                    listOfJarBundles.add(cfBundle);
                }
            }
        }
        return listOfJarBundles;
    }

    public static Map<String, String> getDescriptionAndCategory(String bundleName) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (CFBundle cfBundle : bundles) {
            if (!cfBundle.getName().equals(bundleName)) continue;
            res.put("description", cfBundle.getDescription());
            res.put("category", cfBundle.getCategory());
        }
        return res;
    }

    public static int getMinimumCoreVersionRequired(String bundleName, String version) {
        for (CFBundle cfBundle : bundles) {
            if (!cfBundle.getName().equals(bundleName) || !cfBundle.getCurrentVersion().equals(version)) continue;
            return cfBundle.getMinimumCoreServerUpdateRequired();
        }
        return -1;
    }

    public static List<DependentBundle> getDependentBundles(String bundleName, String version) {
        for (CFBundle cfBundle : bundles) {
            if (!cfBundle.getName().equals(bundleName) || !cfBundle.getCurrentVersion().equals(version)) continue;
            return cfBundle.getDependentBundles();
        }
        return null;
    }

    public static List<DependentBundle> getDependentCFBundles(String commaBundles) {
        String[] bundlesSplit;
        ArrayList<DependentBundle> depsFinal = new ArrayList<DependentBundle>();
        for (String bun : bundlesSplit = commaBundles.split(",")) {
            List<CFBundle> bundlesWithUpdates = FelixUtil.getListOfLatestVersionOfEachBundle();
            bun = bun.trim();
            String[] iSplit = bun.split(":");
            String bundle = iSplit[0];
            String version = FelixUtil.getDefaultVersion();
            if (iSplit.length == 1) {
                for (CFBundle bundleUpd : bundlesWithUpdates) {
                    if (!bundleUpd.getName().equals(bundle)) continue;
                    version = bundleUpd.getCurrentVersion();
                    break;
                }
            }
            if (iSplit.length > 1) {
                version = iSplit[1];
            }
            for (CFBundle cfBundle : bundles) {
                if (!cfBundle.getName().equals(bundle) || !cfBundle.getCurrentVersion().equals(version)) continue;
                List<DependentBundle> deps = cfBundle.getDependentBundles();
                for (DependentBundle dep : deps) {
                    if (!dep.getType().equals("cfdependency")) continue;
                    depsFinal.add(dep);
                    depsFinal.addAll(FelixUtil.getDependentCFBundles(dep.getName() + ":" + dep.getVersion()));
                }
            }
        }
        return depsFinal;
    }

    public static List<CFBundle> listBundles() {
        if (null == bundles || bundles.size() == 0) {
            try {
                FelixUtil.loadBundlesDependency(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<CFBundle> lBundles = new ArrayList<CFBundle>(bundles);
        Collections.sort(lBundles, new BundlesSort());
        boolean isWindows = SystemInfo.isWindows();
        lBundles.removeIf(b -> b.getType().equals("core") || !isWindows && b.getName().equals("odbc"));
        return lBundles;
    }

    public static String listBundlesStr() {
        List<CFBundle> lBundles = FelixUtil.listBundles();
        Object buns = "";
        for (CFBundle bun : lBundles) {
            if (!bun.isInstalled() || bun.getName().equals("felixclassloader")) continue;
            buns = (String)buns + bun.getName() + bun.getVersions() + ",";
        }
        if (((String)buns).endsWith(",")) {
            buns = ((String)buns).substring(0, ((String)buns).length() - 1);
        }
        if (((String)buns).length() == 0) {
            buns = "No modules installed yet";
        }
        return buns;
    }

    public static List<String> listModuleNames() {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (CFBundle cfb : cfbundles) {
            String bundleName = cfb.getName();
            if (bundleNames.contains(bundleName)) continue;
            bundleNames.add(cfb.getName());
        }
        return bundleNames;
    }

    public static List<String> listModuleNamesVersions() {
        List<CFBundle> cfbundles = FelixUtil.listBundles();
        ArrayList<String> bundleNamesVersions = new ArrayList<String>();
        for (CFBundle cfb : cfbundles) {
            bundleNamesVersions.add(cfb.toString());
        }
        return bundleNamesVersions;
    }

    public static void stopBundle(String bundleName, BundleContext context, ServiceRegistration serviceReg) {
        ClassLoader cl;
        if (!bundleName.equals("felixclassloader")) {
            FelixUtil.auditLog(RB.getString(FelixUtil.class, (String)"FelixUtil.stopBundle", (Object)bundleName));
        }
        if (context != null && serviceReg != null) {
            context.ungetService(serviceReg.getReference());
        }
        if (!bundleName.equals("scheduler") && (cl = FelixUtil.class.getClassLoader()) instanceof BootstrapClassLoader) {
            ((BootstrapClassLoader)cl).removeQuartzClasses();
        }
        if (bundleName.equals("orm") && (cl = FelixUtil.class.getClassLoader()) instanceof BootstrapClassLoader) {
            ((BootstrapClassLoader)cl).removeORMClasses();
        }
        if (bundleName.equals("derby") && (cl = FelixUtil.class.getClassLoader()) instanceof BootstrapClassLoader) {
            ((BootstrapClassLoader)cl).removeDerbyClasses();
        }
    }

    public static ServiceRegistration startBundle(BundleContext context, String bundleName, String serviceName, Object impl, Object prop) {
        FelixUtil.auditLog("ServiceRegistration for package : " + bundleName + " started");
        ServiceRegistration serviceReg = null;
        try {
            serviceReg = context.registerService(serviceName, impl, null);
        }
        catch (Throwable e) {
            ModulesServlet.printError(e.getMessage());
        }
        return serviceReg;
    }

    public static String getCurrentVersion(String bundleName) {
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName)) continue;
            return bundle.getCurrentVersion();
        }
        return null;
    }

    public static String getCurrentVersionToInstall(String bundleName) {
        String content = "";
        try {
            Object libPath = CFService.getLibPath();
            if (FelixUtil.isLambdaPackageManager()) {
                libPath = System.getProperty("CFUSION_HOME") + File.separator + "lib";
            }
            FileReader bundlesFr = new FileReader((String)libPath + "/installedBundles.txt");
            Properties props = new Properties();
            props.load(bundlesFr);
            content = props.getProperty("packages", "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String ibundle : content.split(",")) {
            String[] split = ibundle.split(":");
            String name = split[0];
            String cversion = FelixUtil.getDefaultVersion();
            if (split.length == 2) {
                cversion = split[1];
            }
            if (!bundleName.equals(name)) continue;
            return cversion;
        }
        return null;
    }

    public static void downloadBundleFromCFDownloadRepository(String to, String from) throws Exception {
        FelixUtil.downloadBundleFromCFDownloadRepository(to, from, 1);
    }

    public static void downloadBundleFromCFDownloadRepository(final String to, final String from, final int attempt) throws Exception {
        if (System.getSecurityManager() == null) {
            FelixUtil._downloadBundleFromCFDownloadRepository(to, from, attempt);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        FelixUtil._downloadBundleFromCFDownloadRepository(to, from, attempt);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }

    public static void _downloadBundleFromCFDownloadRepository(String to, String fromJar, int attempt) throws Exception {
        String artifactUrl;
        String from;
        String libPath = null;
        if (ServiceFactory.isRuntimeServiceInitialized()) {
            libPath = ServiceFactory.getRuntimeService().getLibDir();
        }
        if (libPath == null) {
            libPath = libFolder;
        }
        if (CFDownloadRepositoryBaseURL == null) {
            FelixUtil.initializeDownloadBaseURL(libFolder, false);
        }
        if (new File(from = (artifactUrl = CFDownloadRepositoryBaseURL) + fromJar).exists()) {
            Files.copy(new File(from).toPath(), new File(to).toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            if (invokedFromClient) {
                FelixUtil.auditLog("Downloading the package : " + from);
                Object jarname = from;
                if (from.lastIndexOf(DIRECTORY_SEPARATOR) > -1) {
                    jarname = from.substring(from.lastIndexOf(DIRECTORY_SEPARATOR) + 1);
                }
                if (fromJar.contains("repo")) {
                    System.out.println(RB.getString(FelixUtil.class, (String)"FelixUtil.downoadingjarInfo", (Object)jarname));
                } else if (!((String)jarname).equals("bundlesdependency.json")) {
                    ModulesServlet.printInfo2(RB.getString(FelixUtil.class, (String)"FelixUtil.downoadingInfo", (Object)jarname));
                }
            }
            InputStream is = null;
            is = FelixUtil.downloadFromURL(from);
            if (is != null) {
                try (BufferedInputStream bis = new BufferedInputStream(is);
                     FileOutputStream fis = new FileOutputStream(to);){
                    byte[] buffer = new byte[1024];
                    int count = 0;
                    while ((count = bis.read(buffer, 0, 1024)) != -1) {
                        fis.write(buffer, 0, count);
                    }
                }
                is.close();
                if (to.endsWith(".zip") || to.endsWith(".jar")) {
                    FelixUtil.validateJar(to, fromJar, attempt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateJar(String to, String from, int attempt) throws Exception {
        try (JarFile jar = null;){
            jar = new JarFile(to, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isJarValid(String jarPath) throws Exception {
        boolean isValid = false;
        if (!new File(jarPath).exists()) {
            return false;
        }
        if (!jarPath.endsWith(".zip") && !jarPath.endsWith(".jar")) {
            return true;
        }
        try (JarFile jar = null;){
            jar = new JarFile(jarPath, true);
            isValid = true;
        }
        return isValid;
    }

    public static void checkIfModuleIsInstalled(String tagName) {
        for (CFBundle bundle : bundles) {
            if (!bundle.getName().equals(tagName) || bundle.isInstalled()) continue;
            throw new ServiceFactory.ModuleNotAvailableException(tagName);
        }
    }

    public static List<String> getInstalledModules() {
        ArrayList<String> installedModules = new ArrayList<String>();
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            installedModules.add(bundle.getName());
        }
        return installedModules;
    }

    public static Map<String, Double> getInstalledModulesNumVersions() {
        HashMap<String, Double> installedModules = new HashMap<String, Double>();
        for (CFBundle bundle : bundles) {
            if (!bundle.isInstalled()) continue;
            installedModules.put(bundle.getName(), FelixUtil.getVersionAsNumber(bundle.getCurrentVersion()));
        }
        return installedModules;
    }

    public static String getDefaultVersion() {
        if (serverBaseVersion == null) {
            serverBaseVersion = DEFAULT_VERSION;
            String baseBuildNumber = Version.getBaseBuildNumber();
            if (baseBuildNumber != null && !baseBuildNumber.endsWith("00000")) {
                serverBaseVersion = Version.getBaseVersion().replaceAll(",", ".") + "." + baseBuildNumber;
            }
        }
        return serverBaseVersion;
    }

    public static void checkAjaxEnabled() {
        if (!ServiceFactory.isAjaxEnabled) {
            throw new ServiceFactory.ModuleNotAvailableException("ajax");
        }
    }

    public static boolean isAdministratorInstalled() {
        return FelixUtil.installed("administrator", ServiceFactory.getRuntimeService().getLibDir());
    }

    public static boolean isAdminapiInstalled() {
        return FelixUtil.installed("adminapi", ServiceFactory.getRuntimeService().getLibDir());
    }

    public static Object createObjectFromSingleJar(String className, String jarName, String version) throws Throwable {
        Bundle bundle = null;
        String bundlePath = FelixUtil.getBundlePath(jarName, version);
        if (bundlesIdMap.get(bundlePath) != null) {
            bundle = FelixUtil.installBundle(bundlePath);
        } else {
            for (int i = 0; i < bundlesDependencies.size(); ++i) {
                JsonObject ibundle = bundlesDependencies.getJsonObject(i);
                String bName = ibundle.getString("bundle");
                JsonArray dependencies = ibundle.getJsonArray("dependencies");
                if (dependencies != null) {
                    for (int j = 0; j < dependencies.size(); ++j) {
                        JsonObject dependency = dependencies.getJsonObject(j);
                        String dependencyName = dependency.getString("name");
                        String dependencyVersion = null;
                        if (dependency.containsKey((Object)"version")) {
                            dependencyVersion = dependency.getString("version");
                        }
                        if (!dependencyName.equals(jarName) || version != null && !dependencyVersion.equals(version)) continue;
                        if (version == null && bundlesIdMap.get(bundlePath = FelixUtil.getBundlePath(jarName, dependencyVersion)) != null) {
                            bundle = FelixUtil.installBundle(bundlePath);
                        }
                        if (null != bundle) break;
                        FelixUtil.deployBundle(bName);
                        bundle = FelixUtil.installBundle(bundlePath);
                        break;
                    }
                }
                if (bundle != null) break;
            }
        }
        if (bundle == null) {
            throw new RuntimeException("Jar not found in repository : " + jarName + ":" + version);
        }
        return new JavaProxy(bundle.loadClass(className));
    }

    public static Object createObjectFromArrayOfJars(String className, Array bundles) throws Throwable {
        Bundle mainBundle = null;
        FelixUtil.installJars(bundles);
        for (int i = 0; i < bundles.size(); ++i) {
            Struct s = (Struct)bundles.get(i);
            String bundleName = (String)s.get((Object)"name");
            String version = (String)s.get((Object)"version");
            boolean isMain = Cast._boolean((Object)s.get((Object)"primary"));
            if (!isMain) continue;
            mainBundle = FelixUtil.installBundle(bundleName, version);
        }
        return new JavaProxy(mainBundle.loadClass(className));
    }

    private static void installJars(Array bundles) {
        Array failedBundles = new Array();
        for (int i = 0; i < bundles.size(); ++i) {
            Struct s = (Struct)bundles.get(i);
            String bundleName = (String)s.get((Object)"name");
            String version = (String)s.get((Object)"version");
            try {
                FelixUtil.installBundle(bundleName, version);
                continue;
            }
            catch (Throwable t) {
                failedBundles.add((Object)s);
            }
        }
        if (failedBundles.size() != 0) {
            FelixUtil.installJars(failedBundles);
        }
    }

    private static Bundle installBundle(String bundleName, String version) throws Throwable {
        String to = FelixUtil.getBundlePath(bundleName, version);
        Bundle bundle = FelixUtil.downloadAndInstall(to, null, bundleName + "-" + version, version);
        return bundle;
    }

    private static String getBundlePath(String bundleName, String version) {
        String cfHomePath = "";
        try {
            cfHomePath = new File(ServiceFactory.getRuntimeService().getLibDir() + "/../../").getCanonicalPath();
        }
        catch (IOException e) {
            ModulesServlet.printError(e.getMessage());
        }
        String to = cfHomePath + "/bundles/repo/" + bundleName + "-" + version + ".jar";
        return to;
    }

    public static void auditLog(String msg) {
        FelixUtil.auditLog("information", msg);
    }

    public static void auditLog(String type, String msg) {
        if (ServerlessUtil.isLambdaEnv()) {
            return;
        }
        if (!invokedFromClient || FelixUtil.isLambdaPackageManager()) {
            try {
                if (msg.trim().equals("")) {
                    return;
                }
                if (invokedFromClient && !ServiceFactory.isLoggingServiceEnabled()) {
                    Thread.sleep(2000L);
                    if (!ServiceFactory.isLoggingServiceEnabled()) {
                        LogService ls = new LogService(new File(libFolder + File.separator + "neo-logging.xml"), String.join((CharSequence)File.separator, Arrays.asList(libFolder, PARENT_DIR_IDENTIFIER, "logs")));
                        ls.start();
                        ServiceFactory.setLoggingService((LoggingService)ls);
                    }
                }
                Logger logger = null;
                LogService logService = (LogService)ServiceFactory.getLoggingService();
                logger = logService.getUserLog("cfpm-audit");
                if (type.equals("information")) {
                    logger.info((Object)msg);
                }
                if (type.equals("error")) {
                    logger.error((Object)msg);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String filename, String outputdir) throws IOException {
        int BUFFER = 2048;
        outputdir = (String)outputdir + System.getProperty("file.separator");
        Logger log = CFLogs.SERVER_LOG;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        try (ZipFile zipfile = null;){
            File newfile;
            String path;
            ZipEntry entry;
            zipfile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                path = (String)outputdir + entry;
                newfile = new File(path);
                if (!entry.isDirectory() || newfile.exists()) continue;
                newfile.mkdir();
            }
            e = zipfile.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                path = (String)outputdir + entry;
                newfile = new File(path);
                if (entry.isDirectory()) continue;
                FelixUtil.createDirs(newfile);
                if (newfile.exists()) {
                    newfile.delete();
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                try {
                    int count;
                    dest = new BufferedOutputStream(new FileOutputStream(newfile), BUFFER);
                    while ((count = is.read(data, 0, BUFFER)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void createDirs(File f) {
        File pf = f.getParentFile();
        if (pf != null && !pf.exists()) {
            Vector<File> parents = new Vector<File>();
            while (pf != null && !pf.exists()) {
                parents.insertElementAt(pf, 0);
                pf = pf.getParentFile();
            }
            Enumeration e = parents.elements();
            while (e.hasMoreElements()) {
                pf = (File)e.nextElement();
                pf.mkdir();
            }
        }
    }

    static {
        invokedFromClient = false;
        installedBundlesFile = null;
        felixInitializedForServerless = false;
        updatesSettingsMap = null;
        bundlesIdMap = new HashMap<String, Long>();
    }

    public static class ProcessLogger
    implements Runnable {
        private InputStream inputStrm;

        public ProcessLogger(InputStream isnpuStream) {
            this.inputStrm = isnpuStream;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStrm));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class ProcessWaitLogger
    implements Runnable {
        private Process process;

        public ProcessWaitLogger(Process p) {
            this.process = p;
        }

        @Override
        public void run() {
            try {
                while (this.process.isAlive()) {
                    System.out.print(". ");
                    Thread.sleep(1500L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static class DownloadAndInstalThread
    implements Callable<Boolean> {
        String to;
        String from;
        String depName;
        String bundle;
        List<Exception> exc;

        public DownloadAndInstalThread(String to, String from, String depName, String bundle, List<Exception> exc) {
            this.to = to;
            this.from = from;
            this.depName = depName;
            this.bundle = bundle;
            this.exc = exc;
        }

        @Override
        public Boolean call() {
            try {
                FelixUtil.downloadAndInstall(this.to, this.from, this.depName, this.bundle);
            }
            catch (Exception e) {
                this.exc.add(e);
                return false;
            }
            return true;
        }
    }
}

