/*
 * Decompiled with CFR 0.152.
 */
package coldfusion;

import coldfusion.Version;
import coldfusion.filter.ApplicationFilter;
import coldfusion.filter.BrowserDebugFilter;
import coldfusion.filter.BrowserFilter;
import coldfusion.filter.CFFiddleFilter;
import coldfusion.filter.CachingFilter;
import coldfusion.filter.CfincludeFilter;
import coldfusion.filter.ClientScopePersistenceFilter;
import coldfusion.filter.CspFilter;
import coldfusion.filter.DatasourceFilter;
import coldfusion.filter.DreamweaverDebugFilter;
import coldfusion.filter.ExceptionFilter;
import coldfusion.filter.FusionContext;
import coldfusion.filter.FusionFilter;
import coldfusion.filter.GlobalsFilter;
import coldfusion.filter.IpFilter;
import coldfusion.filter.LicenseFilter;
import coldfusion.filter.MonitoringFilter;
import coldfusion.filter.NoCacheFilter;
import coldfusion.filter.PathFilter;
import coldfusion.filter.RequestMonitorFilter;
import coldfusion.filter.RequestThrottleFilter;
import coldfusion.license.LicenseManager;
import coldfusion.runtime.RequestLifecycleListener;
import coldfusion.runtime.ServletConfigWrapper;
import coldfusion.server.DebuggingService;
import coldfusion.server.MonitoringService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.util.DynamicSemaphore;
import coldfusion.util.RB;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;

public class CfmServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ServletConfig servletConfig;
    private static CfmServlet cfmServlet;
    private DynamicSemaphore gate;
    private int timeouts = 0;
    private static final Object serveltInitializedMutex;
    private static final boolean ENABLE_FCKEDITOR_FILEUPLOAD;

    public static CfmServlet getCfmServlet() {
        return cfmServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        DebuggingService debuggingService;
        this.servletConfig = new ServletConfigWrapper(config);
        cfmServlet = this;
        if (!ServiceFactory.getLicenseService().isStandard()) {
            int requestLimit = ServiceFactory.getRuntimeService().getQueueLimit("request");
            this.gate = new DynamicSemaphore(requestLimit, true);
        }
        if ((debuggingService = ServiceFactory.getDebuggingService()) != null) {
            debuggingService.setContextRootForLineDebugger(config.getServletContext());
        }
        Object object = serveltInitializedMutex;
        synchronized (object) {
            serveltInitializedMutex.notifyAll();
        }
    }

    private FusionFilter getFilterChain(ServletRequest request) {
        FusionFilter filter = new CfincludeFilter();
        if (request.getAttribute("coldfusion.ExceptionFilter.biscuit") == null) {
            filter = new ApplicationFilter(filter);
        }
        filter = new CspFilter(filter);
        if (RequestMonitorFilter.isFilterEnabled()) {
            filter = new RequestMonitorFilter(filter);
        }
        filter = new MonitoringFilter(filter, "TEMPLATE REQUEST");
        filter = new PathFilter(filter, (Servlet)this);
        if (ServiceFactory.isFiddleServiceEnabled()) {
            filter = new CFFiddleFilter(filter, (Servlet)this);
        }
        filter = new IpFilter(filter);
        if (LicenseManager.isSingleIP()) {
            filter = new LicenseFilter(filter);
        }
        filter = new ExceptionFilter(filter);
        DebuggingService debuggingService = ServiceFactory.getDebuggingService();
        if (debuggingService != null && debuggingService.isEnabled()) {
            filter = DreamweaverDebugFilter.isDreamweaver(request) ? new DreamweaverDebugFilter(filter) : new BrowserDebugFilter(filter);
        }
        filter = new ClientScopePersistenceFilter(filter);
        filter = new BrowserFilter(filter);
        filter = new NoCacheFilter(filter);
        boolean needsFormScope = true;
        filter = new GlobalsFilter(filter, true);
        filter = new DatasourceFilter(filter);
        filter = new CachingFilter(filter);
        if (((HttpServletRequest)request).getMethod().equalsIgnoreCase("POST")) {
            filter = new RequestThrottleFilter(filter);
        }
        return filter;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpReq;
        String uri;
        MonitoringService monitoringService;
        FusionContext context = new FusionContext();
        context.setServletObjects((Servlet)this, request, response);
        FusionContext oldCtx = FusionContext.setCurrent(context);
        if (!ENABLE_FCKEDITOR_FILEUPLOAD) {
            HttpServletRequest httpReq2 = context.getRequest();
            String uri2 = httpReq2.getServletPath();
            if ((uri2 = uri2.toLowerCase()).contains("/fckeditor/editor/filemanager")) {
                context.getResponse().sendError(403, RB.getString((Object)this, "CfmServlet.accessDenied"));
                return;
            }
        }
        if ((monitoringService = ServiceFactory.getMonitoringService()) != null && monitoringService.isMonitoringEnabled() && monitoringService.isRejectNewRequestsEnabled() && !(uri = (httpReq = context.getRequest()).getRequestURI()).startsWith("/CFIDE")) {
            context.getResponse().sendError(503, RB.getString((Object)this, "CfmServlet.busy"));
            return;
        }
        FusionFilter filterChain = this.getFilterChain(request);
        boolean lockAcquired = false;
        try {
            lockAcquired = this.lock(request);
            filterChain.invoke(context);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (TimeoutException ex) {
            this.processTimeout(response);
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ServletException(ex);
        }
        finally {
            if (lockAcquired) {
                this.gate.release();
            }
            FusionContext.setCurrent(oldCtx);
            RequestLifecycleListener.onRequestEnd(1, null);
        }
    }

    private boolean lock(ServletRequest request) throws InterruptedException, TimeoutException {
        HttpServletRequest httpReq;
        String uri;
        if (ServiceFactory.getLicenseService().isStandard()) {
            return false;
        }
        if (this.gate == null) {
            int requestLimit = ServiceFactory.getRuntimeService().getQueueLimit("request");
            this.gate = new DynamicSemaphore(requestLimit, true);
        }
        if (request instanceof HttpServletRequest && (uri = (httpReq = (HttpServletRequest)request).getRequestURI()).startsWith("/CFIDE")) {
            return false;
        }
        RuntimeService runtime = ServiceFactory.getRuntimeService();
        long timeout = -1L;
        if (runtime.timeoutRequests()) {
            timeout = runtime.getQueueTimeout();
        }
        if (timeout <= 0L) {
            this.gate.acquire();
        } else if (!this.gate.tryAcquire(timeout, TimeUnit.SECONDS)) {
            throw new TimeoutException();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimeout(ServletResponse response) {
        File f;
        ServiceFactory.getMetricsService().updateMetric("errorCount", 1);
        ++this.timeouts;
        boolean customErrorSent = false;
        String page = (String)ServiceFactory.getRuntimeService().getErrors().get("queue_timeout");
        String pagePath = this.servletConfig.getServletContext().getRealPath(page);
        if (page != null && page.length() != 0 && pagePath != null && (f = new File(pagePath)).exists() && f.canRead()) {
            FileReader in = null;
            try {
                int n;
                in = new FileReader(f);
                PrintWriter out = response.getWriter();
                char[] buf = new char[1024];
                while ((n = in.read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
                if (response instanceof HttpServletResponse) {
                    ((HttpServletResponse)response).setStatus(503);
                }
                response.flushBuffer();
                customErrorSent = true;
            }
            catch (IOException iOException) {
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!customErrorSent) {
            HttpServletResponse r = (HttpServletResponse)response;
            try {
                r.sendError(503, RB.getString((Object)this, "CfmServlet.timeout"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getServletInfo() {
        return "Cfm Servlet build " + Version.getVersionString();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    protected void setRequestLimit(int limit) {
        if (this.gate != null) {
            this.gate.setLimit(limit);
        }
    }

    public int getRequestLimit() {
        if (this.gate == null) {
            return 0;
        }
        return this.gate.getLimit();
    }

    public int getRequestsQueued() {
        if (this.gate == null) {
            return 0;
        }
        return this.gate.getQueueLength();
    }

    public int getRequestsRunning() {
        if (this.gate == null) {
            return 0;
        }
        return this.gate.getLimit() - this.gate.availablePermits();
    }

    public int getRequestsTimedout() {
        if (this.gate == null) {
            return 0;
        }
        return this.timeouts;
    }

    public void destroy() {
        if (!SystemInfo.isWindows()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitTillServletInitialized() {
        if (cfmServlet == null) {
            Object object = serveltInitializedMutex;
            synchronized (object) {
                while (cfmServlet == null) {
                    try {
                        serveltInitializedMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    static {
        serveltInitializedMutex = new Object();
        ENABLE_FCKEDITOR_FILEUPLOAD = Boolean.valueOf(System.getProperty("coldfusion.fckupload", "false"));
    }

    private class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

