/*
 * Decompiled with CFR 0.152.
 */
package coldfusion;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.monitor.Configuration;
import coldfusion.monitor.connector.CFLoadBalanceInstance;
import coldfusion.monitor.connector.ConnectorAlertBean;
import coldfusion.monitor.connector.ConnectorData;
import coldfusion.monitor.connector.ConnectorMonitor;
import coldfusion.monitor.datastore.JSONConverter;
import coldfusion.util.RB;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConnectorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private ObjectMapper objectmapper;
    private static String APACHE = "Apache";
    private Logger logger = CFLogs.MONITOR_LOG;

    public void init() throws ServletException {
        super.init();
        this.objectmapper = JSONConverter.getMapper();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpservletRequest = (HttpServletRequest)request;
        String responseJson = "";
        String webserverType = "";
        String secretKey = null;
        if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled()) {
            secretKey = httpservletRequest.getHeader("CFMonitoring-Secret");
            if (Configuration.INSTANCE.getConnectorSecret().equalsIgnoreCase(secretKey)) {
                String loadData = httpservletRequest.getHeader("Load-Data");
                String[] sites = loadData.split(";");
                ArrayList<ConnectorAlertBean> alertBeans = new ArrayList<ConnectorAlertBean>();
                for (String siteData : sites) {
                    List<ConnectorAlertBean> record;
                    String local_connector;
                    ConnectorData connectorData = (ConnectorData)this.objectmapper.readValue(siteData.getBytes(), ConnectorData.class);
                    webserverType = connectorData.getSiteType();
                    String siteName = "";
                    if (connectorData.getSiteType().equalsIgnoreCase("Apache")) {
                        siteName = "Apache";
                        if ((siteName = this.getLocalAddress(request, siteName)).equalsIgnoreCase("Apache")) {
                            return;
                        }
                        connectorData.setSiteName(siteName);
                    } else {
                        siteName = connectorData.getSiteName();
                        siteName = this.getLocalAddress(request, siteName);
                        connectorData.setSiteName(siteName);
                    }
                    if (connectorData.getSiteName().endsWith("127.0.0.1") && ((local_connector = System.getProperty("local_connector")) == null || local_connector.isEmpty() || !local_connector.equalsIgnoreCase("true"))) continue;
                    String hostName = Configuration.INSTANCE.getServerHostName();
                    if (connectorData.isLoadBalanced()) {
                        connectorData.setHostName(hostName);
                        connectorData.setClusterId(Configuration.INSTANCE.getClusterId());
                        connectorData.setConnectorId(Configuration.INSTANCE.getClusterId());
                    } else {
                        connectorData.setInstanceId(hostName + ":" + Configuration.INSTANCE.getInstanceName() + ":" + Configuration.INSTANCE.getInstancePort());
                        connectorData.setConnectorId(hostName + ":" + Configuration.INSTANCE.getInstanceName() + ":" + Configuration.INSTANCE.getInstancePort());
                        if (Configuration.INSTANCE.getGroupId() != null) {
                            connectorData.setConnectorId(Configuration.INSTANCE.getGroupId());
                            connectorData.setGroupId(Configuration.INSTANCE.getGroupId());
                        }
                    }
                    if (connectorData.getSiteInstances() != null) {
                        for (CFLoadBalanceInstance instance : connectorData.getSiteInstances()) {
                            instance.setInstanceHealth(instance.getInstanceHealth() * 100.0);
                            instance.setInstanceId(Configuration.INSTANCE.getInstanceId());
                        }
                    }
                    connectorData.setTimeStamp(System.currentTimeMillis());
                    if (connectorData.getAverageResponseTime() == 0.0) {
                        connectorData.setAverageResponseTime(null);
                    }
                    if ((record = ConnectorMonitor.getInstance().record(connectorData)) == null) continue;
                    alertBeans.addAll(record);
                }
                responseJson = this.objectmapper.writeValueAsString(alertBeans);
            }
        }
        if (Configuration.INSTANCE.getMonitorSettings().isMonitoringEnabled() && (secretKey == null || secretKey != null && !secretKey.equalsIgnoreCase(Configuration.INSTANCE.getConnectorSecret()))) {
            this.logger.error(RB.getString((Object)this, "connectorServlet.errorMsg"));
        }
        if (!webserverType.equals("") && !webserverType.equalsIgnoreCase(APACHE)) {
            response.getOutputStream().print(responseJson);
            response.setContentType("application/json");
            response.getOutputStream().flush();
        }
    }

    private String getLocalAddress(ServletRequest request, String siteName) {
        String localAddr = request.getLocalAddr();
        if (localAddr != null && !localAddr.isEmpty()) {
            if (localAddr.equalsIgnoreCase("::1")) {
                localAddr = "127.0.0.1";
            }
            siteName = (String)siteName + ":" + localAddr;
        }
        return siteName;
    }
}

