/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.ant.tasks;

import coldfusion.ant.tasks.Replace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class NeoRelativize
extends Task {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern STRING_PATTERN = Pattern.compile("<string>(.*?)</string>");
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private List<Replace> replaces = new ArrayList<Replace>();

    public void addFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void addReplace(Replace replace) {
        this.replaces.add(replace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Collections.sort(this.replaces);
        for (FileSet fileSet : this.fileSets) {
            String[] includedFiles;
            Project project = this.getProject();
            File dir = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                StringBuilder builder = new StringBuilder();
                Scanner scanner = null;
                File source = new File(dir + File.separator + includedFile);
                try {
                    scanner = new Scanner(source);
                    while (scanner.hasNextLine()) {
                        builder.append(scanner.nextLine()).append(LINE_SEPARATOR);
                    }
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                finally {
                    if (null != scanner) {
                        scanner.close();
                    }
                }
                String relativizedXML = this.relativize(builder.toString(), this.replaces);
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(source, false);
                    fileWriter.write(relativizedXML);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (null != fileWriter) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private String relativize(String xmlStr, List<Replace> replaces) {
        Matcher matcher = STRING_PATTERN.matcher(xmlStr);
        block2: while (matcher.find()) {
            String entry = matcher.group(1);
            File file = new File(entry);
            if (!file.exists()) continue;
            for (Replace replace : replaces) {
                String absolutePathS = "";
                try {
                    absolutePathS = new File(replace.getAbsolute()).getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Path absolutePath = new File(absolutePathS).toPath();
                if (!file.toPath().startsWith(absolutePath)) continue;
                String pathToReplace = (replace.getRelative() + absolutePath.relativize(file.toPath())).replaceAll("\\\\", "/");
                xmlStr = xmlStr.replace(absolutePathS, pathToReplace);
                continue block2;
            }
        }
        return xmlStr;
    }
}

