/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.appdeployment;

import coldfusion.util.RB;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;

public class AppDeploymentLogger {
    BufferedOutputStream logFileOut = null;
    PrintWriter out = null;
    private static final String resourceFileName = "log_messages";

    public AppDeploymentLogger(String appName, String applicationPath) throws IOException {
        String logFilePath = AppDeploymentLogger.getLogFilePath(appName, applicationPath);
        this.out = new PrintWriter(new FileOutputStream(logFilePath));
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
    }

    public void error(String key, Object[] args) {
        this.out.println(this.getTime() + ":" + this.getMessage("error", null) + ":" + this.getMessage(key, args));
    }

    public void error(Exception e) {
        e.printStackTrace(this.out);
    }

    public void warning(String key, Object[] args) {
        this.out.println(this.getTime() + ":" + this.getMessage("warning", null) + ":" + this.getMessage(key, args));
    }

    public void info(String key, Object[] args) {
        this.out.println(this.getTime() + ":" + this.getMessage(key, args));
    }

    private String getMessage(String key, Object[] args) {
        return RB.getMessage(this, resourceFileName, Locale.getDefault(), key, args);
    }

    public static String getLogFilePath(String appName, String appFolder) {
        return appFolder + File.separator + "_" + appName + "_install.log";
    }

    public String getTime() {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        return formatter.format(Calendar.getInstance().getTime());
    }
}

