/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.appdeployment;

import coldfusion.appdeployment.CFAppDeployer;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.util.OrderedHashMap;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AppInstallerService
extends ServiceBase {
    public boolean isStarted = false;
    public File installedAppsInfoFile = null;
    ConfigMap installedApps = null;
    private static final Map emptyMap = new HashMap();
    public static final String appNameKey = "AplicationName";
    public static final String installFolderPathKey = "InstalledFolder";
    public static final String authorKey = "Author";
    public static final String emailKey = "Email";
    public static final String updateUrlKey = "UpdateUrl";
    public static final String installedDateKey = "InstalledDate";
    public static final String lastUpdatedDateKey = "LastUpdated";
    public static final String installedByKey = "InstalledBy";

    public AppInstallerService(File installedAppsFile) {
        this.installedAppsInfoFile = installedAppsFile;
    }

    @Override
    protected String getLoggerName() {
        return "coldfusion.appinstaller";
    }

    @Override
    public void load() throws ServiceException {
        this.installedApps = new ConfigMap(this, "installed_apps");
        if (!this.installedAppsInfoFile.exists()) {
            return;
        }
        if (this.installedAppsInfoFile.length() == 0L) {
            return;
        }
        Vector vInstalledApps = (Vector)this.deserialize(this.installedAppsInfoFile);
        ConfigMap _installedApps = null;
        _installedApps = vInstalledApps.size() > 0 ? (ConfigMap)vInstalledApps.get(0) : new ConfigMap();
        for (String name : _installedApps.keySet()) {
            ConfigMap c_M = (ConfigMap)_installedApps.get(name);
            c_M.init(this, "installed_app");
            this.installedApps.put(name, (Object)c_M);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws ServiceException {
        Vector<ConfigMap> vInstalledApps = new Vector<ConfigMap>();
        ConfigMap configMap = this.installedApps;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "installed_apps");
            for (Object name : this.installedApps.keySet()) {
                ConfigMap app = (ConfigMap)this.installedApps.get(name);
                ConfigMap clon = new ConfigMap(this, "installed_app");
                clon.putAll((Map)app);
                copy.put(name, (Object)clon);
            }
            vInstalledApps.addElement(copy);
        }
        this.serialize(vInstalledApps, this.installedAppsInfoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws ServiceException {
        AppInstallerService appInstallerService = this;
        synchronized (appInstallerService) {
            if (this.isStarted) {
                return;
            }
        }
        super.start();
        appInstallerService = this;
        synchronized (appInstallerService) {
            this.isStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ServiceException {
        AppInstallerService appInstallerService = this;
        synchronized (appInstallerService) {
            if (!this.isStarted) {
                return;
            }
        }
        super.stop();
        appInstallerService = this;
        synchronized (appInstallerService) {
            this.isStarted = false;
        }
    }

    public void addApplication(CFAppDeployer appDeployer) throws ServiceException {
        Date timeNow;
        String appName = appDeployer.getAppName();
        String installedPath = appDeployer.getInstallationFolder();
        String key = appName + ":" + installedPath;
        Object tmpObj = this.installedApps.get(key);
        Date installedDate = timeNow = Calendar.getInstance().getTime();
        Date modifiedDate = timeNow;
        if (tmpObj == null) {
            tmpObj = new ConfigMap(this, "installed_app");
            this.installedApps.put(key, tmpObj);
        } else {
            installedDate = (Date)((ConfigMap)tmpObj).get(installedDateKey);
        }
        ConfigMap app = (ConfigMap)tmpObj;
        String author = appDeployer.getAuthor();
        String email = appDeployer.getEmail();
        String updateUrl = appDeployer.getUpdateURL();
        app.put(appNameKey, (Object)appName);
        app.put(installFolderPathKey, (Object)installedPath);
        app.put(authorKey, (Object)(author == null ? "" : author));
        app.put(emailKey, (Object)(email == null ? "" : email));
        app.put(updateUrlKey, (Object)(updateUrl == null ? "" : updateUrl));
        app.put(installedDateKey, (Object)installedDate);
        app.put(lastUpdatedDateKey, (Object)modifiedDate);
        this.mapModified();
    }

    public void removeApplication(String appName, String installedPath) throws ServiceException {
        String key = appName + ":" + installedPath;
        Object obj = this.installedApps.remove(key);
        if (obj != null) {
            this.mapModified();
        }
    }

    public Map getApplicationsInfo() {
        if (this.installedApps == null) {
            return emptyMap;
        }
        OrderedHashMap appsInfoMap = new OrderedHashMap();
        for (Object name : this.installedApps.keySet()) {
            ConfigMap app = (ConfigMap)this.installedApps.get(name);
            HashMap infoMap = new HashMap();
            infoMap.putAll(app);
            appsInfoMap.put(name, infoMap);
        }
        return appsInfoMap;
    }
}

