/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.appdeployment;

import coldfusion.appdeployment.AppDeploymentExceptions;
import coldfusion.appdeployment.AppDeploymentLogger;
import coldfusion.appdeployment.AppInstallerService;
import coldfusion.appdeployment.ConfigFileParser;
import coldfusion.appdeployment.ConfigInfo;
import coldfusion.appdeployment.DataSourceInfo;
import coldfusion.appdeployment.DataSourceInfoCollection;
import coldfusion.appdeployment.FileCopyInfo;
import coldfusion.appdeployment.InstallTypeInfo;
import coldfusion.appdeployment.MappingInfo;
import coldfusion.appdeployment.MappingsInfoCollection;
import coldfusion.appdeployment.PropertiesInfoCollection;
import coldfusion.appdeployment.PropertyInfo;
import coldfusion.appdeployment.UninstallerInfo;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.StructUtils;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.util.OrderedHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CFAppDeployer {
    Map zipData = new HashMap();
    File tmpAppFolder = null;
    ConfigInfo configInfo = null;
    String zipFilePath = null;
    String targetInstallFolder = null;
    String cfDocRoot = null;
    CFAppDeployer parentDeployer = null;
    private static AppInstallerService appInstallerService = null;
    boolean installationComplete = false;
    boolean installationaborted = false;
    AppDeploymentLogger logger = null;
    UninstallerInfo unInstallerInfo = new UninstallerInfo();

    protected void finalize() {
        if (this.parentDeployer != null || this.installationComplete || this.installationaborted) {
            return;
        }
        if (this.logger != null) {
            this.logger.close();
        }
        this.deleteTempFolder();
    }

    public CFAppDeployer(String zipPath, String targetFolder) throws Exception {
        this.zipFilePath = zipPath;
        this.targetInstallFolder = targetFolder;
        CFAppDeployer.startAppInstallerService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAppInstallerService() throws Exception {
        Class<AppInstallerService> clazz = AppInstallerService.class;
        synchronized (AppInstallerService.class) {
            if (appInstallerService == null) {
                CFAppDeployer.createAppInstallerService();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAppInstallerService() throws Exception {
        Class<AppInstallerService> clazz = AppInstallerService.class;
        synchronized (AppInstallerService.class) {
            String filePath = ServiceFactory.getRuntimeService().getLibDir() + File.separator + "neo-deployedapps.xml";
            appInstallerService = new AppInstallerService(new File(filePath));
            appInstallerService.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public CFAppDeployer(CFAppDeployer parentAppDeployer) {
        this.zipFilePath = parentAppDeployer.zipFilePath;
        this.targetInstallFolder = parentAppDeployer.targetInstallFolder;
        this.parentDeployer = parentAppDeployer;
        this.zipData = parentAppDeployer.zipData;
        this.cfDocRoot = parentAppDeployer.cfDocRoot;
        this.tmpAppFolder = parentAppDeployer.tmpAppFolder;
    }

    public void deleteTempFolder() {
        if (this.tmpAppFolder != null) {
            this.deleteFile(this.tmpAppFolder);
            this.tmpAppFolder = null;
        }
    }

    public void finishDeployment() throws Exception {
        this.deleteTempFolder();
        this.installationComplete = true;
        this.saveUninstallInfo();
        this.logger.info("success.install", new Object[]{this.getAppName()});
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
    }

    public void abortDeployment() throws Exception {
        if (this.installationaborted) {
            return;
        }
        this.deleteTempFolder();
        CFAppDeployer.unInstallApplication(this.unInstallerInfo, null, this.getAppName(), this.targetInstallFolder);
        if (this.logger != null) {
            this.logger.info("install.abort", new Object[]{this.getAppName()});
            this.logger.close();
            this.logger = null;
        }
        this.installationaborted = true;
    }

    private static String getUninstallFilePath(String appName, String appFolder) {
        return appFolder + File.separator + "_uninstall_" + appName + File.separator + "uninstall";
    }

    private void saveUninstallInfo() throws Exception {
        String uninstallFilePath = CFAppDeployer.getUninstallFilePath(this.getAppName(), this.targetInstallFolder);
        File unInstallFile = new File(uninstallFilePath);
        unInstallFile.getParentFile().mkdirs();
        this.unInstallerInfo.saveUninstallInfo(unInstallFile);
    }

    private void verifyInstallationNotComplete() {
        if (this.installationComplete || this.installationaborted) {
            AppDeploymentExceptions.throwInstallationCompleteException();
        }
    }

    private boolean applicationExists(String appName) {
        String unInstallFilePath = CFAppDeployer.getUninstallFilePath(appName, this.targetInstallFolder);
        File unInstallFile = new File(unInstallFilePath);
        return unInstallFile.exists();
    }

    public void loadConfiguration() throws Exception {
        ZipFile zipFile = new ZipFile(new File(this.zipFilePath));
        File tmpFile = File.createTempFile("cf1", "appdep");
        File parentDir = tmpFile.getParentFile();
        tmpFile.delete();
        this.tmpAppFolder = null;
        int counter = 0;
        String zipFileName = zipFile.getName();
        int index = zipFileName.lastIndexOf(46);
        if (index > -1) {
            zipFileName = zipFileName.substring(0, index);
        }
        if ((index = zipFileName.lastIndexOf(File.separatorChar)) > -1) {
            zipFileName = zipFileName.substring(index + 1);
        }
        while (this.tmpAppFolder == null) {
            File tmpFolderPath;
            if (!(tmpFolderPath = new File(parentDir + File.separator + zipFileName + counter++)).mkdir() || !tmpFolderPath.exists()) continue;
            this.tmpAppFolder = tmpFolderPath;
            break;
        }
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            this.addZipEntry(entry);
        }
        this.unzipFile(zipFile);
        zipFile.close();
        ConfigFileParser parser = new ConfigFileParser(this.tmpAppFolder, this);
        parser.parse();
        this.configInfo = parser.getConfigInfo();
        if (this.applicationExists(this.getAppName())) {
            this.abortDeployment();
            AppDeploymentExceptions.throwApplicationExistsException(this.getAppName(), this.targetInstallFolder);
        }
        File tagetFile = new File(this.targetInstallFolder);
        tagetFile.mkdirs();
        this.targetInstallFolder = tagetFile.getCanonicalPath();
        this.logger = new AppDeploymentLogger(this.configInfo.getAppName(), this.targetInstallFolder);
        this.logger.info("start.install", new Object[]{this.getAppName()});
    }

    private void deleteFile(File file) {
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.deleteFile(children[i]);
            }
        }
        file.delete();
    }

    private void unzipFile(ZipFile zipFile) throws Exception {
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            File zipEntryFile = new File(this.tmpAppFolder.getAbsolutePath() + File.separator + entry.getName());
            if (entry.isDirectory()) {
                if (zipEntryFile.exists()) continue;
                zipEntryFile.mkdir();
                continue;
            }
            if (!zipEntryFile.getParentFile().mkdirs() && !zipEntryFile.getParentFile().exists()) {
                AppDeploymentExceptions.throwZipFileCreateException(zipEntryFile.getParentFile().getAbsolutePath());
            }
            if (!zipEntryFile.createNewFile()) {
                AppDeploymentExceptions.throwZipFileCreateException(zipEntryFile.getAbsolutePath());
            }
            InputStream inStream = zipFile.getInputStream(entry);
            FileOutputStream outStream = new FileOutputStream(zipEntryFile);
            byte[] buf = new byte[8192];
            int bytesRead = -1;
            while ((bytesRead = inStream.read(buf)) > 0) {
                outStream.write(buf, 0, bytesRead);
            }
            inStream.close();
            outStream.close();
        }
    }

    private void addZipEntry(ZipEntry entry) {
        Map<String, Object> currMap;
        String entryName;
        String folderPath = entryName = entry.getName();
        String fileName = null;
        if (!entry.isDirectory()) {
            int index = entryName.lastIndexOf(47);
            if (index > -1) {
                folderPath = entryName.substring(0, index);
                fileName = entryName.substring(index + 1);
            } else {
                fileName = entryName;
                this.zipData.put(fileName, fileName);
                return;
            }
        }
        StringTokenizer tk = new StringTokenizer(folderPath, "/");
        HashMap<String, Object> parentMap = currMap = this.zipData;
        while (tk.hasMoreElements()) {
            HashMap<String, Object> newFolderMap;
            String folderName = (String)tk.nextElement();
            currMap = !currMap.containsKey(folderName) ? (newFolderMap = new HashMap<String, Object>()) : (Map)currMap.get(folderName);
            if (parentMap != null) {
                parentMap.put(folderName, currMap);
            }
            parentMap = currMap;
        }
        if (fileName != null) {
            currMap.put(fileName, fileName);
        }
    }

    public String getAppName() {
        return this.configInfo.getAppName();
    }

    public String getAppVersion() {
        return this.configInfo.getVersionNum();
    }

    public String getAuthor() {
        return this.configInfo.getAuthor();
    }

    public String getUpdateURL() {
        return this.configInfo.getUpdateUrl();
    }

    public String getEmail() {
        return this.configInfo.getEmail();
    }

    public String getLicenceText() throws Exception {
        this.verifyInstallationNotComplete();
        if (this.configInfo.getPreInstallInfo() == null) {
            return "";
        }
        String path = this.configInfo.getPreInstallInfo().getLicenseFilePath();
        if (path == null) {
            return null;
        }
        String fullPath = this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "help" + File.separator + path;
        return this.getContent(fullPath);
    }

    public String getSerialNumber() {
        if (this.configInfo.getPreInstallInfo() == null) {
            return "";
        }
        return this.configInfo.getPreInstallInfo().getSerialNumber();
    }

    public void setSerialNumber(String serialNumber) {
        this.configInfo.getPreInstallInfo().setSerialNumber(serialNumber);
    }

    public ArrayList getRequiredLibraries() {
        if (this.configInfo.getPreInstallInfo() == null) {
            return new ArrayList();
        }
        return this.configInfo.getPreInstallInfo().getRequiredLibraires();
    }

    public ArrayList getPreInstallScripts() throws Exception {
        this.verifyInstallationNotComplete();
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        if (this.configInfo.getPreInstallInfo() == null) {
            return result;
        }
        ArrayList scripts = this.configInfo.getPreInstallInfo().getScripts();
        for (String shortPath : scripts) {
            String fullPath = this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + shortPath;
            result.add((CallSite)((Object)fullPath));
        }
        return result;
    }

    public ArrayList getPostInstallScripts() throws Exception {
        this.verifyInstallationNotComplete();
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        if (this.configInfo.getPostInstallInfo() == null) {
            return result;
        }
        ArrayList scripts = this.configInfo.getPostInstallInfo().getScripts();
        for (String shortPath : scripts) {
            String fullPath = this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + shortPath;
            result.add((CallSite)((Object)fullPath));
        }
        return result;
    }

    public String getPreInstallHelp() throws Exception {
        this.verifyInstallationNotComplete();
        if (this.configInfo.getPreInstallInfo() == null) {
            return "";
        }
        String shortPath = this.configInfo.getPreInstallInfo().getHelpFilePath();
        return this.getHelpContent(shortPath);
    }

    public String getApplicationDescription() throws Exception {
        this.verifyInstallationNotComplete();
        if (this.configInfo.getDescription() == null) {
            return "";
        }
        String shortPath = this.configInfo.getDescription();
        return this.getHelpContent(shortPath);
    }

    public String getPostInstallHelp() throws Exception {
        this.verifyInstallationNotComplete();
        if (this.configInfo.getPostInstallInfo() == null) {
            return "";
        }
        String shortPath = this.configInfo.getPostInstallInfo().getHelpFilePath();
        return this.getHelpContent(shortPath);
    }

    public ArrayList getMappings() {
        MappingsInfoCollection mappings = this.configInfo.getMappings();
        return mappings.getMappingsInfo();
    }

    public ArrayList getDataSources() {
        DataSourceInfoCollection dsCollection = this.configInfo.getDatasources();
        return dsCollection.getDataSourcesInfo();
    }

    public ArrayList getProperties() {
        PropertiesInfoCollection propCollection = this.configInfo.getProperties();
        return propCollection.getPropertiesInfo();
    }

    public ArrayList getMappingsWithVariableNames() {
        MappingsInfoCollection mappings = this.configInfo.getMappings();
        return mappings.getMappingsWithVariableName();
    }

    public ArrayList getMappingsWithValueInput() {
        MappingsInfoCollection mappings = this.configInfo.getMappings();
        return mappings.getMappingsWithValuesForInput();
    }

    public MappingInfo getMappingInfo(String name) {
        MappingsInfoCollection mappings = this.configInfo.getMappings();
        return mappings.getMappingInfo(name);
    }

    public DataSourceInfo getDatasourceInfo(String name) {
        DataSourceInfoCollection datasources = this.configInfo.getDatasources();
        return datasources.getDataSourceInfo(name);
    }

    public PropertyInfo getPropertyInfo(String name) {
        PropertiesInfoCollection properties = this.configInfo.getProperties();
        return properties.getPropertyInfo(name);
    }

    public String getHelpContent(String shortPath) throws Exception {
        this.verifyInstallationNotComplete();
        if (shortPath == null) {
            return null;
        }
        String fullPath = this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "help" + File.separator + shortPath;
        File tmpFile = new File(fullPath);
        if (!tmpFile.exists()) {
            return shortPath;
        }
        return this.getContent(fullPath);
    }

    public void createMappings() throws Exception {
        MappingsInfoCollection mappingsCol = this.configInfo.getMappings();
        ArrayList mappings = mappingsCol.getMappingsInfo();
        for (int i = 0; i < mappings.size(); ++i) {
            MappingInfo info = (MappingInfo)mappings.get(i);
            this.createMapping(info);
        }
    }

    public void createMapping(String mappingName) throws Exception {
        MappingInfo mappingInfo = this.getMappingInfo(mappingName);
        if (mappingInfo == null) {
            AppDeploymentExceptions.throwMappingNotFoundException(mappingName);
        }
        this.createMapping(mappingInfo);
    }

    public void createMapping(MappingInfo mappingInfo) throws Exception {
        String nameVarValue = mappingInfo.getNameVarValue();
        String path = mappingInfo.getPath();
        String mapName = nameVarValue == null ? mappingInfo.getName() : nameVarValue;
        this.createMapping(mapName, path);
    }

    public void createMapping(String source, String target) throws Exception {
        if (((String)source).equalsIgnoreCase("/CFIDE")) {
            AppDeploymentExceptions.throwCFIDEMappingExceptionException();
        }
        if (((String)(source = ((String)source).trim())).charAt(0) != '/') {
            source = "/" + (String)source;
        }
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        Map mappings = runtimeService.getMappings();
        mappings.put(source, target);
        this.unInstallerInfo.addMapping((String)source, target);
        this.logger.info("mapping.created", new Object[]{source, target});
    }

    private static void removeMapping(String source) throws Exception {
        if (source.equalsIgnoreCase("/CFIDE")) {
            AppDeploymentExceptions.throwCFIDERemoveMappingException();
        }
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        Map mappings = runtimeService.getMappings();
        mappings.remove(source);
    }

    private static void deleteFolder(File folder) throws Exception {
        if (!folder.isDirectory()) {
            return;
        }
        File[] childFiles = folder.listFiles();
        for (int i = 0; i < childFiles.length; ++i) {
            if (!childFiles[i].isDirectory()) continue;
            CFAppDeployer.deleteFolder(childFiles[i]);
        }
        folder.delete();
    }

    protected String getContent(String filePath) throws Exception {
        FileReader reader = new FileReader(filePath);
        BufferedReader reader1 = new BufferedReader(reader);
        String line = null;
        StringBuffer buf = new StringBuffer();
        while ((line = reader1.readLine()) != null) {
            buf.append(line);
        }
        reader.close();
        return buf.toString();
    }

    public TemplateProxy createCFC(String pathOfCFC, NeoPageContext pageContext) throws Throwable {
        File scriptFile = new File(pathOfCFC);
        TemplateProxy proxy = TemplateProxyFactory.resolveName(null, pageContext, scriptFile, "___preinstall", true, null);
        proxy.verifyInterfacesImpl(pageContext);
        return proxy;
    }

    public String getInstallationFolder() {
        return this.targetInstallFolder;
    }

    public String getCFRootDir() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        return runtimeService.getRootDir();
    }

    public Map getFileCopyInfo() {
        return this.configInfo.getFileCopyInfo();
    }

    public String getCFDocRoot() {
        if (this.cfDocRoot != null) {
            return this.cfDocRoot;
        }
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        Map mappings = runtimeService.getMappings();
        String cfIDEMapping = (String)mappings.get("/CFIDE");
        if (cfIDEMapping == null) {
            return null;
        }
        int index = cfIDEMapping.indexOf("CFIDE");
        this.cfDocRoot = cfIDEMapping.substring(0, index - 1);
        return this.cfDocRoot;
    }

    public void copyFiles() throws Exception {
        this.verifyInstallationNotComplete();
        this.copyFiles(new File(this.tmpAppFolder.getAbsolutePath() + File.separator + "application"), this.configInfo.getFileCopyInfo());
    }

    public void finishCopyFiles() throws Exception {
        this.verifyInstallationNotComplete();
        Map sectionCopyInfo = this.configInfo.getFileCopyInfo();
        HashMap mergedFileCopyInfo = new HashMap();
        for (Map copyInfo : sectionCopyInfo.values()) {
            mergedFileCopyInfo.putAll(copyInfo);
        }
        this.copyFiles(mergedFileCopyInfo);
    }

    private void copyFiles(Map fileCopyInfo) throws Exception {
        this.verifyInstallationNotComplete();
        this.copyFiles(new File(this.tmpAppFolder.getAbsolutePath() + File.separator + "application"), fileCopyInfo);
    }

    private void copyFiles(File aFile, Map fileCopyInfo) throws Exception {
        File[] files = aFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File targetFolder;
            File childFile = files[i];
            FileCopyInfo copyInfo = null;
            String targetPath = null;
            boolean createFolder = true;
            if (fileCopyInfo != null) {
                copyInfo = this.getFileCopyInfo(childFile, fileCopyInfo);
                if (copyInfo == null || (targetPath = copyInfo.getDestination()) == null) continue;
                createFolder = copyInfo.isCreateFolder();
            }
            if (targetPath == null) {
                targetPath = this.targetInstallFolder;
                createFolder = true;
            }
            if (!(targetFolder = new File(targetPath)).exists()) {
                targetFolder.mkdir();
            }
            this.copyToFolder(childFile, targetFolder, createFolder);
            if (!childFile.isDirectory()) continue;
            this.copyFiles(childFile, fileCopyInfo);
        }
    }

    private void copyToFolder(File srcFile, File targetFile, boolean createDestfolder) throws Exception {
        String srcFilePath = srcFile.getCanonicalPath();
        String fileName = srcFile.getName();
        String tmpAppFolderPath = this.tmpAppFolder.getCanonicalPath();
        String relativePath = srcFilePath.substring(tmpAppFolderPath.length());
        int index = relativePath.toLowerCase().indexOf("application");
        relativePath = relativePath.substring(index + "application".length() + 1);
        StringTokenizer tk = new StringTokenizer(relativePath, File.separator);
        File parentFile = targetFile;
        while (tk.hasMoreElements()) {
            File newFile;
            String folderPath;
            String name = (String)tk.nextElement();
            if (name.equals(fileName)) {
                if (srcFile.isDirectory()) {
                    if (!createDestfolder) {
                        createDestfolder = true;
                        continue;
                    }
                    folderPath = parentFile.getAbsolutePath() + File.separator + name;
                    if (this.unInstallerInfo.isFolderCreated(folderPath)) continue;
                    newFile = new File(folderPath);
                    if (!newFile.exists()) {
                        newFile.mkdir();
                        this.unInstallerInfo.addFolderCreated(newFile.getAbsolutePath());
                        this.logger.info("folder.created", new Object[]{newFile.getAbsolutePath()});
                        continue;
                    }
                } else {
                    String filePath = parentFile.getAbsolutePath() + File.separator + name;
                    if (this.unInstallerInfo.isFileCopied(filePath)) continue;
                    newFile = new File(filePath);
                    FileInputStream inStream = new FileInputStream(srcFile);
                    FileOutputStream outStream = new FileOutputStream(newFile);
                    byte[] buf = new byte[8192];
                    int bytesRead = 0;
                    while ((bytesRead = inStream.read(buf)) > 0) {
                        outStream.write(buf, 0, bytesRead);
                    }
                    inStream.close();
                    outStream.close();
                    this.unInstallerInfo.addFileCopied(newFile.getAbsolutePath());
                    this.logger.info("copied.file", new Object[]{newFile.getAbsolutePath()});
                }
            }
            if (createDestfolder) {
                folderPath = parentFile.getAbsolutePath() + File.separator + name;
                parentFile = newFile = new File(folderPath);
                if (this.unInstallerInfo.isFolderCreated(folderPath) || newFile.exists()) continue;
                newFile.mkdir();
                this.unInstallerInfo.addFolderCreated(newFile.getAbsolutePath());
                this.logger.info("folder.created", new Object[]{newFile.getAbsolutePath()});
                continue;
            }
            createDestfolder = true;
        }
    }

    private FileCopyInfo getFileCopyInfo(File fileToCopy, Map fileCopyInfo) throws Exception {
        String path = fileToCopy.getAbsolutePath();
        if (SystemInfo.isWindows()) {
            path = path.toLowerCase();
        }
        Iterator it = fileCopyInfo.keySet().iterator();
        while (it.hasNext()) {
            String key;
            String lowerCaseKey = key = (String)it.next();
            if (SystemInfo.isWindows()) {
                lowerCaseKey = key.toLowerCase();
            }
            if (path.indexOf(lowerCaseKey) <= -1) continue;
            return (FileCopyInfo)fileCopyInfo.get(key);
        }
        return null;
    }

    public String getMappingsValidatorPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getMappingsScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }

    public String getDataSourcesValidatorPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getDatasourcesScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }

    public String getPropertiesValidatorPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getPropertiesScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }

    public boolean hasInstallTypes() {
        return this.configInfo.getInstallTypes().size() > 0;
    }

    public Map getInstallTypes() {
        return this.configInfo.getInstallTypes();
    }

    public CFAppDeployer loadInstallType(String typeName) throws Exception {
        if (this.parentDeployer != null) {
            return this.parentDeployer.loadInstallType(typeName);
        }
        this.verifyInstallationNotComplete();
        Object obj = this.configInfo.getInstallTypes().get(typeName);
        if (obj == null) {
            AppDeploymentExceptions.throwInstallTypeNotFoundException(typeName);
        }
        InstallTypeInfo installInfo = (InstallTypeInfo)obj;
        String configPath = installInfo.getConfigPath();
        CFAppDeployer childDeployer = new CFAppDeployer(this);
        childDeployer.logger = this.logger;
        ConfigFileParser parser = new ConfigFileParser(this.tmpAppFolder, childDeployer);
        parser.parse(configPath);
        childDeployer.configInfo = parser.getConfigInfo();
        childDeployer.configInfo.setAppName(this.configInfo.getAppName());
        childDeployer.configInfo.setAuthor(this.configInfo.getAuthor());
        childDeployer.configInfo.setEmail(this.configInfo.getEmail());
        childDeployer.configInfo.setUpdateUrl(this.configInfo.getUpdateUrl());
        childDeployer.configInfo.setVersionNum(this.configInfo.getVersionNum());
        this.logger.info("install.type", new Object[]{typeName});
        return childDeployer;
    }

    public void setMappingPath(String mappingName, String path) throws Exception {
        MappingInfo mapping = this.getMappingInfo(mappingName);
        if (mapping == null) {
            AppDeploymentExceptions.throwMappingNotFoundException(mappingName);
        }
        path = this.replaceSystemVariableValues(path);
        mapping.setPath(path);
        this.logger.info("mapping.set", new Object[]{mappingName, path});
    }

    public void setMappingAliasValue(String mappingAlias, String value) throws Exception {
        MappingInfo mapping = this.getMappingInfo(mappingAlias);
        if (mapping == null) {
            AppDeploymentExceptions.throwMappingNotFoundException(mappingAlias);
        }
        mapping.setNameVarValue(value);
        this.logger.info("set.mapping.alias", new Object[]{mappingAlias, value});
    }

    public void setDatasourceAliasValue(String dsAlias, String value) throws Exception {
        DataSourceInfo dsInfo = this.getDatasourceInfo(dsAlias);
        if (dsInfo == null) {
            AppDeploymentExceptions.throwDataSourceNotFoundException(dsAlias);
        }
        dsInfo.setDsAliasValue(value);
        this.logger.info("set.ds.alias", new Object[]{dsAlias, value});
    }

    public void setPropertyAliasValue(String propAlias, String value) throws Exception {
        PropertyInfo propInfo = this.getPropertyInfo(propAlias);
        if (propInfo == null) {
            AppDeploymentExceptions.throwPropertyNotFoundException(propAlias);
        }
        propInfo.setPropAliasValue(value);
        this.logger.info("set.prop.alias", new Object[]{propAlias, value});
    }

    public void setPropertyValue(String propName, String value) throws Exception {
        PropertyInfo propInfo = this.getPropertyInfo(propName);
        if (propInfo == null) {
            AppDeploymentExceptions.throwPropertyNotFoundException(propName);
        }
        value = this.replaceSystemVariableValues(value);
        propInfo.setValue(value);
        this.logger.info("set.prop.value", new Object[]{propName, value});
    }

    public String replaceSystemVariableValues(String str) {
        String tmpStr = str;
        if (tmpStr == null || tmpStr.indexOf(36) < 0) {
            return tmpStr;
        }
        tmpStr = tmpStr.toLowerCase();
        String result = str;
        int index = tmpStr.indexOf("$installfolder");
        if (index >= 0) {
            result = this.replaceString(str, index, index + 14, this.getInstallationFolder());
            if (result.indexOf(36) == -1) {
                return result;
            }
            tmpStr = result.toLowerCase();
        }
        if ((index = tmpStr.indexOf("$cfrootfolder")) >= 0) {
            if ((result = this.replaceString(result, index, index + 13, this.getCFRootDir())).indexOf(36) == -1) {
                return result;
            }
            tmpStr = result.toLowerCase();
        }
        if ((index = tmpStr.indexOf("$cfwwwrootfolder")) >= 0 && (result = this.replaceString(result, index, index + 16, this.getCFDocRoot())).indexOf(36) == -1) {
            return result;
        }
        return result;
    }

    private String replaceString(String srcStr, int fromIndex, int toIndex, String replacementString) {
        Object result = srcStr.substring(0, fromIndex);
        result = (String)result + replacementString;
        result = (String)result + srcStr.substring(toIndex);
        return result;
    }

    public void appApplicationInfoToRepository() throws Exception {
        appInstallerService.addApplication(this);
    }

    public static void removeApplicationInfoFromRepository(String appName, String installFolderPath) throws Exception {
        CFAppDeployer.startAppInstallerService();
        appInstallerService.removeApplication(appName, installFolderPath);
    }

    public static Map getApplicationsInfoFromRepository() throws Exception {
        CFAppDeployer.startAppInstallerService();
        return appInstallerService.getApplicationsInfo();
    }

    public static Map getUninstallerInfo(String appName, String appFolder) throws Exception {
        UninstallerInfo unInstallerInfo = new UninstallerInfo();
        String unInstallFilePath = CFAppDeployer.getUninstallFilePath(appName, appFolder);
        unInstallerInfo.loadUninstallInfo(new File(unInstallFilePath));
        return unInstallerInfo.getUninstallInfoMap();
    }

    public static void unInstallApplication(String appName, String appFolder) throws Exception {
        UninstallerInfo unInstallerInfo = new UninstallerInfo();
        String unInstallFilePath = CFAppDeployer.getUninstallFilePath(appName, appFolder);
        File unInstallerFile = new File(unInstallFilePath);
        if (!unInstallerFile.exists()) {
            CFAppDeployer.removeApplicationInfoFromRepository(appName, appFolder);
            AppDeploymentExceptions.throwUninstallerInfoMissingException(appName);
        }
        unInstallerInfo.loadUninstallInfo(unInstallerFile);
        CFAppDeployer.unInstallApplication(unInstallerInfo, unInstallerFile, appName, appFolder);
    }

    private static void unInstallApplication(UninstallerInfo unInstallerInfo, File unInstallerFile, String appName, String appFolder) throws Exception {
        ArrayList foldersCreated;
        ArrayList files;
        Map mappingsInfo = unInstallerInfo.getMappingsInfo();
        if (mappingsInfo != null) {
            for (String key : mappingsInfo.keySet()) {
                CFAppDeployer.removeMapping(key);
            }
        }
        if ((files = unInstallerInfo.getFileCopied()) != null) {
            for (String filePath : files) {
                File aFile = new File(filePath);
                aFile.delete();
            }
        }
        if (unInstallerFile != null) {
            File parentfile = unInstallerFile.getParentFile();
            unInstallerFile.delete();
            parentfile.delete();
        }
        if ((foldersCreated = unInstallerInfo.getFoldersCreated()) != null) {
            for (String folderPath : foldersCreated) {
                File aFile = new File(folderPath);
                if (!aFile.exists()) continue;
                try {
                    CFAppDeployer.deleteFolder(aFile);
                }
                catch (Exception exception) {}
            }
        }
        File logfile = new File(AppDeploymentLogger.getLogFilePath(appName, appFolder));
        logfile.delete();
        File appFolderFileObj = new File(appFolder);
        if (appFolderFileObj.list().length == 0) {
            appFolderFileObj.delete();
        }
        CFAppDeployer.removeApplicationInfoFromRepository(appName, appFolder);
    }

    private void copyFiles(String sectionName) throws Exception {
        Map fileCopyInfo = this.configInfo.getFileCopyInfo();
        Object obj = fileCopyInfo.get(sectionName);
        if (obj == null) {
            return;
        }
        Map fileCopyDetails = (Map)obj;
        this.copyFiles(fileCopyDetails);
    }

    public void copyFilesAfterAppInfo() throws Exception {
        this.copyFiles("appinfo");
    }

    public void copyFilesAfterPreInstall() throws Exception {
        this.copyFiles("preinstall");
    }

    public void copyFilesAfterMappings() throws Exception {
        this.copyFiles("mappings");
    }

    public void copyFilesAfterDatasources() throws Exception {
        this.copyFiles("datasources");
    }

    public void copyFilesAfterProperties() throws Exception {
        this.copyFiles("properties");
    }

    public void copyFilesAfterPostInstall() throws Exception {
        this.copyFiles("postinstall");
    }

    public static Array getStructKeyArray(Map struct) {
        if (!(struct instanceof OrderedHashMap)) {
            return StructUtils.StructKeyArray(struct);
        }
        Array ary = new Array(1);
        OrderedHashMap ordMap = (OrderedHashMap)struct;
        Iterator it = ordMap.getKeys();
        while (it.hasNext()) {
            ary.add(it.next());
        }
        return ary;
    }

    public static String getStructKeyList(Map struct) {
        if (!(struct instanceof OrderedHashMap)) {
            return StructUtils.StructKeyList(struct);
        }
        OrderedHashMap ordMap = (OrderedHashMap)struct;
        StringBuffer str = new StringBuffer();
        Iterator iterator = ordMap.getKeys();
        boolean started = false;
        while (iterator.hasNext()) {
            if (started) {
                str.append(',');
            }
            str.append(Cast._String(iterator.next()));
            started = true;
        }
        return str.toString();
    }

    public String getMappingsEventsHandlerScriptPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getMappingsScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }

    public String getPropertiesEventsHandlerScriptPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getPropertiesScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }

    public String getDatasourcesEventsHandlerScriptPath() {
        this.verifyInstallationNotComplete();
        String path = this.configInfo.getDatasourcesScriptPath();
        if (path == null) {
            return null;
        }
        return this.tmpAppFolder.getAbsolutePath() + File.separator + "installer" + File.separator + "scripts" + File.separator + path.trim();
    }
}

