/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.client;

import coldfusion.centralconfig.client.CFConfigFilesWatcher;
import coldfusion.centralconfig.client.CentralConfigRefreshServlet;
import coldfusion.centralconfig.client.discovery.CFToCCSMulticastSender;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Struct;
import coldfusion.server.CFService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.util.RB;
import coldfusion.util.URLEncoder;
import com.adobe.coldfusion.entman.ProcessServer;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.swing.Timer;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.xml.sax.InputSource;

public class CentralConfigClientUtil {
    private static String ccsServerProtocol = "http";
    private static String hostname = "";
    private static String hostPort = "";
    private static String context = "";
    private static String ccsServerIP = "localhost";
    private static String ccsEnv = "development";
    private static int ccsServerPort = 7071;
    private static String ccsClusterName = "_CF_DEFAULT";
    private static boolean isCCSEnabled = false;
    private static String filesToBeExcluded = "";
    private static boolean isCCSRunning = false;
    private static boolean ccsCheckDone = false;
    private static String currentVersion = "1";
    private static String loadVersionFrom = "-1";
    private static String loadEnvFrom = "development";
    private static String latestVersion = "-1";
    private static String ccsSecretKey = "";
    public static boolean carMigrationStarted = false;
    private static boolean CCS_SELF_SIGNED_CERT_ENABLE = Boolean.parseBoolean(System.getProperty("coldfusion.ccs.selfsignedcert", "false"));
    public static Set<String> cfSettingsFiles;
    static Map<String, String> localSettingsMap;
    private static Thread watcherThread;

    public static String pullFromCCSFilename(String fileName, String path) throws Exception {
        File file = CentralConfigClientUtil.pullFromCCSFile(fileName);
        if (null == file) {
            return path;
        }
        return file.getAbsolutePath();
    }

    public static InputSource pullFromCCS(File file, InputSource source) throws Exception {
        return CentralConfigClientUtil.pullFromCCS(file.getName(), source);
    }

    public static File pullFromCCSFile(final String fileName) {
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return CentralConfigClientUtil._pullFromCCSFile(fileName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File _pullFromCCSFile(String fileName) throws Exception {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return null;
        }
        if (!CentralConfigClientUtil.isModuleAllowedInCCS(fileName)) {
            return null;
        }
        if (CentralConfigClientUtil.excludeFile(fileName)) {
            return null;
        }
        Object url = CentralConfigClientUtil.getReadServerURL();
        url = (String)url + fileName;
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpGet get = new HttpGet((String)url);
        String content = "";
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
            ccsCheckDone = false;
            isCCSRunning = false;
            return null;
        }
        File tempFile = File.createTempFile("prefix-", "-suffix");
        OutputStreamWriter fw = null;
        try {
            tempFile.deleteOnExit();
            fw = new FileWriter(tempFile.getAbsolutePath());
            fw.write(content);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        finally {
            if (null != fw) {
                fw.close();
            }
        }
        return tempFile;
    }

    public static InputSource pullFromCCS(String fileName, InputSource source) throws Exception {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return source;
        }
        if (!CentralConfigClientUtil.isModuleAllowedInCCS(fileName)) {
            return source;
        }
        if (CentralConfigClientUtil.excludeFile(fileName)) {
            return source;
        }
        source = new InputSource(new FileReader(CentralConfigClientUtil.pullFromCCSFile(fileName)));
        return source;
    }

    private static boolean isModuleAllowedInCCS(String fileName) {
        for (String neo : cfSettingsFiles) {
            if (!fileName.equals(neo)) continue;
            return true;
        }
        return false;
    }

    public static String getCurrentVersion() {
        return currentVersion;
    }

    private static String getReadServerURL() {
        String profile = CentralConfigClientUtil.getLoadEnvFrom();
        String version = loadVersionFrom;
        return CentralConfigClientUtil.getCcsBaseUrl() + "/neo/" + CentralConfigClientUtil.getClusterName() + "/" + profile + "/" + version + "/";
    }

    private static String appendHostnamePort(String url) {
        url = (String)url + "?hostname=" + hostname + "&hostport=" + hostPort + "&context=" + context;
        return url;
    }

    public static String getClusterName() {
        return ccsClusterName;
    }

    private static String getWriteServerURL() {
        String env = CentralConfigClientUtil.getEnv();
        String loadedEnv = CentralConfigClientUtil.getLoadEnvFrom();
        String version = loadVersionFrom;
        return CentralConfigClientUtil.getCcsBaseUrl() + "/neo/" + CentralConfigClientUtil.getClusterName() + "/" + env + "/" + loadedEnv + "/" + version + "/";
    }

    private static String getActionURL() {
        String env = CentralConfigClientUtil.getEnv();
        String version = loadVersionFrom;
        return CentralConfigClientUtil.getCcsBaseUrl() + "/action/" + CentralConfigClientUtil.getClusterName() + "/" + env + "/";
    }

    private static void storeCCSServerConfig() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigClientUtil._storeCCSServerConfig();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    private static void _storeCCSServerConfig() {
        File file = CentralConfigClientUtil.getCCSPropertiesFile();
        Properties props = new Properties();
        props.put("protocol", ccsServerProtocol);
        props.put("server", ccsServerIP);
        props.put("environment", ccsEnv);
        props.put("port", "" + ccsServerPort);
        props.put("context", context);
        props.put("enabled", "" + isCCSEnabled);
        props.put("clustername", ccsClusterName);
        props.put("loadenvfrom", loadEnvFrom);
        props.put("loadversionfrom", loadVersionFrom);
        props.put("currentversion", currentVersion);
        props.put("ccssecretkey", ccsSecretKey);
        props.put("hostname", hostname);
        props.put("hostport", hostPort);
        props.put("excludefiles", filesToBeExcluded);
        try (FileOutputStream stream = new FileOutputStream(file);){
            props.store(stream, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isCCSEnabled) {
            ccsCheckDone = false;
            isCCSRunning = false;
            CentralConfigClientUtil.isCCSRunning();
        }
    }

    private static File getCCSPropertiesFile() {
        File file = CFService.getFile("ccs" + File.separator + "ccs.properties");
        return file;
    }

    private static void init() {
        CentralConfigClientUtil.initClientConfig();
    }

    private static void initMulticast() {
        CFToCCSMulticastSender.startMulticastService();
    }

    public static void initHostname(String hn) {
        if (null == hn) {
            InetAddress localHost = null;
            try {
                localHost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            hostname = localHost.getHostName();
        } else {
            hostname = hn;
        }
        CentralConfigClientUtil.storeCCSServerConfig();
    }

    public static void initHostport(int port) {
        if (hostPort == null || hostPort.length() == 0) {
            hostPort = "" + port;
            CentralConfigClientUtil.storeCCSServerConfig();
        }
    }

    public static void initContext(String ctx) {
        if (context == null || context.length() == 0) {
            context = ctx;
            CentralConfigClientUtil.storeCCSServerConfig();
        }
    }

    public static void initHostport() {
        if (FusionContext.getCurrent() != null && FusionContext.getCurrent().getRequest() != null) {
            hostPort = "" + FusionContext.getCurrent().getRequest().getServerPort();
            CentralConfigClientUtil.storeCCSServerConfig();
        }
    }

    public static String getHostport() {
        return hostPort;
    }

    private static void initClientConfig() {
        File file = CentralConfigClientUtil.getCCSPropertiesFile();
        if (null == file || !file.exists()) {
            isCCSEnabled = false;
            return;
        }
        String ccsinfo = file.getAbsolutePath();
        if (!new File(ccsinfo).exists()) {
            CFLogs.SERVER_LOG.warn("Could not find : " + ccsinfo);
            return;
        }
        try {
            DataInputStream ds = new DataInputStream(new FileInputStream(ccsinfo));
            Properties _props = new Properties();
            _props.load(ds);
            if (_props.getProperty("enabled") != null) {
                isCCSEnabled = Boolean.valueOf(_props.getProperty("enabled"));
            }
            if (_props.getProperty("server") != null) {
                ccsServerIP = _props.getProperty("server");
            }
            if (_props.getProperty("hostname") != null) {
                hostname = _props.getProperty("hostname");
            } else {
                CentralConfigClientUtil.initHostname(null);
            }
            if (_props.getProperty("hostport") != null) {
                hostPort = _props.getProperty("hostport");
            } else {
                CentralConfigClientUtil.initHostport();
            }
            if (_props.getProperty("clustername") != null) {
                ccsClusterName = _props.getProperty("clustername");
            }
            if (_props.getProperty("excludefiles") != null) {
                filesToBeExcluded = _props.getProperty("excludefiles");
            }
            if (_props.getProperty("port") != null) {
                ccsServerPort = Integer.valueOf(_props.getProperty("port"));
            }
            if (_props.getProperty("protocol") != null) {
                ccsServerProtocol = _props.getProperty("protocol");
            }
            if (_props.getProperty("currentversion") != null) {
                currentVersion = _props.getProperty("currentversion");
            }
            if (_props.getProperty("environment") != null) {
                ccsEnv = _props.getProperty("environment");
            }
            if (_props.getProperty("context") != null) {
                context = _props.getProperty("context");
            }
            if (_props.getProperty("loadenvfrom") != null) {
                loadEnvFrom = _props.getProperty("loadenvfrom");
            }
            if (_props.getProperty("loadversionfrom") != null) {
                loadVersionFrom = _props.getProperty("loadversionfrom");
            }
            if (_props.getProperty("ccssecretkey") != null) {
                ccsSecretKey = _props.getProperty("ccssecretkey");
                if (ccsSecretKey.length() == 0) {
                    CentralConfigClientUtil.generateSecretKey();
                }
            } else {
                CentralConfigClientUtil.generateSecretKey();
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    private static void generateSecretKey() {
        ccsSecretKey = UUID.randomUUID().toString();
        CentralConfigClientUtil.storeCCSServerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCCSRunning() {
        String url = CentralConfigClientUtil.getHealthURL();
        url = CentralConfigClientUtil.appendMetadata(url);
        HttpGet get = new HttpGet(url);
        String content = "";
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (content.equals("OK")) {
                isCCSRunning = true;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.error(RB.getString(CentralConfigClientUtil.class, "CCS.server.not.running", (Object)url, (Object)ex.toString()), ex);
        }
        finally {
            ccsCheckDone = true;
        }
        return false;
    }

    public static boolean isCCSAvailaible() {
        if (!isCCSEnabled) {
            return false;
        }
        if (isCCSRunning) {
            return true;
        }
        if (ccsCheckDone) {
            return false;
        }
        isCCSRunning = CentralConfigClientUtil.isCCSRunning();
        if (!isCCSRunning) {
            CFLogs.SERVER_LOG.error(RB.getString(CentralConfigClientUtil.class, "CCS.server.not.accessible", (Object)CentralConfigClientUtil.getHealthURL()));
        }
        return isCCSRunning;
    }

    private static String getHealthURL() {
        return CentralConfigClientUtil.getCcsBaseUrl() + "/health/";
    }

    public static void pushToCCS(String fileName, Properties props) throws Exception {
        Object data = "";
        for (Object key : props.keySet()) {
            data = (String)data + key + "=" + props.getProperty(key.toString()) + System.lineSeparator();
        }
        CentralConfigClientUtil.pushToCCS(fileName, (String)data, (Object)fileName, null, null);
    }

    public static void pushToCCS(String fileName, Properties props, Object keyStr, Object value, Object oldValue) throws Exception {
        Object data = "";
        for (Object key : props.keySet()) {
            data = (String)data + key + "=" + props.getProperty(key.toString()) + System.lineSeparator();
        }
        CentralConfigClientUtil.pushToCCS(fileName, (String)data, keyStr, value, oldValue);
    }

    public static void pushToCCS(File file) throws Exception {
        CentralConfigClientUtil.modifyFileMetadata(file);
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        String data = Files.readAllLines(path).get(0);
        CentralConfigClientUtil.pushToCCS(file.getName(), data, null, null, null);
    }

    public static void pushToCCS(File file, Object key, Object value, Object oldValue) throws Exception {
        CentralConfigClientUtil.modifyFileMetadata(file);
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        String data = Files.readAllLines(path).get(0);
        CentralConfigClientUtil.pushToCCS(file.getName(), data, key, value, oldValue);
    }

    public static void pushToCCS(File file, String data, Object key, Object value, Object oldValue) throws Exception {
        CentralConfigClientUtil.pushToCCS(file.getName(), data, key, value, oldValue);
    }

    public static void _modifyFileMetadata(File file) {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return;
        }
        String ct = "" + System.currentTimeMillis();
        ct = ct.substring(0, ct.length() - 4) + "0000";
        file.setLastModified(Long.valueOf(ct));
    }

    public static void modifyFileMetadata(final File file) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigClientUtil._modifyFileMetadata(file);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    public static void pushActionToCCS(String action, String param) throws Exception {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return;
        }
        String username = CentralConfigClientUtil.getUsername();
        String key = action;
        if (key != null) {
            key = URLEncoder.encode(key);
        }
        Object url = CentralConfigClientUtil.getActionURL();
        url = CentralConfigClientUtil.appendMetadata((String)url);
        url = (String)url + "&serverid=" + ServiceBase.serverId + "&username=" + username + "&action=" + key + "&carmigrationstarted=" + carMigrationStarted;
        HttpPost post = new HttpPost((String)url);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("data", param));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            String s = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            ccsCheckDone = false;
            isCCSRunning = false;
        }
    }

    public static void pushToCCS(String fileName, String data, Object key, Object value, Object oldValue) throws Exception {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return;
        }
        if (!CentralConfigClientUtil.isModuleAllowedInCCS(fileName)) {
            return;
        }
        if (CentralConfigClientUtil.isLocalSetting(fileName, key, value)) {
            return;
        }
        if (CentralConfigClientUtil.handleMiscSettings(key, oldValue)) {
            return;
        }
        if (CentralConfigClientUtil.excludeFile(fileName)) {
            return;
        }
        String username = CentralConfigClientUtil.getUsername();
        if (key != null) {
            key = URLEncoder.encode((String)key);
        }
        Object url = CentralConfigClientUtil.getWriteServerURL() + fileName;
        url = CentralConfigClientUtil.appendMetadata((String)url);
        url = (String)url + "&serverid=" + ServiceBase.serverId + "&username=" + username + "&key=" + key + "&carmigrationstarted=" + carMigrationStarted;
        HttpPost post = new HttpPost((String)url);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("data", data));
        urlParameters.add(new BasicNameValuePair("value", String.valueOf(value)));
        urlParameters.add(new BasicNameValuePair("oldvalue", String.valueOf(oldValue)));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters));
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            String version = EntityUtils.toString((HttpEntity)response.getEntity());
            if (version.equals("-2")) {
                return;
            }
            if (!loadVersionFrom.equals(latestVersion) || !ccsEnv.equals(loadEnvFrom)) {
                loadVersionFrom = currentVersion = latestVersion;
                loadEnvFrom = ccsEnv;
                CentralConfigClientUtil.loadVersion(loadVersionFrom, loadEnvFrom);
            }
            currentVersion = latestVersion;
            CentralConfigClientUtil.storeCCSServerConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
            ccsCheckDone = false;
            isCCSRunning = false;
        }
    }

    private static boolean isLocalSetting(String fileName, Object key, Object value) {
        if (null != value && value instanceof String && new File((String)value).exists()) {
            return true;
        }
        if (!(key instanceof String)) {
            return false;
        }
        if (CentralConfigClientUtil.isPassword((String)key)) {
            return true;
        }
        String ls = localSettingsMap.get(fileName);
        if (null == ls || key == null) {
            return false;
        }
        return ls.toLowerCase().contains(((String)key).toLowerCase());
    }

    private static boolean isPassword(String key) {
        return key != null && key.toLowerCase().contains("password");
    }

    private static boolean handleMiscSettings(Object key, Object value) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        String sKey = (String)key;
        if (sKey.equals("corePoolSizeCloudServices") || sKey.equals("maxPoolSizeCloudServices")) {
            if (value != null && value instanceof Integer && (Integer)value == 0) {
                return true;
            }
            if (value != null && value instanceof Double && (Double)value == 0.0) {
                return true;
            }
        }
        return sKey.equals("CFFormScriptSrc") && value != null && value instanceof String && ((String)value).equals("");
    }

    private static boolean excludeFile(String fileName) {
        String[] files;
        for (String file : files = filesToBeExcluded.split(",")) {
            if (!file.equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }

    private static String getUsername() {
        if (FusionContext.getCurrent() != null && FusionContext.getCurrent().getSecureTable() != null) {
            return FusionContext.getCurrent().getSecureTable().getUserName();
        }
        return "";
    }

    public static void loadVersion(String version, String env) {
        CentralConfigClientUtil.loadVersion(version, env, false);
    }

    public static void loadVersion(String version, String env, boolean force) {
        if (!force && version.equals(loadVersionFrom) && loadEnvFrom.equals(env)) {
            return;
        }
        loadVersionFrom = version;
        loadEnvFrom = env;
        CentralConfigClientUtil.storeCCSServerConfig();
        CentralConfigRefreshServlet.reloadAllModules();
    }

    private static String getCcsBaseUrl() {
        return ccsServerProtocol + "://" + ccsServerIP + ":" + ccsServerPort;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getLatestVersion() {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return "0";
        }
        Object url = CentralConfigClientUtil.getCcsBaseUrl() + "/latestversion/" + CentralConfigClientUtil.getClusterName() + "/" + CentralConfigClientUtil.getEnv();
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpPost post = new HttpPost((String)url);
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();){
            String string;
            block15: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    String latestVersion;
                    string = latestVersion = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            return latestVersion;
        }
    }

    private static String appendMetadata(String url) {
        url = CentralConfigClientUtil.appendHostnamePort(url);
        return url;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Struct getEnvVersions() {
        Struct struct = new Struct();
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return struct;
        }
        Object url = CentralConfigClientUtil.getCcsBaseUrl() + "/env/versions/" + CentralConfigClientUtil.getClusterName();
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpGet post = new HttpGet((String)url);
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();){
            Struct struct2;
            block18: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    String envVersions = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject jObj = new JsonObject(envVersions);
                    Iterator keys = jObj.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        JsonArray jAry = jObj.getJsonArray(key);
                        Object versions = "";
                        for (int i = 0; i < jAry.length(); ++i) {
                            String v = jAry.getString(i);
                            versions = (String)versions + v + ",";
                        }
                        if (((String)versions).endsWith(",")) {
                            versions = ((String)versions).substring(0, ((String)versions).length() - 1);
                        }
                        struct.put(key, versions);
                    }
                    struct2 = struct;
                    if (response == null) break block18;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return struct2;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            return null;
        }
    }

    public static String getAvailableVersions() {
        Struct struct = CentralConfigClientUtil.getEnvVersions();
        if (null == struct) {
            return "";
        }
        return (String)struct.get(CentralConfigClientUtil.getEnv());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getVersionHistory() {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return null;
        }
        Object url = CentralConfigClientUtil.getCcsBaseUrl() + "/versions/" + CentralConfigClientUtil.getClusterName() + "/" + CentralConfigClientUtil.getEnv();
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpGet post = new HttpGet((String)url);
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();){
            JsonObject jsonObject;
            block15: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    JsonObject jObj;
                    String versionHistory = EntityUtils.toString((HttpEntity)response.getEntity());
                    jsonObject = jObj = new JsonObject(versionHistory);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonObject;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            return null;
        }
    }

    public static void deleteVersion(String version) {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return;
        }
        String cv = CentralConfigClientUtil.getCurrentVersion();
        if (cv.equals("-1")) {
            cv = CentralConfigClientUtil.getLatestVersion();
        }
        if (cv.equals(version) || CentralConfigClientUtil.getLoadVersionFrom().equals(version) && CentralConfigClientUtil.getLoadEnvFrom().equals(CentralConfigClientUtil.getEnv())) {
            throw new RuntimeException("Current version can not be deleted");
        }
        Object url = CentralConfigClientUtil.getCcsBaseUrl() + "/versions/" + CentralConfigClientUtil.getClusterName() + "/" + CentralConfigClientUtil.getEnv() + "/" + version;
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpDelete post = new HttpDelete((String)url);
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public static void delayStore(final ServiceBase service) {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            try {
                service.store(false);
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
            return;
        }
        Timer timer = new Timer(20000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    service.store(false);
                }
                catch (ServiceException e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static void setServer(String server) {
        if (ccsServerIP.equals(server)) {
            return;
        }
        ccsServerIP = server;
        CentralConfigClientUtil.storeCCSServerConfig();
        ccsCheckDone = false;
    }

    public void setClusterName(String cluster) {
        if (ccsClusterName.equals(cluster)) {
            return;
        }
        ccsClusterName = cluster;
        CentralConfigClientUtil.storeCCSServerConfig();
        ccsCheckDone = false;
        CentralConfigRefreshServlet.reloadAllModules();
    }

    public void setEnv(String env) {
        if (ccsEnv.equals(env)) {
            return;
        }
        ccsEnv = env;
        CentralConfigClientUtil.storeCCSServerConfig();
        CentralConfigRefreshServlet.reloadAllModules();
    }

    public static void setCcsServerProtocol(String ccsProtocol) {
        if (ccsProtocol == ccsServerProtocol) {
            return;
        }
        ccsServerProtocol = ccsProtocol;
        CentralConfigClientUtil.storeCCSServerConfig();
        ccsCheckDone = false;
    }

    public static void setPort(String port) {
        int portLocal = Integer.valueOf(port);
        if (portLocal == ccsServerPort) {
            return;
        }
        ccsServerPort = portLocal;
        CentralConfigClientUtil.storeCCSServerConfig();
        ccsCheckDone = false;
    }

    public static void setEnabled(String enabled) {
        if (!enabled.equalsIgnoreCase("false")) {
            CentralConfigClientUtil.checkIfRegisteredWithCCS();
        }
        if (enabled.equalsIgnoreCase("push")) {
            CentralConfigClientUtil.setEnabledAndPush();
            return;
        }
        boolean enabledLocal = Boolean.valueOf(enabled);
        if (isCCSEnabled == enabledLocal) {
            return;
        }
        isCCSEnabled = enabledLocal;
        if (isCCSEnabled) {
            CentralConfigClientUtil.startCFConfigFilesWatcher();
        } else {
            CentralConfigClientUtil.stopCFConfigFilesWatcher();
        }
        CentralConfigClientUtil.storeCCSServerConfig();
        CentralConfigClientUtil.loadVersion(loadVersionFrom, loadEnvFrom, true);
    }

    public static void pushLocalToCCS() throws Exception {
        for (String string : cfSettingsFiles) {
            String string2 = ServiceFactory.getRuntimeService().getLibDir() + File.separator + string;
            File file = new File(string2);
            if (!file.exists()) continue;
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            String data = Files.readAllLines(path).get(0);
            CentralConfigClientUtil.pushToCCS(file.getName(), data, (Object)"push", (Object)"", (Object)"");
        }
    }

    public static void setEnabledAndPush() {
        if (isCCSEnabled) {
            return;
        }
        isCCSEnabled = true;
        CentralConfigClientUtil.startCFConfigFilesWatcher();
        CentralConfigClientUtil.storeCCSServerConfig();
        try {
            CentralConfigClientUtil.pushLocalToCCS();
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public static void restartServer() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CentralConfigClientUtil._restartServer();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            e.printStackTrace();
        }
    }

    public static void _restartServer() {
        String directory = ServiceFactory.getRuntimeService().getRootDir();
        try {
            String executablePath = directory + File.separator + "bin";
            String executable = executablePath + File.separator + "coldfusion";
            if (File.separatorChar == '\\') {
                executable = executable + ".exe";
                ProcessBuilder processBuilder = new ProcessBuilder(executable, "restart");
                processBuilder.directory(new File(executablePath));
                processBuilder.start();
            } else {
                String jvmConfig = directory + File.separator + "bin" + File.separator + "jvm.config";
                ProcessBuilder processBuilder = new ProcessBuilder(ProcessServer.LinuxCommandUtils.getCommand((String)jvmConfig, (String)directory, (String)"restart"));
                processBuilder.directory(new File(executablePath));
                processBuilder.start();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
    }

    public static CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient httpClient = null;
        if (CCS_SELF_SIGNED_CERT_ENABLE) {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        } else {
            httpClient = HttpClients.createDefault();
        }
        return httpClient;
    }

    private static void checkIfRegisteredWithCCS() {
        String url = CentralConfigClientUtil.getHealthURL();
        url = CentralConfigClientUtil.appendMetadata(url);
        HttpGet get = new HttpGet(url);
        String content = "";
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (content.equals("notregistered")) {
                throw new NodeNotRegisteredException();
            }
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e1) {
            throw new CCSNotReachableException();
        }
    }

    public static String getServer() {
        CentralConfigClientUtil.initHostport();
        return ccsServerIP;
    }

    public static String getEnv() {
        return ccsEnv;
    }

    public static String getLoadEnvFrom() {
        return loadEnvFrom;
    }

    public static void setLoadEnvFrom(String env) {
        loadEnvFrom = env;
    }

    public static String getLoadVersionFrom() {
        return loadVersionFrom;
    }

    public static void setLoadVersionFrom(String version) {
        loadVersionFrom = version;
    }

    public static String[] getEnvs() {
        Struct envVersions = CentralConfigClientUtil.getEnvVersions();
        Set envs = envVersions.keySet();
        HashSet<String> envsSet = new HashSet<String>(envs);
        envsSet.add("development");
        envsSet.add("beta");
        envsSet.add("production");
        return envsSet.toArray(new String[envsSet.size()]);
    }

    public static String getCcsServerProtocol() {
        return ccsServerProtocol;
    }

    public static int getPort() {
        return ccsServerPort;
    }

    public static String getHostName() {
        return hostname;
    }

    public static boolean isEnabled() {
        return isCCSEnabled;
    }

    public static String getSecretKey() {
        return ccsSecretKey;
    }

    public static boolean isCCSEnbledButNotRunning() {
        boolean isCCSEnabled = CentralConfigClientUtil.isEnabled();
        if (isCCSEnabled) {
            boolean isCCSRunning = CentralConfigClientUtil.isCCSAvailaible();
            return !isCCSRunning;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String isAnyNodeDown() {
        if (!CentralConfigClientUtil.isCCSAvailaible()) {
            return "";
        }
        Object url = CentralConfigClientUtil.getCcsBaseUrl() + "/health/nodes";
        url = CentralConfigClientUtil.appendMetadata((String)url);
        HttpGet get = new HttpGet((String)url);
        String content = "";
        try (CloseableHttpClient httpClient = CentralConfigClientUtil.getHttpClient();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            if (content.length() <= 0) return "";
            String string = content;
            return string;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e1) {
            throw new RuntimeException("CCS server is not reachable.");
        }
    }

    public static void setCCSServerStatus(boolean running) {
        if (running) {
            isCCSRunning = true;
            CentralConfigClientUtil.startCFConfigFilesWatcher();
        } else {
            isCCSRunning = false;
            CentralConfigClientUtil.stopCFConfigFilesWatcher();
        }
        ccsCheckDone = true;
    }

    public static void startCFConfigFilesWatcher() {
        if (!CentralConfigClientUtil.isCCSAvailaible() || watcherThread != null) {
            return;
        }
        CFConfigFilesWatcher watcher = new CFConfigFilesWatcher();
        watcherThread = new Thread(watcher);
        watcherThread.start();
    }

    public static void stopCFConfigFilesWatcher() {
        if (watcherThread != null) {
            watcherThread.interrupt();
        }
        watcherThread = null;
    }

    static {
        CentralConfigClientUtil.init();
        cfSettingsFiles = new HashSet<String>();
        cfSettingsFiles.add("neo-security.xml");
        cfSettingsFiles.add("cache.ccf");
        cfSettingsFiles.add("jvm.config");
        cfSettingsFiles.add("memcachedcache.properties");
        cfSettingsFiles.add("neo_updates.xml");
        cfSettingsFiles.add("neo-clientstore.xml");
        cfSettingsFiles.add("neo-cloud-config.xml");
        cfSettingsFiles.add("neo-comobjmap.xml");
        cfSettingsFiles.add("neo-datasource.xml");
        cfSettingsFiles.add("neo-debug.xml");
        cfSettingsFiles.add("neo-document.xml");
        cfSettingsFiles.add("neo-dotnet.xml");
        cfSettingsFiles.add("neo-drivers.xml");
        cfSettingsFiles.add("neo-event.xml");
        cfSettingsFiles.add("neo-graphing.xml");
        cfSettingsFiles.add("neo-jaxrs.xml");
        cfSettingsFiles.add("neo-logging.xml");
        cfSettingsFiles.add("neo-mail.xml");
        cfSettingsFiles.add("neo-metric.xml");
        cfSettingsFiles.add("neo-monitoring.xml");
        cfSettingsFiles.add("neo-nosql-datasource.xml");
        cfSettingsFiles.add("neo-probe.xml");
        cfSettingsFiles.add("neo-registry.xml");
        cfSettingsFiles.add("neo-runtime.xml");
        cfSettingsFiles.add("neo-saml.xml");
        cfSettingsFiles.add("neo-search.xml");
        cfSettingsFiles.add("neo-secureprofile.xml");
        cfSettingsFiles.add("neo-solr.xml");
        cfSettingsFiles.add("neo-watch.xml");
        cfSettingsFiles.add("neo-websocket.xml");
        cfSettingsFiles.add("neo-xmlrpc.xml");
        cfSettingsFiles.add("rediscache.properties");
        cfSettingsFiles.add("quartz.properties");
        cfSettingsFiles.add("license.properties");
        cfSettingsFiles.add("neo-graphql-config.xml");
        localSettingsMap = new HashMap<String, String>();
        localSettingsMap.put("neo-logging.xml", "logDirectory");
        localSettingsMap.put("neo-runtime.xml", "ORMSearchIndexDirectory,CFFormScriptSrc");
        localSettingsMap.put("neo-security.xml", "admin.userid.root.salt");
        localSettingsMap.put("neo-mail.xml", "password");
        localSettingsMap.put("neo-websocket.xml", "keystorePassword");
    }

    public static class NodeNotRegisteredException
    extends CacheException {
    }

    public static class CCSNotReachableException
    extends CacheException {
    }
}

