/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.centralconfig.client.discovery;

import coldfusion.centralconfig.client.discovery.CFToCCSMulticastSender;
import coldfusion.centralconfig.server.CentralConfigServerManager;
import coldfusion.log.CFLogs;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class CFToCCSMulticastReceiver
implements Runnable {
    private MulticastSocket mcSocket;
    private volatile boolean listen = false;

    public CFToCCSMulticastReceiver() {
        InetAddress multicastGroup = null;
        try {
            this.mcSocket = new MulticastSocket(CFToCCSMulticastSender.multiCastPort);
            multicastGroup = InetAddress.getByName(CFToCCSMulticastSender.multiCastGroupIp);
            this.mcSocket.joinGroup(multicastGroup);
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    @Override
    public void run() {
        this.listen = true;
        while (this.listen && this.mcSocket != null) {
            try {
                byte[] inbuf = new byte[1024];
                DatagramPacket packet = new DatagramPacket(inbuf, inbuf.length);
                this.mcSocket.receive(packet);
                this.parseMessage(packet);
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    private void parseMessage(DatagramPacket packet) {
        String data = null;
        byte[] dataInput = packet.getData();
        String prefix = new String(dataInput, 0, CFToCCSMulticastSender.CF_CCS_UPMESSAGE.length());
        if (prefix.equals(CFToCCSMulticastSender.CF_CCS_UPMESSAGE)) {
            data = new String(dataInput, CFToCCSMulticastSender.CF_CCS_UPMESSAGE.length(), packet.getLength() - CFToCCSMulticastSender.CF_CCS_UPMESSAGE.length());
            CentralConfigServerManager.addDiscoveredNode(data);
        }
    }

    public void stopListening() {
        this.listen = false;
    }

    public boolean isOn() {
        return this.listen;
    }
}

